/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-06-01 at 09:24:19 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * UrlMaps A host-matching rule for a URL. If matched, will use the named PathMatcher to select the
 * BackendService.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HostRule extends com.google.api.client.json.GenericJson {

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The list of host patterns to match. They must be valid hostnames, except * will match any
   * string of ([a-z0-9-.]*). In that case, * must be the first character and must be followed in
   * the pattern by either - or ..
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> hosts;

  /**
   * The name of the PathMatcher to use to match the path portion of the URL if the hostRule matches
   * the URL's host portion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pathMatcher;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public HostRule setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The list of host patterns to match. They must be valid hostnames, except * will match any
   * string of ([a-z0-9-.]*). In that case, * must be the first character and must be followed in
   * the pattern by either - or ..
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getHosts() {
    return hosts;
  }

  /**
   * The list of host patterns to match. They must be valid hostnames, except * will match any
   * string of ([a-z0-9-.]*). In that case, * must be the first character and must be followed in
   * the pattern by either - or ..
   * @param hosts hosts or {@code null} for none
   */
  public HostRule setHosts(java.util.List<java.lang.String> hosts) {
    this.hosts = hosts;
    return this;
  }

  /**
   * The name of the PathMatcher to use to match the path portion of the URL if the hostRule matches
   * the URL's host portion.
   * @return value or {@code null} for none
   */
  public java.lang.String getPathMatcher() {
    return pathMatcher;
  }

  /**
   * The name of the PathMatcher to use to match the path portion of the URL if the hostRule matches
   * the URL's host portion.
   * @param pathMatcher pathMatcher or {@code null} for none
   */
  public HostRule setPathMatcher(java.lang.String pathMatcher) {
    this.pathMatcher = pathMatcher;
    return this;
  }

  @Override
  public HostRule set(String fieldName, Object value) {
    return (HostRule) super.set(fieldName, value);
  }

  @Override
  public HostRule clone() {
    return (HostRule) super.clone();
  }

}
