/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-12-07 at 00:00:32 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for LicenseCode.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LicenseCode extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * [Output Only] Description of this License Code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of resource. Always compute#licenseCode for licenses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] URL and description aliases of Licenses with the same License Code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LicenseCodeLicenseAlias> licenseAlias;

  /**
   * [Output Only] Name of the resource. The name is 1-20 characters long and must be a valid 64 bit
   * integer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] Current state of this License Code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * [Output Only] If true, the license will remain attached when creating images or snapshots from
   * disks. Otherwise, the license is not transferred.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean transferable;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public LicenseCode setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * [Output Only] Description of this License Code.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * [Output Only] Description of this License Code.
   * @param description description or {@code null} for none
   */
  public LicenseCode setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public LicenseCode setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of resource. Always compute#licenseCode for licenses.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of resource. Always compute#licenseCode for licenses.
   * @param kind kind or {@code null} for none
   */
  public LicenseCode setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] URL and description aliases of Licenses with the same License Code.
   * @return value or {@code null} for none
   */
  public java.util.List<LicenseCodeLicenseAlias> getLicenseAlias() {
    return licenseAlias;
  }

  /**
   * [Output Only] URL and description aliases of Licenses with the same License Code.
   * @param licenseAlias licenseAlias or {@code null} for none
   */
  public LicenseCode setLicenseAlias(java.util.List<LicenseCodeLicenseAlias> licenseAlias) {
    this.licenseAlias = licenseAlias;
    return this;
  }

  /**
   * [Output Only] Name of the resource. The name is 1-20 characters long and must be a valid 64 bit
   * integer.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * [Output Only] Name of the resource. The name is 1-20 characters long and must be a valid 64 bit
   * integer.
   * @param name name or {@code null} for none
   */
  public LicenseCode setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public LicenseCode setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output Only] Current state of this License Code.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * [Output Only] Current state of this License Code.
   * @param state state or {@code null} for none
   */
  public LicenseCode setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * [Output Only] If true, the license will remain attached when creating images or snapshots from
   * disks. Otherwise, the license is not transferred.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getTransferable() {
    return transferable;
  }

  /**
   * [Output Only] If true, the license will remain attached when creating images or snapshots from
   * disks. Otherwise, the license is not transferred.
   * @param transferable transferable or {@code null} for none
   */
  public LicenseCode setTransferable(java.lang.Boolean transferable) {
    this.transferable = transferable;
    return this;
  }

  @Override
  public LicenseCode set(String fieldName, Object value) {
    return (LicenseCode) super.set(fieldName, value);
  }

  @Override
  public LicenseCode clone() {
    return (LicenseCode) super.clone();
  }

}
