/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-16 at 21:52:07 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerVersion.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerVersion extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instanceTemplate;

  /**
   * Name of the version. Unique among all versions in the scope of this managed instance group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Specifies the intended number of instances to be created from the instanceTemplate. The final
   * number of instances created from the template will be equal to: - If expressed as a fixed
   * number, the minimum of either targetSize.fixed or instanceGroupManager.targetSize is used.  -
   * if expressed as a percent, the targetSize would be (targetSize.percent/100 *
   * InstanceGroupManager.targetSize) If there is a remainder, the number is rounded up.  If unset,
   * this version will update any remaining instances not updated by another version. Read Starting
   * a canary update for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FixedOrPercent targetSize;

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getInstanceTemplate() {
    return instanceTemplate;
  }

  /**
   * @param instanceTemplate instanceTemplate or {@code null} for none
   */
  public InstanceGroupManagerVersion setInstanceTemplate(java.lang.String instanceTemplate) {
    this.instanceTemplate = instanceTemplate;
    return this;
  }

  /**
   * Name of the version. Unique among all versions in the scope of this managed instance group.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the version. Unique among all versions in the scope of this managed instance group.
   * @param name name or {@code null} for none
   */
  public InstanceGroupManagerVersion setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Specifies the intended number of instances to be created from the instanceTemplate. The final
   * number of instances created from the template will be equal to: - If expressed as a fixed
   * number, the minimum of either targetSize.fixed or instanceGroupManager.targetSize is used.  -
   * if expressed as a percent, the targetSize would be (targetSize.percent/100 *
   * InstanceGroupManager.targetSize) If there is a remainder, the number is rounded up.  If unset,
   * this version will update any remaining instances not updated by another version. Read Starting
   * a canary update for more information.
   * @return value or {@code null} for none
   */
  public FixedOrPercent getTargetSize() {
    return targetSize;
  }

  /**
   * Specifies the intended number of instances to be created from the instanceTemplate. The final
   * number of instances created from the template will be equal to: - If expressed as a fixed
   * number, the minimum of either targetSize.fixed or instanceGroupManager.targetSize is used.  -
   * if expressed as a percent, the targetSize would be (targetSize.percent/100 *
   * InstanceGroupManager.targetSize) If there is a remainder, the number is rounded up.  If unset,
   * this version will update any remaining instances not updated by another version. Read Starting
   * a canary update for more information.
   * @param targetSize targetSize or {@code null} for none
   */
  public InstanceGroupManagerVersion setTargetSize(FixedOrPercent targetSize) {
    this.targetSize = targetSize;
    return this;
  }

  @Override
  public InstanceGroupManagerVersion set(String fieldName, Object value) {
    return (InstanceGroupManagerVersion) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerVersion clone() {
    return (InstanceGroupManagerVersion) super.clone();
  }

}
