/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-16 at 21:52:07 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for RegionInstanceGroupManagersSetTargetPoolsRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RegionInstanceGroupManagersSetTargetPoolsRequest extends com.google.api.client.json.GenericJson {

  /**
   * Fingerprint of the target pools information, which is a hash of the contents. This field is
   * used for optimistic locking when you update the target pool entries. This field is optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * The URL of all TargetPool resources to which instances in the instanceGroup field are added.
   * The target pools automatically apply to all of the instances in the managed instance group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> targetPools;

  /**
   * Fingerprint of the target pools information, which is a hash of the contents. This field is
   * used for optimistic locking when you update the target pool entries. This field is optional.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * Fingerprint of the target pools information, which is a hash of the contents. This field is
   * used for optimistic locking when you update the target pool entries. This field is optional.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * Fingerprint of the target pools information, which is a hash of the contents. This field is
   * used for optimistic locking when you update the target pool entries. This field is optional.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public RegionInstanceGroupManagersSetTargetPoolsRequest setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * Fingerprint of the target pools information, which is a hash of the contents. This field is
   * used for optimistic locking when you update the target pool entries. This field is optional.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public RegionInstanceGroupManagersSetTargetPoolsRequest encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * The URL of all TargetPool resources to which instances in the instanceGroup field are added.
   * The target pools automatically apply to all of the instances in the managed instance group.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTargetPools() {
    return targetPools;
  }

  /**
   * The URL of all TargetPool resources to which instances in the instanceGroup field are added.
   * The target pools automatically apply to all of the instances in the managed instance group.
   * @param targetPools targetPools or {@code null} for none
   */
  public RegionInstanceGroupManagersSetTargetPoolsRequest setTargetPools(java.util.List<java.lang.String> targetPools) {
    this.targetPools = targetPools;
    return this;
  }

  @Override
  public RegionInstanceGroupManagersSetTargetPoolsRequest set(String fieldName, Object value) {
    return (RegionInstanceGroupManagersSetTargetPoolsRequest) super.set(fieldName, value);
  }

  @Override
  public RegionInstanceGroupManagersSetTargetPoolsRequest clone() {
    return (RegionInstanceGroupManagersSetTargetPoolsRequest) super.clone();
  }

}
