/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-16 at 21:51:07 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A network peering attached to a network resource. The message includes the peering name, peer
 * network, peering state, and a flag indicating whether Google Compute Engine should automatically
 * create routes for the peering.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkPeering extends com.google.api.client.json.GenericJson {

  /**
   * Whether full mesh connectivity is created and managed automatically. When it is set to true,
   * Google Compute Engine will automatically create and manage the routes between two networks when
   * the state is ACTIVE. Otherwise, user needs to create routes manually to route packets to peer
   * network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoCreateRoutes;

  /**
   * Name of this peering. Provided by the client when the peering is created. The name must comply
   * with RFC1035. Specifically, the name must be 1-63 characters long and match regular expression
   * [a-z]([-a-z0-9]*[a-z0-9])? which means the first character must be a lowercase letter, and all
   * the following characters must be a dash, lowercase letter, or digit, except the last character,
   * which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The URL of the peer network. It can be either full URL or partial URL. The peer network may
   * belong to a different project. If the partial URL does not contain project, it is assumed that
   * the peer network is in the same project as the current network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * [Output Only] State for the peering.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * [Output Only] Details about the current state of the peering.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String stateDetails;

  /**
   * Whether full mesh connectivity is created and managed automatically. When it is set to true,
   * Google Compute Engine will automatically create and manage the routes between two networks when
   * the state is ACTIVE. Otherwise, user needs to create routes manually to route packets to peer
   * network.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoCreateRoutes() {
    return autoCreateRoutes;
  }

  /**
   * Whether full mesh connectivity is created and managed automatically. When it is set to true,
   * Google Compute Engine will automatically create and manage the routes between two networks when
   * the state is ACTIVE. Otherwise, user needs to create routes manually to route packets to peer
   * network.
   * @param autoCreateRoutes autoCreateRoutes or {@code null} for none
   */
  public NetworkPeering setAutoCreateRoutes(java.lang.Boolean autoCreateRoutes) {
    this.autoCreateRoutes = autoCreateRoutes;
    return this;
  }

  /**
   * Name of this peering. Provided by the client when the peering is created. The name must comply
   * with RFC1035. Specifically, the name must be 1-63 characters long and match regular expression
   * [a-z]([-a-z0-9]*[a-z0-9])? which means the first character must be a lowercase letter, and all
   * the following characters must be a dash, lowercase letter, or digit, except the last character,
   * which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this peering. Provided by the client when the peering is created. The name must comply
   * with RFC1035. Specifically, the name must be 1-63 characters long and match regular expression
   * [a-z]([-a-z0-9]*[a-z0-9])? which means the first character must be a lowercase letter, and all
   * the following characters must be a dash, lowercase letter, or digit, except the last character,
   * which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public NetworkPeering setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The URL of the peer network. It can be either full URL or partial URL. The peer network may
   * belong to a different project. If the partial URL does not contain project, it is assumed that
   * the peer network is in the same project as the current network.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * The URL of the peer network. It can be either full URL or partial URL. The peer network may
   * belong to a different project. If the partial URL does not contain project, it is assumed that
   * the peer network is in the same project as the current network.
   * @param network network or {@code null} for none
   */
  public NetworkPeering setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  /**
   * [Output Only] State for the peering.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * [Output Only] State for the peering.
   * @param state state or {@code null} for none
   */
  public NetworkPeering setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * [Output Only] Details about the current state of the peering.
   * @return value or {@code null} for none
   */
  public java.lang.String getStateDetails() {
    return stateDetails;
  }

  /**
   * [Output Only] Details about the current state of the peering.
   * @param stateDetails stateDetails or {@code null} for none
   */
  public NetworkPeering setStateDetails(java.lang.String stateDetails) {
    this.stateDetails = stateDetails;
    return this;
  }

  @Override
  public NetworkPeering set(String fieldName, Object value) {
    return (NetworkPeering) super.set(fieldName, value);
  }

  @Override
  public NetworkPeering clone() {
    return (NetworkPeering) super.clone();
  }

}
