/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-01 at 04:51:13 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagersResizeAdvancedRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagersResizeAdvancedRequest extends com.google.api.client.json.GenericJson {

  /**
   * If this flag is true, the managed instance group attempts to create all instances initiated by
   * this resize request only once. If there is an error during creation, the managed instance group
   * does not retry create this instance, and we will decrease the targetSize of the request
   * instead. If the flag is false, the group attemps to recreate each instance continuously until
   * it succeeds.
   *
   * This flag matters only in the first attempt of creation of an instance. After an instance is
   * successfully created while this flag is enabled, the instance behaves the same way as all the
   * other instances created with a regular resize request. In particular, if a running instance
   * dies unexpectedly at a later time and needs to be recreated, this mode does not affect the
   * recreation behavior in that scenario.
   *
   * This flag is applicable only to the current resize request. It does not influence other resize
   * requests in any way.
   *
   * You can see which instances is being creating in which mode by calling the get or
   * listManagedInstances API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean noCreationRetries;

  /**
   * The number of running instances that the managed instance group should maintain at any given
   * time. The group automatically adds or removes instances to maintain the number of instances
   * specified by this parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer targetSize;

  /**
   * If this flag is true, the managed instance group attempts to create all instances initiated by
   * this resize request only once. If there is an error during creation, the managed instance group
   * does not retry create this instance, and we will decrease the targetSize of the request
   * instead. If the flag is false, the group attemps to recreate each instance continuously until
   * it succeeds.
   *
   * This flag matters only in the first attempt of creation of an instance. After an instance is
   * successfully created while this flag is enabled, the instance behaves the same way as all the
   * other instances created with a regular resize request. In particular, if a running instance
   * dies unexpectedly at a later time and needs to be recreated, this mode does not affect the
   * recreation behavior in that scenario.
   *
   * This flag is applicable only to the current resize request. It does not influence other resize
   * requests in any way.
   *
   * You can see which instances is being creating in which mode by calling the get or
   * listManagedInstances API.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getNoCreationRetries() {
    return noCreationRetries;
  }

  /**
   * If this flag is true, the managed instance group attempts to create all instances initiated by
   * this resize request only once. If there is an error during creation, the managed instance group
   * does not retry create this instance, and we will decrease the targetSize of the request
   * instead. If the flag is false, the group attemps to recreate each instance continuously until
   * it succeeds.
   *
   * This flag matters only in the first attempt of creation of an instance. After an instance is
   * successfully created while this flag is enabled, the instance behaves the same way as all the
   * other instances created with a regular resize request. In particular, if a running instance
   * dies unexpectedly at a later time and needs to be recreated, this mode does not affect the
   * recreation behavior in that scenario.
   *
   * This flag is applicable only to the current resize request. It does not influence other resize
   * requests in any way.
   *
   * You can see which instances is being creating in which mode by calling the get or
   * listManagedInstances API.
   * @param noCreationRetries noCreationRetries or {@code null} for none
   */
  public InstanceGroupManagersResizeAdvancedRequest setNoCreationRetries(java.lang.Boolean noCreationRetries) {
    this.noCreationRetries = noCreationRetries;
    return this;
  }

  /**
   * The number of running instances that the managed instance group should maintain at any given
   * time. The group automatically adds or removes instances to maintain the number of instances
   * specified by this parameter.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTargetSize() {
    return targetSize;
  }

  /**
   * The number of running instances that the managed instance group should maintain at any given
   * time. The group automatically adds or removes instances to maintain the number of instances
   * specified by this parameter.
   * @param targetSize targetSize or {@code null} for none
   */
  public InstanceGroupManagersResizeAdvancedRequest setTargetSize(java.lang.Integer targetSize) {
    this.targetSize = targetSize;
    return this;
  }

  @Override
  public InstanceGroupManagersResizeAdvancedRequest set(String fieldName, Object value) {
    return (InstanceGroupManagersResizeAdvancedRequest) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagersResizeAdvancedRequest clone() {
    return (InstanceGroupManagersResizeAdvancedRequest) super.clone();
  }

}
