/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-03-15 at 20:26:45 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A TargetHttpsProxy resource. This resource defines an HTTPS proxy. (== resource_for
 * beta.targetHttpsProxies ==) (== resource_for v1.targetHttpsProxies ==)
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TargetHttpsProxy extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of resource. Always compute#targetHttpsProxy for target HTTPS proxies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Specifies the QUIC override policy for this TargetHttpsProxy resource. This determines whether
   * the load balancer will attempt to negotiate QUIC with clients or not. Can specify one of NONE,
   * ENABLE, or DISABLE. Specify ENABLE to always enable QUIC, Enables QUIC when set to ENABLE, and
   * disables QUIC when set to DISABLE. If NONE is specified, uses the QUIC policy with no user
   * overrides, which is equivalent to DISABLE. Not specifying this field is equivalent to
   * specifying NONE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String quicOverride;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * URLs to SslCertificate resources that are used to authenticate connections between users and
   * the load balancer. Currently, exactly one SSL certificate must be specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> sslCertificates;

  /**
   * URL of SslPolicy resource that will be associated with the TargetHttpsProxy resource. If not
   * set, the TargetHttpsProxy resource will not have any SSL policy configured.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sslPolicy;

  /**
   * A fully-qualified or valid partial URL to the UrlMap resource that defines the mapping from URL
   * to the BackendService. For example, the following are all valid URLs for specifying a URL map:
   * - https://www.googleapis.compute/v1/projects/project/global/urlMaps/url-map  -
   * projects/project/global/urlMaps/url-map  - global/urlMaps/url-map
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String urlMap;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public TargetHttpsProxy setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public TargetHttpsProxy setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public TargetHttpsProxy setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of resource. Always compute#targetHttpsProxy for target HTTPS proxies.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of resource. Always compute#targetHttpsProxy for target HTTPS proxies.
   * @param kind kind or {@code null} for none
   */
  public TargetHttpsProxy setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public TargetHttpsProxy setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Specifies the QUIC override policy for this TargetHttpsProxy resource. This determines whether
   * the load balancer will attempt to negotiate QUIC with clients or not. Can specify one of NONE,
   * ENABLE, or DISABLE. Specify ENABLE to always enable QUIC, Enables QUIC when set to ENABLE, and
   * disables QUIC when set to DISABLE. If NONE is specified, uses the QUIC policy with no user
   * overrides, which is equivalent to DISABLE. Not specifying this field is equivalent to
   * specifying NONE.
   * @return value or {@code null} for none
   */
  public java.lang.String getQuicOverride() {
    return quicOverride;
  }

  /**
   * Specifies the QUIC override policy for this TargetHttpsProxy resource. This determines whether
   * the load balancer will attempt to negotiate QUIC with clients or not. Can specify one of NONE,
   * ENABLE, or DISABLE. Specify ENABLE to always enable QUIC, Enables QUIC when set to ENABLE, and
   * disables QUIC when set to DISABLE. If NONE is specified, uses the QUIC policy with no user
   * overrides, which is equivalent to DISABLE. Not specifying this field is equivalent to
   * specifying NONE.
   * @param quicOverride quicOverride or {@code null} for none
   */
  public TargetHttpsProxy setQuicOverride(java.lang.String quicOverride) {
    this.quicOverride = quicOverride;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public TargetHttpsProxy setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * URLs to SslCertificate resources that are used to authenticate connections between users and
   * the load balancer. Currently, exactly one SSL certificate must be specified.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSslCertificates() {
    return sslCertificates;
  }

  /**
   * URLs to SslCertificate resources that are used to authenticate connections between users and
   * the load balancer. Currently, exactly one SSL certificate must be specified.
   * @param sslCertificates sslCertificates or {@code null} for none
   */
  public TargetHttpsProxy setSslCertificates(java.util.List<java.lang.String> sslCertificates) {
    this.sslCertificates = sslCertificates;
    return this;
  }

  /**
   * URL of SslPolicy resource that will be associated with the TargetHttpsProxy resource. If not
   * set, the TargetHttpsProxy resource will not have any SSL policy configured.
   * @return value or {@code null} for none
   */
  public java.lang.String getSslPolicy() {
    return sslPolicy;
  }

  /**
   * URL of SslPolicy resource that will be associated with the TargetHttpsProxy resource. If not
   * set, the TargetHttpsProxy resource will not have any SSL policy configured.
   * @param sslPolicy sslPolicy or {@code null} for none
   */
  public TargetHttpsProxy setSslPolicy(java.lang.String sslPolicy) {
    this.sslPolicy = sslPolicy;
    return this;
  }

  /**
   * A fully-qualified or valid partial URL to the UrlMap resource that defines the mapping from URL
   * to the BackendService. For example, the following are all valid URLs for specifying a URL map:
   * - https://www.googleapis.compute/v1/projects/project/global/urlMaps/url-map  -
   * projects/project/global/urlMaps/url-map  - global/urlMaps/url-map
   * @return value or {@code null} for none
   */
  public java.lang.String getUrlMap() {
    return urlMap;
  }

  /**
   * A fully-qualified or valid partial URL to the UrlMap resource that defines the mapping from URL
   * to the BackendService. For example, the following are all valid URLs for specifying a URL map:
   * - https://www.googleapis.compute/v1/projects/project/global/urlMaps/url-map  -
   * projects/project/global/urlMaps/url-map  - global/urlMaps/url-map
   * @param urlMap urlMap or {@code null} for none
   */
  public TargetHttpsProxy setUrlMap(java.lang.String urlMap) {
    this.urlMap = urlMap;
    return this;
  }

  @Override
  public TargetHttpsProxy set(String fieldName, Object value) {
    return (TargetHttpsProxy) super.set(fieldName, value);
  }

  @Override
  public TargetHttpsProxy clone() {
    return (TargetHttpsProxy) super.clone();
  }

}
