/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-04-05 at 18:29:53 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for LicenseResourceRequirements.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LicenseResourceRequirements extends com.google.api.client.json.GenericJson {

  /**
   * Minimum number of guest cpus required to use the Instance. Enforced at Instance creation and
   * Instance start.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minGuestCpuCount;

  /**
   * Minimum memory required to use the Instance. Enforced at Instance creation and Instance start.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minMemoryMb;

  /**
   * Minimum number of guest cpus required to use the Instance. Enforced at Instance creation and
   * Instance start.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinGuestCpuCount() {
    return minGuestCpuCount;
  }

  /**
   * Minimum number of guest cpus required to use the Instance. Enforced at Instance creation and
   * Instance start.
   * @param minGuestCpuCount minGuestCpuCount or {@code null} for none
   */
  public LicenseResourceRequirements setMinGuestCpuCount(java.lang.Integer minGuestCpuCount) {
    this.minGuestCpuCount = minGuestCpuCount;
    return this;
  }

  /**
   * Minimum memory required to use the Instance. Enforced at Instance creation and Instance start.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinMemoryMb() {
    return minMemoryMb;
  }

  /**
   * Minimum memory required to use the Instance. Enforced at Instance creation and Instance start.
   * @param minMemoryMb minMemoryMb or {@code null} for none
   */
  public LicenseResourceRequirements setMinMemoryMb(java.lang.Integer minMemoryMb) {
    this.minMemoryMb = minMemoryMb;
    return this;
  }

  @Override
  public LicenseResourceRequirements set(String fieldName, Object value) {
    return (LicenseResourceRequirements) super.set(fieldName, value);
  }

  @Override
  public LicenseResourceRequirements clone() {
    return (LicenseResourceRequirements) super.clone();
  }

}
