/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-04-14 at 04:21:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A routing configuration attached to a network resource. The message includes the list of routers
 * associated with the network, and a flag indicating the type of routing behavior to enforce
 * network-wide.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkRoutingConfig extends com.google.api.client.json.GenericJson {

  /**
   * The network-wide routing mode to use. If set to REGIONAL, this network's cloud routers will
   * only advertise routes with subnetworks of this network in the same region as the router. If set
   * to GLOBAL, this network's cloud routers will advertise routes with all subnetworks of this
   * network, across regions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String routingMode;

  /**
   * The network-wide routing mode to use. If set to REGIONAL, this network's cloud routers will
   * only advertise routes with subnetworks of this network in the same region as the router. If set
   * to GLOBAL, this network's cloud routers will advertise routes with all subnetworks of this
   * network, across regions.
   * @return value or {@code null} for none
   */
  public java.lang.String getRoutingMode() {
    return routingMode;
  }

  /**
   * The network-wide routing mode to use. If set to REGIONAL, this network's cloud routers will
   * only advertise routes with subnetworks of this network in the same region as the router. If set
   * to GLOBAL, this network's cloud routers will advertise routes with all subnetworks of this
   * network, across regions.
   * @param routingMode routingMode or {@code null} for none
   */
  public NetworkRoutingConfig setRoutingMode(java.lang.String routingMode) {
    this.routingMode = routingMode;
    return this;
  }

  @Override
  public NetworkRoutingConfig set(String fieldName, Object value) {
    return (NetworkRoutingConfig) super.set(fieldName, value);
  }

  @Override
  public NetworkRoutingConfig clone() {
    return (NetworkRoutingConfig) super.clone();
  }

}
