/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-01-08 17:48:37 UTC)
 * on 2016-02-17 at 06:20:24 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for RouterStatusBgpPeerStatus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RouterStatusBgpPeerStatus extends com.google.api.client.json.GenericJson {

  /**
   * Routes that were advertised to the remote BgpPeer
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Route> advertisedRoutes;

  /**
   * IP address of the local BGP interface.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipAddress;

  /**
   * URL of the VPN tunnel that this BgpPeer controls.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String linkedVpnTunnel;

  /**
   * Name of this BgpPeer which is unique within the Router resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Number of routes learned from the remote BGP Peer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long numLearnedRoutes;

  /**
   * IP address of the remote BGP interface.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String peerIpAddress;

  /**
   * BGP state as specified in RFC-1771.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Status of the BgpPeer: {UP, DOWN}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Time this session has been up. Format: 1 second < uptime < 1 day = "23:59:59" 1 day <= uptime <
   * 1 week = "6d:23h:59m" 1 week <= uptime = "123w:6d:23h"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uptime;

  /**
   * Routes that were advertised to the remote BgpPeer
   * @return value or {@code null} for none
   */
  public java.util.List<Route> getAdvertisedRoutes() {
    return advertisedRoutes;
  }

  /**
   * Routes that were advertised to the remote BgpPeer
   * @param advertisedRoutes advertisedRoutes or {@code null} for none
   */
  public RouterStatusBgpPeerStatus setAdvertisedRoutes(java.util.List<Route> advertisedRoutes) {
    this.advertisedRoutes = advertisedRoutes;
    return this;
  }

  /**
   * IP address of the local BGP interface.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpAddress() {
    return ipAddress;
  }

  /**
   * IP address of the local BGP interface.
   * @param ipAddress ipAddress or {@code null} for none
   */
  public RouterStatusBgpPeerStatus setIpAddress(java.lang.String ipAddress) {
    this.ipAddress = ipAddress;
    return this;
  }

  /**
   * URL of the VPN tunnel that this BgpPeer controls.
   * @return value or {@code null} for none
   */
  public java.lang.String getLinkedVpnTunnel() {
    return linkedVpnTunnel;
  }

  /**
   * URL of the VPN tunnel that this BgpPeer controls.
   * @param linkedVpnTunnel linkedVpnTunnel or {@code null} for none
   */
  public RouterStatusBgpPeerStatus setLinkedVpnTunnel(java.lang.String linkedVpnTunnel) {
    this.linkedVpnTunnel = linkedVpnTunnel;
    return this;
  }

  /**
   * Name of this BgpPeer which is unique within the Router resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this BgpPeer which is unique within the Router resource.
   * @param name name or {@code null} for none
   */
  public RouterStatusBgpPeerStatus setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Number of routes learned from the remote BGP Peer.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumLearnedRoutes() {
    return numLearnedRoutes;
  }

  /**
   * Number of routes learned from the remote BGP Peer.
   * @param numLearnedRoutes numLearnedRoutes or {@code null} for none
   */
  public RouterStatusBgpPeerStatus setNumLearnedRoutes(java.lang.Long numLearnedRoutes) {
    this.numLearnedRoutes = numLearnedRoutes;
    return this;
  }

  /**
   * IP address of the remote BGP interface.
   * @return value or {@code null} for none
   */
  public java.lang.String getPeerIpAddress() {
    return peerIpAddress;
  }

  /**
   * IP address of the remote BGP interface.
   * @param peerIpAddress peerIpAddress or {@code null} for none
   */
  public RouterStatusBgpPeerStatus setPeerIpAddress(java.lang.String peerIpAddress) {
    this.peerIpAddress = peerIpAddress;
    return this;
  }

  /**
   * BGP state as specified in RFC-1771.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * BGP state as specified in RFC-1771.
   * @param state state or {@code null} for none
   */
  public RouterStatusBgpPeerStatus setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Status of the BgpPeer: {UP, DOWN}
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Status of the BgpPeer: {UP, DOWN}
   * @param status status or {@code null} for none
   */
  public RouterStatusBgpPeerStatus setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * Time this session has been up. Format: 1 second < uptime < 1 day = "23:59:59" 1 day <= uptime <
   * 1 week = "6d:23h:59m" 1 week <= uptime = "123w:6d:23h"
   * @return value or {@code null} for none
   */
  public java.lang.String getUptime() {
    return uptime;
  }

  /**
   * Time this session has been up. Format: 1 second < uptime < 1 day = "23:59:59" 1 day <= uptime <
   * 1 week = "6d:23h:59m" 1 week <= uptime = "123w:6d:23h"
   * @param uptime uptime or {@code null} for none
   */
  public RouterStatusBgpPeerStatus setUptime(java.lang.String uptime) {
    this.uptime = uptime;
    return this;
  }

  @Override
  public RouterStatusBgpPeerStatus set(String fieldName, Object value) {
    return (RouterStatusBgpPeerStatus) super.set(fieldName, value);
  }

  @Override
  public RouterStatusBgpPeerStatus clone() {
    return (RouterStatusBgpPeerStatus) super.clone();
  }

}
