/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2013-11-22 19:59:01 UTC)
 * on 2013-12-03 at 17:26:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * An operation resource, used to manage asynchronous API requests.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Operation extends com.google.api.client.json.GenericJson {

  /**
   * An optional identifier specified by the client when the mutation was initiated. Must be unique
   * for all operation resources in the project (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clientOperationId;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * The time that this operation was completed. This is in RFC 3339 format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String endTime;

  /**
   * If errors occurred during processing of this operation, this field will be populated (output
   * only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Error error;

  /**
   * If operation fails, the HTTP error message returned, e.g. NOT FOUND. (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String httpErrorMessage;

  /**
   * If operation fails, the HTTP error status code returned, e.g. 404. (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer httpErrorStatusCode;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * The time that this operation was requested. This is in RFC 3339 format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String insertTime;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Type of the operation. Examples include "insert", "update", and "delete" (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String operationType;

  /**
   * An optional progress indicator that ranges from 0 to 100. There is no requirement that this be
   * linear or support any granularity of operations. This should not be used to guess at when the
   * operation will be complete. This number should be monotonically increasing as the operation
   * progresses (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer progress;

  /**
   * URL of the region where the operation resides (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The time that this operation was started by the server. This is in RFC 3339 format (output
   * only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String startTime;

  /**
   * Status of the operation. Can be one of the following: "PENDING", "RUNNING", or "DONE" (output
   * only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * An optional textual description of the current status of the operation (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String statusMessage;

  /**
   * Unique target id which identifies a particular incarnation of the target (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger targetId;

  /**
   * URL of the resource the operation is mutating (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetLink;

  /**
   * User who requested the operation, for example "user@example.com" (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String user;

  /**
   * If warning messages generated during processing of this operation, this field will be populated
   * (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Warnings> warnings;

  static {
    // hack to force ProGuard to consider Warnings used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Warnings.class);
  }

  /**
   * URL of the zone where the operation resides (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * An optional identifier specified by the client when the mutation was initiated. Must be unique
   * for all operation resources in the project (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getClientOperationId() {
    return clientOperationId;
  }

  /**
   * An optional identifier specified by the client when the mutation was initiated. Must be unique
   * for all operation resources in the project (output only).
   * @param clientOperationId clientOperationId or {@code null} for none
   */
  public Operation setClientOperationId(java.lang.String clientOperationId) {
    this.clientOperationId = clientOperationId;
    return this;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public Operation setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * The time that this operation was completed. This is in RFC 3339 format (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getEndTime() {
    return endTime;
  }

  /**
   * The time that this operation was completed. This is in RFC 3339 format (output only).
   * @param endTime endTime or {@code null} for none
   */
  public Operation setEndTime(java.lang.String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * If errors occurred during processing of this operation, this field will be populated (output
   * only).
   * @return value or {@code null} for none
   */
  public Error getError() {
    return error;
  }

  /**
   * If errors occurred during processing of this operation, this field will be populated (output
   * only).
   * @param error error or {@code null} for none
   */
  public Operation setError(Error error) {
    this.error = error;
    return this;
  }

  /**
   * If operation fails, the HTTP error message returned, e.g. NOT FOUND. (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getHttpErrorMessage() {
    return httpErrorMessage;
  }

  /**
   * If operation fails, the HTTP error message returned, e.g. NOT FOUND. (output only).
   * @param httpErrorMessage httpErrorMessage or {@code null} for none
   */
  public Operation setHttpErrorMessage(java.lang.String httpErrorMessage) {
    this.httpErrorMessage = httpErrorMessage;
    return this;
  }

  /**
   * If operation fails, the HTTP error status code returned, e.g. 404. (output only).
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHttpErrorStatusCode() {
    return httpErrorStatusCode;
  }

  /**
   * If operation fails, the HTTP error status code returned, e.g. 404. (output only).
   * @param httpErrorStatusCode httpErrorStatusCode or {@code null} for none
   */
  public Operation setHttpErrorStatusCode(java.lang.Integer httpErrorStatusCode) {
    this.httpErrorStatusCode = httpErrorStatusCode;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @param id id or {@code null} for none
   */
  public Operation setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * The time that this operation was requested. This is in RFC 3339 format (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getInsertTime() {
    return insertTime;
  }

  /**
   * The time that this operation was requested. This is in RFC 3339 format (output only).
   * @param insertTime insertTime or {@code null} for none
   */
  public Operation setInsertTime(java.lang.String insertTime) {
    this.insertTime = insertTime;
    return this;
  }

  /**
   * Type of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * @param kind kind or {@code null} for none
   */
  public Operation setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource (output only).
   * @param name name or {@code null} for none
   */
  public Operation setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Type of the operation. Examples include "insert", "update", and "delete" (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getOperationType() {
    return operationType;
  }

  /**
   * Type of the operation. Examples include "insert", "update", and "delete" (output only).
   * @param operationType operationType or {@code null} for none
   */
  public Operation setOperationType(java.lang.String operationType) {
    this.operationType = operationType;
    return this;
  }

  /**
   * An optional progress indicator that ranges from 0 to 100. There is no requirement that this be
   * linear or support any granularity of operations. This should not be used to guess at when the
   * operation will be complete. This number should be monotonically increasing as the operation
   * progresses (output only).
   * @return value or {@code null} for none
   */
  public java.lang.Integer getProgress() {
    return progress;
  }

  /**
   * An optional progress indicator that ranges from 0 to 100. There is no requirement that this be
   * linear or support any granularity of operations. This should not be used to guess at when the
   * operation will be complete. This number should be monotonically increasing as the operation
   * progresses (output only).
   * @param progress progress or {@code null} for none
   */
  public Operation setProgress(java.lang.Integer progress) {
    this.progress = progress;
    return this;
  }

  /**
   * URL of the region where the operation resides (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * URL of the region where the operation resides (output only).
   * @param region region or {@code null} for none
   */
  public Operation setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * @param selfLink selfLink or {@code null} for none
   */
  public Operation setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The time that this operation was started by the server. This is in RFC 3339 format (output
   * only).
   * @return value or {@code null} for none
   */
  public java.lang.String getStartTime() {
    return startTime;
  }

  /**
   * The time that this operation was started by the server. This is in RFC 3339 format (output
   * only).
   * @param startTime startTime or {@code null} for none
   */
  public Operation setStartTime(java.lang.String startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * Status of the operation. Can be one of the following: "PENDING", "RUNNING", or "DONE" (output
   * only).
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Status of the operation. Can be one of the following: "PENDING", "RUNNING", or "DONE" (output
   * only).
   * @param status status or {@code null} for none
   */
  public Operation setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * An optional textual description of the current status of the operation (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getStatusMessage() {
    return statusMessage;
  }

  /**
   * An optional textual description of the current status of the operation (output only).
   * @param statusMessage statusMessage or {@code null} for none
   */
  public Operation setStatusMessage(java.lang.String statusMessage) {
    this.statusMessage = statusMessage;
    return this;
  }

  /**
   * Unique target id which identifies a particular incarnation of the target (output only).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getTargetId() {
    return targetId;
  }

  /**
   * Unique target id which identifies a particular incarnation of the target (output only).
   * @param targetId targetId or {@code null} for none
   */
  public Operation setTargetId(java.math.BigInteger targetId) {
    this.targetId = targetId;
    return this;
  }

  /**
   * URL of the resource the operation is mutating (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetLink() {
    return targetLink;
  }

  /**
   * URL of the resource the operation is mutating (output only).
   * @param targetLink targetLink or {@code null} for none
   */
  public Operation setTargetLink(java.lang.String targetLink) {
    this.targetLink = targetLink;
    return this;
  }

  /**
   * User who requested the operation, for example "user@example.com" (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getUser() {
    return user;
  }

  /**
   * User who requested the operation, for example "user@example.com" (output only).
   * @param user user or {@code null} for none
   */
  public Operation setUser(java.lang.String user) {
    this.user = user;
    return this;
  }

  /**
   * If warning messages generated during processing of this operation, this field will be populated
   * (output only).
   * @return value or {@code null} for none
   */
  public java.util.List<Warnings> getWarnings() {
    return warnings;
  }

  /**
   * If warning messages generated during processing of this operation, this field will be populated
   * (output only).
   * @param warnings warnings or {@code null} for none
   */
  public Operation setWarnings(java.util.List<Warnings> warnings) {
    this.warnings = warnings;
    return this;
  }

  /**
   * URL of the zone where the operation resides (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * URL of the zone where the operation resides (output only).
   * @param zone zone or {@code null} for none
   */
  public Operation setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public Operation set(String fieldName, Object value) {
    return (Operation) super.set(fieldName, value);
  }

  @Override
  public Operation clone() {
    return (Operation) super.clone();
  }

  /**
   * If errors occurred during processing of this operation, this field will be populated (output
   * only).
   */
  public static final class Error extends com.google.api.client.json.GenericJson {

    /**
     * The array of errors encountered while processing this operation.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Errors> errors;

    static {
      // hack to force ProGuard to consider Errors used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(Errors.class);
    }

    /**
     * The array of errors encountered while processing this operation.
     * @return value or {@code null} for none
     */
    public java.util.List<Errors> getErrors() {
      return errors;
    }

    /**
     * The array of errors encountered while processing this operation.
     * @param errors errors or {@code null} for none
     */
    public Error setErrors(java.util.List<Errors> errors) {
      this.errors = errors;
      return this;
    }

    @Override
    public Error set(String fieldName, Object value) {
      return (Error) super.set(fieldName, value);
    }

    @Override
    public Error clone() {
      return (Error) super.clone();
    }

    /**
     * Model definition for OperationErrorErrors.
     */
    public static final class Errors extends com.google.api.client.json.GenericJson {

      /**
       * The error type identifier for this error.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String code;

      /**
       * Indicates the field in the request which caused the error. This property is optional.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String location;

      /**
       * An optional, human-readable error message.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String message;

      /**
       * The error type identifier for this error.
       * @return value or {@code null} for none
       */
      public java.lang.String getCode() {
        return code;
      }

      /**
       * The error type identifier for this error.
       * @param code code or {@code null} for none
       */
      public Errors setCode(java.lang.String code) {
        this.code = code;
        return this;
      }

      /**
       * Indicates the field in the request which caused the error. This property is optional.
       * @return value or {@code null} for none
       */
      public java.lang.String getLocation() {
        return location;
      }

      /**
       * Indicates the field in the request which caused the error. This property is optional.
       * @param location location or {@code null} for none
       */
      public Errors setLocation(java.lang.String location) {
        this.location = location;
        return this;
      }

      /**
       * An optional, human-readable error message.
       * @return value or {@code null} for none
       */
      public java.lang.String getMessage() {
        return message;
      }

      /**
       * An optional, human-readable error message.
       * @param message message or {@code null} for none
       */
      public Errors setMessage(java.lang.String message) {
        this.message = message;
        return this;
      }

      @Override
      public Errors set(String fieldName, Object value) {
        return (Errors) super.set(fieldName, value);
      }

      @Override
      public Errors clone() {
        return (Errors) super.clone();
      }

    }
  }

  /**
   * Model definition for OperationWarnings.
   */
  public static final class Warnings extends com.google.api.client.json.GenericJson {

    /**
     * The warning type identifier for this warning.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String code;

    /**
     * Metadata for this warning in 'key: value' format.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Data> data;

    static {
      // hack to force ProGuard to consider Data used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(Data.class);
    }

    /**
     * Optional human-readable details for this warning.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String message;

    /**
     * The warning type identifier for this warning.
     * @return value or {@code null} for none
     */
    public java.lang.String getCode() {
      return code;
    }

    /**
     * The warning type identifier for this warning.
     * @param code code or {@code null} for none
     */
    public Warnings setCode(java.lang.String code) {
      this.code = code;
      return this;
    }

    /**
     * Metadata for this warning in 'key: value' format.
     * @return value or {@code null} for none
     */
    public java.util.List<Data> getData() {
      return data;
    }

    /**
     * Metadata for this warning in 'key: value' format.
     * @param data data or {@code null} for none
     */
    public Warnings setData(java.util.List<Data> data) {
      this.data = data;
      return this;
    }

    /**
     * Optional human-readable details for this warning.
     * @return value or {@code null} for none
     */
    public java.lang.String getMessage() {
      return message;
    }

    /**
     * Optional human-readable details for this warning.
     * @param message message or {@code null} for none
     */
    public Warnings setMessage(java.lang.String message) {
      this.message = message;
      return this;
    }

    @Override
    public Warnings set(String fieldName, Object value) {
      return (Warnings) super.set(fieldName, value);
    }

    @Override
    public Warnings clone() {
      return (Warnings) super.clone();
    }

    /**
     * Model definition for OperationWarningsData.
     */
    public static final class Data extends com.google.api.client.json.GenericJson {

      /**
       * A key for the warning data.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String key;

      /**
       * A warning data value corresponding to the key.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String value;

      /**
       * A key for the warning data.
       * @return value or {@code null} for none
       */
      public java.lang.String getKey() {
        return key;
      }

      /**
       * A key for the warning data.
       * @param key key or {@code null} for none
       */
      public Data setKey(java.lang.String key) {
        this.key = key;
        return this;
      }

      /**
       * A warning data value corresponding to the key.
       * @return value or {@code null} for none
       */
      public java.lang.String getValue() {
        return value;
      }

      /**
       * A warning data value corresponding to the key.
       * @param value value or {@code null} for none
       */
      public Data setValue(java.lang.String value) {
        this.value = value;
        return this;
      }

      @Override
      public Data set(String fieldName, Object value) {
        return (Data) super.set(fieldName, value);
      }

      @Override
      public Data clone() {
        return (Data) super.clone();
      }

    }
  }

}
