/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-21 at 01:57:25 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute;

/**
 * Service definition for Compute (v1).
 *
 * <p>
 * Creates and runs virtual machines on Google Cloud Platform.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/compute/docs/reference/latest/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link ComputeRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Compute extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.21.0 of the Compute Engine API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "compute/v1/projects/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Compute(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Compute(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Addresses collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Addresses.List request = compute.addresses().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Addresses addresses() {
    return new Addresses();
  }

  /**
   * The "addresses" collection of methods.
   */
  public class Addresses {

    /**
     * Retrieves an aggregated list of addresses.
     *
     * Create a request for the method "addresses.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.AddressAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of addresses.
       *
       * Create a request for the method "addresses.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AddressAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified address resource.
     *
     * Create a request for the method "addresses.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region for this request.
     * @param address Name of the address resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String region, java.lang.String address) throws java.io.IOException {
      Delete result = new Delete(project, region, address);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified address resource.
       *
       * Create a request for the method "addresses.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region for this request.
       * @param address Name of the address resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String region, java.lang.String address) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = com.google.api.client.util.Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region for this request. */
      public Delete setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the address resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String address;

      /** Name of the address resource to delete.
       */
      public java.lang.String getAddress() {
        return address;
      }

      /** Name of the address resource to delete. */
      public Delete setAddress(java.lang.String address) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = address;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified address resource.
     *
     * Create a request for the method "addresses.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region for this request.
     * @param address Name of the address resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region, java.lang.String address) throws java.io.IOException {
      Get result = new Get(project, region, address);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Address> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified address resource.
       *
       * Create a request for the method "addresses.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region for this request.
       * @param address Name of the address resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region, java.lang.String address) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Address.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = com.google.api.client.util.Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region for this request. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the address resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String address;

      /** Name of the address resource to return.
       */
      public java.lang.String getAddress() {
        return address;
      }

      /** Name of the address resource to return. */
      public Get setAddress(java.lang.String address) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = address;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an address resource in the specified project using the data included in the request.
     *
     * Create a request for the method "addresses.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region for this request.
     * @param content the {@link com.google.api.services.compute.model.Address}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.Address content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates an address resource in the specified project using the data included in the request.
       *
       * Create a request for the method "addresses.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region for this request.
       * @param content the {@link com.google.api.services.compute.model.Address}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.Address content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region for this request. */
      public Insert setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of addresses contained within the specified region.
     *
     * Create a request for the method "addresses.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.AddressList> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of addresses contained within the specified region.
       *
       * Create a request for the method "addresses.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AddressList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region for this request. */
      public List setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Autoscalers collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Autoscalers.List request = compute.autoscalers().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Autoscalers autoscalers() {
    return new Autoscalers();
  }

  /**
   * The "autoscalers" collection of methods.
   */
  public class Autoscalers {

    /**
     * Retrieves an aggregated list of autoscalers.
     *
     * Create a request for the method "autoscalers.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.AutoscalerAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/autoscalers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of autoscalers.
       *
       * Create a request for the method "autoscalers.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AutoscalerAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified autoscaler.
     *
     * Create a request for the method "autoscalers.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @param autoscaler Name of the autoscaler to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String autoscaler) throws java.io.IOException {
      Delete result = new Delete(project, zone, autoscaler);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/autoscalers/{autoscaler}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern AUTOSCALER_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified autoscaler.
       *
       * Create a request for the method "autoscalers.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @param autoscaler Name of the autoscaler to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String autoscaler) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoscaler = com.google.api.client.util.Preconditions.checkNotNull(autoscaler, "Required parameter autoscaler must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public Delete setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the autoscaler to delete. */
      @com.google.api.client.util.Key
      private java.lang.String autoscaler;

      /** Name of the autoscaler to delete.
       */
      public java.lang.String getAutoscaler() {
        return autoscaler;
      }

      /** Name of the autoscaler to delete. */
      public Delete setAutoscaler(java.lang.String autoscaler) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoscaler = autoscaler;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified autoscaler resource. Get a list of available autoscalers by making a list()
     * request.
     *
     * Create a request for the method "autoscalers.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @param autoscaler Name of the autoscaler to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String autoscaler) throws java.io.IOException {
      Get result = new Get(project, zone, autoscaler);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Autoscaler> {

      private static final String REST_PATH = "{project}/zones/{zone}/autoscalers/{autoscaler}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern AUTOSCALER_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified autoscaler resource. Get a list of available autoscalers by making a
       * list() request.
       *
       * Create a request for the method "autoscalers.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @param autoscaler Name of the autoscaler to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String autoscaler) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Autoscaler.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoscaler = com.google.api.client.util.Preconditions.checkNotNull(autoscaler, "Required parameter autoscaler must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the autoscaler to return. */
      @com.google.api.client.util.Key
      private java.lang.String autoscaler;

      /** Name of the autoscaler to return.
       */
      public java.lang.String getAutoscaler() {
        return autoscaler;
      }

      /** Name of the autoscaler to return. */
      public Get setAutoscaler(java.lang.String autoscaler) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoscaler = autoscaler;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an autoscaler in the specified project using the data included in the request.
     *
     * Create a request for the method "autoscalers.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @param content the {@link com.google.api.services.compute.model.Autoscaler}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Autoscaler content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/autoscalers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates an autoscaler in the specified project using the data included in the request.
       *
       * Create a request for the method "autoscalers.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @param content the {@link com.google.api.services.compute.model.Autoscaler}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Autoscaler content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public Insert setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of autoscalers contained within the specified zone.
     *
     * Create a request for the method "autoscalers.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.AutoscalerList> {

      private static final String REST_PATH = "{project}/zones/{zone}/autoscalers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of autoscalers contained within the specified zone.
       *
       * Create a request for the method "autoscalers.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AutoscalerList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an autoscaler in the specified project using the data included in the request. This
     * method supports patch semantics.
     *
     * Create a request for the method "autoscalers.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @param autoscaler Name of the autoscaler to update.
     * @param content the {@link com.google.api.services.compute.model.Autoscaler}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String zone, java.lang.String autoscaler, com.google.api.services.compute.model.Autoscaler content) throws java.io.IOException {
      Patch result = new Patch(project, zone, autoscaler, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/autoscalers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern AUTOSCALER_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates an autoscaler in the specified project using the data included in the request. This
       * method supports patch semantics.
       *
       * Create a request for the method "autoscalers.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @param autoscaler Name of the autoscaler to update.
       * @param content the {@link com.google.api.services.compute.model.Autoscaler}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String zone, java.lang.String autoscaler, com.google.api.services.compute.model.Autoscaler content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoscaler = com.google.api.client.util.Preconditions.checkNotNull(autoscaler, "Required parameter autoscaler must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public Patch setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the autoscaler to update. */
      @com.google.api.client.util.Key
      private java.lang.String autoscaler;

      /** Name of the autoscaler to update.
       */
      public java.lang.String getAutoscaler() {
        return autoscaler;
      }

      /** Name of the autoscaler to update. */
      public Patch setAutoscaler(java.lang.String autoscaler) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoscaler = autoscaler;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates an autoscaler in the specified project using the data included in the request.
     *
     * Create a request for the method "autoscalers.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @param content the {@link com.google.api.services.compute.model.Autoscaler}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Autoscaler content) throws java.io.IOException {
      Update result = new Update(project, zone, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/autoscalers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern AUTOSCALER_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates an autoscaler in the specified project using the data included in the request.
       *
       * Create a request for the method "autoscalers.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @param content the {@link com.google.api.services.compute.model.Autoscaler}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Autoscaler content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public Update setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the autoscaler to update. */
      @com.google.api.client.util.Key
      private java.lang.String autoscaler;

      /** Name of the autoscaler to update.
       */
      public java.lang.String getAutoscaler() {
        return autoscaler;
      }

      /** Name of the autoscaler to update. */
      public Update setAutoscaler(java.lang.String autoscaler) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoscaler = autoscaler;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the BackendServices collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.BackendServices.List request = compute.backendServices().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public BackendServices backendServices() {
    return new BackendServices();
  }

  /**
   * The "backendServices" collection of methods.
   */
  public class BackendServices {

    /**
     * Deletes the specified BackendService resource.
     *
     * Create a request for the method "backendServices.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String backendService) throws java.io.IOException {
      Delete result = new Delete(project, backendService);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified BackendService resource.
       *
       * Create a request for the method "backendServices.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String backendService) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to delete.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to delete. */
      public Delete setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendService = backendService;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified BackendService resource. Get a list of available backend services by making
     * a list() request.
     *
     * Create a request for the method "backendServices.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String backendService) throws java.io.IOException {
      Get result = new Get(project, backendService);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.BackendService> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified BackendService resource. Get a list of available backend services by
       * making a list() request.
       *
       * Create a request for the method "backendServices.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String backendService) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.BackendService.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to return.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to return. */
      public Get setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendService = backendService;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets the most recent health check results for this BackendService.
     *
     * Create a request for the method "backendServices.getHealth".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetHealth#execute()} method to invoke the remote operation.
     *
     * @param project
     * @param backendService Name of the BackendService resource to which the queried instance belongs.
     * @param content the {@link com.google.api.services.compute.model.ResourceGroupReference}
     * @return the request
     */
    public GetHealth getHealth(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.ResourceGroupReference content) throws java.io.IOException {
      GetHealth result = new GetHealth(project, backendService, content);
      initialize(result);
      return result;
    }

    public class GetHealth extends ComputeRequest<com.google.api.services.compute.model.BackendServiceGroupHealth> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}/getHealth";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Gets the most recent health check results for this BackendService.
       *
       * Create a request for the method "backendServices.getHealth".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetHealth#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetHealth#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project
       * @param backendService Name of the BackendService resource to which the queried instance belongs.
       * @param content the {@link com.google.api.services.compute.model.ResourceGroupReference}
       * @since 1.13
       */
      protected GetHealth(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.ResourceGroupReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.BackendServiceGroupHealth.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public GetHealth setAlt(java.lang.String alt) {
        return (GetHealth) super.setAlt(alt);
      }

      @Override
      public GetHealth setFields(java.lang.String fields) {
        return (GetHealth) super.setFields(fields);
      }

      @Override
      public GetHealth setKey(java.lang.String key) {
        return (GetHealth) super.setKey(key);
      }

      @Override
      public GetHealth setOauthToken(java.lang.String oauthToken) {
        return (GetHealth) super.setOauthToken(oauthToken);
      }

      @Override
      public GetHealth setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetHealth) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetHealth setQuotaUser(java.lang.String quotaUser) {
        return (GetHealth) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetHealth setUserIp(java.lang.String userIp) {
        return (GetHealth) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String project;

      /**

       */
      public java.lang.String getProject() {
        return project;
      }

      public GetHealth setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to which the queried instance belongs. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to which the queried instance belongs.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to which the queried instance belongs. */
      public GetHealth setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendService = backendService;
        return this;
      }

      @Override
      public GetHealth set(String parameterName, Object value) {
        return (GetHealth) super.set(parameterName, value);
      }
    }
    /**
     * Creates a BackendService resource in the specified project using the data included in the
     * request. There are several restrictions and guidelines to keep in mind when creating a backend
     * service. Read  Restrictions and Guidelines for more information.
     *
     * Create a request for the method "backendServices.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.BackendService}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.BackendService content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendServices";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a BackendService resource in the specified project using the data included in the
       * request. There are several restrictions and guidelines to keep in mind when creating a backend
       * service. Read  Restrictions and Guidelines for more information.
       *
       * Create a request for the method "backendServices.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.BackendService}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.BackendService content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of BackendService resources available to the specified project.
     *
     * Create a request for the method "backendServices.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.BackendServiceList> {

      private static final String REST_PATH = "{project}/global/backendServices";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of BackendService resources available to the specified project.
       *
       * Create a request for the method "backendServices.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.BackendServiceList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the entire content of the BackendService resource. There are several restrictions and
     * guidelines to keep in mind when updating a backend service. Read  Restrictions and Guidelines for
     * more information. This method supports patch semantics.
     *
     * Create a request for the method "backendServices.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to update.
     * @param content the {@link com.google.api.services.compute.model.BackendService}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.BackendService content) throws java.io.IOException {
      Patch result = new Patch(project, backendService, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates the entire content of the BackendService resource. There are several restrictions and
       * guidelines to keep in mind when updating a backend service. Read  Restrictions and Guidelines
       * for more information. This method supports patch semantics.
       *
       * Create a request for the method "backendServices.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to update.
       * @param content the {@link com.google.api.services.compute.model.BackendService}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.BackendService content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to update.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to update. */
      public Patch setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendService = backendService;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the entire content of the BackendService resource. There are several restrictions and
     * guidelines to keep in mind when updating a backend service. Read  Restrictions and Guidelines for
     * more information.
     *
     * Create a request for the method "backendServices.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to update.
     * @param content the {@link com.google.api.services.compute.model.BackendService}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.BackendService content) throws java.io.IOException {
      Update result = new Update(project, backendService, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates the entire content of the BackendService resource. There are several restrictions and
       * guidelines to keep in mind when updating a backend service. Read  Restrictions and Guidelines
       * for more information.
       *
       * Create a request for the method "backendServices.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to update.
       * @param content the {@link com.google.api.services.compute.model.BackendService}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.BackendService content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to update.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to update. */
      public Update setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendService = backendService;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the DiskTypes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.DiskTypes.List request = compute.diskTypes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public DiskTypes diskTypes() {
    return new DiskTypes();
  }

  /**
   * The "diskTypes" collection of methods.
   */
  public class DiskTypes {

    /**
     * Retrieves an aggregated list of disk types.
     *
     * Create a request for the method "diskTypes.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.DiskTypeAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/diskTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of disk types.
       *
       * Create a request for the method "diskTypes.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskTypeAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified disk type. Get a list of available disk types by making a list() request.
     *
     * Create a request for the method "diskTypes.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param diskType Name of the disk type to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String diskType) throws java.io.IOException {
      Get result = new Get(project, zone, diskType);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.DiskType> {

      private static final String REST_PATH = "{project}/zones/{zone}/diskTypes/{diskType}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_TYPE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified disk type. Get a list of available disk types by making a list() request.
       *
       * Create a request for the method "diskTypes.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param diskType Name of the disk type to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String diskType) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskType.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.diskType = com.google.api.client.util.Preconditions.checkNotNull(diskType, "Required parameter diskType must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_TYPE_PATTERN.matcher(diskType).matches(),
              "Parameter diskType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the disk type to return. */
      @com.google.api.client.util.Key
      private java.lang.String diskType;

      /** Name of the disk type to return.
       */
      public java.lang.String getDiskType() {
        return diskType;
      }

      /** Name of the disk type to return. */
      public Get setDiskType(java.lang.String diskType) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_TYPE_PATTERN.matcher(diskType).matches(),
              "Parameter diskType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.diskType = diskType;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of disk types available to the specified project.
     *
     * Create a request for the method "diskTypes.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.DiskTypeList> {

      private static final String REST_PATH = "{project}/zones/{zone}/diskTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of disk types available to the specified project.
       *
       * Create a request for the method "diskTypes.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskTypeList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Disks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Disks.List request = compute.disks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Disks disks() {
    return new Disks();
  }

  /**
   * The "disks" collection of methods.
   */
  public class Disks {

    /**
     * Retrieves an aggregated list of persistent disks.
     *
     * Create a request for the method "disks.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.DiskAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of persistent disks.
       *
       * Create a request for the method "disks.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Creates a snapshot of a specified persistent disk.
     *
     * Create a request for the method "disks.createSnapshot".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link CreateSnapshot#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk Name of the persistent disk to snapshot.
     * @param content the {@link com.google.api.services.compute.model.Snapshot}
     * @return the request
     */
    public CreateSnapshot createSnapshot(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.Snapshot content) throws java.io.IOException {
      CreateSnapshot result = new CreateSnapshot(project, zone, disk, content);
      initialize(result);
      return result;
    }

    public class CreateSnapshot extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}/createSnapshot";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a snapshot of a specified persistent disk.
       *
       * Create a request for the method "disks.createSnapshot".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link CreateSnapshot#execute()} method to invoke the remote operation.
       * <p> {@link CreateSnapshot#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk Name of the persistent disk to snapshot.
       * @param content the {@link com.google.api.services.compute.model.Snapshot}
       * @since 1.13
       */
      protected CreateSnapshot(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.Snapshot content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public CreateSnapshot setAlt(java.lang.String alt) {
        return (CreateSnapshot) super.setAlt(alt);
      }

      @Override
      public CreateSnapshot setFields(java.lang.String fields) {
        return (CreateSnapshot) super.setFields(fields);
      }

      @Override
      public CreateSnapshot setKey(java.lang.String key) {
        return (CreateSnapshot) super.setKey(key);
      }

      @Override
      public CreateSnapshot setOauthToken(java.lang.String oauthToken) {
        return (CreateSnapshot) super.setOauthToken(oauthToken);
      }

      @Override
      public CreateSnapshot setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (CreateSnapshot) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public CreateSnapshot setQuotaUser(java.lang.String quotaUser) {
        return (CreateSnapshot) super.setQuotaUser(quotaUser);
      }

      @Override
      public CreateSnapshot setUserIp(java.lang.String userIp) {
        return (CreateSnapshot) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public CreateSnapshot setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public CreateSnapshot setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk to snapshot. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** Name of the persistent disk to snapshot.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** Name of the persistent disk to snapshot. */
      public CreateSnapshot setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = disk;
        return this;
      }

      @Override
      public CreateSnapshot set(String parameterName, Object value) {
        return (CreateSnapshot) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified persistent disk. Deleting a disk removes its data permanently and is
     * irreversible. However, deleting a disk does not delete any snapshots previously made from the
     * disk. You must separately delete snapshots.
     *
     * Create a request for the method "disks.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk Name of the persistent disk to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String disk) throws java.io.IOException {
      Delete result = new Delete(project, zone, disk);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified persistent disk. Deleting a disk removes its data permanently and is
       * irreversible. However, deleting a disk does not delete any snapshots previously made from the
       * disk. You must separately delete snapshots.
       *
       * Create a request for the method "disks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk Name of the persistent disk to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String disk) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Delete setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk to delete. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** Name of the persistent disk to delete.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** Name of the persistent disk to delete. */
      public Delete setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = disk;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns a specified persistent disk. Get a list of available persistent disks by making a list()
     * request.
     *
     * Create a request for the method "disks.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk Name of the persistent disk to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String disk) throws java.io.IOException {
      Get result = new Get(project, zone, disk);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Disk> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns a specified persistent disk. Get a list of available persistent disks by making a
       * list() request.
       *
       * Create a request for the method "disks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk Name of the persistent disk to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String disk) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Disk.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk to return. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** Name of the persistent disk to return.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** Name of the persistent disk to return. */
      public Get setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = disk;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a persistent disk in the specified project using the data in the request. You can create
     * a disk with a sourceImage, a sourceSnapshot, or create an empty 500 GB data disk by omitting all
     * properties. You can also create a disk that is larger than the default size by specifying the
     * sizeGb property.
     *
     * Create a request for the method "disks.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param content the {@link com.google.api.services.compute.model.Disk}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Disk content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a persistent disk in the specified project using the data in the request. You can
       * create a disk with a sourceImage, a sourceSnapshot, or create an empty 500 GB data disk by
       * omitting all properties. You can also create a disk that is larger than the default size by
       * specifying the sizeGb property.
       *
       * Create a request for the method "disks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param content the {@link com.google.api.services.compute.model.Disk}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Disk content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Insert setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Optional. Source image to restore onto a disk. */
      @com.google.api.client.util.Key
      private java.lang.String sourceImage;

      /** Optional. Source image to restore onto a disk.
       */
      public java.lang.String getSourceImage() {
        return sourceImage;
      }

      /** Optional. Source image to restore onto a disk. */
      public Insert setSourceImage(java.lang.String sourceImage) {
        this.sourceImage = sourceImage;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of persistent disks contained within the specified zone.
     *
     * Create a request for the method "disks.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.DiskList> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of persistent disks contained within the specified zone.
       *
       * Create a request for the method "disks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Resizes the specified persistent disk.
     *
     * Create a request for the method "disks.resize".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Resize#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk The name of the persistent disk.
     * @param content the {@link com.google.api.services.compute.model.DisksResizeRequest}
     * @return the request
     */
    public Resize resize(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.DisksResizeRequest content) throws java.io.IOException {
      Resize result = new Resize(project, zone, disk, content);
      initialize(result);
      return result;
    }

    public class Resize extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}/resize";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Resizes the specified persistent disk.
       *
       * Create a request for the method "disks.resize".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Resize#execute()} method to invoke the remote operation. <p> {@link
       * Resize#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk The name of the persistent disk.
       * @param content the {@link com.google.api.services.compute.model.DisksResizeRequest}
       * @since 1.13
       */
      protected Resize(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.DisksResizeRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Resize setAlt(java.lang.String alt) {
        return (Resize) super.setAlt(alt);
      }

      @Override
      public Resize setFields(java.lang.String fields) {
        return (Resize) super.setFields(fields);
      }

      @Override
      public Resize setKey(java.lang.String key) {
        return (Resize) super.setKey(key);
      }

      @Override
      public Resize setOauthToken(java.lang.String oauthToken) {
        return (Resize) super.setOauthToken(oauthToken);
      }

      @Override
      public Resize setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Resize) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Resize setQuotaUser(java.lang.String quotaUser) {
        return (Resize) super.setQuotaUser(quotaUser);
      }

      @Override
      public Resize setUserIp(java.lang.String userIp) {
        return (Resize) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Resize setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Resize setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** The name of the persistent disk. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** The name of the persistent disk.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** The name of the persistent disk. */
      public Resize setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = disk;
        return this;
      }

      @Override
      public Resize set(String parameterName, Object value) {
        return (Resize) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Firewalls collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Firewalls.List request = compute.firewalls().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Firewalls firewalls() {
    return new Firewalls();
  }

  /**
   * The "firewalls" collection of methods.
   */
  public class Firewalls {

    /**
     * Deletes the specified firewall.
     *
     * Create a request for the method "firewalls.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param firewall Name of the firewall rule to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String firewall) throws java.io.IOException {
      Delete result = new Delete(project, firewall);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified firewall.
       *
       * Create a request for the method "firewalls.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param firewall Name of the firewall rule to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String firewall) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall rule to delete. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall rule to delete.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall rule to delete. */
      public Delete setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified firewall.
     *
     * Create a request for the method "firewalls.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param firewall Name of the firewall rule to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String firewall) throws java.io.IOException {
      Get result = new Get(project, firewall);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Firewall> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified firewall.
       *
       * Create a request for the method "firewalls.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param firewall Name of the firewall rule to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String firewall) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Firewall.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall rule to return. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall rule to return.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall rule to return. */
      public Get setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a firewall rule in the specified project using the data included in the request.
     *
     * Create a request for the method "firewalls.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a firewall rule in the specified project using the data included in the request.
       *
       * Create a request for the method "firewalls.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of firewall rules available to the specified project.
     *
     * Create a request for the method "firewalls.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.FirewallList> {

      private static final String REST_PATH = "{project}/global/firewalls";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of firewall rules available to the specified project.
       *
       * Create a request for the method "firewalls.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.FirewallList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified firewall rule with the data included in the request. This method supports
     * patch semantics.
     *
     * Create a request for the method "firewalls.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param firewall Name of the firewall rule to update.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Patch result = new Patch(project, firewall, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates the specified firewall rule with the data included in the request. This method supports
       * patch semantics.
       *
       * Create a request for the method "firewalls.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param firewall Name of the firewall rule to update.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall rule to update. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall rule to update.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall rule to update. */
      public Patch setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified firewall rule with the data included in the request.
     *
     * Create a request for the method "firewalls.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param firewall Name of the firewall rule to update.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Update result = new Update(project, firewall, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates the specified firewall rule with the data included in the request.
       *
       * Create a request for the method "firewalls.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param firewall Name of the firewall rule to update.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall rule to update. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall rule to update.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall rule to update. */
      public Update setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ForwardingRules collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.ForwardingRules.List request = compute.forwardingRules().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ForwardingRules forwardingRules() {
    return new ForwardingRules();
  }

  /**
   * The "forwardingRules" collection of methods.
   */
  public class ForwardingRules {

    /**
     * Retrieves an aggregated list of forwarding rules.
     *
     * Create a request for the method "forwardingRules.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.ForwardingRuleAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of forwarding rules.
       *
       * Create a request for the method "forwardingRules.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRuleAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified ForwardingRule resource.
     *
     * Create a request for the method "forwardingRules.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) throws java.io.IOException {
      Delete result = new Delete(project, region, forwardingRule);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified ForwardingRule resource.
       *
       * Create a request for the method "forwardingRules.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Delete setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource to delete.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to delete. */
      public Delete setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified ForwardingRule resource.
     *
     * Create a request for the method "forwardingRules.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) throws java.io.IOException {
      Get result = new Get(project, region, forwardingRule);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.ForwardingRule> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified ForwardingRule resource.
       *
       * Create a request for the method "forwardingRules.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRule.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource to return.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to return. */
      public Get setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a ForwardingRule resource in the specified project and region using the data included in
     * the request.
     *
     * Create a request for the method "forwardingRules.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.ForwardingRule content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a ForwardingRule resource in the specified project and region using the data included
       * in the request.
       *
       * Create a request for the method "forwardingRules.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region scoping this request.
       * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.ForwardingRule content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Insert setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of ForwardingRule resources available to the specified project and region.
     *
     * Create a request for the method "forwardingRules.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ForwardingRuleList> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of ForwardingRule resources available to the specified project and region.
       *
       * Create a request for the method "forwardingRules.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRuleList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public List setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Changes target URL for forwarding rule. The new target should be of the same type as the old
     * target.
     *
     * Create a request for the method "forwardingRules.setTarget".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetTarget#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource in which target is to be set.
     * @param content the {@link com.google.api.services.compute.model.TargetReference}
     * @return the request
     */
    public SetTarget setTarget(java.lang.String project, java.lang.String region, java.lang.String forwardingRule, com.google.api.services.compute.model.TargetReference content) throws java.io.IOException {
      SetTarget result = new SetTarget(project, region, forwardingRule, content);
      initialize(result);
      return result;
    }

    public class SetTarget extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}/setTarget";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Changes target URL for forwarding rule. The new target should be of the same type as the old
       * target.
       *
       * Create a request for the method "forwardingRules.setTarget".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetTarget#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetTarget#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource in which target is to be set.
       * @param content the {@link com.google.api.services.compute.model.TargetReference}
       * @since 1.13
       */
      protected SetTarget(java.lang.String project, java.lang.String region, java.lang.String forwardingRule, com.google.api.services.compute.model.TargetReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetTarget setAlt(java.lang.String alt) {
        return (SetTarget) super.setAlt(alt);
      }

      @Override
      public SetTarget setFields(java.lang.String fields) {
        return (SetTarget) super.setFields(fields);
      }

      @Override
      public SetTarget setKey(java.lang.String key) {
        return (SetTarget) super.setKey(key);
      }

      @Override
      public SetTarget setOauthToken(java.lang.String oauthToken) {
        return (SetTarget) super.setOauthToken(oauthToken);
      }

      @Override
      public SetTarget setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetTarget) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetTarget setQuotaUser(java.lang.String quotaUser) {
        return (SetTarget) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetTarget setUserIp(java.lang.String userIp) {
        return (SetTarget) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetTarget setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public SetTarget setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource in which target is to be set. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource in which target is to be set.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource in which target is to be set. */
      public SetTarget setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public SetTarget set(String parameterName, Object value) {
        return (SetTarget) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the GlobalAddresses collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.GlobalAddresses.List request = compute.globalAddresses().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public GlobalAddresses globalAddresses() {
    return new GlobalAddresses();
  }

  /**
   * The "globalAddresses" collection of methods.
   */
  public class GlobalAddresses {

    /**
     * Deletes the specified address resource.
     *
     * Create a request for the method "globalAddresses.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param address Name of the address resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String address) throws java.io.IOException {
      Delete result = new Delete(project, address);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified address resource.
       *
       * Create a request for the method "globalAddresses.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param address Name of the address resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String address) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.address = com.google.api.client.util.Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the address resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String address;

      /** Name of the address resource to delete.
       */
      public java.lang.String getAddress() {
        return address;
      }

      /** Name of the address resource to delete. */
      public Delete setAddress(java.lang.String address) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = address;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified address resource. Get a list of available addresses by making a list()
     * request.
     *
     * Create a request for the method "globalAddresses.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param address Name of the address resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String address) throws java.io.IOException {
      Get result = new Get(project, address);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Address> {

      private static final String REST_PATH = "{project}/global/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified address resource. Get a list of available addresses by making a list()
       * request.
       *
       * Create a request for the method "globalAddresses.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param address Name of the address resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String address) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Address.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.address = com.google.api.client.util.Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the address resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String address;

      /** Name of the address resource to return.
       */
      public java.lang.String getAddress() {
        return address;
      }

      /** Name of the address resource to return. */
      public Get setAddress(java.lang.String address) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = address;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an address resource in the specified project using the data included in the request.
     *
     * Create a request for the method "globalAddresses.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.Address}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Address content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates an address resource in the specified project using the data included in the request.
       *
       * Create a request for the method "globalAddresses.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.Address}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Address content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of global addresses.
     *
     * Create a request for the method "globalAddresses.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.AddressList> {

      private static final String REST_PATH = "{project}/global/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves a list of global addresses.
       *
       * Create a request for the method "globalAddresses.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AddressList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the GlobalForwardingRules collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.GlobalForwardingRules.List request = compute.globalForwardingRules().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public GlobalForwardingRules globalForwardingRules() {
    return new GlobalForwardingRules();
  }

  /**
   * The "globalForwardingRules" collection of methods.
   */
  public class GlobalForwardingRules {

    /**
     * Deletes the specified ForwardingRule resource.
     *
     * Create a request for the method "globalForwardingRules.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param forwardingRule Name of the ForwardingRule resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String forwardingRule) throws java.io.IOException {
      Delete result = new Delete(project, forwardingRule);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified ForwardingRule resource.
       *
       * Create a request for the method "globalForwardingRules.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param forwardingRule Name of the ForwardingRule resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String forwardingRule) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the ForwardingRule resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource to delete.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to delete. */
      public Delete setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified ForwardingRule resource. Get a list of available forwarding rules by making
     * a list() request.
     *
     * Create a request for the method "globalForwardingRules.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param forwardingRule Name of the ForwardingRule resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String forwardingRule) throws java.io.IOException {
      Get result = new Get(project, forwardingRule);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.ForwardingRule> {

      private static final String REST_PATH = "{project}/global/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified ForwardingRule resource. Get a list of available forwarding rules by
       * making a list() request.
       *
       * Create a request for the method "globalForwardingRules.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param forwardingRule Name of the ForwardingRule resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String forwardingRule) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRule.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the ForwardingRule resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource to return.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to return. */
      public Get setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a ForwardingRule resource in the specified project and region using the data included in
     * the request.
     *
     * Create a request for the method "globalForwardingRules.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.ForwardingRule content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a ForwardingRule resource in the specified project and region using the data included
       * in the request.
       *
       * Create a request for the method "globalForwardingRules.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.ForwardingRule content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of ForwardingRule resources available to the specified project.
     *
     * Create a request for the method "globalForwardingRules.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ForwardingRuleList> {

      private static final String REST_PATH = "{project}/global/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves a list of ForwardingRule resources available to the specified project.
       *
       * Create a request for the method "globalForwardingRules.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRuleList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Changes target URL for forwarding rule. The new target should be of the same type as the old
     * target.
     *
     * Create a request for the method "globalForwardingRules.setTarget".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetTarget#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param forwardingRule Name of the ForwardingRule resource in which target is to be set.
     * @param content the {@link com.google.api.services.compute.model.TargetReference}
     * @return the request
     */
    public SetTarget setTarget(java.lang.String project, java.lang.String forwardingRule, com.google.api.services.compute.model.TargetReference content) throws java.io.IOException {
      SetTarget result = new SetTarget(project, forwardingRule, content);
      initialize(result);
      return result;
    }

    public class SetTarget extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/forwardingRules/{forwardingRule}/setTarget";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Changes target URL for forwarding rule. The new target should be of the same type as the old
       * target.
       *
       * Create a request for the method "globalForwardingRules.setTarget".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetTarget#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetTarget#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param forwardingRule Name of the ForwardingRule resource in which target is to be set.
       * @param content the {@link com.google.api.services.compute.model.TargetReference}
       * @since 1.13
       */
      protected SetTarget(java.lang.String project, java.lang.String forwardingRule, com.google.api.services.compute.model.TargetReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetTarget setAlt(java.lang.String alt) {
        return (SetTarget) super.setAlt(alt);
      }

      @Override
      public SetTarget setFields(java.lang.String fields) {
        return (SetTarget) super.setFields(fields);
      }

      @Override
      public SetTarget setKey(java.lang.String key) {
        return (SetTarget) super.setKey(key);
      }

      @Override
      public SetTarget setOauthToken(java.lang.String oauthToken) {
        return (SetTarget) super.setOauthToken(oauthToken);
      }

      @Override
      public SetTarget setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetTarget) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetTarget setQuotaUser(java.lang.String quotaUser) {
        return (SetTarget) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetTarget setUserIp(java.lang.String userIp) {
        return (SetTarget) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetTarget setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the ForwardingRule resource in which target is to be set. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource in which target is to be set.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource in which target is to be set. */
      public SetTarget setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public SetTarget set(String parameterName, Object value) {
        return (SetTarget) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the GlobalOperations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.GlobalOperations.List request = compute.globalOperations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public GlobalOperations globalOperations() {
    return new GlobalOperations();
  }

  /**
   * The "globalOperations" collection of methods.
   */
  public class GlobalOperations {

    /**
     * Retrieves an aggregated list of all operations.
     *
     * Create a request for the method "globalOperations.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.OperationAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/operations";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of all operations.
       *
       * Create a request for the method "globalOperations.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.OperationAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified Operations resource.
     *
     * Create a request for the method "globalOperations.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param operation Name of the Operations resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String operation) throws java.io.IOException {
      Delete result = new Delete(project, operation);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<Void> {

      private static final String REST_PATH = "{project}/global/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified Operations resource.
       *
       * Create a request for the method "globalOperations.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param operation Name of the Operations resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String operation) {
        super(Compute.this, "DELETE", REST_PATH, null, Void.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the Operations resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Name of the Operations resource to delete.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Name of the Operations resource to delete. */
      public Delete setOperation(java.lang.String operation) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the specified Operations resource. Get a list of operations by making a list() request.
     *
     * Create a request for the method "globalOperations.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param operation Name of the Operations resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String operation) throws java.io.IOException {
      Get result = new Get(project, operation);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the specified Operations resource. Get a list of operations by making a list()
       * request.
       *
       * Create a request for the method "globalOperations.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param operation Name of the Operations resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String operation) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the Operations resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Name of the Operations resource to return.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Name of the Operations resource to return. */
      public Get setOperation(java.lang.String operation) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of Operation resources contained within the specified project.
     *
     * Create a request for the method "globalOperations.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.OperationList> {

      private static final String REST_PATH = "{project}/global/operations";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves a list of Operation resources contained within the specified project.
       *
       * Create a request for the method "globalOperations.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.OperationList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the HttpHealthChecks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.HttpHealthChecks.List request = compute.httpHealthChecks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public HttpHealthChecks httpHealthChecks() {
    return new HttpHealthChecks();
  }

  /**
   * The "httpHealthChecks" collection of methods.
   */
  public class HttpHealthChecks {

    /**
     * Deletes the specified HttpHealthCheck resource.
     *
     * Create a request for the method "httpHealthChecks.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String httpHealthCheck) throws java.io.IOException {
      Delete result = new Delete(project, httpHealthCheck);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTP_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified HttpHealthCheck resource.
       *
       * Create a request for the method "httpHealthChecks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String httpHealthCheck) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to delete.
       */
      public java.lang.String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to delete. */
      public Delete setHttpHealthCheck(java.lang.String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified HttpHealthCheck resource. Get a list of available HTTP health checks by
     * making a list() request.
     *
     * Create a request for the method "httpHealthChecks.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String httpHealthCheck) throws java.io.IOException {
      Get result = new Get(project, httpHealthCheck);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.HttpHealthCheck> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTP_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified HttpHealthCheck resource. Get a list of available HTTP health checks by
       * making a list() request.
       *
       * Create a request for the method "httpHealthChecks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String httpHealthCheck) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.HttpHealthCheck.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to return.
       */
      public java.lang.String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to return. */
      public Get setHttpHealthCheck(java.lang.String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a HttpHealthCheck resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "httpHealthChecks.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.HttpHealthCheck content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a HttpHealthCheck resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "httpHealthChecks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.HttpHealthCheck content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of HttpHealthCheck resources available to the specified project.
     *
     * Create a request for the method "httpHealthChecks.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.HttpHealthCheckList> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of HttpHealthCheck resources available to the specified project.
       *
       * Create a request for the method "httpHealthChecks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.HttpHealthCheckList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a HttpHealthCheck resource in the specified project using the data included in the
     * request. This method supports patch semantics.
     *
     * Create a request for the method "httpHealthChecks.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
     * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) throws java.io.IOException {
      Patch result = new Patch(project, httpHealthCheck, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTP_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates a HttpHealthCheck resource in the specified project using the data included in the
       * request. This method supports patch semantics.
       *
       * Create a request for the method "httpHealthChecks.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
       * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to update.
       */
      public java.lang.String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to update. */
      public Patch setHttpHealthCheck(java.lang.String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates a HttpHealthCheck resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "httpHealthChecks.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
     * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) throws java.io.IOException {
      Update result = new Update(project, httpHealthCheck, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTP_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates a HttpHealthCheck resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "httpHealthChecks.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
       * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to update.
       */
      public java.lang.String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to update. */
      public Update setHttpHealthCheck(java.lang.String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the HttpsHealthChecks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.HttpsHealthChecks.List request = compute.httpsHealthChecks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public HttpsHealthChecks httpsHealthChecks() {
    return new HttpsHealthChecks();
  }

  /**
   * The "httpsHealthChecks" collection of methods.
   */
  public class HttpsHealthChecks {

    /**
     * Deletes the specified HttpsHealthCheck resource.
     *
     * Create a request for the method "httpsHealthChecks.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param httpsHealthCheck Name of the HttpsHealthCheck resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String httpsHealthCheck) throws java.io.IOException {
      Delete result = new Delete(project, httpsHealthCheck);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpsHealthChecks/{httpsHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTPS_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified HttpsHealthCheck resource.
       *
       * Create a request for the method "httpsHealthChecks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param httpsHealthCheck Name of the HttpsHealthCheck resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String httpsHealthCheck) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpsHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpsHealthCheck, "Required parameter httpsHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPS_HEALTH_CHECK_PATTERN.matcher(httpsHealthCheck).matches(),
              "Parameter httpsHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpsHealthCheck resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String httpsHealthCheck;

      /** Name of the HttpsHealthCheck resource to delete.
       */
      public java.lang.String getHttpsHealthCheck() {
        return httpsHealthCheck;
      }

      /** Name of the HttpsHealthCheck resource to delete. */
      public Delete setHttpsHealthCheck(java.lang.String httpsHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPS_HEALTH_CHECK_PATTERN.matcher(httpsHealthCheck).matches(),
              "Parameter httpsHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpsHealthCheck = httpsHealthCheck;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified HttpsHealthCheck resource. Get a list of available HTTPS health checks by
     * making a list() request.
     *
     * Create a request for the method "httpsHealthChecks.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param httpsHealthCheck Name of the HttpsHealthCheck resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String httpsHealthCheck) throws java.io.IOException {
      Get result = new Get(project, httpsHealthCheck);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.HttpsHealthCheck> {

      private static final String REST_PATH = "{project}/global/httpsHealthChecks/{httpsHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTPS_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified HttpsHealthCheck resource. Get a list of available HTTPS health checks by
       * making a list() request.
       *
       * Create a request for the method "httpsHealthChecks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param httpsHealthCheck Name of the HttpsHealthCheck resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String httpsHealthCheck) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.HttpsHealthCheck.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpsHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpsHealthCheck, "Required parameter httpsHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPS_HEALTH_CHECK_PATTERN.matcher(httpsHealthCheck).matches(),
              "Parameter httpsHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpsHealthCheck resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String httpsHealthCheck;

      /** Name of the HttpsHealthCheck resource to return.
       */
      public java.lang.String getHttpsHealthCheck() {
        return httpsHealthCheck;
      }

      /** Name of the HttpsHealthCheck resource to return. */
      public Get setHttpsHealthCheck(java.lang.String httpsHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPS_HEALTH_CHECK_PATTERN.matcher(httpsHealthCheck).matches(),
              "Parameter httpsHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpsHealthCheck = httpsHealthCheck;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a HttpsHealthCheck resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "httpsHealthChecks.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.HttpsHealthCheck}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.HttpsHealthCheck content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpsHealthChecks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a HttpsHealthCheck resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "httpsHealthChecks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.HttpsHealthCheck}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.HttpsHealthCheck content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of HttpsHealthCheck resources available to the specified project.
     *
     * Create a request for the method "httpsHealthChecks.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.HttpsHealthCheckList> {

      private static final String REST_PATH = "{project}/global/httpsHealthChecks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of HttpsHealthCheck resources available to the specified project.
       *
       * Create a request for the method "httpsHealthChecks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.HttpsHealthCheckList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a HttpsHealthCheck resource in the specified project using the data included in the
     * request. This method supports patch semantics.
     *
     * Create a request for the method "httpsHealthChecks.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param httpsHealthCheck Name of the HttpsHealthCheck resource to update.
     * @param content the {@link com.google.api.services.compute.model.HttpsHealthCheck}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String httpsHealthCheck, com.google.api.services.compute.model.HttpsHealthCheck content) throws java.io.IOException {
      Patch result = new Patch(project, httpsHealthCheck, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpsHealthChecks/{httpsHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTPS_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates a HttpsHealthCheck resource in the specified project using the data included in the
       * request. This method supports patch semantics.
       *
       * Create a request for the method "httpsHealthChecks.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param httpsHealthCheck Name of the HttpsHealthCheck resource to update.
       * @param content the {@link com.google.api.services.compute.model.HttpsHealthCheck}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String httpsHealthCheck, com.google.api.services.compute.model.HttpsHealthCheck content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpsHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpsHealthCheck, "Required parameter httpsHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPS_HEALTH_CHECK_PATTERN.matcher(httpsHealthCheck).matches(),
              "Parameter httpsHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpsHealthCheck resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String httpsHealthCheck;

      /** Name of the HttpsHealthCheck resource to update.
       */
      public java.lang.String getHttpsHealthCheck() {
        return httpsHealthCheck;
      }

      /** Name of the HttpsHealthCheck resource to update. */
      public Patch setHttpsHealthCheck(java.lang.String httpsHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPS_HEALTH_CHECK_PATTERN.matcher(httpsHealthCheck).matches(),
              "Parameter httpsHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpsHealthCheck = httpsHealthCheck;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates a HttpsHealthCheck resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "httpsHealthChecks.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param httpsHealthCheck Name of the HttpsHealthCheck resource to update.
     * @param content the {@link com.google.api.services.compute.model.HttpsHealthCheck}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String httpsHealthCheck, com.google.api.services.compute.model.HttpsHealthCheck content) throws java.io.IOException {
      Update result = new Update(project, httpsHealthCheck, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpsHealthChecks/{httpsHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTPS_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates a HttpsHealthCheck resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "httpsHealthChecks.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param httpsHealthCheck Name of the HttpsHealthCheck resource to update.
       * @param content the {@link com.google.api.services.compute.model.HttpsHealthCheck}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String httpsHealthCheck, com.google.api.services.compute.model.HttpsHealthCheck content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpsHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpsHealthCheck, "Required parameter httpsHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPS_HEALTH_CHECK_PATTERN.matcher(httpsHealthCheck).matches(),
              "Parameter httpsHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpsHealthCheck resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String httpsHealthCheck;

      /** Name of the HttpsHealthCheck resource to update.
       */
      public java.lang.String getHttpsHealthCheck() {
        return httpsHealthCheck;
      }

      /** Name of the HttpsHealthCheck resource to update. */
      public Update setHttpsHealthCheck(java.lang.String httpsHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPS_HEALTH_CHECK_PATTERN.matcher(httpsHealthCheck).matches(),
              "Parameter httpsHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpsHealthCheck = httpsHealthCheck;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Images collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Images.List request = compute.images().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Images images() {
    return new Images();
  }

  /**
   * The "images" collection of methods.
   */
  public class Images {

    /**
     * Deletes the specified image.
     *
     * Create a request for the method "images.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param image Name of the image resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String image) throws java.io.IOException {
      Delete result = new Delete(project, image);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/images/{image}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern IMAGE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified image.
       *
       * Create a request for the method "images.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param image Name of the image resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String image) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.image = com.google.api.client.util.Preconditions.checkNotNull(image, "Required parameter image must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the image resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String image;

      /** Name of the image resource to delete.
       */
      public java.lang.String getImage() {
        return image;
      }

      /** Name of the image resource to delete. */
      public Delete setImage(java.lang.String image) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.image = image;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Sets the deprecation status of an image.
     *
     * If an empty request body is given, clears the deprecation status instead.
     *
     * Create a request for the method "images.deprecate".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Deprecate#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param image Image name.
     * @param content the {@link com.google.api.services.compute.model.DeprecationStatus}
     * @return the request
     */
    public Deprecate deprecate(java.lang.String project, java.lang.String image, com.google.api.services.compute.model.DeprecationStatus content) throws java.io.IOException {
      Deprecate result = new Deprecate(project, image, content);
      initialize(result);
      return result;
    }

    public class Deprecate extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/images/{image}/deprecate";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern IMAGE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets the deprecation status of an image.
       *
       * If an empty request body is given, clears the deprecation status instead.
       *
       * Create a request for the method "images.deprecate".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Deprecate#execute()} method to invoke the remote operation. <p>
       * {@link
       * Deprecate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param image Image name.
       * @param content the {@link com.google.api.services.compute.model.DeprecationStatus}
       * @since 1.13
       */
      protected Deprecate(java.lang.String project, java.lang.String image, com.google.api.services.compute.model.DeprecationStatus content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.image = com.google.api.client.util.Preconditions.checkNotNull(image, "Required parameter image must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Deprecate setAlt(java.lang.String alt) {
        return (Deprecate) super.setAlt(alt);
      }

      @Override
      public Deprecate setFields(java.lang.String fields) {
        return (Deprecate) super.setFields(fields);
      }

      @Override
      public Deprecate setKey(java.lang.String key) {
        return (Deprecate) super.setKey(key);
      }

      @Override
      public Deprecate setOauthToken(java.lang.String oauthToken) {
        return (Deprecate) super.setOauthToken(oauthToken);
      }

      @Override
      public Deprecate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Deprecate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Deprecate setQuotaUser(java.lang.String quotaUser) {
        return (Deprecate) super.setQuotaUser(quotaUser);
      }

      @Override
      public Deprecate setUserIp(java.lang.String userIp) {
        return (Deprecate) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Deprecate setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Image name. */
      @com.google.api.client.util.Key
      private java.lang.String image;

      /** Image name.
       */
      public java.lang.String getImage() {
        return image;
      }

      /** Image name. */
      public Deprecate setImage(java.lang.String image) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.image = image;
        return this;
      }

      @Override
      public Deprecate set(String parameterName, Object value) {
        return (Deprecate) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified image. Get a list of available images by making a list() request.
     *
     * Create a request for the method "images.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param image Name of the image resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String image) throws java.io.IOException {
      Get result = new Get(project, image);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Image> {

      private static final String REST_PATH = "{project}/global/images/{image}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern IMAGE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified image. Get a list of available images by making a list() request.
       *
       * Create a request for the method "images.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param image Name of the image resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String image) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Image.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.image = com.google.api.client.util.Preconditions.checkNotNull(image, "Required parameter image must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the image resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String image;

      /** Name of the image resource to return.
       */
      public java.lang.String getImage() {
        return image;
      }

      /** Name of the image resource to return. */
      public Get setImage(java.lang.String image) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.image = image;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Returns the latest image that is part of an image family and is not deprecated.
     *
     * Create a request for the method "images.getFromFamily".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetFromFamily#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param family Name of the image resource to return.
     * @return the request
     */
    public GetFromFamily getFromFamily(java.lang.String project, java.lang.String family) throws java.io.IOException {
      GetFromFamily result = new GetFromFamily(project, family);
      initialize(result);
      return result;
    }

    public class GetFromFamily extends ComputeRequest<com.google.api.services.compute.model.Image> {

      private static final String REST_PATH = "{project}/global/images/family/{family}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FAMILY_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the latest image that is part of an image family and is not deprecated.
       *
       * Create a request for the method "images.getFromFamily".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetFromFamily#execute()} method to invoke the remote operation. <p>
       * {@link GetFromFamily#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientR
       * equest)} must be called to initialize this instance immediately after invoking the constructor.
       * </p>
       *
       * @param project Project ID for this request.
       * @param family Name of the image resource to return.
       * @since 1.13
       */
      protected GetFromFamily(java.lang.String project, java.lang.String family) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Image.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.family = com.google.api.client.util.Preconditions.checkNotNull(family, "Required parameter family must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FAMILY_PATTERN.matcher(family).matches(),
              "Parameter family must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetFromFamily setAlt(java.lang.String alt) {
        return (GetFromFamily) super.setAlt(alt);
      }

      @Override
      public GetFromFamily setFields(java.lang.String fields) {
        return (GetFromFamily) super.setFields(fields);
      }

      @Override
      public GetFromFamily setKey(java.lang.String key) {
        return (GetFromFamily) super.setKey(key);
      }

      @Override
      public GetFromFamily setOauthToken(java.lang.String oauthToken) {
        return (GetFromFamily) super.setOauthToken(oauthToken);
      }

      @Override
      public GetFromFamily setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetFromFamily) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetFromFamily setQuotaUser(java.lang.String quotaUser) {
        return (GetFromFamily) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetFromFamily setUserIp(java.lang.String userIp) {
        return (GetFromFamily) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public GetFromFamily setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the image resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String family;

      /** Name of the image resource to return.
       */
      public java.lang.String getFamily() {
        return family;
      }

      /** Name of the image resource to return. */
      public GetFromFamily setFamily(java.lang.String family) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FAMILY_PATTERN.matcher(family).matches(),
              "Parameter family must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.family = family;
        return this;
      }

      @Override
      public GetFromFamily set(String parameterName, Object value) {
        return (GetFromFamily) super.set(parameterName, value);
      }
    }
    /**
     * Creates an image in the specified project using the data included in the request.
     *
     * Create a request for the method "images.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.Image}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Image content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/images";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates an image in the specified project using the data included in the request.
       *
       * Create a request for the method "images.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.Image}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Image content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of private images available to the specified project. Private images are
     * images you create that belong to your project. This method does not get any images that belong to
     * other projects, including publicly-available images, like Debian 7. If you want to get a list of
     * publicly-available images, use this method to make a request to the respective image project,
     * such as debian-cloud or windows-cloud.
     *
     * See Accessing images for more information.
     *
     * Create a request for the method "images.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ImageList> {

      private static final String REST_PATH = "{project}/global/images";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of private images available to the specified project. Private images are
       * images you create that belong to your project. This method does not get any images that belong
       * to other projects, including publicly-available images, like Debian 7. If you want to get a
       * list of publicly-available images, use this method to make a request to the respective image
       * project, such as debian-cloud or windows-cloud.
       *
       * See Accessing images for more information.
       *
       * Create a request for the method "images.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ImageList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the InstanceGroupManagers collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.InstanceGroupManagers.List request = compute.instanceGroupManagers().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public InstanceGroupManagers instanceGroupManagers() {
    return new InstanceGroupManagers();
  }

  /**
   * The "instanceGroupManagers" collection of methods.
   */
  public class InstanceGroupManagers {

    /**
     * Schedules a group action to remove the specified instances from the managed instance group.
     * Abandoning an instance does not delete the instance, but it does remove the instance from any
     * target pools that are applied by the managed instance group. This method reduces the targetSize
     * of the managed instance group by the number of instances that you abandon. This operation is
     * marked as DONE when the action is scheduled even if the instances have not yet been removed from
     * the group. You must separately verify the status of the abandoning action with the
     * listmanagedinstances method.
     *
     * Create a request for the method "instanceGroupManagers.abandonInstances".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AbandonInstances#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @param instanceGroupManager The name of the managed instance group.
     * @param content the {@link com.google.api.services.compute.model.InstanceGroupManagersAbandonInstancesRequest}
     * @return the request
     */
    public AbandonInstances abandonInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, com.google.api.services.compute.model.InstanceGroupManagersAbandonInstancesRequest content) throws java.io.IOException {
      AbandonInstances result = new AbandonInstances(project, zone, instanceGroupManager, content);
      initialize(result);
      return result;
    }

    public class AbandonInstances extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/abandonInstances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Schedules a group action to remove the specified instances from the managed instance group.
       * Abandoning an instance does not delete the instance, but it does remove the instance from any
       * target pools that are applied by the managed instance group. This method reduces the targetSize
       * of the managed instance group by the number of instances that you abandon. This operation is
       * marked as DONE when the action is scheduled even if the instances have not yet been removed
       * from the group. You must separately verify the status of the abandoning action with the
       * listmanagedinstances method.
       *
       * Create a request for the method "instanceGroupManagers.abandonInstances".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AbandonInstances#execute()} method to invoke the remote operation.
       * <p> {@link AbandonInstances#initialize(com.google.api.client.googleapis.services.AbstractGoogle
       * ClientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @param instanceGroupManager The name of the managed instance group.
       * @param content the {@link com.google.api.services.compute.model.InstanceGroupManagersAbandonInstancesRequest}
       * @since 1.13
       */
      protected AbandonInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, com.google.api.services.compute.model.InstanceGroupManagersAbandonInstancesRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroupManager = com.google.api.client.util.Preconditions.checkNotNull(instanceGroupManager, "Required parameter instanceGroupManager must be specified.");
      }

      @Override
      public AbandonInstances setAlt(java.lang.String alt) {
        return (AbandonInstances) super.setAlt(alt);
      }

      @Override
      public AbandonInstances setFields(java.lang.String fields) {
        return (AbandonInstances) super.setFields(fields);
      }

      @Override
      public AbandonInstances setKey(java.lang.String key) {
        return (AbandonInstances) super.setKey(key);
      }

      @Override
      public AbandonInstances setOauthToken(java.lang.String oauthToken) {
        return (AbandonInstances) super.setOauthToken(oauthToken);
      }

      @Override
      public AbandonInstances setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AbandonInstances) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AbandonInstances setQuotaUser(java.lang.String quotaUser) {
        return (AbandonInstances) super.setQuotaUser(quotaUser);
      }

      @Override
      public AbandonInstances setUserIp(java.lang.String userIp) {
        return (AbandonInstances) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AbandonInstances setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public AbandonInstances setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the managed instance group. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroupManager;

      /** The name of the managed instance group.
       */
      public java.lang.String getInstanceGroupManager() {
        return instanceGroupManager;
      }

      /** The name of the managed instance group. */
      public AbandonInstances setInstanceGroupManager(java.lang.String instanceGroupManager) {
        this.instanceGroupManager = instanceGroupManager;
        return this;
      }

      @Override
      public AbandonInstances set(String parameterName, Object value) {
        return (AbandonInstances) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of managed instance groups and groups them by zone.
     *
     * Create a request for the method "instanceGroupManagers.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.InstanceGroupManagerAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/instanceGroupManagers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of managed instance groups and groups them by zone.
       *
       * Create a request for the method "instanceGroupManagers.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceGroupManagerAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified managed instance group and all of the instances in that group. Note that
     * the instance group must not belong to a backend service. Read  Deleting an instance group for
     * more information.
     *
     * Create a request for the method "instanceGroupManagers.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @param instanceGroupManager The name of the managed instance group to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager) throws java.io.IOException {
      Delete result = new Delete(project, zone, instanceGroupManager);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Deletes the specified managed instance group and all of the instances in that group. Note that
       * the instance group must not belong to a backend service. Read  Deleting an instance group for
       * more information.
       *
       * Create a request for the method "instanceGroupManagers.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @param instanceGroupManager The name of the managed instance group to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroupManager = com.google.api.client.util.Preconditions.checkNotNull(instanceGroupManager, "Required parameter instanceGroupManager must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public Delete setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the managed instance group to delete. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroupManager;

      /** The name of the managed instance group to delete.
       */
      public java.lang.String getInstanceGroupManager() {
        return instanceGroupManager;
      }

      /** The name of the managed instance group to delete. */
      public Delete setInstanceGroupManager(java.lang.String instanceGroupManager) {
        this.instanceGroupManager = instanceGroupManager;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Schedules a group action to delete the specified instances in the managed instance group. The
     * instances are also removed from any target pools of which they were a member. This method reduces
     * the targetSize of the managed instance group by the number of instances that you delete. This
     * operation is marked as DONE when the action is scheduled even if the instances are still being
     * deleted. You must separately verify the status of the deleting action with the
     * listmanagedinstances method.
     *
     * Create a request for the method "instanceGroupManagers.deleteInstances".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link DeleteInstances#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @param instanceGroupManager The name of the managed instance group.
     * @param content the {@link com.google.api.services.compute.model.InstanceGroupManagersDeleteInstancesRequest}
     * @return the request
     */
    public DeleteInstances deleteInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, com.google.api.services.compute.model.InstanceGroupManagersDeleteInstancesRequest content) throws java.io.IOException {
      DeleteInstances result = new DeleteInstances(project, zone, instanceGroupManager, content);
      initialize(result);
      return result;
    }

    public class DeleteInstances extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/deleteInstances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Schedules a group action to delete the specified instances in the managed instance group. The
       * instances are also removed from any target pools of which they were a member. This method
       * reduces the targetSize of the managed instance group by the number of instances that you
       * delete. This operation is marked as DONE when the action is scheduled even if the instances are
       * still being deleted. You must separately verify the status of the deleting action with the
       * listmanagedinstances method.
       *
       * Create a request for the method "instanceGroupManagers.deleteInstances".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link DeleteInstances#execute()} method to invoke the remote operation.
       * <p> {@link DeleteInstances#initialize(com.google.api.client.googleapis.services.AbstractGoogleC
       * lientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @param instanceGroupManager The name of the managed instance group.
       * @param content the {@link com.google.api.services.compute.model.InstanceGroupManagersDeleteInstancesRequest}
       * @since 1.13
       */
      protected DeleteInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, com.google.api.services.compute.model.InstanceGroupManagersDeleteInstancesRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroupManager = com.google.api.client.util.Preconditions.checkNotNull(instanceGroupManager, "Required parameter instanceGroupManager must be specified.");
      }

      @Override
      public DeleteInstances setAlt(java.lang.String alt) {
        return (DeleteInstances) super.setAlt(alt);
      }

      @Override
      public DeleteInstances setFields(java.lang.String fields) {
        return (DeleteInstances) super.setFields(fields);
      }

      @Override
      public DeleteInstances setKey(java.lang.String key) {
        return (DeleteInstances) super.setKey(key);
      }

      @Override
      public DeleteInstances setOauthToken(java.lang.String oauthToken) {
        return (DeleteInstances) super.setOauthToken(oauthToken);
      }

      @Override
      public DeleteInstances setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DeleteInstances) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DeleteInstances setQuotaUser(java.lang.String quotaUser) {
        return (DeleteInstances) super.setQuotaUser(quotaUser);
      }

      @Override
      public DeleteInstances setUserIp(java.lang.String userIp) {
        return (DeleteInstances) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public DeleteInstances setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public DeleteInstances setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the managed instance group. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroupManager;

      /** The name of the managed instance group.
       */
      public java.lang.String getInstanceGroupManager() {
        return instanceGroupManager;
      }

      /** The name of the managed instance group. */
      public DeleteInstances setInstanceGroupManager(java.lang.String instanceGroupManager) {
        this.instanceGroupManager = instanceGroupManager;
        return this;
      }

      @Override
      public DeleteInstances set(String parameterName, Object value) {
        return (DeleteInstances) super.set(parameterName, value);
      }
    }
    /**
     * Returns all of the details about the specified managed instance group. Get a list of available
     * managed instance groups by making a list() request.
     *
     * Create a request for the method "instanceGroupManagers.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @param instanceGroupManager The name of the managed instance group.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager) throws java.io.IOException {
      Get result = new Get(project, zone, instanceGroupManager);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.InstanceGroupManager> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Returns all of the details about the specified managed instance group. Get a list of available
       * managed instance groups by making a list() request.
       *
       * Create a request for the method "instanceGroupManagers.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @param instanceGroupManager The name of the managed instance group.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceGroupManager.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroupManager = com.google.api.client.util.Preconditions.checkNotNull(instanceGroupManager, "Required parameter instanceGroupManager must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public Get setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the managed instance group. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroupManager;

      /** The name of the managed instance group.
       */
      public java.lang.String getInstanceGroupManager() {
        return instanceGroupManager;
      }

      /** The name of the managed instance group. */
      public Get setInstanceGroupManager(java.lang.String instanceGroupManager) {
        this.instanceGroupManager = instanceGroupManager;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a managed instance group using the information that you specify in the request. After the
     * group is created, it schedules an action to create instances in the group using the specified
     * instance template. This operation is marked as DONE when the group is created even if the
     * instances in the group have not yet been created. You must separately verify the status of the
     * individual instances with the listmanagedinstances method.
     *
     * Create a request for the method "instanceGroupManagers.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where you want to create the managed instance group.
     * @param content the {@link com.google.api.services.compute.model.InstanceGroupManager}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.InstanceGroupManager content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a managed instance group using the information that you specify in the request. After
       * the group is created, it schedules an action to create instances in the group using the
       * specified instance template. This operation is marked as DONE when the group is created even if
       * the instances in the group have not yet been created. You must separately verify the status of
       * the individual instances with the listmanagedinstances method.
       *
       * Create a request for the method "instanceGroupManagers.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where you want to create the managed instance group.
       * @param content the {@link com.google.api.services.compute.model.InstanceGroupManager}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.InstanceGroupManager content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where you want to create the managed instance group. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where you want to create the managed instance group.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where you want to create the managed instance group. */
      public Insert setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of managed instance groups that are contained within the specified project and
     * zone.
     *
     * Create a request for the method "instanceGroupManagers.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.InstanceGroupManagerList> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves a list of managed instance groups that are contained within the specified project and
       * zone.
       *
       * Create a request for the method "instanceGroupManagers.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceGroupManagerList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public List setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Lists all of the instances in the managed instance group. Each instance in the list has a
     * currentAction, which indicates the action that the managed instance group is performing on the
     * instance. For example, if the group is still creating an instance, the currentAction is CREATING.
     * If a previous action failed, the list displays the errors for that failed action.
     *
     * Create a request for the method "instanceGroupManagers.listManagedInstances".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link ListManagedInstances#execute()} method to invoke the remote
     * operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @param instanceGroupManager The name of the managed instance group.
     * @return the request
     */
    public ListManagedInstances listManagedInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager) throws java.io.IOException {
      ListManagedInstances result = new ListManagedInstances(project, zone, instanceGroupManager);
      initialize(result);
      return result;
    }

    public class ListManagedInstances extends ComputeRequest<com.google.api.services.compute.model.InstanceGroupManagersListManagedInstancesResponse> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/listManagedInstances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Lists all of the instances in the managed instance group. Each instance in the list has a
       * currentAction, which indicates the action that the managed instance group is performing on the
       * instance. For example, if the group is still creating an instance, the currentAction is
       * CREATING. If a previous action failed, the list displays the errors for that failed action.
       *
       * Create a request for the method "instanceGroupManagers.listManagedInstances".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link ListManagedInstances#execute()} method to invoke the remote
       * operation. <p> {@link ListManagedInstances#initialize(com.google.api.client.googleapis.services
       * .AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @param instanceGroupManager The name of the managed instance group.
       * @since 1.13
       */
      protected ListManagedInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.InstanceGroupManagersListManagedInstancesResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroupManager = com.google.api.client.util.Preconditions.checkNotNull(instanceGroupManager, "Required parameter instanceGroupManager must be specified.");
      }

      @Override
      public ListManagedInstances setAlt(java.lang.String alt) {
        return (ListManagedInstances) super.setAlt(alt);
      }

      @Override
      public ListManagedInstances setFields(java.lang.String fields) {
        return (ListManagedInstances) super.setFields(fields);
      }

      @Override
      public ListManagedInstances setKey(java.lang.String key) {
        return (ListManagedInstances) super.setKey(key);
      }

      @Override
      public ListManagedInstances setOauthToken(java.lang.String oauthToken) {
        return (ListManagedInstances) super.setOauthToken(oauthToken);
      }

      @Override
      public ListManagedInstances setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ListManagedInstances) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ListManagedInstances setQuotaUser(java.lang.String quotaUser) {
        return (ListManagedInstances) super.setQuotaUser(quotaUser);
      }

      @Override
      public ListManagedInstances setUserIp(java.lang.String userIp) {
        return (ListManagedInstances) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public ListManagedInstances setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public ListManagedInstances setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the managed instance group. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroupManager;

      /** The name of the managed instance group.
       */
      public java.lang.String getInstanceGroupManager() {
        return instanceGroupManager;
      }

      /** The name of the managed instance group. */
      public ListManagedInstances setInstanceGroupManager(java.lang.String instanceGroupManager) {
        this.instanceGroupManager = instanceGroupManager;
        return this;
      }

      @Override
      public ListManagedInstances set(String parameterName, Object value) {
        return (ListManagedInstances) super.set(parameterName, value);
      }
    }
    /**
     * Schedules a group action to recreate the specified instances in the managed instance group. The
     * instances are deleted and recreated using the current instance template for the managed instance
     * group. This operation is marked as DONE when the action is scheduled even if the instances have
     * not yet been recreated. You must separately verify the status of the recreating action with the
     * listmanagedinstances method.
     *
     * Create a request for the method "instanceGroupManagers.recreateInstances".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link RecreateInstances#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @param instanceGroupManager The name of the managed instance group.
     * @param content the {@link com.google.api.services.compute.model.InstanceGroupManagersRecreateInstancesRequest}
     * @return the request
     */
    public RecreateInstances recreateInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, com.google.api.services.compute.model.InstanceGroupManagersRecreateInstancesRequest content) throws java.io.IOException {
      RecreateInstances result = new RecreateInstances(project, zone, instanceGroupManager, content);
      initialize(result);
      return result;
    }

    public class RecreateInstances extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/recreateInstances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Schedules a group action to recreate the specified instances in the managed instance group. The
       * instances are deleted and recreated using the current instance template for the managed
       * instance group. This operation is marked as DONE when the action is scheduled even if the
       * instances have not yet been recreated. You must separately verify the status of the recreating
       * action with the listmanagedinstances method.
       *
       * Create a request for the method "instanceGroupManagers.recreateInstances".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link RecreateInstances#execute()} method to invoke the remote operation.
       * <p> {@link RecreateInstances#initialize(com.google.api.client.googleapis.services.AbstractGoogl
       * eClientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @param instanceGroupManager The name of the managed instance group.
       * @param content the {@link com.google.api.services.compute.model.InstanceGroupManagersRecreateInstancesRequest}
       * @since 1.13
       */
      protected RecreateInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, com.google.api.services.compute.model.InstanceGroupManagersRecreateInstancesRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroupManager = com.google.api.client.util.Preconditions.checkNotNull(instanceGroupManager, "Required parameter instanceGroupManager must be specified.");
      }

      @Override
      public RecreateInstances setAlt(java.lang.String alt) {
        return (RecreateInstances) super.setAlt(alt);
      }

      @Override
      public RecreateInstances setFields(java.lang.String fields) {
        return (RecreateInstances) super.setFields(fields);
      }

      @Override
      public RecreateInstances setKey(java.lang.String key) {
        return (RecreateInstances) super.setKey(key);
      }

      @Override
      public RecreateInstances setOauthToken(java.lang.String oauthToken) {
        return (RecreateInstances) super.setOauthToken(oauthToken);
      }

      @Override
      public RecreateInstances setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RecreateInstances) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RecreateInstances setQuotaUser(java.lang.String quotaUser) {
        return (RecreateInstances) super.setQuotaUser(quotaUser);
      }

      @Override
      public RecreateInstances setUserIp(java.lang.String userIp) {
        return (RecreateInstances) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public RecreateInstances setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public RecreateInstances setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the managed instance group. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroupManager;

      /** The name of the managed instance group.
       */
      public java.lang.String getInstanceGroupManager() {
        return instanceGroupManager;
      }

      /** The name of the managed instance group. */
      public RecreateInstances setInstanceGroupManager(java.lang.String instanceGroupManager) {
        this.instanceGroupManager = instanceGroupManager;
        return this;
      }

      @Override
      public RecreateInstances set(String parameterName, Object value) {
        return (RecreateInstances) super.set(parameterName, value);
      }
    }
    /**
     * Resizes the managed instance group. If you increase the size, the group creates new instances
     * using the current instance template. If you decrease the size, the group deletes instances. The
     * resize operation is marked DONE when the resize actions are scheduled even if the group has not
     * yet added or deleted any instances. You must separately verify the status of the creating or
     * deleting actions with the listmanagedinstances method.
     *
     * Create a request for the method "instanceGroupManagers.resize".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Resize#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @param instanceGroupManager The name of the managed instance group.
     * @param size The number of running instances that the managed instance group should maintain at any given time.
     *        The group automatically adds or removes instances to maintain the number of instances
     *        specified by this parameter.
     * @return the request
     */
    public Resize resize(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, java.lang.Integer size) throws java.io.IOException {
      Resize result = new Resize(project, zone, instanceGroupManager, size);
      initialize(result);
      return result;
    }

    public class Resize extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resize";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Resizes the managed instance group. If you increase the size, the group creates new instances
       * using the current instance template. If you decrease the size, the group deletes instances. The
       * resize operation is marked DONE when the resize actions are scheduled even if the group has not
       * yet added or deleted any instances. You must separately verify the status of the creating or
       * deleting actions with the listmanagedinstances method.
       *
       * Create a request for the method "instanceGroupManagers.resize".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Resize#execute()} method to invoke the remote operation. <p> {@link
       * Resize#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @param instanceGroupManager The name of the managed instance group.
       * @param size The number of running instances that the managed instance group should maintain at any given time.
     *        The group automatically adds or removes instances to maintain the number of instances
     *        specified by this parameter.
       * @since 1.13
       */
      protected Resize(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, java.lang.Integer size) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroupManager = com.google.api.client.util.Preconditions.checkNotNull(instanceGroupManager, "Required parameter instanceGroupManager must be specified.");
        this.size = com.google.api.client.util.Preconditions.checkNotNull(size, "Required parameter size must be specified.");
      }

      @Override
      public Resize setAlt(java.lang.String alt) {
        return (Resize) super.setAlt(alt);
      }

      @Override
      public Resize setFields(java.lang.String fields) {
        return (Resize) super.setFields(fields);
      }

      @Override
      public Resize setKey(java.lang.String key) {
        return (Resize) super.setKey(key);
      }

      @Override
      public Resize setOauthToken(java.lang.String oauthToken) {
        return (Resize) super.setOauthToken(oauthToken);
      }

      @Override
      public Resize setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Resize) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Resize setQuotaUser(java.lang.String quotaUser) {
        return (Resize) super.setQuotaUser(quotaUser);
      }

      @Override
      public Resize setUserIp(java.lang.String userIp) {
        return (Resize) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Resize setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public Resize setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the managed instance group. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroupManager;

      /** The name of the managed instance group.
       */
      public java.lang.String getInstanceGroupManager() {
        return instanceGroupManager;
      }

      /** The name of the managed instance group. */
      public Resize setInstanceGroupManager(java.lang.String instanceGroupManager) {
        this.instanceGroupManager = instanceGroupManager;
        return this;
      }

      /**
       * The number of running instances that the managed instance group should maintain at any
       * given time. The group automatically adds or removes instances to maintain the number of
       * instances specified by this parameter.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer size;

      /** The number of running instances that the managed instance group should maintain at any given time.
     The group automatically adds or removes instances to maintain the number of instances specified by
     this parameter.
       */
      public java.lang.Integer getSize() {
        return size;
      }

      /**
       * The number of running instances that the managed instance group should maintain at any
       * given time. The group automatically adds or removes instances to maintain the number of
       * instances specified by this parameter.
       */
      public Resize setSize(java.lang.Integer size) {
        this.size = size;
        return this;
      }

      @Override
      public Resize set(String parameterName, Object value) {
        return (Resize) super.set(parameterName, value);
      }
    }
    /**
     * Specifies the instance template to use when creating new instances in this group. The templates
     * for existing instances in the group do not change unless you recreate them.
     *
     * Create a request for the method "instanceGroupManagers.setInstanceTemplate".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetInstanceTemplate#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @param instanceGroupManager The name of the managed instance group.
     * @param content the {@link com.google.api.services.compute.model.InstanceGroupManagersSetInstanceTemplateRequest}
     * @return the request
     */
    public SetInstanceTemplate setInstanceTemplate(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, com.google.api.services.compute.model.InstanceGroupManagersSetInstanceTemplateRequest content) throws java.io.IOException {
      SetInstanceTemplate result = new SetInstanceTemplate(project, zone, instanceGroupManager, content);
      initialize(result);
      return result;
    }

    public class SetInstanceTemplate extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/setInstanceTemplate";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Specifies the instance template to use when creating new instances in this group. The templates
       * for existing instances in the group do not change unless you recreate them.
       *
       * Create a request for the method "instanceGroupManagers.setInstanceTemplate".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetInstanceTemplate#execute()} method to invoke the remote
       * operation. <p> {@link SetInstanceTemplate#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @param instanceGroupManager The name of the managed instance group.
       * @param content the {@link com.google.api.services.compute.model.InstanceGroupManagersSetInstanceTemplateRequest}
       * @since 1.13
       */
      protected SetInstanceTemplate(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, com.google.api.services.compute.model.InstanceGroupManagersSetInstanceTemplateRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroupManager = com.google.api.client.util.Preconditions.checkNotNull(instanceGroupManager, "Required parameter instanceGroupManager must be specified.");
      }

      @Override
      public SetInstanceTemplate setAlt(java.lang.String alt) {
        return (SetInstanceTemplate) super.setAlt(alt);
      }

      @Override
      public SetInstanceTemplate setFields(java.lang.String fields) {
        return (SetInstanceTemplate) super.setFields(fields);
      }

      @Override
      public SetInstanceTemplate setKey(java.lang.String key) {
        return (SetInstanceTemplate) super.setKey(key);
      }

      @Override
      public SetInstanceTemplate setOauthToken(java.lang.String oauthToken) {
        return (SetInstanceTemplate) super.setOauthToken(oauthToken);
      }

      @Override
      public SetInstanceTemplate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetInstanceTemplate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetInstanceTemplate setQuotaUser(java.lang.String quotaUser) {
        return (SetInstanceTemplate) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetInstanceTemplate setUserIp(java.lang.String userIp) {
        return (SetInstanceTemplate) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetInstanceTemplate setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public SetInstanceTemplate setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the managed instance group. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroupManager;

      /** The name of the managed instance group.
       */
      public java.lang.String getInstanceGroupManager() {
        return instanceGroupManager;
      }

      /** The name of the managed instance group. */
      public SetInstanceTemplate setInstanceGroupManager(java.lang.String instanceGroupManager) {
        this.instanceGroupManager = instanceGroupManager;
        return this;
      }

      @Override
      public SetInstanceTemplate set(String parameterName, Object value) {
        return (SetInstanceTemplate) super.set(parameterName, value);
      }
    }
    /**
     * Modifies the target pools to which all instances in this managed instance group are assigned. The
     * target pools automatically apply to all of the instances in the managed instance group. This
     * operation is marked DONE when you make the request even if the instances have not yet been added
     * to their target pools. The change might take some time to apply to all of the instances in the
     * group depending on the size of the group.
     *
     * Create a request for the method "instanceGroupManagers.setTargetPools".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetTargetPools#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @param instanceGroupManager The name of the managed instance group.
     * @param content the {@link com.google.api.services.compute.model.InstanceGroupManagersSetTargetPoolsRequest}
     * @return the request
     */
    public SetTargetPools setTargetPools(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, com.google.api.services.compute.model.InstanceGroupManagersSetTargetPoolsRequest content) throws java.io.IOException {
      SetTargetPools result = new SetTargetPools(project, zone, instanceGroupManager, content);
      initialize(result);
      return result;
    }

    public class SetTargetPools extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/setTargetPools";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Modifies the target pools to which all instances in this managed instance group are assigned.
       * The target pools automatically apply to all of the instances in the managed instance group.
       * This operation is marked DONE when you make the request even if the instances have not yet been
       * added to their target pools. The change might take some time to apply to all of the instances
       * in the group depending on the size of the group.
       *
       * Create a request for the method "instanceGroupManagers.setTargetPools".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetTargetPools#execute()} method to invoke the remote operation.
       * <p> {@link SetTargetPools#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @param instanceGroupManager The name of the managed instance group.
       * @param content the {@link com.google.api.services.compute.model.InstanceGroupManagersSetTargetPoolsRequest}
       * @since 1.13
       */
      protected SetTargetPools(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, com.google.api.services.compute.model.InstanceGroupManagersSetTargetPoolsRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroupManager = com.google.api.client.util.Preconditions.checkNotNull(instanceGroupManager, "Required parameter instanceGroupManager must be specified.");
      }

      @Override
      public SetTargetPools setAlt(java.lang.String alt) {
        return (SetTargetPools) super.setAlt(alt);
      }

      @Override
      public SetTargetPools setFields(java.lang.String fields) {
        return (SetTargetPools) super.setFields(fields);
      }

      @Override
      public SetTargetPools setKey(java.lang.String key) {
        return (SetTargetPools) super.setKey(key);
      }

      @Override
      public SetTargetPools setOauthToken(java.lang.String oauthToken) {
        return (SetTargetPools) super.setOauthToken(oauthToken);
      }

      @Override
      public SetTargetPools setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetTargetPools) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetTargetPools setQuotaUser(java.lang.String quotaUser) {
        return (SetTargetPools) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetTargetPools setUserIp(java.lang.String userIp) {
        return (SetTargetPools) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetTargetPools setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public SetTargetPools setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the managed instance group. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroupManager;

      /** The name of the managed instance group.
       */
      public java.lang.String getInstanceGroupManager() {
        return instanceGroupManager;
      }

      /** The name of the managed instance group. */
      public SetTargetPools setInstanceGroupManager(java.lang.String instanceGroupManager) {
        this.instanceGroupManager = instanceGroupManager;
        return this;
      }

      @Override
      public SetTargetPools set(String parameterName, Object value) {
        return (SetTargetPools) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the InstanceGroups collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.InstanceGroups.List request = compute.instanceGroups().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public InstanceGroups instanceGroups() {
    return new InstanceGroups();
  }

  /**
   * The "instanceGroups" collection of methods.
   */
  public class InstanceGroups {

    /**
     * Adds a list of instances to the specified instance group. All of the instances in the instance
     * group must be in the same network/subnetwork. Read  Adding instances for more information.
     *
     * Create a request for the method "instanceGroups.addInstances".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AddInstances#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the instance group is located.
     * @param instanceGroup The name of the instance group where you are adding instances.
     * @param content the {@link com.google.api.services.compute.model.InstanceGroupsAddInstancesRequest}
     * @return the request
     */
    public AddInstances addInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroup, com.google.api.services.compute.model.InstanceGroupsAddInstancesRequest content) throws java.io.IOException {
      AddInstances result = new AddInstances(project, zone, instanceGroup, content);
      initialize(result);
      return result;
    }

    public class AddInstances extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroups/{instanceGroup}/addInstances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Adds a list of instances to the specified instance group. All of the instances in the instance
       * group must be in the same network/subnetwork. Read  Adding instances for more information.
       *
       * Create a request for the method "instanceGroups.addInstances".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddInstances#execute()} method to invoke the remote operation. <p>
       * {@link
       * AddInstances#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the instance group is located.
       * @param instanceGroup The name of the instance group where you are adding instances.
       * @param content the {@link com.google.api.services.compute.model.InstanceGroupsAddInstancesRequest}
       * @since 1.13
       */
      protected AddInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroup, com.google.api.services.compute.model.InstanceGroupsAddInstancesRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroup = com.google.api.client.util.Preconditions.checkNotNull(instanceGroup, "Required parameter instanceGroup must be specified.");
      }

      @Override
      public AddInstances setAlt(java.lang.String alt) {
        return (AddInstances) super.setAlt(alt);
      }

      @Override
      public AddInstances setFields(java.lang.String fields) {
        return (AddInstances) super.setFields(fields);
      }

      @Override
      public AddInstances setKey(java.lang.String key) {
        return (AddInstances) super.setKey(key);
      }

      @Override
      public AddInstances setOauthToken(java.lang.String oauthToken) {
        return (AddInstances) super.setOauthToken(oauthToken);
      }

      @Override
      public AddInstances setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AddInstances) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddInstances setQuotaUser(java.lang.String quotaUser) {
        return (AddInstances) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddInstances setUserIp(java.lang.String userIp) {
        return (AddInstances) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AddInstances setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the instance group is located. */
      public AddInstances setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the instance group where you are adding instances. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroup;

      /** The name of the instance group where you are adding instances.
       */
      public java.lang.String getInstanceGroup() {
        return instanceGroup;
      }

      /** The name of the instance group where you are adding instances. */
      public AddInstances setInstanceGroup(java.lang.String instanceGroup) {
        this.instanceGroup = instanceGroup;
        return this;
      }

      @Override
      public AddInstances set(String parameterName, Object value) {
        return (AddInstances) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of instance groups and sorts them by zone.
     *
     * Create a request for the method "instanceGroups.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.InstanceGroupAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/instanceGroups";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of instance groups and sorts them by zone.
       *
       * Create a request for the method "instanceGroups.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceGroupAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified instance group. The instances in the group are not deleted. Note that
     * instance group must not belong to a backend service. Read  Deleting an instance group for more
     * information.
     *
     * Create a request for the method "instanceGroups.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the instance group is located.
     * @param instanceGroup The name of the instance group to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String instanceGroup) throws java.io.IOException {
      Delete result = new Delete(project, zone, instanceGroup);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroups/{instanceGroup}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Deletes the specified instance group. The instances in the group are not deleted. Note that
       * instance group must not belong to a backend service. Read  Deleting an instance group for more
       * information.
       *
       * Create a request for the method "instanceGroups.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the instance group is located.
       * @param instanceGroup The name of the instance group to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String instanceGroup) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroup = com.google.api.client.util.Preconditions.checkNotNull(instanceGroup, "Required parameter instanceGroup must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the instance group is located. */
      public Delete setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the instance group to delete. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroup;

      /** The name of the instance group to delete.
       */
      public java.lang.String getInstanceGroup() {
        return instanceGroup;
      }

      /** The name of the instance group to delete. */
      public Delete setInstanceGroup(java.lang.String instanceGroup) {
        this.instanceGroup = instanceGroup;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified instance group. Get a list of available instance groups by making a list()
     * request.
     *
     * Create a request for the method "instanceGroups.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the instance group is located.
     * @param instanceGroup The name of the instance group.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String instanceGroup) throws java.io.IOException {
      Get result = new Get(project, zone, instanceGroup);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.InstanceGroup> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroups/{instanceGroup}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Returns the specified instance group. Get a list of available instance groups by making a
       * list() request.
       *
       * Create a request for the method "instanceGroups.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the instance group is located.
       * @param instanceGroup The name of the instance group.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String instanceGroup) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceGroup.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroup = com.google.api.client.util.Preconditions.checkNotNull(instanceGroup, "Required parameter instanceGroup must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the instance group is located. */
      public Get setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the instance group. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroup;

      /** The name of the instance group.
       */
      public java.lang.String getInstanceGroup() {
        return instanceGroup;
      }

      /** The name of the instance group. */
      public Get setInstanceGroup(java.lang.String instanceGroup) {
        this.instanceGroup = instanceGroup;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an instance group in the specified project using the parameters that are included in the
     * request.
     *
     * Create a request for the method "instanceGroups.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where you want to create the instance group.
     * @param content the {@link com.google.api.services.compute.model.InstanceGroup}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.InstanceGroup content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroups";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates an instance group in the specified project using the parameters that are included in
       * the request.
       *
       * Create a request for the method "instanceGroups.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where you want to create the instance group.
       * @param content the {@link com.google.api.services.compute.model.InstanceGroup}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.InstanceGroup content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where you want to create the instance group. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where you want to create the instance group.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where you want to create the instance group. */
      public Insert setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of instance groups that are located in the specified project and zone.
     *
     * Create a request for the method "instanceGroups.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the instance group is located.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.InstanceGroupList> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroups";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of instance groups that are located in the specified project and zone.
       *
       * Create a request for the method "instanceGroups.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the instance group is located.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceGroupList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the instance group is located. */
      public List setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Lists the instances in the specified instance group.
     *
     * Create a request for the method "instanceGroups.listInstances".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link ListInstances#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the instance group is located.
     * @param instanceGroup The name of the instance group from which you want to generate a list of included instances.
     * @param content the {@link com.google.api.services.compute.model.InstanceGroupsListInstancesRequest}
     * @return the request
     */
    public ListInstances listInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroup, com.google.api.services.compute.model.InstanceGroupsListInstancesRequest content) throws java.io.IOException {
      ListInstances result = new ListInstances(project, zone, instanceGroup, content);
      initialize(result);
      return result;
    }

    public class ListInstances extends ComputeRequest<com.google.api.services.compute.model.InstanceGroupsListInstances> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroups/{instanceGroup}/listInstances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Lists the instances in the specified instance group.
       *
       * Create a request for the method "instanceGroups.listInstances".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link ListInstances#execute()} method to invoke the remote operation. <p>
       * {@link ListInstances#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientR
       * equest)} must be called to initialize this instance immediately after invoking the constructor.
       * </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the instance group is located.
       * @param instanceGroup The name of the instance group from which you want to generate a list of included instances.
       * @param content the {@link com.google.api.services.compute.model.InstanceGroupsListInstancesRequest}
       * @since 1.13
       */
      protected ListInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroup, com.google.api.services.compute.model.InstanceGroupsListInstancesRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.InstanceGroupsListInstances.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroup = com.google.api.client.util.Preconditions.checkNotNull(instanceGroup, "Required parameter instanceGroup must be specified.");
      }

      @Override
      public ListInstances setAlt(java.lang.String alt) {
        return (ListInstances) super.setAlt(alt);
      }

      @Override
      public ListInstances setFields(java.lang.String fields) {
        return (ListInstances) super.setFields(fields);
      }

      @Override
      public ListInstances setKey(java.lang.String key) {
        return (ListInstances) super.setKey(key);
      }

      @Override
      public ListInstances setOauthToken(java.lang.String oauthToken) {
        return (ListInstances) super.setOauthToken(oauthToken);
      }

      @Override
      public ListInstances setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ListInstances) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ListInstances setQuotaUser(java.lang.String quotaUser) {
        return (ListInstances) super.setQuotaUser(quotaUser);
      }

      @Override
      public ListInstances setUserIp(java.lang.String userIp) {
        return (ListInstances) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public ListInstances setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the instance group is located. */
      public ListInstances setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /**
       * The name of the instance group from which you want to generate a list of included
       * instances.
       */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroup;

      /** The name of the instance group from which you want to generate a list of included instances.
       */
      public java.lang.String getInstanceGroup() {
        return instanceGroup;
      }

      /**
       * The name of the instance group from which you want to generate a list of included
       * instances.
       */
      public ListInstances setInstanceGroup(java.lang.String instanceGroup) {
        this.instanceGroup = instanceGroup;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public ListInstances setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public ListInstances setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public ListInstances setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public ListInstances set(String parameterName, Object value) {
        return (ListInstances) super.set(parameterName, value);
      }
    }
    /**
     * Removes one or more instances from the specified instance group, but does not delete those
     * instances.
     *
     * Create a request for the method "instanceGroups.removeInstances".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link RemoveInstances#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the instance group is located.
     * @param instanceGroup The name of the instance group where the specified instances will be removed.
     * @param content the {@link com.google.api.services.compute.model.InstanceGroupsRemoveInstancesRequest}
     * @return the request
     */
    public RemoveInstances removeInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroup, com.google.api.services.compute.model.InstanceGroupsRemoveInstancesRequest content) throws java.io.IOException {
      RemoveInstances result = new RemoveInstances(project, zone, instanceGroup, content);
      initialize(result);
      return result;
    }

    public class RemoveInstances extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroups/{instanceGroup}/removeInstances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Removes one or more instances from the specified instance group, but does not delete those
       * instances.
       *
       * Create a request for the method "instanceGroups.removeInstances".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link RemoveInstances#execute()} method to invoke the remote operation.
       * <p> {@link RemoveInstances#initialize(com.google.api.client.googleapis.services.AbstractGoogleC
       * lientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the instance group is located.
       * @param instanceGroup The name of the instance group where the specified instances will be removed.
       * @param content the {@link com.google.api.services.compute.model.InstanceGroupsRemoveInstancesRequest}
       * @since 1.13
       */
      protected RemoveInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroup, com.google.api.services.compute.model.InstanceGroupsRemoveInstancesRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroup = com.google.api.client.util.Preconditions.checkNotNull(instanceGroup, "Required parameter instanceGroup must be specified.");
      }

      @Override
      public RemoveInstances setAlt(java.lang.String alt) {
        return (RemoveInstances) super.setAlt(alt);
      }

      @Override
      public RemoveInstances setFields(java.lang.String fields) {
        return (RemoveInstances) super.setFields(fields);
      }

      @Override
      public RemoveInstances setKey(java.lang.String key) {
        return (RemoveInstances) super.setKey(key);
      }

      @Override
      public RemoveInstances setOauthToken(java.lang.String oauthToken) {
        return (RemoveInstances) super.setOauthToken(oauthToken);
      }

      @Override
      public RemoveInstances setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RemoveInstances) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RemoveInstances setQuotaUser(java.lang.String quotaUser) {
        return (RemoveInstances) super.setQuotaUser(quotaUser);
      }

      @Override
      public RemoveInstances setUserIp(java.lang.String userIp) {
        return (RemoveInstances) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public RemoveInstances setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the instance group is located. */
      public RemoveInstances setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the instance group where the specified instances will be removed. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroup;

      /** The name of the instance group where the specified instances will be removed.
       */
      public java.lang.String getInstanceGroup() {
        return instanceGroup;
      }

      /** The name of the instance group where the specified instances will be removed. */
      public RemoveInstances setInstanceGroup(java.lang.String instanceGroup) {
        this.instanceGroup = instanceGroup;
        return this;
      }

      @Override
      public RemoveInstances set(String parameterName, Object value) {
        return (RemoveInstances) super.set(parameterName, value);
      }
    }
    /**
     * Sets the named ports for the specified instance group.
     *
     * Create a request for the method "instanceGroups.setNamedPorts".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetNamedPorts#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the instance group is located.
     * @param instanceGroup The name of the instance group where the named ports are updated.
     * @param content the {@link com.google.api.services.compute.model.InstanceGroupsSetNamedPortsRequest}
     * @return the request
     */
    public SetNamedPorts setNamedPorts(java.lang.String project, java.lang.String zone, java.lang.String instanceGroup, com.google.api.services.compute.model.InstanceGroupsSetNamedPortsRequest content) throws java.io.IOException {
      SetNamedPorts result = new SetNamedPorts(project, zone, instanceGroup, content);
      initialize(result);
      return result;
    }

    public class SetNamedPorts extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroups/{instanceGroup}/setNamedPorts";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Sets the named ports for the specified instance group.
       *
       * Create a request for the method "instanceGroups.setNamedPorts".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetNamedPorts#execute()} method to invoke the remote operation. <p>
       * {@link SetNamedPorts#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientR
       * equest)} must be called to initialize this instance immediately after invoking the constructor.
       * </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the instance group is located.
       * @param instanceGroup The name of the instance group where the named ports are updated.
       * @param content the {@link com.google.api.services.compute.model.InstanceGroupsSetNamedPortsRequest}
       * @since 1.13
       */
      protected SetNamedPorts(java.lang.String project, java.lang.String zone, java.lang.String instanceGroup, com.google.api.services.compute.model.InstanceGroupsSetNamedPortsRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroup = com.google.api.client.util.Preconditions.checkNotNull(instanceGroup, "Required parameter instanceGroup must be specified.");
      }

      @Override
      public SetNamedPorts setAlt(java.lang.String alt) {
        return (SetNamedPorts) super.setAlt(alt);
      }

      @Override
      public SetNamedPorts setFields(java.lang.String fields) {
        return (SetNamedPorts) super.setFields(fields);
      }

      @Override
      public SetNamedPorts setKey(java.lang.String key) {
        return (SetNamedPorts) super.setKey(key);
      }

      @Override
      public SetNamedPorts setOauthToken(java.lang.String oauthToken) {
        return (SetNamedPorts) super.setOauthToken(oauthToken);
      }

      @Override
      public SetNamedPorts setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetNamedPorts) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetNamedPorts setQuotaUser(java.lang.String quotaUser) {
        return (SetNamedPorts) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetNamedPorts setUserIp(java.lang.String userIp) {
        return (SetNamedPorts) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetNamedPorts setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the instance group is located. */
      public SetNamedPorts setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the instance group where the named ports are updated. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroup;

      /** The name of the instance group where the named ports are updated.
       */
      public java.lang.String getInstanceGroup() {
        return instanceGroup;
      }

      /** The name of the instance group where the named ports are updated. */
      public SetNamedPorts setInstanceGroup(java.lang.String instanceGroup) {
        this.instanceGroup = instanceGroup;
        return this;
      }

      @Override
      public SetNamedPorts set(String parameterName, Object value) {
        return (SetNamedPorts) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the InstanceTemplates collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.InstanceTemplates.List request = compute.instanceTemplates().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public InstanceTemplates instanceTemplates() {
    return new InstanceTemplates();
  }

  /**
   * The "instanceTemplates" collection of methods.
   */
  public class InstanceTemplates {

    /**
     * Deletes the specified instance template. If you delete an instance template that is being
     * referenced from another instance group, the instance group will not be able to create or recreate
     * virtual machine instances. Deleting an instance template is permanent and cannot be undone.
     *
     * Create a request for the method "instanceTemplates.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param instanceTemplate The name of the instance template to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String instanceTemplate) throws java.io.IOException {
      Delete result = new Delete(project, instanceTemplate);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/instanceTemplates/{instanceTemplate}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern INSTANCE_TEMPLATE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified instance template. If you delete an instance template that is being
       * referenced from another instance group, the instance group will not be able to create or
       * recreate virtual machine instances. Deleting an instance template is permanent and cannot be
       * undone.
       *
       * Create a request for the method "instanceTemplates.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param instanceTemplate The name of the instance template to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String instanceTemplate) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.instanceTemplate = com.google.api.client.util.Preconditions.checkNotNull(instanceTemplate, "Required parameter instanceTemplate must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_TEMPLATE_PATTERN.matcher(instanceTemplate).matches(),
              "Parameter instanceTemplate must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the instance template to delete. */
      @com.google.api.client.util.Key
      private java.lang.String instanceTemplate;

      /** The name of the instance template to delete.
       */
      public java.lang.String getInstanceTemplate() {
        return instanceTemplate;
      }

      /** The name of the instance template to delete. */
      public Delete setInstanceTemplate(java.lang.String instanceTemplate) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_TEMPLATE_PATTERN.matcher(instanceTemplate).matches(),
              "Parameter instanceTemplate must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instanceTemplate = instanceTemplate;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified instance template. Get a list of available instance templates by making a
     * list() request.
     *
     * Create a request for the method "instanceTemplates.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param instanceTemplate The name of the instance template.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String instanceTemplate) throws java.io.IOException {
      Get result = new Get(project, instanceTemplate);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.InstanceTemplate> {

      private static final String REST_PATH = "{project}/global/instanceTemplates/{instanceTemplate}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern INSTANCE_TEMPLATE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified instance template. Get a list of available instance templates by making a
       * list() request.
       *
       * Create a request for the method "instanceTemplates.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param instanceTemplate The name of the instance template.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String instanceTemplate) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceTemplate.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.instanceTemplate = com.google.api.client.util.Preconditions.checkNotNull(instanceTemplate, "Required parameter instanceTemplate must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_TEMPLATE_PATTERN.matcher(instanceTemplate).matches(),
              "Parameter instanceTemplate must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the instance template. */
      @com.google.api.client.util.Key
      private java.lang.String instanceTemplate;

      /** The name of the instance template.
       */
      public java.lang.String getInstanceTemplate() {
        return instanceTemplate;
      }

      /** The name of the instance template. */
      public Get setInstanceTemplate(java.lang.String instanceTemplate) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_TEMPLATE_PATTERN.matcher(instanceTemplate).matches(),
              "Parameter instanceTemplate must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instanceTemplate = instanceTemplate;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an instance template in the specified project using the data that is included in the
     * request. If you are creating a new template to update an existing instance group, your new
     * instance template must use the same network or, if applicable, the same subnetwork as the
     * original template.
     *
     * Create a request for the method "instanceTemplates.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.InstanceTemplate}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.InstanceTemplate content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/instanceTemplates";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates an instance template in the specified project using the data that is included in the
       * request. If you are creating a new template to update an existing instance group, your new
       * instance template must use the same network or, if applicable, the same subnetwork as the
       * original template.
       *
       * Create a request for the method "instanceTemplates.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.InstanceTemplate}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.InstanceTemplate content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of instance templates that are contained within the specified project and zone.
     *
     * Create a request for the method "instanceTemplates.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.InstanceTemplateList> {

      private static final String REST_PATH = "{project}/global/instanceTemplates";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves a list of instance templates that are contained within the specified project and
       * zone.
       *
       * Create a request for the method "instanceTemplates.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceTemplateList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Instances collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Instances.List request = compute.instances().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Instances instances() {
    return new Instances();
  }

  /**
   * The "instances" collection of methods.
   */
  public class Instances {

    /**
     * Adds an access config to an instance's network interface.
     *
     * Create a request for the method "instances.addAccessConfig".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AddAccessConfig#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance The instance name for this request.
     * @param networkInterface The name of the network interface to add to this instance.
     * @param content the {@link com.google.api.services.compute.model.AccessConfig}
     * @return the request
     */
    public AddAccessConfig addAccessConfig(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String networkInterface, com.google.api.services.compute.model.AccessConfig content) throws java.io.IOException {
      AddAccessConfig result = new AddAccessConfig(project, zone, instance, networkInterface, content);
      initialize(result);
      return result;
    }

    public class AddAccessConfig extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/addAccessConfig";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Adds an access config to an instance's network interface.
       *
       * Create a request for the method "instances.addAccessConfig".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddAccessConfig#execute()} method to invoke the remote operation.
       * <p> {@link AddAccessConfig#initialize(com.google.api.client.googleapis.services.AbstractGoogleC
       * lientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance The instance name for this request.
       * @param networkInterface The name of the network interface to add to this instance.
       * @param content the {@link com.google.api.services.compute.model.AccessConfig}
       * @since 1.13
       */
      protected AddAccessConfig(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String networkInterface, com.google.api.services.compute.model.AccessConfig content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.networkInterface = com.google.api.client.util.Preconditions.checkNotNull(networkInterface, "Required parameter networkInterface must be specified.");
      }

      @Override
      public AddAccessConfig setAlt(java.lang.String alt) {
        return (AddAccessConfig) super.setAlt(alt);
      }

      @Override
      public AddAccessConfig setFields(java.lang.String fields) {
        return (AddAccessConfig) super.setFields(fields);
      }

      @Override
      public AddAccessConfig setKey(java.lang.String key) {
        return (AddAccessConfig) super.setKey(key);
      }

      @Override
      public AddAccessConfig setOauthToken(java.lang.String oauthToken) {
        return (AddAccessConfig) super.setOauthToken(oauthToken);
      }

      @Override
      public AddAccessConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AddAccessConfig) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddAccessConfig setQuotaUser(java.lang.String quotaUser) {
        return (AddAccessConfig) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddAccessConfig setUserIp(java.lang.String userIp) {
        return (AddAccessConfig) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AddAccessConfig setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public AddAccessConfig setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** The instance name for this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** The instance name for this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** The instance name for this request. */
      public AddAccessConfig setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      /** The name of the network interface to add to this instance. */
      @com.google.api.client.util.Key
      private java.lang.String networkInterface;

      /** The name of the network interface to add to this instance.
       */
      public java.lang.String getNetworkInterface() {
        return networkInterface;
      }

      /** The name of the network interface to add to this instance. */
      public AddAccessConfig setNetworkInterface(java.lang.String networkInterface) {
        this.networkInterface = networkInterface;
        return this;
      }

      @Override
      public AddAccessConfig set(String parameterName, Object value) {
        return (AddAccessConfig) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves aggregated list of instances.
     *
     * Create a request for the method "instances.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.InstanceAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/instances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves aggregated list of instances.
       *
       * Create a request for the method "instances.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Attaches a Disk resource to an instance.
     *
     * Create a request for the method "instances.attachDisk".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AttachDisk#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance The instance name for this request.
     * @param content the {@link com.google.api.services.compute.model.AttachedDisk}
     * @return the request
     */
    public AttachDisk attachDisk(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.AttachedDisk content) throws java.io.IOException {
      AttachDisk result = new AttachDisk(project, zone, instance, content);
      initialize(result);
      return result;
    }

    public class AttachDisk extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/attachDisk";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Attaches a Disk resource to an instance.
       *
       * Create a request for the method "instances.attachDisk".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AttachDisk#execute()} method to invoke the remote operation. <p>
       * {@link
       * AttachDisk#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance The instance name for this request.
       * @param content the {@link com.google.api.services.compute.model.AttachedDisk}
       * @since 1.13
       */
      protected AttachDisk(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.AttachedDisk content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public AttachDisk setAlt(java.lang.String alt) {
        return (AttachDisk) super.setAlt(alt);
      }

      @Override
      public AttachDisk setFields(java.lang.String fields) {
        return (AttachDisk) super.setFields(fields);
      }

      @Override
      public AttachDisk setKey(java.lang.String key) {
        return (AttachDisk) super.setKey(key);
      }

      @Override
      public AttachDisk setOauthToken(java.lang.String oauthToken) {
        return (AttachDisk) super.setOauthToken(oauthToken);
      }

      @Override
      public AttachDisk setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AttachDisk) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AttachDisk setQuotaUser(java.lang.String quotaUser) {
        return (AttachDisk) super.setQuotaUser(quotaUser);
      }

      @Override
      public AttachDisk setUserIp(java.lang.String userIp) {
        return (AttachDisk) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AttachDisk setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public AttachDisk setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** The instance name for this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** The instance name for this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** The instance name for this request. */
      public AttachDisk setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public AttachDisk set(String parameterName, Object value) {
        return (AttachDisk) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified Instance resource. For more information, see Stopping or Deleting an
     * Instance.
     *
     * Create a request for the method "instances.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Name of the instance resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String instance) throws java.io.IOException {
      Delete result = new Delete(project, zone, instance);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified Instance resource. For more information, see Stopping or Deleting an
       * Instance.
       *
       * Create a request for the method "instances.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Name of the instance resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String instance) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Delete setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance resource to delete.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance resource to delete. */
      public Delete setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Deletes an access config from an instance's network interface.
     *
     * Create a request for the method "instances.deleteAccessConfig".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link DeleteAccessConfig#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance The instance name for this request.
     * @param accessConfig The name of the access config to delete.
     * @param networkInterface The name of the network interface.
     * @return the request
     */
    public DeleteAccessConfig deleteAccessConfig(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String accessConfig, java.lang.String networkInterface) throws java.io.IOException {
      DeleteAccessConfig result = new DeleteAccessConfig(project, zone, instance, accessConfig, networkInterface);
      initialize(result);
      return result;
    }

    public class DeleteAccessConfig extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/deleteAccessConfig";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes an access config from an instance's network interface.
       *
       * Create a request for the method "instances.deleteAccessConfig".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link DeleteAccessConfig#execute()} method to invoke the remote
       * operation. <p> {@link DeleteAccessConfig#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance The instance name for this request.
       * @param accessConfig The name of the access config to delete.
       * @param networkInterface The name of the network interface.
       * @since 1.13
       */
      protected DeleteAccessConfig(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String accessConfig, java.lang.String networkInterface) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.accessConfig = com.google.api.client.util.Preconditions.checkNotNull(accessConfig, "Required parameter accessConfig must be specified.");
        this.networkInterface = com.google.api.client.util.Preconditions.checkNotNull(networkInterface, "Required parameter networkInterface must be specified.");
      }

      @Override
      public DeleteAccessConfig setAlt(java.lang.String alt) {
        return (DeleteAccessConfig) super.setAlt(alt);
      }

      @Override
      public DeleteAccessConfig setFields(java.lang.String fields) {
        return (DeleteAccessConfig) super.setFields(fields);
      }

      @Override
      public DeleteAccessConfig setKey(java.lang.String key) {
        return (DeleteAccessConfig) super.setKey(key);
      }

      @Override
      public DeleteAccessConfig setOauthToken(java.lang.String oauthToken) {
        return (DeleteAccessConfig) super.setOauthToken(oauthToken);
      }

      @Override
      public DeleteAccessConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DeleteAccessConfig) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DeleteAccessConfig setQuotaUser(java.lang.String quotaUser) {
        return (DeleteAccessConfig) super.setQuotaUser(quotaUser);
      }

      @Override
      public DeleteAccessConfig setUserIp(java.lang.String userIp) {
        return (DeleteAccessConfig) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public DeleteAccessConfig setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public DeleteAccessConfig setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** The instance name for this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** The instance name for this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** The instance name for this request. */
      public DeleteAccessConfig setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      /** The name of the access config to delete. */
      @com.google.api.client.util.Key
      private java.lang.String accessConfig;

      /** The name of the access config to delete.
       */
      public java.lang.String getAccessConfig() {
        return accessConfig;
      }

      /** The name of the access config to delete. */
      public DeleteAccessConfig setAccessConfig(java.lang.String accessConfig) {
        this.accessConfig = accessConfig;
        return this;
      }

      /** The name of the network interface. */
      @com.google.api.client.util.Key
      private java.lang.String networkInterface;

      /** The name of the network interface.
       */
      public java.lang.String getNetworkInterface() {
        return networkInterface;
      }

      /** The name of the network interface. */
      public DeleteAccessConfig setNetworkInterface(java.lang.String networkInterface) {
        this.networkInterface = networkInterface;
        return this;
      }

      @Override
      public DeleteAccessConfig set(String parameterName, Object value) {
        return (DeleteAccessConfig) super.set(parameterName, value);
      }
    }
    /**
     * Detaches a disk from an instance.
     *
     * Create a request for the method "instances.detachDisk".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link DetachDisk#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Instance name.
     * @param deviceName Disk device name to detach.
     * @return the request
     */
    public DetachDisk detachDisk(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String deviceName) throws java.io.IOException {
      DetachDisk result = new DetachDisk(project, zone, instance, deviceName);
      initialize(result);
      return result;
    }

    public class DetachDisk extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/detachDisk";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DEVICE_NAME_PATTERN =
          java.util.regex.Pattern.compile("\\w[\\w.-]{0,254}");

      /**
       * Detaches a disk from an instance.
       *
       * Create a request for the method "instances.detachDisk".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link DetachDisk#execute()} method to invoke the remote operation. <p>
       * {@link
       * DetachDisk#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Instance name.
       * @param deviceName Disk device name to detach.
       * @since 1.13
       */
      protected DetachDisk(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String deviceName) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.deviceName = com.google.api.client.util.Preconditions.checkNotNull(deviceName, "Required parameter deviceName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DEVICE_NAME_PATTERN.matcher(deviceName).matches(),
              "Parameter deviceName must conform to the pattern " +
              "\\w[\\w.-]{0,254}");
        }
      }

      @Override
      public DetachDisk setAlt(java.lang.String alt) {
        return (DetachDisk) super.setAlt(alt);
      }

      @Override
      public DetachDisk setFields(java.lang.String fields) {
        return (DetachDisk) super.setFields(fields);
      }

      @Override
      public DetachDisk setKey(java.lang.String key) {
        return (DetachDisk) super.setKey(key);
      }

      @Override
      public DetachDisk setOauthToken(java.lang.String oauthToken) {
        return (DetachDisk) super.setOauthToken(oauthToken);
      }

      @Override
      public DetachDisk setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DetachDisk) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DetachDisk setQuotaUser(java.lang.String quotaUser) {
        return (DetachDisk) super.setQuotaUser(quotaUser);
      }

      @Override
      public DetachDisk setUserIp(java.lang.String userIp) {
        return (DetachDisk) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public DetachDisk setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public DetachDisk setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Instance name. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Instance name.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Instance name. */
      public DetachDisk setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      /** Disk device name to detach. */
      @com.google.api.client.util.Key
      private java.lang.String deviceName;

      /** Disk device name to detach.
       */
      public java.lang.String getDeviceName() {
        return deviceName;
      }

      /** Disk device name to detach. */
      public DetachDisk setDeviceName(java.lang.String deviceName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DEVICE_NAME_PATTERN.matcher(deviceName).matches(),
              "Parameter deviceName must conform to the pattern " +
              "\\w[\\w.-]{0,254}");
        }
        this.deviceName = deviceName;
        return this;
      }

      @Override
      public DetachDisk set(String parameterName, Object value) {
        return (DetachDisk) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified Instance resource. Get a list of available instances by making a list()
     * request.
     *
     * Create a request for the method "instances.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Name of the instance resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String instance) throws java.io.IOException {
      Get result = new Get(project, zone, instance);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Instance> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified Instance resource. Get a list of available instances by making a list()
       * request.
       *
       * Create a request for the method "instances.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Name of the instance resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String instance) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Instance.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance resource to return.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance resource to return. */
      public Get setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified instance's serial port output.
     *
     * Create a request for the method "instances.getSerialPortOutput".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetSerialPortOutput#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Name of the instance scoping this request.
     * @return the request
     */
    public GetSerialPortOutput getSerialPortOutput(java.lang.String project, java.lang.String zone, java.lang.String instance) throws java.io.IOException {
      GetSerialPortOutput result = new GetSerialPortOutput(project, zone, instance);
      initialize(result);
      return result;
    }

    public class GetSerialPortOutput extends ComputeRequest<com.google.api.services.compute.model.SerialPortOutput> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/serialPort";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified instance's serial port output.
       *
       * Create a request for the method "instances.getSerialPortOutput".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetSerialPortOutput#execute()} method to invoke the remote
       * operation. <p> {@link GetSerialPortOutput#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Name of the instance scoping this request.
       * @since 1.13
       */
      protected GetSerialPortOutput(java.lang.String project, java.lang.String zone, java.lang.String instance) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.SerialPortOutput.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetSerialPortOutput setAlt(java.lang.String alt) {
        return (GetSerialPortOutput) super.setAlt(alt);
      }

      @Override
      public GetSerialPortOutput setFields(java.lang.String fields) {
        return (GetSerialPortOutput) super.setFields(fields);
      }

      @Override
      public GetSerialPortOutput setKey(java.lang.String key) {
        return (GetSerialPortOutput) super.setKey(key);
      }

      @Override
      public GetSerialPortOutput setOauthToken(java.lang.String oauthToken) {
        return (GetSerialPortOutput) super.setOauthToken(oauthToken);
      }

      @Override
      public GetSerialPortOutput setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetSerialPortOutput) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetSerialPortOutput setQuotaUser(java.lang.String quotaUser) {
        return (GetSerialPortOutput) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetSerialPortOutput setUserIp(java.lang.String userIp) {
        return (GetSerialPortOutput) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public GetSerialPortOutput setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public GetSerialPortOutput setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance scoping this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public GetSerialPortOutput setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      /** Specifies which COM or serial port to retrieve data from. */
      @com.google.api.client.util.Key
      private java.lang.Integer port;

      /** Specifies which COM or serial port to retrieve data from. [default: 1] [minimum: 1] [maximum: 4]
       */
      public java.lang.Integer getPort() {
        return port;
      }

      /** Specifies which COM or serial port to retrieve data from. */
      public GetSerialPortOutput setPort(java.lang.Integer port) {
        this.port = port;
        return this;
      }

      @Override
      public GetSerialPortOutput set(String parameterName, Object value) {
        return (GetSerialPortOutput) super.set(parameterName, value);
      }
    }
    /**
     * Creates an instance resource in the specified project using the data included in the request.
     *
     * Create a request for the method "instances.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param content the {@link com.google.api.services.compute.model.Instance}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Instance content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates an instance resource in the specified project using the data included in the request.
       *
       * Create a request for the method "instances.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param content the {@link com.google.api.services.compute.model.Instance}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Instance content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Insert setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of instances contained within the specified zone.
     *
     * Create a request for the method "instances.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.InstanceList> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of instances contained within the specified zone.
       *
       * Create a request for the method "instances.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Performs a hard reset on the instance.
     *
     * Create a request for the method "instances.reset".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Reset#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Name of the instance scoping this request.
     * @return the request
     */
    public Reset reset(java.lang.String project, java.lang.String zone, java.lang.String instance) throws java.io.IOException {
      Reset result = new Reset(project, zone, instance);
      initialize(result);
      return result;
    }

    public class Reset extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/reset";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Performs a hard reset on the instance.
       *
       * Create a request for the method "instances.reset".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Reset#execute()} method to invoke the remote operation. <p> {@link
       * Reset#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Name of the instance scoping this request.
       * @since 1.13
       */
      protected Reset(java.lang.String project, java.lang.String zone, java.lang.String instance) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Reset setAlt(java.lang.String alt) {
        return (Reset) super.setAlt(alt);
      }

      @Override
      public Reset setFields(java.lang.String fields) {
        return (Reset) super.setFields(fields);
      }

      @Override
      public Reset setKey(java.lang.String key) {
        return (Reset) super.setKey(key);
      }

      @Override
      public Reset setOauthToken(java.lang.String oauthToken) {
        return (Reset) super.setOauthToken(oauthToken);
      }

      @Override
      public Reset setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Reset) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Reset setQuotaUser(java.lang.String quotaUser) {
        return (Reset) super.setQuotaUser(quotaUser);
      }

      @Override
      public Reset setUserIp(java.lang.String userIp) {
        return (Reset) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Reset setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Reset setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance scoping this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public Reset setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public Reset set(String parameterName, Object value) {
        return (Reset) super.set(parameterName, value);
      }
    }
    /**
     * Sets the auto-delete flag for a disk attached to an instance.
     *
     * Create a request for the method "instances.setDiskAutoDelete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetDiskAutoDelete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance The instance name.
     * @param autoDelete Whether to auto-delete the disk when the instance is deleted.
     * @param deviceName The device name of the disk to modify.
     * @return the request
     */
    public SetDiskAutoDelete setDiskAutoDelete(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.Boolean autoDelete, java.lang.String deviceName) throws java.io.IOException {
      SetDiskAutoDelete result = new SetDiskAutoDelete(project, zone, instance, autoDelete, deviceName);
      initialize(result);
      return result;
    }

    public class SetDiskAutoDelete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setDiskAutoDelete";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DEVICE_NAME_PATTERN =
          java.util.regex.Pattern.compile("\\w[\\w.-]{0,254}");

      /**
       * Sets the auto-delete flag for a disk attached to an instance.
       *
       * Create a request for the method "instances.setDiskAutoDelete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetDiskAutoDelete#execute()} method to invoke the remote operation.
       * <p> {@link SetDiskAutoDelete#initialize(com.google.api.client.googleapis.services.AbstractGoogl
       * eClientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance The instance name.
       * @param autoDelete Whether to auto-delete the disk when the instance is deleted.
       * @param deviceName The device name of the disk to modify.
       * @since 1.13
       */
      protected SetDiskAutoDelete(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.Boolean autoDelete, java.lang.String deviceName) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoDelete = com.google.api.client.util.Preconditions.checkNotNull(autoDelete, "Required parameter autoDelete must be specified.");
        this.deviceName = com.google.api.client.util.Preconditions.checkNotNull(deviceName, "Required parameter deviceName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DEVICE_NAME_PATTERN.matcher(deviceName).matches(),
              "Parameter deviceName must conform to the pattern " +
              "\\w[\\w.-]{0,254}");
        }
      }

      @Override
      public SetDiskAutoDelete setAlt(java.lang.String alt) {
        return (SetDiskAutoDelete) super.setAlt(alt);
      }

      @Override
      public SetDiskAutoDelete setFields(java.lang.String fields) {
        return (SetDiskAutoDelete) super.setFields(fields);
      }

      @Override
      public SetDiskAutoDelete setKey(java.lang.String key) {
        return (SetDiskAutoDelete) super.setKey(key);
      }

      @Override
      public SetDiskAutoDelete setOauthToken(java.lang.String oauthToken) {
        return (SetDiskAutoDelete) super.setOauthToken(oauthToken);
      }

      @Override
      public SetDiskAutoDelete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetDiskAutoDelete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetDiskAutoDelete setQuotaUser(java.lang.String quotaUser) {
        return (SetDiskAutoDelete) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetDiskAutoDelete setUserIp(java.lang.String userIp) {
        return (SetDiskAutoDelete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetDiskAutoDelete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public SetDiskAutoDelete setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** The instance name. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** The instance name.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** The instance name. */
      public SetDiskAutoDelete setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      /** Whether to auto-delete the disk when the instance is deleted. */
      @com.google.api.client.util.Key
      private java.lang.Boolean autoDelete;

      /** Whether to auto-delete the disk when the instance is deleted.
       */
      public java.lang.Boolean getAutoDelete() {
        return autoDelete;
      }

      /** Whether to auto-delete the disk when the instance is deleted. */
      public SetDiskAutoDelete setAutoDelete(java.lang.Boolean autoDelete) {
        this.autoDelete = autoDelete;
        return this;
      }

      /** The device name of the disk to modify. */
      @com.google.api.client.util.Key
      private java.lang.String deviceName;

      /** The device name of the disk to modify.
       */
      public java.lang.String getDeviceName() {
        return deviceName;
      }

      /** The device name of the disk to modify. */
      public SetDiskAutoDelete setDeviceName(java.lang.String deviceName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DEVICE_NAME_PATTERN.matcher(deviceName).matches(),
              "Parameter deviceName must conform to the pattern " +
              "\\w[\\w.-]{0,254}");
        }
        this.deviceName = deviceName;
        return this;
      }

      @Override
      public SetDiskAutoDelete set(String parameterName, Object value) {
        return (SetDiskAutoDelete) super.set(parameterName, value);
      }
    }
    /**
     * Changes the machine type for a stopped instance to the machine type specified in the request.
     *
     * Create a request for the method "instances.setMachineType".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetMachineType#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Name of the instance scoping this request.
     * @param content the {@link com.google.api.services.compute.model.InstancesSetMachineTypeRequest}
     * @return the request
     */
    public SetMachineType setMachineType(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.InstancesSetMachineTypeRequest content) throws java.io.IOException {
      SetMachineType result = new SetMachineType(project, zone, instance, content);
      initialize(result);
      return result;
    }

    public class SetMachineType extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setMachineType";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Changes the machine type for a stopped instance to the machine type specified in the request.
       *
       * Create a request for the method "instances.setMachineType".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetMachineType#execute()} method to invoke the remote operation.
       * <p> {@link SetMachineType#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Name of the instance scoping this request.
       * @param content the {@link com.google.api.services.compute.model.InstancesSetMachineTypeRequest}
       * @since 1.13
       */
      protected SetMachineType(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.InstancesSetMachineTypeRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetMachineType setAlt(java.lang.String alt) {
        return (SetMachineType) super.setAlt(alt);
      }

      @Override
      public SetMachineType setFields(java.lang.String fields) {
        return (SetMachineType) super.setFields(fields);
      }

      @Override
      public SetMachineType setKey(java.lang.String key) {
        return (SetMachineType) super.setKey(key);
      }

      @Override
      public SetMachineType setOauthToken(java.lang.String oauthToken) {
        return (SetMachineType) super.setOauthToken(oauthToken);
      }

      @Override
      public SetMachineType setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetMachineType) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetMachineType setQuotaUser(java.lang.String quotaUser) {
        return (SetMachineType) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetMachineType setUserIp(java.lang.String userIp) {
        return (SetMachineType) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetMachineType setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public SetMachineType setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance scoping this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public SetMachineType setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public SetMachineType set(String parameterName, Object value) {
        return (SetMachineType) super.set(parameterName, value);
      }
    }
    /**
     * Sets metadata for the specified instance to the data included in the request.
     *
     * Create a request for the method "instances.setMetadata".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetMetadata#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Name of the instance scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Metadata}
     * @return the request
     */
    public SetMetadata setMetadata(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Metadata content) throws java.io.IOException {
      SetMetadata result = new SetMetadata(project, zone, instance, content);
      initialize(result);
      return result;
    }

    public class SetMetadata extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setMetadata";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets metadata for the specified instance to the data included in the request.
       *
       * Create a request for the method "instances.setMetadata".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetMetadata#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetMetadata#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Name of the instance scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Metadata}
       * @since 1.13
       */
      protected SetMetadata(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Metadata content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetMetadata setAlt(java.lang.String alt) {
        return (SetMetadata) super.setAlt(alt);
      }

      @Override
      public SetMetadata setFields(java.lang.String fields) {
        return (SetMetadata) super.setFields(fields);
      }

      @Override
      public SetMetadata setKey(java.lang.String key) {
        return (SetMetadata) super.setKey(key);
      }

      @Override
      public SetMetadata setOauthToken(java.lang.String oauthToken) {
        return (SetMetadata) super.setOauthToken(oauthToken);
      }

      @Override
      public SetMetadata setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetMetadata) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetMetadata setQuotaUser(java.lang.String quotaUser) {
        return (SetMetadata) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetMetadata setUserIp(java.lang.String userIp) {
        return (SetMetadata) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetMetadata setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public SetMetadata setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance scoping this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public SetMetadata setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public SetMetadata set(String parameterName, Object value) {
        return (SetMetadata) super.set(parameterName, value);
      }
    }
    /**
     * Sets an instance's scheduling options.
     *
     * Create a request for the method "instances.setScheduling".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetScheduling#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Instance name.
     * @param content the {@link com.google.api.services.compute.model.Scheduling}
     * @return the request
     */
    public SetScheduling setScheduling(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Scheduling content) throws java.io.IOException {
      SetScheduling result = new SetScheduling(project, zone, instance, content);
      initialize(result);
      return result;
    }

    public class SetScheduling extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setScheduling";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets an instance's scheduling options.
       *
       * Create a request for the method "instances.setScheduling".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetScheduling#execute()} method to invoke the remote operation. <p>
       * {@link SetScheduling#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientR
       * equest)} must be called to initialize this instance immediately after invoking the constructor.
       * </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Instance name.
       * @param content the {@link com.google.api.services.compute.model.Scheduling}
       * @since 1.13
       */
      protected SetScheduling(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Scheduling content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetScheduling setAlt(java.lang.String alt) {
        return (SetScheduling) super.setAlt(alt);
      }

      @Override
      public SetScheduling setFields(java.lang.String fields) {
        return (SetScheduling) super.setFields(fields);
      }

      @Override
      public SetScheduling setKey(java.lang.String key) {
        return (SetScheduling) super.setKey(key);
      }

      @Override
      public SetScheduling setOauthToken(java.lang.String oauthToken) {
        return (SetScheduling) super.setOauthToken(oauthToken);
      }

      @Override
      public SetScheduling setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetScheduling) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetScheduling setQuotaUser(java.lang.String quotaUser) {
        return (SetScheduling) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetScheduling setUserIp(java.lang.String userIp) {
        return (SetScheduling) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetScheduling setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public SetScheduling setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Instance name. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Instance name.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Instance name. */
      public SetScheduling setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public SetScheduling set(String parameterName, Object value) {
        return (SetScheduling) super.set(parameterName, value);
      }
    }
    /**
     * Sets tags for the specified instance to the data included in the request.
     *
     * Create a request for the method "instances.setTags".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetTags#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Name of the instance scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Tags}
     * @return the request
     */
    public SetTags setTags(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Tags content) throws java.io.IOException {
      SetTags result = new SetTags(project, zone, instance, content);
      initialize(result);
      return result;
    }

    public class SetTags extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setTags";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets tags for the specified instance to the data included in the request.
       *
       * Create a request for the method "instances.setTags".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetTags#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetTags#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Name of the instance scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Tags}
       * @since 1.13
       */
      protected SetTags(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Tags content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetTags setAlt(java.lang.String alt) {
        return (SetTags) super.setAlt(alt);
      }

      @Override
      public SetTags setFields(java.lang.String fields) {
        return (SetTags) super.setFields(fields);
      }

      @Override
      public SetTags setKey(java.lang.String key) {
        return (SetTags) super.setKey(key);
      }

      @Override
      public SetTags setOauthToken(java.lang.String oauthToken) {
        return (SetTags) super.setOauthToken(oauthToken);
      }

      @Override
      public SetTags setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetTags) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetTags setQuotaUser(java.lang.String quotaUser) {
        return (SetTags) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetTags setUserIp(java.lang.String userIp) {
        return (SetTags) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetTags setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public SetTags setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance scoping this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public SetTags setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public SetTags set(String parameterName, Object value) {
        return (SetTags) super.set(parameterName, value);
      }
    }
    /**
     * Starts an instance that was stopped using the using the instances().stop method. For more
     * information, see Restart an instance.
     *
     * Create a request for the method "instances.start".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Start#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Name of the instance resource to start.
     * @return the request
     */
    public Start start(java.lang.String project, java.lang.String zone, java.lang.String instance) throws java.io.IOException {
      Start result = new Start(project, zone, instance);
      initialize(result);
      return result;
    }

    public class Start extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/start";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Starts an instance that was stopped using the using the instances().stop method. For more
       * information, see Restart an instance.
       *
       * Create a request for the method "instances.start".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Start#execute()} method to invoke the remote operation. <p> {@link
       * Start#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Name of the instance resource to start.
       * @since 1.13
       */
      protected Start(java.lang.String project, java.lang.String zone, java.lang.String instance) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Start setAlt(java.lang.String alt) {
        return (Start) super.setAlt(alt);
      }

      @Override
      public Start setFields(java.lang.String fields) {
        return (Start) super.setFields(fields);
      }

      @Override
      public Start setKey(java.lang.String key) {
        return (Start) super.setKey(key);
      }

      @Override
      public Start setOauthToken(java.lang.String oauthToken) {
        return (Start) super.setOauthToken(oauthToken);
      }

      @Override
      public Start setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Start) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Start setQuotaUser(java.lang.String quotaUser) {
        return (Start) super.setQuotaUser(quotaUser);
      }

      @Override
      public Start setUserIp(java.lang.String userIp) {
        return (Start) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Start setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Start setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance resource to start. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance resource to start.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance resource to start. */
      public Start setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public Start set(String parameterName, Object value) {
        return (Start) super.set(parameterName, value);
      }
    }
    /**
     * Stops a running instance, shutting it down cleanly, and allows you to restart the instance at a
     * later time. Stopped instances do not incur per-minute, virtual machine usage charges while they
     * are stopped, but any resources that the virtual machine is using, such as persistent disks and
     * static IP addresses, will continue to be charged until they are deleted. For more information,
     * see Stopping an instance.
     *
     * Create a request for the method "instances.stop".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Stop#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Name of the instance resource to stop.
     * @return the request
     */
    public Stop stop(java.lang.String project, java.lang.String zone, java.lang.String instance) throws java.io.IOException {
      Stop result = new Stop(project, zone, instance);
      initialize(result);
      return result;
    }

    public class Stop extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/stop";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Stops a running instance, shutting it down cleanly, and allows you to restart the instance at a
       * later time. Stopped instances do not incur per-minute, virtual machine usage charges while they
       * are stopped, but any resources that the virtual machine is using, such as persistent disks and
       * static IP addresses, will continue to be charged until they are deleted. For more information,
       * see Stopping an instance.
       *
       * Create a request for the method "instances.stop".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Stop#execute()} method to invoke the remote operation. <p> {@link
       * Stop#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Name of the instance resource to stop.
       * @since 1.13
       */
      protected Stop(java.lang.String project, java.lang.String zone, java.lang.String instance) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Stop setAlt(java.lang.String alt) {
        return (Stop) super.setAlt(alt);
      }

      @Override
      public Stop setFields(java.lang.String fields) {
        return (Stop) super.setFields(fields);
      }

      @Override
      public Stop setKey(java.lang.String key) {
        return (Stop) super.setKey(key);
      }

      @Override
      public Stop setOauthToken(java.lang.String oauthToken) {
        return (Stop) super.setOauthToken(oauthToken);
      }

      @Override
      public Stop setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Stop) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Stop setQuotaUser(java.lang.String quotaUser) {
        return (Stop) super.setQuotaUser(quotaUser);
      }

      @Override
      public Stop setUserIp(java.lang.String userIp) {
        return (Stop) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Stop setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Stop setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance resource to stop. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance resource to stop.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance resource to stop. */
      public Stop setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public Stop set(String parameterName, Object value) {
        return (Stop) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Licenses collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Licenses.List request = compute.licenses().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Licenses licenses() {
    return new Licenses();
  }

  /**
   * The "licenses" collection of methods.
   */
  public class Licenses {

    /**
     * Returns the specified License resource. Get a list of available licenses by making a list()
     * request.
     *
     * Create a request for the method "licenses.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param license Name of the License resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String license) throws java.io.IOException {
      Get result = new Get(project, license);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.License> {

      private static final String REST_PATH = "{project}/global/licenses/{license}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern LICENSE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified License resource. Get a list of available licenses by making a list()
       * request.
       *
       * Create a request for the method "licenses.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param license Name of the License resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String license) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.License.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.license = com.google.api.client.util.Preconditions.checkNotNull(license, "Required parameter license must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(LICENSE_PATTERN.matcher(license).matches(),
              "Parameter license must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the License resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String license;

      /** Name of the License resource to return.
       */
      public java.lang.String getLicense() {
        return license;
      }

      /** Name of the License resource to return. */
      public Get setLicense(java.lang.String license) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(LICENSE_PATTERN.matcher(license).matches(),
              "Parameter license must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.license = license;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the MachineTypes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.MachineTypes.List request = compute.machineTypes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public MachineTypes machineTypes() {
    return new MachineTypes();
  }

  /**
   * The "machineTypes" collection of methods.
   */
  public class MachineTypes {

    /**
     * Retrieves an aggregated list of machine types.
     *
     * Create a request for the method "machineTypes.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.MachineTypeAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/machineTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of machine types.
       *
       * Create a request for the method "machineTypes.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.MachineTypeAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified machine type. Get a list of available machine types by making a list()
     * request.
     *
     * Create a request for the method "machineTypes.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param machineType Name of the machine type to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String machineType) throws java.io.IOException {
      Get result = new Get(project, zone, machineType);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.MachineType> {

      private static final String REST_PATH = "{project}/zones/{zone}/machineTypes/{machineType}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern MACHINE_TYPE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified machine type. Get a list of available machine types by making a list()
       * request.
       *
       * Create a request for the method "machineTypes.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param machineType Name of the machine type to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String machineType) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.MachineType.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.machineType = com.google.api.client.util.Preconditions.checkNotNull(machineType, "Required parameter machineType must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MACHINE_TYPE_PATTERN.matcher(machineType).matches(),
              "Parameter machineType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the machine type to return. */
      @com.google.api.client.util.Key
      private java.lang.String machineType;

      /** Name of the machine type to return.
       */
      public java.lang.String getMachineType() {
        return machineType;
      }

      /** Name of the machine type to return. */
      public Get setMachineType(java.lang.String machineType) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MACHINE_TYPE_PATTERN.matcher(machineType).matches(),
              "Parameter machineType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.machineType = machineType;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of machine types available to the specified project.
     *
     * Create a request for the method "machineTypes.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.MachineTypeList> {

      private static final String REST_PATH = "{project}/zones/{zone}/machineTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of machine types available to the specified project.
       *
       * Create a request for the method "machineTypes.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.MachineTypeList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Networks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Networks.List request = compute.networks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Networks networks() {
    return new Networks();
  }

  /**
   * The "networks" collection of methods.
   */
  public class Networks {

    /**
     * Deletes the specified network.
     *
     * Create a request for the method "networks.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param network Name of the network to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String network) throws java.io.IOException {
      Delete result = new Delete(project, network);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/networks/{network}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern NETWORK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified network.
       *
       * Create a request for the method "networks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param network Name of the network to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String network) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.network = com.google.api.client.util.Preconditions.checkNotNull(network, "Required parameter network must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NETWORK_PATTERN.matcher(network).matches(),
              "Parameter network must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the network to delete. */
      @com.google.api.client.util.Key
      private java.lang.String network;

      /** Name of the network to delete.
       */
      public java.lang.String getNetwork() {
        return network;
      }

      /** Name of the network to delete. */
      public Delete setNetwork(java.lang.String network) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NETWORK_PATTERN.matcher(network).matches(),
              "Parameter network must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.network = network;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified network. Get a list of available networks by making a list() request.
     *
     * Create a request for the method "networks.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param network Name of the network to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String network) throws java.io.IOException {
      Get result = new Get(project, network);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Network> {

      private static final String REST_PATH = "{project}/global/networks/{network}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern NETWORK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified network. Get a list of available networks by making a list() request.
       *
       * Create a request for the method "networks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param network Name of the network to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String network) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Network.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.network = com.google.api.client.util.Preconditions.checkNotNull(network, "Required parameter network must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NETWORK_PATTERN.matcher(network).matches(),
              "Parameter network must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the network to return. */
      @com.google.api.client.util.Key
      private java.lang.String network;

      /** Name of the network to return.
       */
      public java.lang.String getNetwork() {
        return network;
      }

      /** Name of the network to return. */
      public Get setNetwork(java.lang.String network) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NETWORK_PATTERN.matcher(network).matches(),
              "Parameter network must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.network = network;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a network in the specified project using the data included in the request.
     *
     * Create a request for the method "networks.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.Network}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Network content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/networks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a network in the specified project using the data included in the request.
       *
       * Create a request for the method "networks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.Network}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Network content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of networks available to the specified project.
     *
     * Create a request for the method "networks.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.NetworkList> {

      private static final String REST_PATH = "{project}/global/networks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of networks available to the specified project.
       *
       * Create a request for the method "networks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.NetworkList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Sets a filter expression for filtering listed resources, in the form filter={expression}. Your
     {expression} must be in the format: field_name comparison_string literal_string.

     The field_name is the name of the field you want to compare. Only atomic field types are supported
     (string, number, boolean). The comparison_string must be either eq (equals) or ne (not equals). The
     literal_string is the string value to filter to. The literal value must be valid for the type of
     field you are filtering by (string, number, boolean). For string fields, the literal value is
     interpreted as a regular expression using RE2 syntax. The literal value must match the entire
     field.

     For example, to filter for instances that do not have a name of example-instance, you would use
     filter=name ne example-instance.

     Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested fields.
     For example, you could filter on instances that have set the scheduling.automaticRestart field to
     true. Use filtering on nested fields to take advantage of labels to organize and search for results
     based on label values.

     The Beta API also supports filtering on multiple expressions by providing each separate expression
     within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq us-central1-f).
     Multiple expressions are treated as AND expressions, meaning that resources must match all
     expressions to pass the filters.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Sets a filter expression for filtering listed resources, in the form filter={expression}.
       * Your {expression} must be in the format: field_name comparison_string literal_string.
       *
       * The field_name is the name of the field you want to compare. Only atomic field types are
       * supported (string, number, boolean). The comparison_string must be either eq (equals) or ne
       * (not equals). The literal_string is the string value to filter to. The literal value must
       * be valid for the type of field you are filtering by (string, number, boolean). For string
       * fields, the literal value is interpreted as a regular expression using RE2 syntax. The
       * literal value must match the entire field.
       *
       * For example, to filter for instances that do not have a name of example-instance, you would
       * use filter=name ne example-instance.
       *
       * Compute Engine Beta API Only: When filtering in the Beta API, you can also filter on nested
       * fields. For example, you could filter on instances that have set the
       * scheduling.automaticRestart field to true. Use filtering on nested fields to take advantage
       * of labels to organize and search for results based on label values.
       *
       * The Beta API also supports filtering on multiple expressions by providing each separate
       * expression within parentheses. For example, (scheduling.automaticRestart eq true) (zone eq
       * us-central1-f). Multiple expressions are treated as AND expressions, meaning that resources
       * must match all expressions to pass the filters.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Projects.List request = compute.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * Retu