/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-07-01 at 04:03:28 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Cloud Autoscaler policy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AutoscalingPolicy extends com.google.api.client.json.GenericJson {

  /**
   * The number of seconds that the autoscaler should wait before it starts collecting information
   * from a new instance. This prevents the autoscaler from collecting information when the instance
   * is initializing, during which the collected usage would not be reliable. The default time
   * autoscaler waits is 60 seconds.
   *
   * Virtual machine initialization times might vary because of numerous factors. We recommend that
   * you test how long an instance may take to initialize. To do this, create an instance and time
   * the startup process.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer coolDownPeriodSec;

  /**
   * Defines the CPU utilization policy that allows the autoscaler to scale based on the average CPU
   * utilization of a managed instance group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AutoscalingPolicyCpuUtilization cpuUtilization;

  /**
   * Configuration parameters of autoscaling based on a custom metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AutoscalingPolicyCustomMetricUtilization> customMetricUtilizations;

  /**
   * Configuration parameters of autoscaling based on load balancer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AutoscalingPolicyLoadBalancingUtilization loadBalancingUtilization;

  /**
   * The maximum number of instances that the autoscaler can scale up to. This is required when
   * creating or updating an autoscaler. The maximum number of replicas should not be lower than
   * minimal number of replicas.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxNumReplicas;

  /**
   * The minimum number of replicas that the autoscaler can scale down to. This cannot be less than
   * 0. If not provided, autoscaler will choose a default value depending on maximum number of
   * instances allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minNumReplicas;

  /**
   * The number of seconds that the autoscaler should wait before it starts collecting information
   * from a new instance. This prevents the autoscaler from collecting information when the instance
   * is initializing, during which the collected usage would not be reliable. The default time
   * autoscaler waits is 60 seconds.
   *
   * Virtual machine initialization times might vary because of numerous factors. We recommend that
   * you test how long an instance may take to initialize. To do this, create an instance and time
   * the startup process.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCoolDownPeriodSec() {
    return coolDownPeriodSec;
  }

  /**
   * The number of seconds that the autoscaler should wait before it starts collecting information
   * from a new instance. This prevents the autoscaler from collecting information when the instance
   * is initializing, during which the collected usage would not be reliable. The default time
   * autoscaler waits is 60 seconds.
   *
   * Virtual machine initialization times might vary because of numerous factors. We recommend that
   * you test how long an instance may take to initialize. To do this, create an instance and time
   * the startup process.
   * @param coolDownPeriodSec coolDownPeriodSec or {@code null} for none
   */
  public AutoscalingPolicy setCoolDownPeriodSec(java.lang.Integer coolDownPeriodSec) {
    this.coolDownPeriodSec = coolDownPeriodSec;
    return this;
  }

  /**
   * Defines the CPU utilization policy that allows the autoscaler to scale based on the average CPU
   * utilization of a managed instance group.
   * @return value or {@code null} for none
   */
  public AutoscalingPolicyCpuUtilization getCpuUtilization() {
    return cpuUtilization;
  }

  /**
   * Defines the CPU utilization policy that allows the autoscaler to scale based on the average CPU
   * utilization of a managed instance group.
   * @param cpuUtilization cpuUtilization or {@code null} for none
   */
  public AutoscalingPolicy setCpuUtilization(AutoscalingPolicyCpuUtilization cpuUtilization) {
    this.cpuUtilization = cpuUtilization;
    return this;
  }

  /**
   * Configuration parameters of autoscaling based on a custom metric.
   * @return value or {@code null} for none
   */
  public java.util.List<AutoscalingPolicyCustomMetricUtilization> getCustomMetricUtilizations() {
    return customMetricUtilizations;
  }

  /**
   * Configuration parameters of autoscaling based on a custom metric.
   * @param customMetricUtilizations customMetricUtilizations or {@code null} for none
   */
  public AutoscalingPolicy setCustomMetricUtilizations(java.util.List<AutoscalingPolicyCustomMetricUtilization> customMetricUtilizations) {
    this.customMetricUtilizations = customMetricUtilizations;
    return this;
  }

  /**
   * Configuration parameters of autoscaling based on load balancer.
   * @return value or {@code null} for none
   */
  public AutoscalingPolicyLoadBalancingUtilization getLoadBalancingUtilization() {
    return loadBalancingUtilization;
  }

  /**
   * Configuration parameters of autoscaling based on load balancer.
   * @param loadBalancingUtilization loadBalancingUtilization or {@code null} for none
   */
  public AutoscalingPolicy setLoadBalancingUtilization(AutoscalingPolicyLoadBalancingUtilization loadBalancingUtilization) {
    this.loadBalancingUtilization = loadBalancingUtilization;
    return this;
  }

  /**
   * The maximum number of instances that the autoscaler can scale up to. This is required when
   * creating or updating an autoscaler. The maximum number of replicas should not be lower than
   * minimal number of replicas.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxNumReplicas() {
    return maxNumReplicas;
  }

  /**
   * The maximum number of instances that the autoscaler can scale up to. This is required when
   * creating or updating an autoscaler. The maximum number of replicas should not be lower than
   * minimal number of replicas.
   * @param maxNumReplicas maxNumReplicas or {@code null} for none
   */
  public AutoscalingPolicy setMaxNumReplicas(java.lang.Integer maxNumReplicas) {
    this.maxNumReplicas = maxNumReplicas;
    return this;
  }

  /**
   * The minimum number of replicas that the autoscaler can scale down to. This cannot be less than
   * 0. If not provided, autoscaler will choose a default value depending on maximum number of
   * instances allowed.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinNumReplicas() {
    return minNumReplicas;
  }

  /**
   * The minimum number of replicas that the autoscaler can scale down to. This cannot be less than
   * 0. If not provided, autoscaler will choose a default value depending on maximum number of
   * instances allowed.
   * @param minNumReplicas minNumReplicas or {@code null} for none
   */
  public AutoscalingPolicy setMinNumReplicas(java.lang.Integer minNumReplicas) {
    this.minNumReplicas = minNumReplicas;
    return this;
  }

  @Override
  public AutoscalingPolicy set(String fieldName, Object value) {
    return (AutoscalingPolicy) super.set(fieldName, value);
  }

  @Override
  public AutoscalingPolicy clone() {
    return (AutoscalingPolicy) super.clone();
  }

}
