/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.compute;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.compute.ComputeRequest;
import com.google.api.services.compute.ComputeRequestInitializer;
import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.Address;
import com.google.api.services.compute.model.AddressAggregatedList;
import com.google.api.services.compute.model.AddressList;
import com.google.api.services.compute.model.AttachedDisk;
import com.google.api.services.compute.model.Autoscaler;
import com.google.api.services.compute.model.AutoscalerAggregatedList;
import com.google.api.services.compute.model.AutoscalerList;
import com.google.api.services.compute.model.BackendService;
import com.google.api.services.compute.model.BackendServiceGroupHealth;
import com.google.api.services.compute.model.BackendServiceList;
import com.google.api.services.compute.model.CacheInvalidationRule;
import com.google.api.services.compute.model.DeprecationStatus;
import com.google.api.services.compute.model.Disk;
import com.google.api.services.compute.model.DiskAggregatedList;
import com.google.api.services.compute.model.DiskList;
import com.google.api.services.compute.model.DiskMoveRequest;
import com.google.api.services.compute.model.DiskType;
import com.google.api.services.compute.model.DiskTypeAggregatedList;
import com.google.api.services.compute.model.DiskTypeList;
import com.google.api.services.compute.model.DisksResizeRequest;
import com.google.api.services.compute.model.Firewall;
import com.google.api.services.compute.model.FirewallList;
import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.ForwardingRuleAggregatedList;
import com.google.api.services.compute.model.ForwardingRuleList;
import com.google.api.services.compute.model.HttpHealthCheck;
import com.google.api.services.compute.model.HttpHealthCheckList;
import com.google.api.services.compute.model.HttpsHealthCheck;
import com.google.api.services.compute.model.HttpsHealthCheckList;
import com.google.api.services.compute.model.Image;
import com.google.api.services.compute.model.ImageList;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceAggregatedList;
import com.google.api.services.compute.model.InstanceGroup;
import com.google.api.services.compute.model.InstanceGroupAggregatedList;
import com.google.api.services.compute.model.InstanceGroupList;
import com.google.api.services.compute.model.InstanceGroupManager;
import com.google.api.services.compute.model.InstanceGroupManagerAggregatedList;
import com.google.api.services.compute.model.InstanceGroupManagerList;
import com.google.api.services.compute.model.InstanceGroupManagersAbandonInstancesRequest;
import com.google.api.services.compute.model.InstanceGroupManagersDeleteInstancesRequest;
import com.google.api.services.compute.model.InstanceGroupManagersListManagedInstancesResponse;
import com.google.api.services.compute.model.InstanceGroupManagersRecreateInstancesRequest;
import com.google.api.services.compute.model.InstanceGroupManagersSetInstanceTemplateRequest;
import com.google.api.services.compute.model.InstanceGroupManagersSetTargetPoolsRequest;
import com.google.api.services.compute.model.InstanceGroupsAddInstancesRequest;
import com.google.api.services.compute.model.InstanceGroupsListInstances;
import com.google.api.services.compute.model.InstanceGroupsListInstancesRequest;
import com.google.api.services.compute.model.InstanceGroupsRemoveInstancesRequest;
import com.google.api.services.compute.model.InstanceGroupsSetNamedPortsRequest;
import com.google.api.services.compute.model.InstanceList;
import com.google.api.services.compute.model.InstanceMoveRequest;
import com.google.api.services.compute.model.InstanceReference;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.InstanceTemplateList;
import com.google.api.services.compute.model.InstancesSetMachineTypeRequest;
import com.google.api.services.compute.model.InstancesStartWithEncryptionKeyRequest;
import com.google.api.services.compute.model.License;
import com.google.api.services.compute.model.MachineType;
import com.google.api.services.compute.model.MachineTypeAggregatedList;
import com.google.api.services.compute.model.MachineTypeList;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.Network;
import com.google.api.services.compute.model.NetworkList;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.OperationAggregatedList;
import com.google.api.services.compute.model.OperationList;
import com.google.api.services.compute.model.Project;
import com.google.api.services.compute.model.Region;
import com.google.api.services.compute.model.RegionList;
import com.google.api.services.compute.model.ResourceGroupReference;
import com.google.api.services.compute.model.Route;
import com.google.api.services.compute.model.RouteList;
import com.google.api.services.compute.model.Router;
import com.google.api.services.compute.model.RouterAggregatedList;
import com.google.api.services.compute.model.RouterList;
import com.google.api.services.compute.model.RouterStatusResponse;
import com.google.api.services.compute.model.RoutersPreviewResponse;
import com.google.api.services.compute.model.Scheduling;
import com.google.api.services.compute.model.SerialPortOutput;
import com.google.api.services.compute.model.Snapshot;
import com.google.api.services.compute.model.SnapshotList;
import com.google.api.services.compute.model.SslCertificate;
import com.google.api.services.compute.model.SslCertificateList;
import com.google.api.services.compute.model.Subnetwork;
import com.google.api.services.compute.model.SubnetworkAggregatedList;
import com.google.api.services.compute.model.SubnetworkList;
import com.google.api.services.compute.model.Tags;
import com.google.api.services.compute.model.TargetHttpProxy;
import com.google.api.services.compute.model.TargetHttpProxyList;
import com.google.api.services.compute.model.TargetHttpsProxiesSetSslCertificatesRequest;
import com.google.api.services.compute.model.TargetHttpsProxy;
import com.google.api.services.compute.model.TargetHttpsProxyList;
import com.google.api.services.compute.model.TargetInstance;
import com.google.api.services.compute.model.TargetInstanceAggregatedList;
import com.google.api.services.compute.model.TargetInstanceList;
import com.google.api.services.compute.model.TargetPool;
import com.google.api.services.compute.model.TargetPoolAggregatedList;
import com.google.api.services.compute.model.TargetPoolInstanceHealth;
import com.google.api.services.compute.model.TargetPoolList;
import com.google.api.services.compute.model.TargetPoolsAddHealthCheckRequest;
import com.google.api.services.compute.model.TargetPoolsAddInstanceRequest;
import com.google.api.services.compute.model.TargetPoolsRemoveHealthCheckRequest;
import com.google.api.services.compute.model.TargetPoolsRemoveInstanceRequest;
import com.google.api.services.compute.model.TargetReference;
import com.google.api.services.compute.model.TargetVpnGateway;
import com.google.api.services.compute.model.TargetVpnGatewayAggregatedList;
import com.google.api.services.compute.model.TargetVpnGatewayList;
import com.google.api.services.compute.model.UrlMap;
import com.google.api.services.compute.model.UrlMapList;
import com.google.api.services.compute.model.UrlMapReference;
import com.google.api.services.compute.model.UrlMapsValidateRequest;
import com.google.api.services.compute.model.UrlMapsValidateResponse;
import com.google.api.services.compute.model.UsageExportLocation;
import com.google.api.services.compute.model.VpnTunnel;
import com.google.api.services.compute.model.VpnTunnelAggregatedList;
import com.google.api.services.compute.model.VpnTunnelList;
import com.google.api.services.compute.model.Zone;
import com.google.api.services.compute.model.ZoneList;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compute
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "compute/v1/projects/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/compute/v1/projects/";

    public Compute(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Compute(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Addresses addresses() {
        return new Addresses();
    }

    public Autoscalers autoscalers() {
        return new Autoscalers();
    }

    public BackendServices backendServices() {
        return new BackendServices();
    }

    public DiskTypes diskTypes() {
        return new DiskTypes();
    }

    public Disks disks() {
        return new Disks();
    }

    public Firewalls firewalls() {
        return new Firewalls();
    }

    public ForwardingRules forwardingRules() {
        return new ForwardingRules();
    }

    public GlobalAddresses globalAddresses() {
        return new GlobalAddresses();
    }

    public GlobalForwardingRules globalForwardingRules() {
        return new GlobalForwardingRules();
    }

    public GlobalOperations globalOperations() {
        return new GlobalOperations();
    }

    public HttpHealthChecks httpHealthChecks() {
        return new HttpHealthChecks();
    }

    public HttpsHealthChecks httpsHealthChecks() {
        return new HttpsHealthChecks();
    }

    public Images images() {
        return new Images();
    }

    public InstanceGroupManagers instanceGroupManagers() {
        return new InstanceGroupManagers();
    }

    public InstanceGroups instanceGroups() {
        return new InstanceGroups();
    }

    public InstanceTemplates instanceTemplates() {
        return new InstanceTemplates();
    }

    public Instances instances() {
        return new Instances();
    }

    public Licenses licenses() {
        return new Licenses();
    }

    public MachineTypes machineTypes() {
        return new MachineTypes();
    }

    public Networks networks() {
        return new Networks();
    }

    public Projects projects() {
        return new Projects();
    }

    public RegionOperations regionOperations() {
        return new RegionOperations();
    }

    public Regions regions() {
        return new Regions();
    }

    public Routers routers() {
        return new Routers();
    }

    public Routes routes() {
        return new Routes();
    }

    public Snapshots snapshots() {
        return new Snapshots();
    }

    public SslCertificates sslCertificates() {
        return new SslCertificates();
    }

    public Subnetworks subnetworks() {
        return new Subnetworks();
    }

    public TargetHttpProxies targetHttpProxies() {
        return new TargetHttpProxies();
    }

    public TargetHttpsProxies targetHttpsProxies() {
        return new TargetHttpsProxies();
    }

    public TargetInstances targetInstances() {
        return new TargetInstances();
    }

    public TargetPools targetPools() {
        return new TargetPools();
    }

    public TargetVpnGateways targetVpnGateways() {
        return new TargetVpnGateways();
    }

    public UrlMaps urlMaps() {
        return new UrlMaps();
    }

    public VpnTunnels vpnTunnels() {
        return new VpnTunnels();
    }

    public ZoneOperations zoneOperations() {
        return new ZoneOperations();
    }

    public Zones zones() {
        return new Zones();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.20.0 of the Compute Engine API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Compute.DEFAULT_ROOT_URL, Compute.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Compute build() {
            return new Compute(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setComputeRequestInitializer(ComputeRequestInitializer computeRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)computeRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Zones {
        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<ZoneList> {
            private static final String REST_PATH = "{project}/zones";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, ZoneList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Zone> {
            private static final String REST_PATH = "{project}/zones/{zone}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Zone.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class ZoneOperations {
        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<OperationList> {
            private static final String REST_PATH = "{project}/zones/{zone}/operations";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, OperationList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String operation;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string3).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Get setOperation(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Void> {
            private static final String REST_PATH = "{project}/zones/{zone}/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String operation;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string3).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Delete setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Delete setOperation(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class VpnTunnels {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, VpnTunnel vpnTunnel) throws IOException {
            Insert insert = new Insert(string, string2, vpnTunnel);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<VpnTunnelList> {
            private static final String REST_PATH = "{project}/regions/{region}/vpnTunnels";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, VpnTunnelList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/vpnTunnels";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;

            protected Insert(String string, String string2, VpnTunnel vpnTunnel) {
                super(Compute.this, "POST", REST_PATH, (Object)vpnTunnel, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Insert setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<VpnTunnel> {
            private static final String REST_PATH = "{project}/regions/{region}/vpnTunnels/{vpnTunnel}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern VPN_TUNNEL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String vpnTunnel;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, VpnTunnel.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.VPN_TUNNEL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.vpnTunnel = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter vpnTunnel must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.VPN_TUNNEL_PATTERN.matcher(string3).matches(), (Object)"Parameter vpnTunnel must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getVpnTunnel() {
                return this.vpnTunnel;
            }

            public Get setVpnTunnel(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.VPN_TUNNEL_PATTERN.matcher(string).matches(), (Object)"Parameter vpnTunnel must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.vpnTunnel = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/vpnTunnels/{vpnTunnel}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern VPN_TUNNEL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String vpnTunnel;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.VPN_TUNNEL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.vpnTunnel = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter vpnTunnel must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.VPN_TUNNEL_PATTERN.matcher(string3).matches(), (Object)"Parameter vpnTunnel must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getVpnTunnel() {
                return this.vpnTunnel;
            }

            public Delete setVpnTunnel(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.VPN_TUNNEL_PATTERN.matcher(string).matches(), (Object)"Parameter vpnTunnel must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.vpnTunnel = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<VpnTunnelAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/vpnTunnels";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, VpnTunnelAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class UrlMaps {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, UrlMap urlMap) throws IOException {
            Insert insert = new Insert(string, urlMap);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public InvalidateCache invalidateCache(String string, String string2, CacheInvalidationRule cacheInvalidationRule) throws IOException {
            InvalidateCache invalidateCache = new InvalidateCache(string, string2, cacheInvalidationRule);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)invalidateCache);
            return invalidateCache;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, UrlMap urlMap) throws IOException {
            Patch patch = new Patch(string, string2, urlMap);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, UrlMap urlMap) throws IOException {
            Update update = new Update(string, string2, urlMap);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        public Validate validate(String string, String string2, UrlMapsValidateRequest urlMapsValidateRequest) throws IOException {
            Validate validate = new Validate(string, string2, urlMapsValidateRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)validate);
            return validate;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Validate
        extends ComputeRequest<UrlMapsValidateResponse> {
            private static final String REST_PATH = "{project}/global/urlMaps/{urlMap}/validate";
            private final Pattern PROJECT_PATTERN;
            private final Pattern URL_MAP_PATTERN;
            @Key
            private String project;
            @Key
            private String urlMap;

            protected Validate(String string, String string2, UrlMapsValidateRequest urlMapsValidateRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)urlMapsValidateRequest, UrlMapsValidateResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.URL_MAP_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.urlMap = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter urlMap must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(string2).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Validate setAlt(String string) {
                return (Validate)super.setAlt(string);
            }

            public Validate setFields(String string) {
                return (Validate)super.setFields(string);
            }

            public Validate setKey(String string) {
                return (Validate)super.setKey(string);
            }

            public Validate setOauthToken(String string) {
                return (Validate)super.setOauthToken(string);
            }

            public Validate setPrettyPrint(Boolean bl) {
                return (Validate)super.setPrettyPrint(bl);
            }

            public Validate setQuotaUser(String string) {
                return (Validate)super.setQuotaUser(string);
            }

            public Validate setUserIp(String string) {
                return (Validate)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Validate setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getUrlMap() {
                return this.urlMap;
            }

            public Validate setUrlMap(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(string).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.urlMap = string;
                return this;
            }

            @Override
            public Validate set(String string, Object object) {
                return (Validate)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/urlMaps/{urlMap}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern URL_MAP_PATTERN;
            @Key
            private String project;
            @Key
            private String urlMap;

            protected Update(String string, String string2, UrlMap urlMap) {
                super(Compute.this, "PUT", REST_PATH, (Object)urlMap, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.URL_MAP_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.urlMap = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter urlMap must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(string2).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getUrlMap() {
                return this.urlMap;
            }

            public Update setUrlMap(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(string).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.urlMap = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/urlMaps/{urlMap}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern URL_MAP_PATTERN;
            @Key
            private String project;
            @Key
            private String urlMap;

            protected Patch(String string, String string2, UrlMap urlMap) {
                super(Compute.this, "PATCH", REST_PATH, (Object)urlMap, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.URL_MAP_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.urlMap = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter urlMap must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(string2).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getUrlMap() {
                return this.urlMap;
            }

            public Patch setUrlMap(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(string).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.urlMap = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<UrlMapList> {
            private static final String REST_PATH = "{project}/global/urlMaps";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, UrlMapList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InvalidateCache
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/urlMaps/{urlMap}/invalidateCache";
            private final Pattern PROJECT_PATTERN;
            private final Pattern URL_MAP_PATTERN;
            @Key
            private String project;
            @Key
            private String urlMap;

            protected InvalidateCache(String string, String string2, CacheInvalidationRule cacheInvalidationRule) {
                super(Compute.this, "POST", REST_PATH, (Object)cacheInvalidationRule, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.URL_MAP_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.urlMap = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter urlMap must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(string2).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public InvalidateCache setAlt(String string) {
                return (InvalidateCache)super.setAlt(string);
            }

            public InvalidateCache setFields(String string) {
                return (InvalidateCache)super.setFields(string);
            }

            public InvalidateCache setKey(String string) {
                return (InvalidateCache)super.setKey(string);
            }

            public InvalidateCache setOauthToken(String string) {
                return (InvalidateCache)super.setOauthToken(string);
            }

            public InvalidateCache setPrettyPrint(Boolean bl) {
                return (InvalidateCache)super.setPrettyPrint(bl);
            }

            public InvalidateCache setQuotaUser(String string) {
                return (InvalidateCache)super.setQuotaUser(string);
            }

            public InvalidateCache setUserIp(String string) {
                return (InvalidateCache)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public InvalidateCache setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getUrlMap() {
                return this.urlMap;
            }

            public InvalidateCache setUrlMap(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(string).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.urlMap = string;
                return this;
            }

            @Override
            public InvalidateCache set(String string, Object object) {
                return (InvalidateCache)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/urlMaps";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, UrlMap urlMap) {
                super(Compute.this, "POST", REST_PATH, (Object)urlMap, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<UrlMap> {
            private static final String REST_PATH = "{project}/global/urlMaps/{urlMap}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern URL_MAP_PATTERN;
            @Key
            private String project;
            @Key
            private String urlMap;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, UrlMap.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.URL_MAP_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.urlMap = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter urlMap must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(string2).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getUrlMap() {
                return this.urlMap;
            }

            public Get setUrlMap(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(string).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.urlMap = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/urlMaps/{urlMap}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern URL_MAP_PATTERN;
            @Key
            private String project;
            @Key
            private String urlMap;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.URL_MAP_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.urlMap = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter urlMap must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(string2).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getUrlMap() {
                return this.urlMap;
            }

            public Delete setUrlMap(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(string).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.urlMap = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class TargetVpnGateways {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, TargetVpnGateway targetVpnGateway) throws IOException {
            Insert insert = new Insert(string, string2, targetVpnGateway);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<TargetVpnGatewayList> {
            private static final String REST_PATH = "{project}/regions/{region}/targetVpnGateways";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, TargetVpnGatewayList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/targetVpnGateways";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;

            protected Insert(String string, String string2, TargetVpnGateway targetVpnGateway) {
                super(Compute.this, "POST", REST_PATH, (Object)targetVpnGateway, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Insert setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<TargetVpnGateway> {
            private static final String REST_PATH = "{project}/regions/{region}/targetVpnGateways/{targetVpnGateway}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_VPN_GATEWAY_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetVpnGateway;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, TargetVpnGateway.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_VPN_GATEWAY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetVpnGateway = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetVpnGateway must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_VPN_GATEWAY_PATTERN.matcher(string3).matches(), (Object)"Parameter targetVpnGateway must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetVpnGateway() {
                return this.targetVpnGateway;
            }

            public Get setTargetVpnGateway(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_VPN_GATEWAY_PATTERN.matcher(string).matches(), (Object)"Parameter targetVpnGateway must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetVpnGateway = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/targetVpnGateways/{targetVpnGateway}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_VPN_GATEWAY_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetVpnGateway;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_VPN_GATEWAY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetVpnGateway = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetVpnGateway must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_VPN_GATEWAY_PATTERN.matcher(string3).matches(), (Object)"Parameter targetVpnGateway must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetVpnGateway() {
                return this.targetVpnGateway;
            }

            public Delete setTargetVpnGateway(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_VPN_GATEWAY_PATTERN.matcher(string).matches(), (Object)"Parameter targetVpnGateway must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetVpnGateway = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<TargetVpnGatewayAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/targetVpnGateways";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, TargetVpnGatewayAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class TargetPools {
        public AddHealthCheck addHealthCheck(String string, String string2, String string3, TargetPoolsAddHealthCheckRequest targetPoolsAddHealthCheckRequest) throws IOException {
            AddHealthCheck addHealthCheck = new AddHealthCheck(string, string2, string3, targetPoolsAddHealthCheckRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)addHealthCheck);
            return addHealthCheck;
        }

        public AddInstance addInstance(String string, String string2, String string3, TargetPoolsAddInstanceRequest targetPoolsAddInstanceRequest) throws IOException {
            AddInstance addInstance = new AddInstance(string, string2, string3, targetPoolsAddInstanceRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)addInstance);
            return addInstance;
        }

        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetHealth getHealth(String string, String string2, String string3, InstanceReference instanceReference) throws IOException {
            GetHealth getHealth = new GetHealth(string, string2, string3, instanceReference);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)getHealth);
            return getHealth;
        }

        public Insert insert(String string, String string2, TargetPool targetPool) throws IOException {
            Insert insert = new Insert(string, string2, targetPool);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public RemoveHealthCheck removeHealthCheck(String string, String string2, String string3, TargetPoolsRemoveHealthCheckRequest targetPoolsRemoveHealthCheckRequest) throws IOException {
            RemoveHealthCheck removeHealthCheck = new RemoveHealthCheck(string, string2, string3, targetPoolsRemoveHealthCheckRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)removeHealthCheck);
            return removeHealthCheck;
        }

        public RemoveInstance removeInstance(String string, String string2, String string3, TargetPoolsRemoveInstanceRequest targetPoolsRemoveInstanceRequest) throws IOException {
            RemoveInstance removeInstance = new RemoveInstance(string, string2, string3, targetPoolsRemoveInstanceRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)removeInstance);
            return removeInstance;
        }

        public SetBackup setBackup(String string, String string2, String string3, TargetReference targetReference) throws IOException {
            SetBackup setBackup = new SetBackup(string, string2, string3, targetReference);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setBackup);
            return setBackup;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetBackup
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/setBackup";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_POOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;
            @Key
            private Float failoverRatio;

            protected SetBackup(String string, String string2, String string3, TargetReference targetReference) {
                super(Compute.this, "POST", REST_PATH, (Object)targetReference, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_POOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(string3).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public SetBackup setAlt(String string) {
                return (SetBackup)super.setAlt(string);
            }

            public SetBackup setFields(String string) {
                return (SetBackup)super.setFields(string);
            }

            public SetBackup setKey(String string) {
                return (SetBackup)super.setKey(string);
            }

            public SetBackup setOauthToken(String string) {
                return (SetBackup)super.setOauthToken(string);
            }

            public SetBackup setPrettyPrint(Boolean bl) {
                return (SetBackup)super.setPrettyPrint(bl);
            }

            public SetBackup setQuotaUser(String string) {
                return (SetBackup)super.setQuotaUser(string);
            }

            public SetBackup setUserIp(String string) {
                return (SetBackup)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetBackup setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public SetBackup setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public SetBackup setTargetPool(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(string).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = string;
                return this;
            }

            public Float getFailoverRatio() {
                return this.failoverRatio;
            }

            public SetBackup setFailoverRatio(Float f) {
                this.failoverRatio = f;
                return this;
            }

            @Override
            public SetBackup set(String string, Object object) {
                return (SetBackup)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class RemoveInstance
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/removeInstance";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_POOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;

            protected RemoveInstance(String string, String string2, String string3, TargetPoolsRemoveInstanceRequest targetPoolsRemoveInstanceRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)targetPoolsRemoveInstanceRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_POOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(string3).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public RemoveInstance setAlt(String string) {
                return (RemoveInstance)super.setAlt(string);
            }

            public RemoveInstance setFields(String string) {
                return (RemoveInstance)super.setFields(string);
            }

            public RemoveInstance setKey(String string) {
                return (RemoveInstance)super.setKey(string);
            }

            public RemoveInstance setOauthToken(String string) {
                return (RemoveInstance)super.setOauthToken(string);
            }

            public RemoveInstance setPrettyPrint(Boolean bl) {
                return (RemoveInstance)super.setPrettyPrint(bl);
            }

            public RemoveInstance setQuotaUser(String string) {
                return (RemoveInstance)super.setQuotaUser(string);
            }

            public RemoveInstance setUserIp(String string) {
                return (RemoveInstance)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public RemoveInstance setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public RemoveInstance setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public RemoveInstance setTargetPool(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(string).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = string;
                return this;
            }

            @Override
            public RemoveInstance set(String string, Object object) {
                return (RemoveInstance)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class RemoveHealthCheck
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/removeHealthCheck";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_POOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;

            protected RemoveHealthCheck(String string, String string2, String string3, TargetPoolsRemoveHealthCheckRequest targetPoolsRemoveHealthCheckRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)targetPoolsRemoveHealthCheckRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_POOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(string3).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public RemoveHealthCheck setAlt(String string) {
                return (RemoveHealthCheck)super.setAlt(string);
            }

            public RemoveHealthCheck setFields(String string) {
                return (RemoveHealthCheck)super.setFields(string);
            }

            public RemoveHealthCheck setKey(String string) {
                return (RemoveHealthCheck)super.setKey(string);
            }

            public RemoveHealthCheck setOauthToken(String string) {
                return (RemoveHealthCheck)super.setOauthToken(string);
            }

            public RemoveHealthCheck setPrettyPrint(Boolean bl) {
                return (RemoveHealthCheck)super.setPrettyPrint(bl);
            }

            public RemoveHealthCheck setQuotaUser(String string) {
                return (RemoveHealthCheck)super.setQuotaUser(string);
            }

            public RemoveHealthCheck setUserIp(String string) {
                return (RemoveHealthCheck)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public RemoveHealthCheck setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public RemoveHealthCheck setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public RemoveHealthCheck setTargetPool(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(string).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = string;
                return this;
            }

            @Override
            public RemoveHealthCheck set(String string, Object object) {
                return (RemoveHealthCheck)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<TargetPoolList> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, TargetPoolList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;

            protected Insert(String string, String string2, TargetPool targetPool) {
                super(Compute.this, "POST", REST_PATH, (Object)targetPool, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Insert setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetHealth
        extends ComputeRequest<TargetPoolInstanceHealth> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/getHealth";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_POOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;

            protected GetHealth(String string, String string2, String string3, InstanceReference instanceReference) {
                super(Compute.this, "POST", REST_PATH, (Object)instanceReference, TargetPoolInstanceHealth.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_POOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(string3).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public GetHealth setAlt(String string) {
                return (GetHealth)super.setAlt(string);
            }

            public GetHealth setFields(String string) {
                return (GetHealth)super.setFields(string);
            }

            public GetHealth setKey(String string) {
                return (GetHealth)super.setKey(string);
            }

            public GetHealth setOauthToken(String string) {
                return (GetHealth)super.setOauthToken(string);
            }

            public GetHealth setPrettyPrint(Boolean bl) {
                return (GetHealth)super.setPrettyPrint(bl);
            }

            public GetHealth setQuotaUser(String string) {
                return (GetHealth)super.setQuotaUser(string);
            }

            public GetHealth setUserIp(String string) {
                return (GetHealth)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public GetHealth setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public GetHealth setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public GetHealth setTargetPool(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(string).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = string;
                return this;
            }

            @Override
            public GetHealth set(String string, Object object) {
                return (GetHealth)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<TargetPool> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_POOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, TargetPool.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_POOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(string3).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public Get setTargetPool(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(string).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_POOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_POOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(string3).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public Delete setTargetPool(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(string).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<TargetPoolAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/targetPools";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, TargetPoolAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AddInstance
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/addInstance";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_POOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;

            protected AddInstance(String string, String string2, String string3, TargetPoolsAddInstanceRequest targetPoolsAddInstanceRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)targetPoolsAddInstanceRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_POOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(string3).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public AddInstance setAlt(String string) {
                return (AddInstance)super.setAlt(string);
            }

            public AddInstance setFields(String string) {
                return (AddInstance)super.setFields(string);
            }

            public AddInstance setKey(String string) {
                return (AddInstance)super.setKey(string);
            }

            public AddInstance setOauthToken(String string) {
                return (AddInstance)super.setOauthToken(string);
            }

            public AddInstance setPrettyPrint(Boolean bl) {
                return (AddInstance)super.setPrettyPrint(bl);
            }

            public AddInstance setQuotaUser(String string) {
                return (AddInstance)super.setQuotaUser(string);
            }

            public AddInstance setUserIp(String string) {
                return (AddInstance)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AddInstance setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public AddInstance setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public AddInstance setTargetPool(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(string).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = string;
                return this;
            }

            @Override
            public AddInstance set(String string, Object object) {
                return (AddInstance)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AddHealthCheck
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/addHealthCheck";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_POOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;

            protected AddHealthCheck(String string, String string2, String string3, TargetPoolsAddHealthCheckRequest targetPoolsAddHealthCheckRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)targetPoolsAddHealthCheckRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_POOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(string3).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public AddHealthCheck setAlt(String string) {
                return (AddHealthCheck)super.setAlt(string);
            }

            public AddHealthCheck setFields(String string) {
                return (AddHealthCheck)super.setFields(string);
            }

            public AddHealthCheck setKey(String string) {
                return (AddHealthCheck)super.setKey(string);
            }

            public AddHealthCheck setOauthToken(String string) {
                return (AddHealthCheck)super.setOauthToken(string);
            }

            public AddHealthCheck setPrettyPrint(Boolean bl) {
                return (AddHealthCheck)super.setPrettyPrint(bl);
            }

            public AddHealthCheck setQuotaUser(String string) {
                return (AddHealthCheck)super.setQuotaUser(string);
            }

            public AddHealthCheck setUserIp(String string) {
                return (AddHealthCheck)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AddHealthCheck setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public AddHealthCheck setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public AddHealthCheck setTargetPool(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(string).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = string;
                return this;
            }

            @Override
            public AddHealthCheck set(String string, Object object) {
                return (AddHealthCheck)super.set(string, object);
            }
        }
    }

    public class TargetInstances {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, TargetInstance targetInstance) throws IOException {
            Insert insert = new Insert(string, string2, targetInstance);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<TargetInstanceList> {
            private static final String REST_PATH = "{project}/zones/{zone}/targetInstances";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, TargetInstanceList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/targetInstances";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;

            protected Insert(String string, String string2, TargetInstance targetInstance) {
                super(Compute.this, "POST", REST_PATH, (Object)targetInstance, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Insert setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<TargetInstance> {
            private static final String REST_PATH = "{project}/zones/{zone}/targetInstances/{targetInstance}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern TARGET_INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String targetInstance;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, TargetInstance.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetInstance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetInstance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter targetInstance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getTargetInstance() {
                return this.targetInstance;
            }

            public Get setTargetInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter targetInstance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetInstance = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/targetInstances/{targetInstance}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern TARGET_INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String targetInstance;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetInstance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetInstance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter targetInstance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Delete setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getTargetInstance() {
                return this.targetInstance;
            }

            public Delete setTargetInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter targetInstance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetInstance = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<TargetInstanceAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/targetInstances";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, TargetInstanceAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class TargetHttpsProxies {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, TargetHttpsProxy targetHttpsProxy) throws IOException {
            Insert insert = new Insert(string, targetHttpsProxy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public SetSslCertificates setSslCertificates(String string, String string2, TargetHttpsProxiesSetSslCertificatesRequest targetHttpsProxiesSetSslCertificatesRequest) throws IOException {
            SetSslCertificates setSslCertificates = new SetSslCertificates(string, string2, targetHttpsProxiesSetSslCertificatesRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setSslCertificates);
            return setSslCertificates;
        }

        public SetUrlMap setUrlMap(String string, String string2, UrlMapReference urlMapReference) throws IOException {
            SetUrlMap setUrlMap = new SetUrlMap(string, string2, urlMapReference);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setUrlMap);
            return setUrlMap;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetUrlMap
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/targetHttpsProxies/{targetHttpsProxy}/setUrlMap";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_HTTPS_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpsProxy;

            protected SetUrlMap(String string, String string2, UrlMapReference urlMapReference) {
                super(Compute.this, "POST", REST_PATH, (Object)urlMapReference, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_HTTPS_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpsProxy = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter targetHttpsProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(string2).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public SetUrlMap setAlt(String string) {
                return (SetUrlMap)super.setAlt(string);
            }

            public SetUrlMap setFields(String string) {
                return (SetUrlMap)super.setFields(string);
            }

            public SetUrlMap setKey(String string) {
                return (SetUrlMap)super.setKey(string);
            }

            public SetUrlMap setOauthToken(String string) {
                return (SetUrlMap)super.setOauthToken(string);
            }

            public SetUrlMap setPrettyPrint(Boolean bl) {
                return (SetUrlMap)super.setPrettyPrint(bl);
            }

            public SetUrlMap setQuotaUser(String string) {
                return (SetUrlMap)super.setQuotaUser(string);
            }

            public SetUrlMap setUserIp(String string) {
                return (SetUrlMap)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetUrlMap setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getTargetHttpsProxy() {
                return this.targetHttpsProxy;
            }

            public SetUrlMap setTargetHttpsProxy(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(string).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetHttpsProxy = string;
                return this;
            }

            @Override
            public SetUrlMap set(String string, Object object) {
                return (SetUrlMap)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetSslCertificates
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/targetHttpsProxies/{targetHttpsProxy}/setSslCertificates";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_HTTPS_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpsProxy;

            protected SetSslCertificates(String string, String string2, TargetHttpsProxiesSetSslCertificatesRequest targetHttpsProxiesSetSslCertificatesRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)targetHttpsProxiesSetSslCertificatesRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_HTTPS_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpsProxy = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter targetHttpsProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(string2).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public SetSslCertificates setAlt(String string) {
                return (SetSslCertificates)super.setAlt(string);
            }

            public SetSslCertificates setFields(String string) {
                return (SetSslCertificates)super.setFields(string);
            }

            public SetSslCertificates setKey(String string) {
                return (SetSslCertificates)super.setKey(string);
            }

            public SetSslCertificates setOauthToken(String string) {
                return (SetSslCertificates)super.setOauthToken(string);
            }

            public SetSslCertificates setPrettyPrint(Boolean bl) {
                return (SetSslCertificates)super.setPrettyPrint(bl);
            }

            public SetSslCertificates setQuotaUser(String string) {
                return (SetSslCertificates)super.setQuotaUser(string);
            }

            public SetSslCertificates setUserIp(String string) {
                return (SetSslCertificates)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetSslCertificates setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getTargetHttpsProxy() {
                return this.targetHttpsProxy;
            }

            public SetSslCertificates setTargetHttpsProxy(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(string).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetHttpsProxy = string;
                return this;
            }

            @Override
            public SetSslCertificates set(String string, Object object) {
                return (SetSslCertificates)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<TargetHttpsProxyList> {
            private static final String REST_PATH = "{project}/global/targetHttpsProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, TargetHttpsProxyList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/targetHttpsProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, TargetHttpsProxy targetHttpsProxy) {
                super(Compute.this, "POST", REST_PATH, (Object)targetHttpsProxy, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<TargetHttpsProxy> {
            private static final String REST_PATH = "{project}/global/targetHttpsProxies/{targetHttpsProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_HTTPS_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpsProxy;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, TargetHttpsProxy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_HTTPS_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpsProxy = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter targetHttpsProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(string2).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getTargetHttpsProxy() {
                return this.targetHttpsProxy;
            }

            public Get setTargetHttpsProxy(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(string).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetHttpsProxy = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/targetHttpsProxies/{targetHttpsProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_HTTPS_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpsProxy;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_HTTPS_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpsProxy = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter targetHttpsProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(string2).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getTargetHttpsProxy() {
                return this.targetHttpsProxy;
            }

            public Delete setTargetHttpsProxy(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(string).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetHttpsProxy = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class TargetHttpProxies {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, TargetHttpProxy targetHttpProxy) throws IOException {
            Insert insert = new Insert(string, targetHttpProxy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public SetUrlMap setUrlMap(String string, String string2, UrlMapReference urlMapReference) throws IOException {
            SetUrlMap setUrlMap = new SetUrlMap(string, string2, urlMapReference);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setUrlMap);
            return setUrlMap;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetUrlMap
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/targetHttpProxies/{targetHttpProxy}/setUrlMap";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_HTTP_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpProxy;

            protected SetUrlMap(String string, String string2, UrlMapReference urlMapReference) {
                super(Compute.this, "POST", REST_PATH, (Object)urlMapReference, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_HTTP_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpProxy = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter targetHttpProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTP_PROXY_PATTERN.matcher(string2).matches(), (Object)"Parameter targetHttpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public SetUrlMap setAlt(String string) {
                return (SetUrlMap)super.setAlt(string);
            }

            public SetUrlMap setFields(String string) {
                return (SetUrlMap)super.setFields(string);
            }

            public SetUrlMap setKey(String string) {
                return (SetUrlMap)super.setKey(string);
            }

            public SetUrlMap setOauthToken(String string) {
                return (SetUrlMap)super.setOauthToken(string);
            }

            public SetUrlMap setPrettyPrint(Boolean bl) {
                return (SetUrlMap)super.setPrettyPrint(bl);
            }

            public SetUrlMap setQuotaUser(String string) {
                return (SetUrlMap)super.setQuotaUser(string);
            }

            public SetUrlMap setUserIp(String string) {
                return (SetUrlMap)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetUrlMap setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getTargetHttpProxy() {
                return this.targetHttpProxy;
            }

            public SetUrlMap setTargetHttpProxy(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTP_PROXY_PATTERN.matcher(string).matches(), (Object)"Parameter targetHttpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetHttpProxy = string;
                return this;
            }

            @Override
            public SetUrlMap set(String string, Object object) {
                return (SetUrlMap)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<TargetHttpProxyList> {
            private static final String REST_PATH = "{project}/global/targetHttpProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, TargetHttpProxyList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/targetHttpProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, TargetHttpProxy targetHttpProxy) {
                super(Compute.this, "POST", REST_PATH, (Object)targetHttpProxy, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<TargetHttpProxy> {
            private static final String REST_PATH = "{project}/global/targetHttpProxies/{targetHttpProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_HTTP_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpProxy;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, TargetHttpProxy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_HTTP_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpProxy = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter targetHttpProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTP_PROXY_PATTERN.matcher(string2).matches(), (Object)"Parameter targetHttpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getTargetHttpProxy() {
                return this.targetHttpProxy;
            }

            public Get setTargetHttpProxy(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTP_PROXY_PATTERN.matcher(string).matches(), (Object)"Parameter targetHttpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetHttpProxy = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/targetHttpProxies/{targetHttpProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_HTTP_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpProxy;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_HTTP_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpProxy = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter targetHttpProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTP_PROXY_PATTERN.matcher(string2).matches(), (Object)"Parameter targetHttpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getTargetHttpProxy() {
                return this.targetHttpProxy;
            }

            public Delete setTargetHttpProxy(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTP_PROXY_PATTERN.matcher(string).matches(), (Object)"Parameter targetHttpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetHttpProxy = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Subnetworks {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, Subnetwork subnetwork) throws IOException {
            Insert insert = new Insert(string, string2, subnetwork);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<SubnetworkList> {
            private static final String REST_PATH = "{project}/regions/{region}/subnetworks";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, SubnetworkList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/subnetworks";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;

            protected Insert(String string, String string2, Subnetwork subnetwork) {
                super(Compute.this, "POST", REST_PATH, (Object)subnetwork, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Insert setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Subnetwork> {
            private static final String REST_PATH = "{project}/regions/{region}/subnetworks/{subnetwork}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern SUBNETWORK_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String subnetwork;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, Subnetwork.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.SUBNETWORK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.subnetwork = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter subnetwork must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBNETWORK_PATTERN.matcher(string3).matches(), (Object)"Parameter subnetwork must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getSubnetwork() {
                return this.subnetwork;
            }

            public Get setSubnetwork(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBNETWORK_PATTERN.matcher(string).matches(), (Object)"Parameter subnetwork must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.subnetwork = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/subnetworks/{subnetwork}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern SUBNETWORK_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String subnetwork;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.SUBNETWORK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.subnetwork = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter subnetwork must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBNETWORK_PATTERN.matcher(string3).matches(), (Object)"Parameter subnetwork must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getSubnetwork() {
                return this.subnetwork;
            }

            public Delete setSubnetwork(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBNETWORK_PATTERN.matcher(string).matches(), (Object)"Parameter subnetwork must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.subnetwork = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<SubnetworkAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/subnetworks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, SubnetworkAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class SslCertificates {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, SslCertificate sslCertificate) throws IOException {
            Insert insert = new Insert(string, sslCertificate);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<SslCertificateList> {
            private static final String REST_PATH = "{project}/global/sslCertificates";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, SslCertificateList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/sslCertificates";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, SslCertificate sslCertificate) {
                super(Compute.this, "POST", REST_PATH, (Object)sslCertificate, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<SslCertificate> {
            private static final String REST_PATH = "{project}/global/sslCertificates/{sslCertificate}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SSL_CERTIFICATE_PATTERN;
            @Key
            private String project;
            @Key
            private String sslCertificate;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, SslCertificate.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SSL_CERTIFICATE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.sslCertificate = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter sslCertificate must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SSL_CERTIFICATE_PATTERN.matcher(string2).matches(), (Object)"Parameter sslCertificate must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getSslCertificate() {
                return this.sslCertificate;
            }

            public Get setSslCertificate(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SSL_CERTIFICATE_PATTERN.matcher(string).matches(), (Object)"Parameter sslCertificate must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.sslCertificate = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/sslCertificates/{sslCertificate}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SSL_CERTIFICATE_PATTERN;
            @Key
            private String project;
            @Key
            private String sslCertificate;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SSL_CERTIFICATE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.sslCertificate = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter sslCertificate must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SSL_CERTIFICATE_PATTERN.matcher(string2).matches(), (Object)"Parameter sslCertificate must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getSslCertificate() {
                return this.sslCertificate;
            }

            public Delete setSslCertificate(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SSL_CERTIFICATE_PATTERN.matcher(string).matches(), (Object)"Parameter sslCertificate must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.sslCertificate = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Snapshots {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<SnapshotList> {
            private static final String REST_PATH = "{project}/global/snapshots";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, SnapshotList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Snapshot> {
            private static final String REST_PATH = "{project}/global/snapshots/{snapshot}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SNAPSHOT_PATTERN;
            @Key
            private String project;
            @Key
            private String snapshot;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Snapshot.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SNAPSHOT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.snapshot = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter snapshot must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(string2).matches(), (Object)"Parameter snapshot must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getSnapshot() {
                return this.snapshot;
            }

            public Get setSnapshot(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(string).matches(), (Object)"Parameter snapshot must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.snapshot = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/snapshots/{snapshot}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SNAPSHOT_PATTERN;
            @Key
            private String project;
            @Key
            private String snapshot;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SNAPSHOT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.snapshot = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter snapshot must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(string2).matches(), (Object)"Parameter snapshot must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getSnapshot() {
                return this.snapshot;
            }

            public Delete setSnapshot(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(string).matches(), (Object)"Parameter snapshot must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.snapshot = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Routes {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Route route) throws IOException {
            Insert insert = new Insert(string, route);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<RouteList> {
            private static final String REST_PATH = "{project}/global/routes";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, RouteList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/routes";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, Route route) {
                super(Compute.this, "POST", REST_PATH, (Object)route, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Route> {
            private static final String REST_PATH = "{project}/global/routes/{route}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ROUTE_PATTERN;
            @Key
            private String project;
            @Key
            private String route;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Route.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ROUTE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.route = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter route must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTE_PATTERN.matcher(string2).matches(), (Object)"Parameter route must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRoute() {
                return this.route;
            }

            public Get setRoute(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTE_PATTERN.matcher(string).matches(), (Object)"Parameter route must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.route = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/routes/{route}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ROUTE_PATTERN;
            @Key
            private String project;
            @Key
            private String route;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ROUTE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.route = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter route must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTE_PATTERN.matcher(string2).matches(), (Object)"Parameter route must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRoute() {
                return this.route;
            }

            public Delete setRoute(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTE_PATTERN.matcher(string).matches(), (Object)"Parameter route must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.route = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Routers {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetRouterStatus getRouterStatus(String string, String string2, String string3) throws IOException {
            GetRouterStatus getRouterStatus = new GetRouterStatus(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)getRouterStatus);
            return getRouterStatus;
        }

        public Insert insert(String string, String string2, Router router) throws IOException {
            Insert insert = new Insert(string, string2, router);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, String string3, Router router) throws IOException {
            Patch patch = new Patch(string, string2, string3, router);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Preview preview(String string, String string2, String string3, Router router) throws IOException {
            Preview preview = new Preview(string, string2, string3, router);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)preview);
            return preview;
        }

        public Update update(String string, String string2, String string3, Router router) throws IOException {
            Update update = new Update(string, string2, string3, router);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/routers/{router}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern ROUTER_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String router;

            protected Update(String string, String string2, String string3, Router router) {
                super(Compute.this, "PUT", REST_PATH, (Object)router, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.ROUTER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.router = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter router must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTER_PATTERN.matcher(string3).matches(), (Object)"Parameter router must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Update setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getRouter() {
                return this.router;
            }

            public Update setRouter(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTER_PATTERN.matcher(string).matches(), (Object)"Parameter router must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.router = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Preview
        extends ComputeRequest<RoutersPreviewResponse> {
            private static final String REST_PATH = "{project}/regions/{region}/routers/{router}/preview";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern ROUTER_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String router;

            protected Preview(String string, String string2, String string3, Router router) {
                super(Compute.this, "POST", REST_PATH, (Object)router, RoutersPreviewResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.ROUTER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.router = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter router must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTER_PATTERN.matcher(string3).matches(), (Object)"Parameter router must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Preview setAlt(String string) {
                return (Preview)super.setAlt(string);
            }

            public Preview setFields(String string) {
                return (Preview)super.setFields(string);
            }

            public Preview setKey(String string) {
                return (Preview)super.setKey(string);
            }

            public Preview setOauthToken(String string) {
                return (Preview)super.setOauthToken(string);
            }

            public Preview setPrettyPrint(Boolean bl) {
                return (Preview)super.setPrettyPrint(bl);
            }

            public Preview setQuotaUser(String string) {
                return (Preview)super.setQuotaUser(string);
            }

            public Preview setUserIp(String string) {
                return (Preview)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Preview setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Preview setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getRouter() {
                return this.router;
            }

            public Preview setRouter(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTER_PATTERN.matcher(string).matches(), (Object)"Parameter router must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.router = string;
                return this;
            }

            @Override
            public Preview set(String string, Object object) {
                return (Preview)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/routers/{router}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern ROUTER_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String router;

            protected Patch(String string, String string2, String string3, Router router) {
                super(Compute.this, "PATCH", REST_PATH, (Object)router, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.ROUTER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.router = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter router must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTER_PATTERN.matcher(string3).matches(), (Object)"Parameter router must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Patch setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getRouter() {
                return this.router;
            }

            public Patch setRouter(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTER_PATTERN.matcher(string).matches(), (Object)"Parameter router must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.router = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<RouterList> {
            private static final String REST_PATH = "{project}/regions/{region}/routers";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, RouterList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/routers";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;

            protected Insert(String string, String string2, Router router) {
                super(Compute.this, "POST", REST_PATH, (Object)router, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Insert setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetRouterStatus
        extends ComputeRequest<RouterStatusResponse> {
            private static final String REST_PATH = "{project}/regions/{region}/routers/{router}/getRouterStatus";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern ROUTER_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String router;

            protected GetRouterStatus(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, RouterStatusResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.ROUTER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.router = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter router must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTER_PATTERN.matcher(string3).matches(), (Object)"Parameter router must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetRouterStatus setAlt(String string) {
                return (GetRouterStatus)super.setAlt(string);
            }

            public GetRouterStatus setFields(String string) {
                return (GetRouterStatus)super.setFields(string);
            }

            public GetRouterStatus setKey(String string) {
                return (GetRouterStatus)super.setKey(string);
            }

            public GetRouterStatus setOauthToken(String string) {
                return (GetRouterStatus)super.setOauthToken(string);
            }

            public GetRouterStatus setPrettyPrint(Boolean bl) {
                return (GetRouterStatus)super.setPrettyPrint(bl);
            }

            public GetRouterStatus setQuotaUser(String string) {
                return (GetRouterStatus)super.setQuotaUser(string);
            }

            public GetRouterStatus setUserIp(String string) {
                return (GetRouterStatus)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public GetRouterStatus setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public GetRouterStatus setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getRouter() {
                return this.router;
            }

            public GetRouterStatus setRouter(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTER_PATTERN.matcher(string).matches(), (Object)"Parameter router must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.router = string;
                return this;
            }

            @Override
            public GetRouterStatus set(String string, Object object) {
                return (GetRouterStatus)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Router> {
            private static final String REST_PATH = "{project}/regions/{region}/routers/{router}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern ROUTER_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String router;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, Router.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.ROUTER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.router = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter router must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTER_PATTERN.matcher(string3).matches(), (Object)"Parameter router must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getRouter() {
                return this.router;
            }

            public Get setRouter(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTER_PATTERN.matcher(string).matches(), (Object)"Parameter router must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.router = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/routers/{router}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern ROUTER_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String router;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.ROUTER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.router = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter router must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTER_PATTERN.matcher(string3).matches(), (Object)"Parameter router must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getRouter() {
                return this.router;
            }

            public Delete setRouter(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTER_PATTERN.matcher(string).matches(), (Object)"Parameter router must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.router = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<RouterAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/routers";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, RouterAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class Regions {
        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<RegionList> {
            private static final String REST_PATH = "{project}/regions";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, RegionList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Region> {
            private static final String REST_PATH = "{project}/regions/{region}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Region.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class RegionOperations {
        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<OperationList> {
            private static final String REST_PATH = "{project}/regions/{region}/operations";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, OperationList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String operation;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string3).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Get setOperation(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Void> {
            private static final String REST_PATH = "{project}/regions/{region}/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String operation;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string3).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Delete setOperation(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Projects {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public MoveDisk moveDisk(String string, DiskMoveRequest diskMoveRequest) throws IOException {
            MoveDisk moveDisk = new MoveDisk(string, diskMoveRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)moveDisk);
            return moveDisk;
        }

        public MoveInstance moveInstance(String string, InstanceMoveRequest instanceMoveRequest) throws IOException {
            MoveInstance moveInstance = new MoveInstance(string, instanceMoveRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)moveInstance);
            return moveInstance;
        }

        public SetCommonInstanceMetadata setCommonInstanceMetadata(String string, Metadata metadata) throws IOException {
            SetCommonInstanceMetadata setCommonInstanceMetadata = new SetCommonInstanceMetadata(string, metadata);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setCommonInstanceMetadata);
            return setCommonInstanceMetadata;
        }

        public SetUsageExportBucket setUsageExportBucket(String string, UsageExportLocation usageExportLocation) throws IOException {
            SetUsageExportBucket setUsageExportBucket = new SetUsageExportBucket(string, usageExportLocation);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setUsageExportBucket);
            return setUsageExportBucket;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetUsageExportBucket
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/setUsageExportBucket";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected SetUsageExportBucket(String string, UsageExportLocation usageExportLocation) {
                super(Compute.this, "POST", REST_PATH, (Object)usageExportLocation, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public SetUsageExportBucket setAlt(String string) {
                return (SetUsageExportBucket)super.setAlt(string);
            }

            public SetUsageExportBucket setFields(String string) {
                return (SetUsageExportBucket)super.setFields(string);
            }

            public SetUsageExportBucket setKey(String string) {
                return (SetUsageExportBucket)super.setKey(string);
            }

            public SetUsageExportBucket setOauthToken(String string) {
                return (SetUsageExportBucket)super.setOauthToken(string);
            }

            public SetUsageExportBucket setPrettyPrint(Boolean bl) {
                return (SetUsageExportBucket)super.setPrettyPrint(bl);
            }

            public SetUsageExportBucket setQuotaUser(String string) {
                return (SetUsageExportBucket)super.setQuotaUser(string);
            }

            public SetUsageExportBucket setUserIp(String string) {
                return (SetUsageExportBucket)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetUsageExportBucket setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public SetUsageExportBucket set(String string, Object object) {
                return (SetUsageExportBucket)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetCommonInstanceMetadata
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/setCommonInstanceMetadata";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected SetCommonInstanceMetadata(String string, Metadata metadata) {
                super(Compute.this, "POST", REST_PATH, (Object)metadata, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public SetCommonInstanceMetadata setAlt(String string) {
                return (SetCommonInstanceMetadata)super.setAlt(string);
            }

            public SetCommonInstanceMetadata setFields(String string) {
                return (SetCommonInstanceMetadata)super.setFields(string);
            }

            public SetCommonInstanceMetadata setKey(String string) {
                return (SetCommonInstanceMetadata)super.setKey(string);
            }

            public SetCommonInstanceMetadata setOauthToken(String string) {
                return (SetCommonInstanceMetadata)super.setOauthToken(string);
            }

            public SetCommonInstanceMetadata setPrettyPrint(Boolean bl) {
                return (SetCommonInstanceMetadata)super.setPrettyPrint(bl);
            }

            public SetCommonInstanceMetadata setQuotaUser(String string) {
                return (SetCommonInstanceMetadata)super.setQuotaUser(string);
            }

            public SetCommonInstanceMetadata setUserIp(String string) {
                return (SetCommonInstanceMetadata)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetCommonInstanceMetadata setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public SetCommonInstanceMetadata set(String string, Object object) {
                return (SetCommonInstanceMetadata)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class MoveInstance
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/moveInstance";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected MoveInstance(String string, InstanceMoveRequest instanceMoveRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)instanceMoveRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public MoveInstance setAlt(String string) {
                return (MoveInstance)super.setAlt(string);
            }

            public MoveInstance setFields(String string) {
                return (MoveInstance)super.setFields(string);
            }

            public MoveInstance setKey(String string) {
                return (MoveInstance)super.setKey(string);
            }

            public MoveInstance setOauthToken(String string) {
                return (MoveInstance)super.setOauthToken(string);
            }

            public MoveInstance setPrettyPrint(Boolean bl) {
                return (MoveInstance)super.setPrettyPrint(bl);
            }

            public MoveInstance setQuotaUser(String string) {
                return (MoveInstance)super.setQuotaUser(string);
            }

            public MoveInstance setUserIp(String string) {
                return (MoveInstance)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public MoveInstance setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public MoveInstance set(String string, Object object) {
                return (MoveInstance)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class MoveDisk
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/moveDisk";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected MoveDisk(String string, DiskMoveRequest diskMoveRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)diskMoveRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public MoveDisk setAlt(String string) {
                return (MoveDisk)super.setAlt(string);
            }

            public MoveDisk setFields(String string) {
                return (MoveDisk)super.setFields(string);
            }

            public MoveDisk setKey(String string) {
                return (MoveDisk)super.setKey(string);
            }

            public MoveDisk setOauthToken(String string) {
                return (MoveDisk)super.setOauthToken(string);
            }

            public MoveDisk setPrettyPrint(Boolean bl) {
                return (MoveDisk)super.setPrettyPrint(bl);
            }

            public MoveDisk setQuotaUser(String string) {
                return (MoveDisk)super.setQuotaUser(string);
            }

            public MoveDisk setUserIp(String string) {
                return (MoveDisk)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public MoveDisk setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public MoveDisk set(String string, Object object) {
                return (MoveDisk)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Project> {
            private static final String REST_PATH = "{project}";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Get(String string) {
                super(Compute.this, "GET", REST_PATH, null, Project.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Networks {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Network network) throws IOException {
            Insert insert = new Insert(string, network);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<NetworkList> {
            private static final String REST_PATH = "{project}/global/networks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, NetworkList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/networks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, Network network) {
                super(Compute.this, "POST", REST_PATH, (Object)network, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Network> {
            private static final String REST_PATH = "{project}/global/networks/{network}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern NETWORK_PATTERN;
            @Key
            private String project;
            @Key
            private String network;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Network.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.NETWORK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.network = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter network must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NETWORK_PATTERN.matcher(string2).matches(), (Object)"Parameter network must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getNetwork() {
                return this.network;
            }

            public Get setNetwork(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NETWORK_PATTERN.matcher(string).matches(), (Object)"Parameter network must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.network = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/networks/{network}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern NETWORK_PATTERN;
            @Key
            private String project;
            @Key
            private String network;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.NETWORK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.network = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter network must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NETWORK_PATTERN.matcher(string2).matches(), (Object)"Parameter network must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getNetwork() {
                return this.network;
            }

            public Delete setNetwork(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NETWORK_PATTERN.matcher(string).matches(), (Object)"Parameter network must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.network = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class MachineTypes {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<MachineTypeList> {
            private static final String REST_PATH = "{project}/zones/{zone}/machineTypes";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, MachineTypeList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<MachineType> {
            private static final String REST_PATH = "{project}/zones/{zone}/machineTypes/{machineType}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern MACHINE_TYPE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String machineType;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, MachineType.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.MACHINE_TYPE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.machineType = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter machineType must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MACHINE_TYPE_PATTERN.matcher(string3).matches(), (Object)"Parameter machineType must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getMachineType() {
                return this.machineType;
            }

            public Get setMachineType(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MACHINE_TYPE_PATTERN.matcher(string).matches(), (Object)"Parameter machineType must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.machineType = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<MachineTypeAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/machineTypes";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, MachineTypeAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class Licenses {
        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<License> {
            private static final String REST_PATH = "{project}/global/licenses/{license}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern LICENSE_PATTERN;
            @Key
            private String project;
            @Key
            private String license;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, License.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.LICENSE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.license = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter license must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.LICENSE_PATTERN.matcher(string2).matches(), (Object)"Parameter license must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getLicense() {
                return this.license;
            }

            public Get setLicense(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.LICENSE_PATTERN.matcher(string).matches(), (Object)"Parameter license must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.license = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Instances {
        public AddAccessConfig addAccessConfig(String string, String string2, String string3, String string4, AccessConfig accessConfig) throws IOException {
            AddAccessConfig addAccessConfig = new AddAccessConfig(string, string2, string3, string4, accessConfig);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)addAccessConfig);
            return addAccessConfig;
        }

        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public AttachDisk attachDisk(String string, String string2, String string3, AttachedDisk attachedDisk) throws IOException {
            AttachDisk attachDisk = new AttachDisk(string, string2, string3, attachedDisk);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)attachDisk);
            return attachDisk;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public DeleteAccessConfig deleteAccessConfig(String string, String string2, String string3, String string4, String string5) throws IOException {
            DeleteAccessConfig deleteAccessConfig = new DeleteAccessConfig(string, string2, string3, string4, string5);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)deleteAccessConfig);
            return deleteAccessConfig;
        }

        public DetachDisk detachDisk(String string, String string2, String string3, String string4) throws IOException {
            DetachDisk detachDisk = new DetachDisk(string, string2, string3, string4);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)detachDisk);
            return detachDisk;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetSerialPortOutput getSerialPortOutput(String string, String string2, String string3) throws IOException {
            GetSerialPortOutput getSerialPortOutput = new GetSerialPortOutput(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)getSerialPortOutput);
            return getSerialPortOutput;
        }

        public Insert insert(String string, String string2, Instance instance) throws IOException {
            Insert insert = new Insert(string, string2, instance);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Reset reset(String string, String string2, String string3) throws IOException {
            Reset reset = new Reset(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)reset);
            return reset;
        }

        public SetDiskAutoDelete setDiskAutoDelete(String string, String string2, String string3, Boolean bl, String string4) throws IOException {
            SetDiskAutoDelete setDiskAutoDelete = new SetDiskAutoDelete(string, string2, string3, bl, string4);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setDiskAutoDelete);
            return setDiskAutoDelete;
        }

        public SetMachineType setMachineType(String string, String string2, String string3, InstancesSetMachineTypeRequest instancesSetMachineTypeRequest) throws IOException {
            SetMachineType setMachineType = new SetMachineType(string, string2, string3, instancesSetMachineTypeRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setMachineType);
            return setMachineType;
        }

        public SetMetadata setMetadata(String string, String string2, String string3, Metadata metadata) throws IOException {
            SetMetadata setMetadata = new SetMetadata(string, string2, string3, metadata);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setMetadata);
            return setMetadata;
        }

        public SetScheduling setScheduling(String string, String string2, String string3, Scheduling scheduling) throws IOException {
            SetScheduling setScheduling = new SetScheduling(string, string2, string3, scheduling);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setScheduling);
            return setScheduling;
        }

        public SetTags setTags(String string, String string2, String string3, Tags tags) throws IOException {
            SetTags setTags = new SetTags(string, string2, string3, tags);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setTags);
            return setTags;
        }

        public Start start(String string, String string2, String string3) throws IOException {
            Start start = new Start(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)start);
            return start;
        }

        public StartWithEncryptionKey startWithEncryptionKey(String string, String string2, String string3, InstancesStartWithEncryptionKeyRequest instancesStartWithEncryptionKeyRequest) throws IOException {
            StartWithEncryptionKey startWithEncryptionKey = new StartWithEncryptionKey(string, string2, string3, instancesStartWithEncryptionKeyRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)startWithEncryptionKey);
            return startWithEncryptionKey;
        }

        public Stop stop(String string, String string2, String string3) throws IOException {
            Stop stop = new Stop(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)stop);
            return stop;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Stop
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/stop";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected Stop(String string, String string2, String string3) {
                super(Compute.this, "POST", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Stop setAlt(String string) {
                return (Stop)super.setAlt(string);
            }

            public Stop setFields(String string) {
                return (Stop)super.setFields(string);
            }

            public Stop setKey(String string) {
                return (Stop)super.setKey(string);
            }

            public Stop setOauthToken(String string) {
                return (Stop)super.setOauthToken(string);
            }

            public Stop setPrettyPrint(Boolean bl) {
                return (Stop)super.setPrettyPrint(bl);
            }

            public Stop setQuotaUser(String string) {
                return (Stop)super.setQuotaUser(string);
            }

            public Stop setUserIp(String string) {
                return (Stop)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Stop setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Stop setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Stop setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public Stop set(String string, Object object) {
                return (Stop)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class StartWithEncryptionKey
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/startWithEncryptionKey";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected StartWithEncryptionKey(String string, String string2, String string3, InstancesStartWithEncryptionKeyRequest instancesStartWithEncryptionKeyRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)instancesStartWithEncryptionKeyRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public StartWithEncryptionKey setAlt(String string) {
                return (StartWithEncryptionKey)super.setAlt(string);
            }

            public StartWithEncryptionKey setFields(String string) {
                return (StartWithEncryptionKey)super.setFields(string);
            }

            public StartWithEncryptionKey setKey(String string) {
                return (StartWithEncryptionKey)super.setKey(string);
            }

            public StartWithEncryptionKey setOauthToken(String string) {
                return (StartWithEncryptionKey)super.setOauthToken(string);
            }

            public StartWithEncryptionKey setPrettyPrint(Boolean bl) {
                return (StartWithEncryptionKey)super.setPrettyPrint(bl);
            }

            public StartWithEncryptionKey setQuotaUser(String string) {
                return (StartWithEncryptionKey)super.setQuotaUser(string);
            }

            public StartWithEncryptionKey setUserIp(String string) {
                return (StartWithEncryptionKey)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public StartWithEncryptionKey setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public StartWithEncryptionKey setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public StartWithEncryptionKey setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public StartWithEncryptionKey set(String string, Object object) {
                return (StartWithEncryptionKey)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Start
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/start";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected Start(String string, String string2, String string3) {
                super(Compute.this, "POST", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Start setAlt(String string) {
                return (Start)super.setAlt(string);
            }

            public Start setFields(String string) {
                return (Start)super.setFields(string);
            }

            public Start setKey(String string) {
                return (Start)super.setKey(string);
            }

            public Start setOauthToken(String string) {
                return (Start)super.setOauthToken(string);
            }

            public Start setPrettyPrint(Boolean bl) {
                return (Start)super.setPrettyPrint(bl);
            }

            public Start setQuotaUser(String string) {
                return (Start)super.setQuotaUser(string);
            }

            public Start setUserIp(String string) {
                return (Start)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Start setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Start setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Start setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public Start set(String string, Object object) {
                return (Start)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetTags
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setTags";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected SetTags(String string, String string2, String string3, Tags tags) {
                super(Compute.this, "POST", REST_PATH, (Object)tags, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public SetTags setAlt(String string) {
                return (SetTags)super.setAlt(string);
            }

            public SetTags setFields(String string) {
                return (SetTags)super.setFields(string);
            }

            public SetTags setKey(String string) {
                return (SetTags)super.setKey(string);
            }

            public SetTags setOauthToken(String string) {
                return (SetTags)super.setOauthToken(string);
            }

            public SetTags setPrettyPrint(Boolean bl) {
                return (SetTags)super.setPrettyPrint(bl);
            }

            public SetTags setQuotaUser(String string) {
                return (SetTags)super.setQuotaUser(string);
            }

            public SetTags setUserIp(String string) {
                return (SetTags)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetTags setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public SetTags setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public SetTags setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public SetTags set(String string, Object object) {
                return (SetTags)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetScheduling
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setScheduling";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected SetScheduling(String string, String string2, String string3, Scheduling scheduling) {
                super(Compute.this, "POST", REST_PATH, (Object)scheduling, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public SetScheduling setAlt(String string) {
                return (SetScheduling)super.setAlt(string);
            }

            public SetScheduling setFields(String string) {
                return (SetScheduling)super.setFields(string);
            }

            public SetScheduling setKey(String string) {
                return (SetScheduling)super.setKey(string);
            }

            public SetScheduling setOauthToken(String string) {
                return (SetScheduling)super.setOauthToken(string);
            }

            public SetScheduling setPrettyPrint(Boolean bl) {
                return (SetScheduling)super.setPrettyPrint(bl);
            }

            public SetScheduling setQuotaUser(String string) {
                return (SetScheduling)super.setQuotaUser(string);
            }

            public SetScheduling setUserIp(String string) {
                return (SetScheduling)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetScheduling setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public SetScheduling setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public SetScheduling setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public SetScheduling set(String string, Object object) {
                return (SetScheduling)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetMetadata
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setMetadata";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected SetMetadata(String string, String string2, String string3, Metadata metadata) {
                super(Compute.this, "POST", REST_PATH, (Object)metadata, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public SetMetadata setAlt(String string) {
                return (SetMetadata)super.setAlt(string);
            }

            public SetMetadata setFields(String string) {
                return (SetMetadata)super.setFields(string);
            }

            public SetMetadata setKey(String string) {
                return (SetMetadata)super.setKey(string);
            }

            public SetMetadata setOauthToken(String string) {
                return (SetMetadata)super.setOauthToken(string);
            }

            public SetMetadata setPrettyPrint(Boolean bl) {
                return (SetMetadata)super.setPrettyPrint(bl);
            }

            public SetMetadata setQuotaUser(String string) {
                return (SetMetadata)super.setQuotaUser(string);
            }

            public SetMetadata setUserIp(String string) {
                return (SetMetadata)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetMetadata setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public SetMetadata setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public SetMetadata setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public SetMetadata set(String string, Object object) {
                return (SetMetadata)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetMachineType
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setMachineType";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected SetMachineType(String string, String string2, String string3, InstancesSetMachineTypeRequest instancesSetMachineTypeRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)instancesSetMachineTypeRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public SetMachineType setAlt(String string) {
                return (SetMachineType)super.setAlt(string);
            }

            public SetMachineType setFields(String string) {
                return (SetMachineType)super.setFields(string);
            }

            public SetMachineType setKey(String string) {
                return (SetMachineType)super.setKey(string);
            }

            public SetMachineType setOauthToken(String string) {
                return (SetMachineType)super.setOauthToken(string);
            }

            public SetMachineType setPrettyPrint(Boolean bl) {
                return (SetMachineType)super.setPrettyPrint(bl);
            }

            public SetMachineType setQuotaUser(String string) {
                return (SetMachineType)super.setQuotaUser(string);
            }

            public SetMachineType setUserIp(String string) {
                return (SetMachineType)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetMachineType setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public SetMachineType setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public SetMachineType setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public SetMachineType set(String string, Object object) {
                return (SetMachineType)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetDiskAutoDelete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setDiskAutoDelete";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            private final Pattern DEVICE_NAME_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;
            @Key
            private Boolean autoDelete;
            @Key
            private String deviceName;

            protected SetDiskAutoDelete(String string, String string2, String string3, Boolean bl, String string4) {
                super(Compute.this, "POST", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.DEVICE_NAME_PATTERN = Pattern.compile("\\w[\\w.-]{0,254}");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.autoDelete = (Boolean)Preconditions.checkNotNull((Object)bl, (Object)"Required parameter autoDelete must be specified.");
                this.deviceName = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter deviceName must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEVICE_NAME_PATTERN.matcher(string4).matches(), (Object)"Parameter deviceName must conform to the pattern \\w[\\w.-]{0,254}");
                }
            }

            public SetDiskAutoDelete setAlt(String string) {
                return (SetDiskAutoDelete)super.setAlt(string);
            }

            public SetDiskAutoDelete setFields(String string) {
                return (SetDiskAutoDelete)super.setFields(string);
            }

            public SetDiskAutoDelete setKey(String string) {
                return (SetDiskAutoDelete)super.setKey(string);
            }

            public SetDiskAutoDelete setOauthToken(String string) {
                return (SetDiskAutoDelete)super.setOauthToken(string);
            }

            public SetDiskAutoDelete setPrettyPrint(Boolean bl) {
                return (SetDiskAutoDelete)super.setPrettyPrint(bl);
            }

            public SetDiskAutoDelete setQuotaUser(String string) {
                return (SetDiskAutoDelete)super.setQuotaUser(string);
            }

            public SetDiskAutoDelete setUserIp(String string) {
                return (SetDiskAutoDelete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetDiskAutoDelete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public SetDiskAutoDelete setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public SetDiskAutoDelete setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            public Boolean getAutoDelete() {
                return this.autoDelete;
            }

            public SetDiskAutoDelete setAutoDelete(Boolean bl) {
                this.autoDelete = bl;
                return this;
            }

            public String getDeviceName() {
                return this.deviceName;
            }

            public SetDiskAutoDelete setDeviceName(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEVICE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter deviceName must conform to the pattern \\w[\\w.-]{0,254}");
                }
                this.deviceName = string;
                return this;
            }

            @Override
            public SetDiskAutoDelete set(String string, Object object) {
                return (SetDiskAutoDelete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Reset
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/reset";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected Reset(String string, String string2, String string3) {
                super(Compute.this, "POST", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Reset setAlt(String string) {
                return (Reset)super.setAlt(string);
            }

            public Reset setFields(String string) {
                return (Reset)super.setFields(string);
            }

            public Reset setKey(String string) {
                return (Reset)super.setKey(string);
            }

            public Reset setOauthToken(String string) {
                return (Reset)super.setOauthToken(string);
            }

            public Reset setPrettyPrint(Boolean bl) {
                return (Reset)super.setPrettyPrint(bl);
            }

            public Reset setQuotaUser(String string) {
                return (Reset)super.setQuotaUser(string);
            }

            public Reset setUserIp(String string) {
                return (Reset)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Reset setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Reset setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Reset setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public Reset set(String string, Object object) {
                return (Reset)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<InstanceList> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, InstanceList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;

            protected Insert(String string, String string2, Instance instance) {
                super(Compute.this, "POST", REST_PATH, (Object)instance, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Insert setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetSerialPortOutput
        extends ComputeRequest<SerialPortOutput> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/serialPort";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;
            @Key
            private Integer port;

            protected GetSerialPortOutput(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, SerialPortOutput.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetSerialPortOutput setAlt(String string) {
                return (GetSerialPortOutput)super.setAlt(string);
            }

            public GetSerialPortOutput setFields(String string) {
                return (GetSerialPortOutput)super.setFields(string);
            }

            public GetSerialPortOutput setKey(String string) {
                return (GetSerialPortOutput)super.setKey(string);
            }

            public GetSerialPortOutput setOauthToken(String string) {
                return (GetSerialPortOutput)super.setOauthToken(string);
            }

            public GetSerialPortOutput setPrettyPrint(Boolean bl) {
                return (GetSerialPortOutput)super.setPrettyPrint(bl);
            }

            public GetSerialPortOutput setQuotaUser(String string) {
                return (GetSerialPortOutput)super.setQuotaUser(string);
            }

            public GetSerialPortOutput setUserIp(String string) {
                return (GetSerialPortOutput)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public GetSerialPortOutput setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public GetSerialPortOutput setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public GetSerialPortOutput setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            public Integer getPort() {
                return this.port;
            }

            public GetSerialPortOutput setPort(Integer n) {
                this.port = n;
                return this;
            }

            @Override
            public GetSerialPortOutput set(String string, Object object) {
                return (GetSerialPortOutput)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Instance> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, Instance.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Get setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class DetachDisk
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/detachDisk";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;
            @Key
            private String deviceName;

            protected DetachDisk(String string, String string2, String string3, String string4) {
                super(Compute.this, "POST", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deviceName = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter deviceName must be specified.");
            }

            public DetachDisk setAlt(String string) {
                return (DetachDisk)super.setAlt(string);
            }

            public DetachDisk setFields(String string) {
                return (DetachDisk)super.setFields(string);
            }

            public DetachDisk setKey(String string) {
                return (DetachDisk)super.setKey(string);
            }

            public DetachDisk setOauthToken(String string) {
                return (DetachDisk)super.setOauthToken(string);
            }

            public DetachDisk setPrettyPrint(Boolean bl) {
                return (DetachDisk)super.setPrettyPrint(bl);
            }

            public DetachDisk setQuotaUser(String string) {
                return (DetachDisk)super.setQuotaUser(string);
            }

            public DetachDisk setUserIp(String string) {
                return (DetachDisk)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public DetachDisk setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public DetachDisk setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public DetachDisk setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            public String getDeviceName() {
                return this.deviceName;
            }

            public DetachDisk setDeviceName(String string) {
                this.deviceName = string;
                return this;
            }

            @Override
            public DetachDisk set(String string, Object object) {
                return (DetachDisk)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class DeleteAccessConfig
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/deleteAccessConfig";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;
            @Key
            private String accessConfig;
            @Key
            private String networkInterface;

            protected DeleteAccessConfig(String string, String string2, String string3, String string4, String string5) {
                super(Compute.this, "POST", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.accessConfig = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter accessConfig must be specified.");
                this.networkInterface = (String)Preconditions.checkNotNull((Object)string5, (Object)"Required parameter networkInterface must be specified.");
            }

            public DeleteAccessConfig setAlt(String string) {
                return (DeleteAccessConfig)super.setAlt(string);
            }

            public DeleteAccessConfig setFields(String string) {
                return (DeleteAccessConfig)super.setFields(string);
            }

            public DeleteAccessConfig setKey(String string) {
                return (DeleteAccessConfig)super.setKey(string);
            }

            public DeleteAccessConfig setOauthToken(String string) {
                return (DeleteAccessConfig)super.setOauthToken(string);
            }

            public DeleteAccessConfig setPrettyPrint(Boolean bl) {
                return (DeleteAccessConfig)super.setPrettyPrint(bl);
            }

            public DeleteAccessConfig setQuotaUser(String string) {
                return (DeleteAccessConfig)super.setQuotaUser(string);
            }

            public DeleteAccessConfig setUserIp(String string) {
                return (DeleteAccessConfig)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public DeleteAccessConfig setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public DeleteAccessConfig setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public DeleteAccessConfig setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            public String getAccessConfig() {
                return this.accessConfig;
            }

            public DeleteAccessConfig setAccessConfig(String string) {
                this.accessConfig = string;
                return this;
            }

            public String getNetworkInterface() {
                return this.networkInterface;
            }

            public DeleteAccessConfig setNetworkInterface(String string) {
                this.networkInterface = string;
                return this;
            }

            @Override
            public DeleteAccessConfig set(String string, Object object) {
                return (DeleteAccessConfig)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Delete setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Delete setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AttachDisk
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/attachDisk";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected AttachDisk(String string, String string2, String string3, AttachedDisk attachedDisk) {
                super(Compute.this, "POST", REST_PATH, (Object)attachedDisk, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public AttachDisk setAlt(String string) {
                return (AttachDisk)super.setAlt(string);
            }

            public AttachDisk setFields(String string) {
                return (AttachDisk)super.setFields(string);
            }

            public AttachDisk setKey(String string) {
                return (AttachDisk)super.setKey(string);
            }

            public AttachDisk setOauthToken(String string) {
                return (AttachDisk)super.setOauthToken(string);
            }

            public AttachDisk setPrettyPrint(Boolean bl) {
                return (AttachDisk)super.setPrettyPrint(bl);
            }

            public AttachDisk setQuotaUser(String string) {
                return (AttachDisk)super.setQuotaUser(string);
            }

            public AttachDisk setUserIp(String string) {
                return (AttachDisk)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AttachDisk setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public AttachDisk setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public AttachDisk setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public AttachDisk set(String string, Object object) {
                return (AttachDisk)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<InstanceAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/instances";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, InstanceAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AddAccessConfig
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/addAccessConfig";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;
            @Key
            private String networkInterface;

            protected AddAccessConfig(String string, String string2, String string3, String string4, AccessConfig accessConfig) {
                super(Compute.this, "POST", REST_PATH, (Object)accessConfig, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.networkInterface = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter networkInterface must be specified.");
            }

            public AddAccessConfig setAlt(String string) {
                return (AddAccessConfig)super.setAlt(string);
            }

            public AddAccessConfig setFields(String string) {
                return (AddAccessConfig)super.setFields(string);
            }

            public AddAccessConfig setKey(String string) {
                return (AddAccessConfig)super.setKey(string);
            }

            public AddAccessConfig setOauthToken(String string) {
                return (AddAccessConfig)super.setOauthToken(string);
            }

            public AddAccessConfig setPrettyPrint(Boolean bl) {
                return (AddAccessConfig)super.setPrettyPrint(bl);
            }

            public AddAccessConfig setQuotaUser(String string) {
                return (AddAccessConfig)super.setQuotaUser(string);
            }

            public AddAccessConfig setUserIp(String string) {
                return (AddAccessConfig)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AddAccessConfig setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public AddAccessConfig setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public AddAccessConfig setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            public String getNetworkInterface() {
                return this.networkInterface;
            }

            public AddAccessConfig setNetworkInterface(String string) {
                this.networkInterface = string;
                return this;
            }

            @Override
            public AddAccessConfig set(String string, Object object) {
                return (AddAccessConfig)super.set(string, object);
            }
        }
    }

    public class InstanceTemplates {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, InstanceTemplate instanceTemplate) throws IOException {
            Insert insert = new Insert(string, instanceTemplate);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<InstanceTemplateList> {
            private static final String REST_PATH = "{project}/global/instanceTemplates";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, InstanceTemplateList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/instanceTemplates";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, InstanceTemplate instanceTemplate) {
                super(Compute.this, "POST", REST_PATH, (Object)instanceTemplate, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<InstanceTemplate> {
            private static final String REST_PATH = "{project}/global/instanceTemplates/{instanceTemplate}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern INSTANCE_TEMPLATE_PATTERN;
            @Key
            private String project;
            @Key
            private String instanceTemplate;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, InstanceTemplate.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.INSTANCE_TEMPLATE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.instanceTemplate = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instanceTemplate must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_TEMPLATE_PATTERN.matcher(string2).matches(), (Object)"Parameter instanceTemplate must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getInstanceTemplate() {
                return this.instanceTemplate;
            }

            public Get setInstanceTemplate(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_TEMPLATE_PATTERN.matcher(string).matches(), (Object)"Parameter instanceTemplate must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instanceTemplate = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/instanceTemplates/{instanceTemplate}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern INSTANCE_TEMPLATE_PATTERN;
            @Key
            private String project;
            @Key
            private String instanceTemplate;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.INSTANCE_TEMPLATE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.instanceTemplate = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instanceTemplate must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_TEMPLATE_PATTERN.matcher(string2).matches(), (Object)"Parameter instanceTemplate must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getInstanceTemplate() {
                return this.instanceTemplate;
            }

            public Delete setInstanceTemplate(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_TEMPLATE_PATTERN.matcher(string).matches(), (Object)"Parameter instanceTemplate must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instanceTemplate = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class InstanceGroups {
        public AddInstances addInstances(String string, String string2, String string3, InstanceGroupsAddInstancesRequest instanceGroupsAddInstancesRequest) throws IOException {
            AddInstances addInstances = new AddInstances(string, string2, string3, instanceGroupsAddInstancesRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)addInstances);
            return addInstances;
        }

        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, InstanceGroup instanceGroup) throws IOException {
            Insert insert = new Insert(string, string2, instanceGroup);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public ListInstances listInstances(String string, String string2, String string3, InstanceGroupsListInstancesRequest instanceGroupsListInstancesRequest) throws IOException {
            ListInstances listInstances = new ListInstances(string, string2, string3, instanceGroupsListInstancesRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)listInstances);
            return listInstances;
        }

        public RemoveInstances removeInstances(String string, String string2, String string3, InstanceGroupsRemoveInstancesRequest instanceGroupsRemoveInstancesRequest) throws IOException {
            RemoveInstances removeInstances = new RemoveInstances(string, string2, string3, instanceGroupsRemoveInstancesRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)removeInstances);
            return removeInstances;
        }

        public SetNamedPorts setNamedPorts(String string, String string2, String string3, InstanceGroupsSetNamedPortsRequest instanceGroupsSetNamedPortsRequest) throws IOException {
            SetNamedPorts setNamedPorts = new SetNamedPorts(string, string2, string3, instanceGroupsSetNamedPortsRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setNamedPorts);
            return setNamedPorts;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetNamedPorts
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroups/{instanceGroup}/setNamedPorts";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instanceGroup;

            protected SetNamedPorts(String string, String string2, String string3, InstanceGroupsSetNamedPortsRequest instanceGroupsSetNamedPortsRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)instanceGroupsSetNamedPortsRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                this.instanceGroup = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instanceGroup must be specified.");
            }

            public SetNamedPorts setAlt(String string) {
                return (SetNamedPorts)super.setAlt(string);
            }

            public SetNamedPorts setFields(String string) {
                return (SetNamedPorts)super.setFields(string);
            }

            public SetNamedPorts setKey(String string) {
                return (SetNamedPorts)super.setKey(string);
            }

            public SetNamedPorts setOauthToken(String string) {
                return (SetNamedPorts)super.setOauthToken(string);
            }

            public SetNamedPorts setPrettyPrint(Boolean bl) {
                return (SetNamedPorts)super.setPrettyPrint(bl);
            }

            public SetNamedPorts setQuotaUser(String string) {
                return (SetNamedPorts)super.setQuotaUser(string);
            }

            public SetNamedPorts setUserIp(String string) {
                return (SetNamedPorts)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetNamedPorts setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public SetNamedPorts setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getInstanceGroup() {
                return this.instanceGroup;
            }

            public SetNamedPorts setInstanceGroup(String string) {
                this.instanceGroup = string;
                return this;
            }

            @Override
            public SetNamedPorts set(String string, Object object) {
                return (SetNamedPorts)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class RemoveInstances
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroups/{instanceGroup}/removeInstances";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instanceGroup;

            protected RemoveInstances(String string, String string2, String string3, InstanceGroupsRemoveInstancesRequest instanceGroupsRemoveInstancesRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)instanceGroupsRemoveInstancesRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                this.instanceGroup = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instanceGroup must be specified.");
            }

            public RemoveInstances setAlt(String string) {
                return (RemoveInstances)super.setAlt(string);
            }

            public RemoveInstances setFields(String string) {
                return (RemoveInstances)super.setFields(string);
            }

            public RemoveInstances setKey(String string) {
                return (RemoveInstances)super.setKey(string);
            }

            public RemoveInstances setOauthToken(String string) {
                return (RemoveInstances)super.setOauthToken(string);
            }

            public RemoveInstances setPrettyPrint(Boolean bl) {
                return (RemoveInstances)super.setPrettyPrint(bl);
            }

            public RemoveInstances setQuotaUser(String string) {
                return (RemoveInstances)super.setQuotaUser(string);
            }

            public RemoveInstances setUserIp(String string) {
                return (RemoveInstances)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public RemoveInstances setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public RemoveInstances setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getInstanceGroup() {
                return this.instanceGroup;
            }

            public RemoveInstances setInstanceGroup(String string) {
                this.instanceGroup = string;
                return this;
            }

            @Override
            public RemoveInstances set(String string, Object object) {
                return (RemoveInstances)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListInstances
        extends ComputeRequest<InstanceGroupsListInstances> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroups/{instanceGroup}/listInstances";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instanceGroup;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected ListInstances(String string, String string2, String string3, InstanceGroupsListInstancesRequest instanceGroupsListInstancesRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)instanceGroupsListInstancesRequest, InstanceGroupsListInstances.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                this.instanceGroup = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instanceGroup must be specified.");
            }

            public ListInstances setAlt(String string) {
                return (ListInstances)super.setAlt(string);
            }

            public ListInstances setFields(String string) {
                return (ListInstances)super.setFields(string);
            }

            public ListInstances setKey(String string) {
                return (ListInstances)super.setKey(string);
            }

            public ListInstances setOauthToken(String string) {
                return (ListInstances)super.setOauthToken(string);
            }

            public ListInstances setPrettyPrint(Boolean bl) {
                return (ListInstances)super.setPrettyPrint(bl);
            }

            public ListInstances setQuotaUser(String string) {
                return (ListInstances)super.setQuotaUser(string);
            }

            public ListInstances setUserIp(String string) {
                return (ListInstances)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public ListInstances setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public ListInstances setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getInstanceGroup() {
                return this.instanceGroup;
            }

            public ListInstances setInstanceGroup(String string) {
                this.instanceGroup = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public ListInstances setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public ListInstances setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListInstances setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public ListInstances set(String string, Object object) {
                return (ListInstances)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<InstanceGroupList> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroups";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, InstanceGroupList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroups";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;

            protected Insert(String string, String string2, InstanceGroup instanceGroup) {
                super(Compute.this, "POST", REST_PATH, (Object)instanceGroup, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Insert setZone(String string) {
                this.zone = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<InstanceGroup> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroups/{instanceGroup}";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instanceGroup;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, InstanceGroup.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                this.instanceGroup = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instanceGroup must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getInstanceGroup() {
                return this.instanceGroup;
            }

            public Get setInstanceGroup(String string) {
                this.instanceGroup = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroups/{instanceGroup}";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instanceGroup;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                this.instanceGroup = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instanceGroup must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Delete setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getInstanceGroup() {
                return this.instanceGroup;
            }

            public Delete setInstanceGroup(String string) {
                this.instanceGroup = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<InstanceGroupAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/instanceGroups";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, InstanceGroupAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AddInstances
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroups/{instanceGroup}/addInstances";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instanceGroup;

            protected AddInstances(String string, String string2, String string3, InstanceGroupsAddInstancesRequest instanceGroupsAddInstancesRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)instanceGroupsAddInstancesRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                this.instanceGroup = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instanceGroup must be specified.");
            }

            public AddInstances setAlt(String string) {
                return (AddInstances)super.setAlt(string);
            }

            public AddInstances setFields(String string) {
                return (AddInstances)super.setFields(string);
            }

            public AddInstances setKey(String string) {
                return (AddInstances)super.setKey(string);
            }

            public AddInstances setOauthToken(String string) {
                return (AddInstances)super.setOauthToken(string);
            }

            public AddInstances setPrettyPrint(Boolean bl) {
                return (AddInstances)super.setPrettyPrint(bl);
            }

            public AddInstances setQuotaUser(String string) {
                return (AddInstances)super.setQuotaUser(string);
            }

            public AddInstances setUserIp(String string) {
                return (AddInstances)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AddInstances setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public AddInstances setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getInstanceGroup() {
                return this.instanceGroup;
            }

            public AddInstances setInstanceGroup(String string) {
                this.instanceGroup = string;
                return this;
            }

            @Override
            public AddInstances set(String string, Object object) {
                return (AddInstances)super.set(string, object);
            }
        }
    }

    public class InstanceGroupManagers {
        public AbandonInstances abandonInstances(String string, String string2, String string3, InstanceGroupManagersAbandonInstancesRequest instanceGroupManagersAbandonInstancesRequest) throws IOException {
            AbandonInstances abandonInstances = new AbandonInstances(string, string2, string3, instanceGroupManagersAbandonInstancesRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)abandonInstances);
            return abandonInstances;
        }

        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public DeleteInstances deleteInstances(String string, String string2, String string3, InstanceGroupManagersDeleteInstancesRequest instanceGroupManagersDeleteInstancesRequest) throws IOException {
            DeleteInstances deleteInstances = new DeleteInstances(string, string2, string3, instanceGroupManagersDeleteInstancesRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)deleteInstances);
            return deleteInstances;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, InstanceGroupManager instanceGroupManager) throws IOException {
            Insert insert = new Insert(string, string2, instanceGroupManager);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public ListManagedInstances listManagedInstances(String string, String string2, String string3) throws IOException {
            ListManagedInstances listManagedInstances = new ListManagedInstances(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)listManagedInstances);
            return listManagedInstances;
        }

        public RecreateInstances recreateInstances(String string, String string2, String string3, InstanceGroupManagersRecreateInstancesRequest instanceGroupManagersRecreateInstancesRequest) throws IOException {
            RecreateInstances recreateInstances = new RecreateInstances(string, string2, string3, instanceGroupManagersRecreateInstancesRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)recreateInstances);
            return recreateInstances;
        }

        public Resize resize(String string, String string2, String string3, Integer n) throws IOException {
            Resize resize = new Resize(string, string2, string3, n);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)resize);
            return resize;
        }

        public SetInstanceTemplate setInstanceTemplate(String string, String string2, String string3, InstanceGroupManagersSetInstanceTemplateRequest instanceGroupManagersSetInstanceTemplateRequest) throws IOException {
            SetInstanceTemplate setInstanceTemplate = new SetInstanceTemplate(string, string2, string3, instanceGroupManagersSetInstanceTemplateRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setInstanceTemplate);
            return setInstanceTemplate;
        }

        public SetTargetPools setTargetPools(String string, String string2, String string3, InstanceGroupManagersSetTargetPoolsRequest instanceGroupManagersSetTargetPoolsRequest) throws IOException {
            SetTargetPools setTargetPools = new SetTargetPools(string, string2, string3, instanceGroupManagersSetTargetPoolsRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setTargetPools);
            return setTargetPools;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetTargetPools
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/setTargetPools";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instanceGroupManager;

            protected SetTargetPools(String string, String string2, String string3, InstanceGroupManagersSetTargetPoolsRequest instanceGroupManagersSetTargetPoolsRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)instanceGroupManagersSetTargetPoolsRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                this.instanceGroupManager = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instanceGroupManager must be specified.");
            }

            public SetTargetPools setAlt(String string) {
                return (SetTargetPools)super.setAlt(string);
            }

            public SetTargetPools setFields(String string) {
                return (SetTargetPools)super.setFields(string);
            }

            public SetTargetPools setKey(String string) {
                return (SetTargetPools)super.setKey(string);
            }

            public SetTargetPools setOauthToken(String string) {
                return (SetTargetPools)super.setOauthToken(string);
            }

            public SetTargetPools setPrettyPrint(Boolean bl) {
                return (SetTargetPools)super.setPrettyPrint(bl);
            }

            public SetTargetPools setQuotaUser(String string) {
                return (SetTargetPools)super.setQuotaUser(string);
            }

            public SetTargetPools setUserIp(String string) {
                return (SetTargetPools)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetTargetPools setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public SetTargetPools setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getInstanceGroupManager() {
                return this.instanceGroupManager;
            }

            public SetTargetPools setInstanceGroupManager(String string) {
                this.instanceGroupManager = string;
                return this;
            }

            @Override
            public SetTargetPools set(String string, Object object) {
                return (SetTargetPools)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetInstanceTemplate
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/setInstanceTemplate";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instanceGroupManager;

            protected SetInstanceTemplate(String string, String string2, String string3, InstanceGroupManagersSetInstanceTemplateRequest instanceGroupManagersSetInstanceTemplateRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)instanceGroupManagersSetInstanceTemplateRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                this.instanceGroupManager = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instanceGroupManager must be specified.");
            }

            public SetInstanceTemplate setAlt(String string) {
                return (SetInstanceTemplate)super.setAlt(string);
            }

            public SetInstanceTemplate setFields(String string) {
                return (SetInstanceTemplate)super.setFields(string);
            }

            public SetInstanceTemplate setKey(String string) {
                return (SetInstanceTemplate)super.setKey(string);
            }

            public SetInstanceTemplate setOauthToken(String string) {
                return (SetInstanceTemplate)super.setOauthToken(string);
            }

            public SetInstanceTemplate setPrettyPrint(Boolean bl) {
                return (SetInstanceTemplate)super.setPrettyPrint(bl);
            }

            public SetInstanceTemplate setQuotaUser(String string) {
                return (SetInstanceTemplate)super.setQuotaUser(string);
            }

            public SetInstanceTemplate setUserIp(String string) {
                return (SetInstanceTemplate)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetInstanceTemplate setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public SetInstanceTemplate setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getInstanceGroupManager() {
                return this.instanceGroupManager;
            }

            public SetInstanceTemplate setInstanceGroupManager(String string) {
                this.instanceGroupManager = string;
                return this;
            }

            @Override
            public SetInstanceTemplate set(String string, Object object) {
                return (SetInstanceTemplate)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Resize
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resize";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instanceGroupManager;
            @Key
            private Integer size;

            protected Resize(String string, String string2, String string3, Integer n) {
                super(Compute.this, "POST", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                this.instanceGroupManager = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instanceGroupManager must be specified.");
                this.size = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter size must be specified.");
            }

            public Resize setAlt(String string) {
                return (Resize)super.setAlt(string);
            }

            public Resize setFields(String string) {
                return (Resize)super.setFields(string);
            }

            public Resize setKey(String string) {
                return (Resize)super.setKey(string);
            }

            public Resize setOauthToken(String string) {
                return (Resize)super.setOauthToken(string);
            }

            public Resize setPrettyPrint(Boolean bl) {
                return (Resize)super.setPrettyPrint(bl);
            }

            public Resize setQuotaUser(String string) {
                return (Resize)super.setQuotaUser(string);
            }

            public Resize setUserIp(String string) {
                return (Resize)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Resize setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Resize setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getInstanceGroupManager() {
                return this.instanceGroupManager;
            }

            public Resize setInstanceGroupManager(String string) {
                this.instanceGroupManager = string;
                return this;
            }

            public Integer getSize() {
                return this.size;
            }

            public Resize setSize(Integer n) {
                this.size = n;
                return this;
            }

            @Override
            public Resize set(String string, Object object) {
                return (Resize)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class RecreateInstances
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/recreateInstances";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instanceGroupManager;

            protected RecreateInstances(String string, String string2, String string3, InstanceGroupManagersRecreateInstancesRequest instanceGroupManagersRecreateInstancesRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)instanceGroupManagersRecreateInstancesRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                this.instanceGroupManager = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instanceGroupManager must be specified.");
            }

            public RecreateInstances setAlt(String string) {
                return (RecreateInstances)super.setAlt(string);
            }

            public RecreateInstances setFields(String string) {
                return (RecreateInstances)super.setFields(string);
            }

            public RecreateInstances setKey(String string) {
                return (RecreateInstances)super.setKey(string);
            }

            public RecreateInstances setOauthToken(String string) {
                return (RecreateInstances)super.setOauthToken(string);
            }

            public RecreateInstances setPrettyPrint(Boolean bl) {
                return (RecreateInstances)super.setPrettyPrint(bl);
            }

            public RecreateInstances setQuotaUser(String string) {
                return (RecreateInstances)super.setQuotaUser(string);
            }

            public RecreateInstances setUserIp(String string) {
                return (RecreateInstances)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public RecreateInstances setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public RecreateInstances setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getInstanceGroupManager() {
                return this.instanceGroupManager;
            }

            public RecreateInstances setInstanceGroupManager(String string) {
                this.instanceGroupManager = string;
                return this;
            }

            @Override
            public RecreateInstances set(String string, Object object) {
                return (RecreateInstances)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListManagedInstances
        extends ComputeRequest<InstanceGroupManagersListManagedInstancesResponse> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/listManagedInstances";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instanceGroupManager;

            protected ListManagedInstances(String string, String string2, String string3) {
                super(Compute.this, "POST", REST_PATH, null, InstanceGroupManagersListManagedInstancesResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                this.instanceGroupManager = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instanceGroupManager must be specified.");
            }

            public ListManagedInstances setAlt(String string) {
                return (ListManagedInstances)super.setAlt(string);
            }

            public ListManagedInstances setFields(String string) {
                return (ListManagedInstances)super.setFields(string);
            }

            public ListManagedInstances setKey(String string) {
                return (ListManagedInstances)super.setKey(string);
            }

            public ListManagedInstances setOauthToken(String string) {
                return (ListManagedInstances)super.setOauthToken(string);
            }

            public ListManagedInstances setPrettyPrint(Boolean bl) {
                return (ListManagedInstances)super.setPrettyPrint(bl);
            }

            public ListManagedInstances setQuotaUser(String string) {
                return (ListManagedInstances)super.setQuotaUser(string);
            }

            public ListManagedInstances setUserIp(String string) {
                return (ListManagedInstances)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public ListManagedInstances setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public ListManagedInstances setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getInstanceGroupManager() {
                return this.instanceGroupManager;
            }

            public ListManagedInstances setInstanceGroupManager(String string) {
                this.instanceGroupManager = string;
                return this;
            }

            @Override
            public ListManagedInstances set(String string, Object object) {
                return (ListManagedInstances)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<InstanceGroupManagerList> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, InstanceGroupManagerList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;

            protected Insert(String string, String string2, InstanceGroupManager instanceGroupManager) {
                super(Compute.this, "POST", REST_PATH, (Object)instanceGroupManager, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Insert setZone(String string) {
                this.zone = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<InstanceGroupManager> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instanceGroupManager;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, InstanceGroupManager.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                this.instanceGroupManager = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instanceGroupManager must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getInstanceGroupManager() {
                return this.instanceGroupManager;
            }

            public Get setInstanceGroupManager(String string) {
                this.instanceGroupManager = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class DeleteInstances
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/deleteInstances";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instanceGroupManager;

            protected DeleteInstances(String string, String string2, String string3, InstanceGroupManagersDeleteInstancesRequest instanceGroupManagersDeleteInstancesRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)instanceGroupManagersDeleteInstancesRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                this.instanceGroupManager = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instanceGroupManager must be specified.");
            }

            public DeleteInstances setAlt(String string) {
                return (DeleteInstances)super.setAlt(string);
            }

            public DeleteInstances setFields(String string) {
                return (DeleteInstances)super.setFields(string);
            }

            public DeleteInstances setKey(String string) {
                return (DeleteInstances)super.setKey(string);
            }

            public DeleteInstances setOauthToken(String string) {
                return (DeleteInstances)super.setOauthToken(string);
            }

            public DeleteInstances setPrettyPrint(Boolean bl) {
                return (DeleteInstances)super.setPrettyPrint(bl);
            }

            public DeleteInstances setQuotaUser(String string) {
                return (DeleteInstances)super.setQuotaUser(string);
            }

            public DeleteInstances setUserIp(String string) {
                return (DeleteInstances)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public DeleteInstances setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public DeleteInstances setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getInstanceGroupManager() {
                return this.instanceGroupManager;
            }

            public DeleteInstances setInstanceGroupManager(String string) {
                this.instanceGroupManager = string;
                return this;
            }

            @Override
            public DeleteInstances set(String string, Object object) {
                return (DeleteInstances)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instanceGroupManager;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                this.instanceGroupManager = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instanceGroupManager must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Delete setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getInstanceGroupManager() {
                return this.instanceGroupManager;
            }

            public Delete setInstanceGroupManager(String string) {
                this.instanceGroupManager = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<InstanceGroupManagerAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/instanceGroupManagers";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, InstanceGroupManagerAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AbandonInstances
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/abandonInstances";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instanceGroupManager;

            protected AbandonInstances(String string, String string2, String string3, InstanceGroupManagersAbandonInstancesRequest instanceGroupManagersAbandonInstancesRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)instanceGroupManagersAbandonInstancesRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                this.instanceGroupManager = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instanceGroupManager must be specified.");
            }

            public AbandonInstances setAlt(String string) {
                return (AbandonInstances)super.setAlt(string);
            }

            public AbandonInstances setFields(String string) {
                return (AbandonInstances)super.setFields(string);
            }

            public AbandonInstances setKey(String string) {
                return (AbandonInstances)super.setKey(string);
            }

            public AbandonInstances setOauthToken(String string) {
                return (AbandonInstances)super.setOauthToken(string);
            }

            public AbandonInstances setPrettyPrint(Boolean bl) {
                return (AbandonInstances)super.setPrettyPrint(bl);
            }

            public AbandonInstances setQuotaUser(String string) {
                return (AbandonInstances)super.setQuotaUser(string);
            }

            public AbandonInstances setUserIp(String string) {
                return (AbandonInstances)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AbandonInstances setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public AbandonInstances setZone(String string) {
                this.zone = string;
                return this;
            }

            public String getInstanceGroupManager() {
                return this.instanceGroupManager;
            }

            public AbandonInstances setInstanceGroupManager(String string) {
                this.instanceGroupManager = string;
                return this;
            }

            @Override
            public AbandonInstances set(String string, Object object) {
                return (AbandonInstances)super.set(string, object);
            }
        }
    }

    public class Images {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Deprecate deprecate(String string, String string2, DeprecationStatus deprecationStatus) throws IOException {
            Deprecate deprecate = new Deprecate(string, string2, deprecationStatus);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)deprecate);
            return deprecate;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetFromFamily getFromFamily(String string, String string2) throws IOException {
            GetFromFamily getFromFamily = new GetFromFamily(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)getFromFamily);
            return getFromFamily;
        }

        public Insert insert(String string, Image image) throws IOException {
            Insert insert = new Insert(string, image);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<ImageList> {
            private static final String REST_PATH = "{project}/global/images";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, ImageList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/images";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, Image image) {
                super(Compute.this, "POST", REST_PATH, (Object)image, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetFromFamily
        extends ComputeRequest<Image> {
            private static final String REST_PATH = "{project}/global/images/family/{family}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern FAMILY_PATTERN;
            @Key
            private String project;
            @Key
            private String family;

            protected GetFromFamily(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Image.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.FAMILY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.family = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter family must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FAMILY_PATTERN.matcher(string2).matches(), (Object)"Parameter family must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetFromFamily setAlt(String string) {
                return (GetFromFamily)super.setAlt(string);
            }

            public GetFromFamily setFields(String string) {
                return (GetFromFamily)super.setFields(string);
            }

            public GetFromFamily setKey(String string) {
                return (GetFromFamily)super.setKey(string);
            }

            public GetFromFamily setOauthToken(String string) {
                return (GetFromFamily)super.setOauthToken(string);
            }

            public GetFromFamily setPrettyPrint(Boolean bl) {
                return (GetFromFamily)super.setPrettyPrint(bl);
            }

            public GetFromFamily setQuotaUser(String string) {
                return (GetFromFamily)super.setQuotaUser(string);
            }

            public GetFromFamily setUserIp(String string) {
                return (GetFromFamily)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public GetFromFamily setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFamily() {
                return this.family;
            }

            public GetFromFamily setFamily(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FAMILY_PATTERN.matcher(string).matches(), (Object)"Parameter family must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.family = string;
                return this;
            }

            @Override
            public GetFromFamily set(String string, Object object) {
                return (GetFromFamily)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Image> {
            private static final String REST_PATH = "{project}/global/images/{image}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern IMAGE_PATTERN;
            @Key
            private String project;
            @Key
            private String image;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Image.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.IMAGE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.image = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter image must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IMAGE_PATTERN.matcher(string2).matches(), (Object)"Parameter image must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getImage() {
                return this.image;
            }

            public Get setImage(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IMAGE_PATTERN.matcher(string).matches(), (Object)"Parameter image must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.image = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Deprecate
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/images/{image}/deprecate";
            private final Pattern PROJECT_PATTERN;
            private final Pattern IMAGE_PATTERN;
            @Key
            private String project;
            @Key
            private String image;

            protected Deprecate(String string, String string2, DeprecationStatus deprecationStatus) {
                super(Compute.this, "POST", REST_PATH, (Object)deprecationStatus, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.IMAGE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.image = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter image must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IMAGE_PATTERN.matcher(string2).matches(), (Object)"Parameter image must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Deprecate setAlt(String string) {
                return (Deprecate)super.setAlt(string);
            }

            public Deprecate setFields(String string) {
                return (Deprecate)super.setFields(string);
            }

            public Deprecate setKey(String string) {
                return (Deprecate)super.setKey(string);
            }

            public Deprecate setOauthToken(String string) {
                return (Deprecate)super.setOauthToken(string);
            }

            public Deprecate setPrettyPrint(Boolean bl) {
                return (Deprecate)super.setPrettyPrint(bl);
            }

            public Deprecate setQuotaUser(String string) {
                return (Deprecate)super.setQuotaUser(string);
            }

            public Deprecate setUserIp(String string) {
                return (Deprecate)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Deprecate setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getImage() {
                return this.image;
            }

            public Deprecate setImage(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IMAGE_PATTERN.matcher(string).matches(), (Object)"Parameter image must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.image = string;
                return this;
            }

            @Override
            public Deprecate set(String string, Object object) {
                return (Deprecate)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/images/{image}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern IMAGE_PATTERN;
            @Key
            private String project;
            @Key
            private String image;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.IMAGE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.image = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter image must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IMAGE_PATTERN.matcher(string2).matches(), (Object)"Parameter image must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getImage() {
                return this.image;
            }

            public Delete setImage(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IMAGE_PATTERN.matcher(string).matches(), (Object)"Parameter image must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.image = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class HttpsHealthChecks {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, HttpsHealthCheck httpsHealthCheck) throws IOException {
            Insert insert = new Insert(string, httpsHealthCheck);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, HttpsHealthCheck httpsHealthCheck) throws IOException {
            Patch patch = new Patch(string, string2, httpsHealthCheck);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, HttpsHealthCheck httpsHealthCheck) throws IOException {
            Update update = new Update(string, string2, httpsHealthCheck);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/httpsHealthChecks/{httpsHealthCheck}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern HTTPS_HEALTH_CHECK_PATTERN;
            @Key
            private String project;
            @Key
            private String httpsHealthCheck;

            protected Update(String string, String string2, HttpsHealthCheck httpsHealthCheck) {
                super(Compute.this, "PUT", REST_PATH, (Object)httpsHealthCheck, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.HTTPS_HEALTH_CHECK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.httpsHealthCheck = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter httpsHealthCheck must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTPS_HEALTH_CHECK_PATTERN.matcher(string2).matches(), (Object)"Parameter httpsHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getHttpsHealthCheck() {
                return this.httpsHealthCheck;
            }

            public Update setHttpsHealthCheck(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTPS_HEALTH_CHECK_PATTERN.matcher(string).matches(), (Object)"Parameter httpsHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.httpsHealthCheck = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/httpsHealthChecks/{httpsHealthCheck}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern HTTPS_HEALTH_CHECK_PATTERN;
            @Key
            private String project;
            @Key
            private String httpsHealthCheck;

            protected Patch(String string, String string2, HttpsHealthCheck httpsHealthCheck) {
                super(Compute.this, "PATCH", REST_PATH, (Object)httpsHealthCheck, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.HTTPS_HEALTH_CHECK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.httpsHealthCheck = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter httpsHealthCheck must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTPS_HEALTH_CHECK_PATTERN.matcher(string2).matches(), (Object)"Parameter httpsHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getHttpsHealthCheck() {
                return this.httpsHealthCheck;
            }

            public Patch setHttpsHealthCheck(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTPS_HEALTH_CHECK_PATTERN.matcher(string).matches(), (Object)"Parameter httpsHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.httpsHealthCheck = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<HttpsHealthCheckList> {
            private static final String REST_PATH = "{project}/global/httpsHealthChecks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, HttpsHealthCheckList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/httpsHealthChecks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, HttpsHealthCheck httpsHealthCheck) {
                super(Compute.this, "POST", REST_PATH, (Object)httpsHealthCheck, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<HttpsHealthCheck> {
            private static final String REST_PATH = "{project}/global/httpsHealthChecks/{httpsHealthCheck}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern HTTPS_HEALTH_CHECK_PATTERN;
            @Key
            private String project;
            @Key
            private String httpsHealthCheck;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, HttpsHealthCheck.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.HTTPS_HEALTH_CHECK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.httpsHealthCheck = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter httpsHealthCheck must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTPS_HEALTH_CHECK_PATTERN.matcher(string2).matches(), (Object)"Parameter httpsHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getHttpsHealthCheck() {
                return this.httpsHealthCheck;
            }

            public Get setHttpsHealthCheck(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTPS_HEALTH_CHECK_PATTERN.matcher(string).matches(), (Object)"Parameter httpsHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.httpsHealthCheck = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/httpsHealthChecks/{httpsHealthCheck}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern HTTPS_HEALTH_CHECK_PATTERN;
            @Key
            private String project;
            @Key
            private String httpsHealthCheck;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.HTTPS_HEALTH_CHECK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.httpsHealthCheck = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter httpsHealthCheck must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTPS_HEALTH_CHECK_PATTERN.matcher(string2).matches(), (Object)"Parameter httpsHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getHttpsHealthCheck() {
                return this.httpsHealthCheck;
            }

            public Delete setHttpsHealthCheck(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTPS_HEALTH_CHECK_PATTERN.matcher(string).matches(), (Object)"Parameter httpsHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.httpsHealthCheck = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class HttpHealthChecks {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, HttpHealthCheck httpHealthCheck) throws IOException {
            Insert insert = new Insert(string, httpHealthCheck);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, HttpHealthCheck httpHealthCheck) throws IOException {
            Patch patch = new Patch(string, string2, httpHealthCheck);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, HttpHealthCheck httpHealthCheck) throws IOException {
            Update update = new Update(string, string2, httpHealthCheck);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern HTTP_HEALTH_CHECK_PATTERN;
            @Key
            private String project;
            @Key
            private String httpHealthCheck;

            protected Update(String string, String string2, HttpHealthCheck httpHealthCheck) {
                super(Compute.this, "PUT", REST_PATH, (Object)httpHealthCheck, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.HTTP_HEALTH_CHECK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.httpHealthCheck = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter httpHealthCheck must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTP_HEALTH_CHECK_PATTERN.matcher(string2).matches(), (Object)"Parameter httpHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getHttpHealthCheck() {
                return this.httpHealthCheck;
            }

            public Update setHttpHealthCheck(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTP_HEALTH_CHECK_PATTERN.matcher(string).matches(), (Object)"Parameter httpHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.httpHealthCheck = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern HTTP_HEALTH_CHECK_PATTERN;
            @Key
            private String project;
            @Key
            private String httpHealthCheck;

            protected Patch(String string, String string2, HttpHealthCheck httpHealthCheck) {
                super(Compute.this, "PATCH", REST_PATH, (Object)httpHealthCheck, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.HTTP_HEALTH_CHECK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.httpHealthCheck = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter httpHealthCheck must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTP_HEALTH_CHECK_PATTERN.matcher(string2).matches(), (Object)"Parameter httpHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getHttpHealthCheck() {
                return this.httpHealthCheck;
            }

            public Patch setHttpHealthCheck(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTP_HEALTH_CHECK_PATTERN.matcher(string).matches(), (Object)"Parameter httpHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.httpHealthCheck = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<HttpHealthCheckList> {
            private static final String REST_PATH = "{project}/global/httpHealthChecks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, HttpHealthCheckList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/httpHealthChecks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, HttpHealthCheck httpHealthCheck) {
                super(Compute.this, "POST", REST_PATH, (Object)httpHealthCheck, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<HttpHealthCheck> {
            private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern HTTP_HEALTH_CHECK_PATTERN;
            @Key
            private String project;
            @Key
            private String httpHealthCheck;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, HttpHealthCheck.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.HTTP_HEALTH_CHECK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.httpHealthCheck = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter httpHealthCheck must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTP_HEALTH_CHECK_PATTERN.matcher(string2).matches(), (Object)"Parameter httpHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getHttpHealthCheck() {
                return this.httpHealthCheck;
            }

            public Get setHttpHealthCheck(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTP_HEALTH_CHECK_PATTERN.matcher(string).matches(), (Object)"Parameter httpHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.httpHealthCheck = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern HTTP_HEALTH_CHECK_PATTERN;
            @Key
            private String project;
            @Key
            private String httpHealthCheck;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.HTTP_HEALTH_CHECK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.httpHealthCheck = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter httpHealthCheck must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTP_HEALTH_CHECK_PATTERN.matcher(string2).matches(), (Object)"Parameter httpHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getHttpHealthCheck() {
                return this.httpHealthCheck;
            }

            public Delete setHttpHealthCheck(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTP_HEALTH_CHECK_PATTERN.matcher(string).matches(), (Object)"Parameter httpHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.httpHealthCheck = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class GlobalOperations {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<OperationList> {
            private static final String REST_PATH = "{project}/global/operations";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, OperationList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String operation;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string2).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Get setOperation(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Void> {
            private static final String REST_PATH = "{project}/global/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String operation;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string2).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Delete setOperation(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<OperationAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/operations";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, OperationAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class GlobalForwardingRules {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, ForwardingRule forwardingRule) throws IOException {
            Insert insert = new Insert(string, forwardingRule);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public SetTarget setTarget(String string, String string2, TargetReference targetReference) throws IOException {
            SetTarget setTarget = new SetTarget(string, string2, targetReference);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setTarget);
            return setTarget;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetTarget
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/forwardingRules/{forwardingRule}/setTarget";
            private final Pattern PROJECT_PATTERN;
            private final Pattern FORWARDING_RULE_PATTERN;
            @Key
            private String project;
            @Key
            private String forwardingRule;

            protected SetTarget(String string, String string2, TargetReference targetReference) {
                super(Compute.this, "POST", REST_PATH, (Object)targetReference, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.FORWARDING_RULE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.forwardingRule = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter forwardingRule must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDING_RULE_PATTERN.matcher(string2).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public SetTarget setAlt(String string) {
                return (SetTarget)super.setAlt(string);
            }

            public SetTarget setFields(String string) {
                return (SetTarget)super.setFields(string);
            }

            public SetTarget setKey(String string) {
                return (SetTarget)super.setKey(string);
            }

            public SetTarget setOauthToken(String string) {
                return (SetTarget)super.setOauthToken(string);
            }

            public SetTarget setPrettyPrint(Boolean bl) {
                return (SetTarget)super.setPrettyPrint(bl);
            }

            public SetTarget setQuotaUser(String string) {
                return (SetTarget)super.setQuotaUser(string);
            }

            public SetTarget setUserIp(String string) {
                return (SetTarget)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetTarget setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getForwardingRule() {
                return this.forwardingRule;
            }

            public SetTarget setForwardingRule(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDING_RULE_PATTERN.matcher(string).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.forwardingRule = string;
                return this;
            }

            @Override
            public SetTarget set(String string, Object object) {
                return (SetTarget)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<ForwardingRuleList> {
            private static final String REST_PATH = "{project}/global/forwardingRules";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, ForwardingRuleList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/forwardingRules";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, ForwardingRule forwardingRule) {
                super(Compute.this, "POST", REST_PATH, (Object)forwardingRule, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<ForwardingRule> {
            private static final String REST_PATH = "{project}/global/forwardingRules/{forwardingRule}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern FORWARDING_RULE_PATTERN;
            @Key
            private String project;
            @Key
            private String forwardingRule;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, ForwardingRule.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.FORWARDING_RULE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.forwardingRule = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter forwardingRule must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDING_RULE_PATTERN.matcher(string2).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getForwardingRule() {
                return this.forwardingRule;
            }

            public Get setForwardingRule(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDING_RULE_PATTERN.matcher(string).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.forwardingRule = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/forwardingRules/{forwardingRule}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern FORWARDING_RULE_PATTERN;
            @Key
            private String project;
            @Key
            private String forwardingRule;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.FORWARDING_RULE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.forwardingRule = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter forwardingRule must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDING_RULE_PATTERN.matcher(string2).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getForwardingRule() {
                return this.forwardingRule;
            }

            public Delete setForwardingRule(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDING_RULE_PATTERN.matcher(string).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.forwardingRule = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class GlobalAddresses {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Address address) throws IOException {
            Insert insert = new Insert(string, address);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<AddressList> {
            private static final String REST_PATH = "{project}/global/addresses";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, AddressList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/addresses";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, Address address) {
                super(Compute.this, "POST", REST_PATH, (Object)address, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Address> {
            private static final String REST_PATH = "{project}/global/addresses/{address}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ADDRESS_PATTERN;
            @Key
            private String project;
            @Key
            private String address;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Address.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ADDRESS_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.address = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter address must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ADDRESS_PATTERN.matcher(string2).matches(), (Object)"Parameter address must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getAddress() {
                return this.address;
            }

            public Get setAddress(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ADDRESS_PATTERN.matcher(string).matches(), (Object)"Parameter address must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.address = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/addresses/{address}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ADDRESS_PATTERN;
            @Key
            private String project;
            @Key
            private String address;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ADDRESS_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.address = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter address must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ADDRESS_PATTERN.matcher(string2).matches(), (Object)"Parameter address must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getAddress() {
                return this.address;
            }

            public Delete setAddress(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ADDRESS_PATTERN.matcher(string).matches(), (Object)"Parameter address must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.address = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class ForwardingRules {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, ForwardingRule forwardingRule) throws IOException {
            Insert insert = new Insert(string, string2, forwardingRule);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public SetTarget setTarget(String string, String string2, String string3, TargetReference targetReference) throws IOException {
            SetTarget setTarget = new SetTarget(string, string2, string3, targetReference);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setTarget);
            return setTarget;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetTarget
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}/setTarget";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern FORWARDING_RULE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String forwardingRule;

            protected SetTarget(String string, String string2, String string3, TargetReference targetReference) {
                super(Compute.this, "POST", REST_PATH, (Object)targetReference, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.FORWARDING_RULE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.forwardingRule = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter forwardingRule must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDING_RULE_PATTERN.matcher(string3).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public SetTarget setAlt(String string) {
                return (SetTarget)super.setAlt(string);
            }

            public SetTarget setFields(String string) {
                return (SetTarget)super.setFields(string);
            }

            public SetTarget setKey(String string) {
                return (SetTarget)super.setKey(string);
            }

            public SetTarget setOauthToken(String string) {
                return (SetTarget)super.setOauthToken(string);
            }

            public SetTarget setPrettyPrint(Boolean bl) {
                return (SetTarget)super.setPrettyPrint(bl);
            }

            public SetTarget setQuotaUser(String string) {
                return (SetTarget)super.setQuotaUser(string);
            }

            public SetTarget setUserIp(String string) {
                return (SetTarget)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetTarget setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public SetTarget setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getForwardingRule() {
                return this.forwardingRule;
            }

            public SetTarget setForwardingRule(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDING_RULE_PATTERN.matcher(string).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.forwardingRule = string;
                return this;
            }

            @Override
            public SetTarget set(String string, Object object) {
                return (SetTarget)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<ForwardingRuleList> {
            private static final String REST_PATH = "{project}/regions/{region}/forwardingRules";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, ForwardingRuleList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/forwardingRules";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;

            protected Insert(String string, String string2, ForwardingRule forwardingRule) {
                super(Compute.this, "POST", REST_PATH, (Object)forwardingRule, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Insert setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<ForwardingRule> {
            private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern FORWARDING_RULE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String forwardingRule;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, ForwardingRule.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.FORWARDING_RULE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.forwardingRule = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter forwardingRule must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDING_RULE_PATTERN.matcher(string3).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getForwardingRule() {
                return this.forwardingRule;
            }

            public Get setForwardingRule(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDING_RULE_PATTERN.matcher(string).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.forwardingRule = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern FORWARDING_RULE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String forwardingRule;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.FORWARDING_RULE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.forwardingRule = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter forwardingRule must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDING_RULE_PATTERN.matcher(string3).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getForwardingRule() {
                return this.forwardingRule;
            }

            public Delete setForwardingRule(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDING_RULE_PATTERN.matcher(string).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.forwardingRule = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<ForwardingRuleAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/forwardingRules";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, ForwardingRuleAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class Firewalls {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Firewall firewall) throws IOException {
            Insert insert = new Insert(string, firewall);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, Firewall firewall) throws IOException {
            Patch patch = new Patch(string, string2, firewall);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, Firewall firewall) throws IOException {
            Update update = new Update(string, string2, firewall);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/firewalls/{firewall}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern FIREWALL_PATTERN;
            @Key
            private String project;
            @Key
            private String firewall;

            protected Update(String string, String string2, Firewall firewall) {
                super(Compute.this, "PUT", REST_PATH, (Object)firewall, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.FIREWALL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.firewall = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter firewall must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string2).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFirewall() {
                return this.firewall;
            }

            public Update setFirewall(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.firewall = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/firewalls/{firewall}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern FIREWALL_PATTERN;
            @Key
            private String project;
            @Key
            private String firewall;

            protected Patch(String string, String string2, Firewall firewall) {
                super(Compute.this, "PATCH", REST_PATH, (Object)firewall, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.FIREWALL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.firewall = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter firewall must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string2).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFirewall() {
                return this.firewall;
            }

            public Patch setFirewall(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.firewall = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<FirewallList> {
            private static final String REST_PATH = "{project}/global/firewalls";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, FirewallList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/firewalls";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, Firewall firewall) {
                super(Compute.this, "POST", REST_PATH, (Object)firewall, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Firewall> {
            private static final String REST_PATH = "{project}/global/firewalls/{firewall}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern FIREWALL_PATTERN;
            @Key
            private String project;
            @Key
            private String firewall;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Firewall.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.FIREWALL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.firewall = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter firewall must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string2).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFirewall() {
                return this.firewall;
            }

            public Get setFirewall(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.firewall = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/firewalls/{firewall}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern FIREWALL_PATTERN;
            @Key
            private String project;
            @Key
            private String firewall;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.FIREWALL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.firewall = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter firewall must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string2).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFirewall() {
                return this.firewall;
            }

            public Delete setFirewall(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.firewall = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Disks {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public CreateSnapshot createSnapshot(String string, String string2, String string3, Snapshot snapshot) throws IOException {
            CreateSnapshot createSnapshot = new CreateSnapshot(string, string2, string3, snapshot);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)createSnapshot);
            return createSnapshot;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, Disk disk) throws IOException {
            Insert insert = new Insert(string, string2, disk);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Resize resize(String string, String string2, String string3, DisksResizeRequest disksResizeRequest) throws IOException {
            Resize resize = new Resize(string, string2, string3, disksResizeRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)resize);
            return resize;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Resize
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}/resize";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern DISK_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String disk;

            protected Resize(String string, String string2, String string3, DisksResizeRequest disksResizeRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)disksResizeRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.DISK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.disk = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter disk must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string3).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Resize setAlt(String string) {
                return (Resize)super.setAlt(string);
            }

            public Resize setFields(String string) {
                return (Resize)super.setFields(string);
            }

            public Resize setKey(String string) {
                return (Resize)super.setKey(string);
            }

            public Resize setOauthToken(String string) {
                return (Resize)super.setOauthToken(string);
            }

            public Resize setPrettyPrint(Boolean bl) {
                return (Resize)super.setPrettyPrint(bl);
            }

            public Resize setQuotaUser(String string) {
                return (Resize)super.setQuotaUser(string);
            }

            public Resize setUserIp(String string) {
                return (Resize)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Resize setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Resize setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getDisk() {
                return this.disk;
            }

            public Resize setDisk(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.disk = string;
                return this;
            }

            @Override
            public Resize set(String string, Object object) {
                return (Resize)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<DiskList> {
            private static final String REST_PATH = "{project}/zones/{zone}/disks";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, DiskList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/disks";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String sourceImage;

            protected Insert(String string, String string2, Disk disk) {
                super(Compute.this, "POST", REST_PATH, (Object)disk, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Insert setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getSourceImage() {
                return this.sourceImage;
            }

            public Insert setSourceImage(String string) {
                this.sourceImage = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Disk> {
            private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern DISK_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String disk;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, Disk.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.DISK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.disk = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter disk must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string3).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getDisk() {
                return this.disk;
            }

            public Get setDisk(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.disk = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern DISK_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String disk;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.DISK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.disk = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter disk must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string3).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Delete setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getDisk() {
                return this.disk;
            }

            public Delete setDisk(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.disk = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class CreateSnapshot
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}/createSnapshot";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern DISK_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String disk;

            protected CreateSnapshot(String string, String string2, String string3, Snapshot snapshot) {
                super(Compute.this, "POST", REST_PATH, (Object)snapshot, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.DISK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.disk = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter disk must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string3).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public CreateSnapshot setAlt(String string) {
                return (CreateSnapshot)super.setAlt(string);
            }

            public CreateSnapshot setFields(String string) {
                return (CreateSnapshot)super.setFields(string);
            }

            public CreateSnapshot setKey(String string) {
                return (CreateSnapshot)super.setKey(string);
            }

            public CreateSnapshot setOauthToken(String string) {
                return (CreateSnapshot)super.setOauthToken(string);
            }

            public CreateSnapshot setPrettyPrint(Boolean bl) {
                return (CreateSnapshot)super.setPrettyPrint(bl);
            }

            public CreateSnapshot setQuotaUser(String string) {
                return (CreateSnapshot)super.setQuotaUser(string);
            }

            public CreateSnapshot setUserIp(String string) {
                return (CreateSnapshot)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public CreateSnapshot setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public CreateSnapshot setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getDisk() {
                return this.disk;
            }

            public CreateSnapshot setDisk(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.disk = string;
                return this;
            }

            @Override
            public CreateSnapshot set(String string, Object object) {
                return (CreateSnapshot)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<DiskAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/disks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, DiskAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class DiskTypes {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<DiskTypeList> {
            private static final String REST_PATH = "{project}/zones/{zone}/diskTypes";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, DiskTypeList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<DiskType> {
            private static final String REST_PATH = "{project}/zones/{zone}/diskTypes/{diskType}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern DISK_TYPE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String diskType;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, DiskType.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.DISK_TYPE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.diskType = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter diskType must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_TYPE_PATTERN.matcher(string3).matches(), (Object)"Parameter diskType must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getDiskType() {
                return this.diskType;
            }

            public Get setDiskType(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_TYPE_PATTERN.matcher(string).matches(), (Object)"Parameter diskType must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.diskType = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<DiskTypeAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/diskTypes";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, DiskTypeAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class BackendServices {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetHealth getHealth(String string, String string2, ResourceGroupReference resourceGroupReference) throws IOException {
            GetHealth getHealth = new GetHealth(string, string2, resourceGroupReference);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)getHealth);
            return getHealth;
        }

        public Insert insert(String string, BackendService backendService) throws IOException {
            Insert insert = new Insert(string, backendService);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, BackendService backendService) throws IOException {
            Patch patch = new Patch(string, string2, backendService);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, BackendService backendService) throws IOException {
            Update update = new Update(string, string2, backendService);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/backendServices/{backendService}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern BACKEND_SERVICE_PATTERN;
            @Key
            private String project;
            @Key
            private String backendService;

            protected Update(String string, String string2, BackendService backendService) {
                super(Compute.this, "PUT", REST_PATH, (Object)backendService, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.BACKEND_SERVICE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.backendService = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter backendService must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.BACKEND_SERVICE_PATTERN.matcher(string2).matches(), (Object)"Parameter backendService must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getBackendService() {
                return this.backendService;
            }

            public Update setBackendService(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.BACKEND_SERVICE_PATTERN.matcher(string).matches(), (Object)"Parameter backendService must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.backendService = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/backendServices/{backendService}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern BACKEND_SERVICE_PATTERN;
            @Key
            private String project;
            @Key
            private String backendService;

            protected Patch(String string, String string2, BackendService backendService) {
                super(Compute.this, "PATCH", REST_PATH, (Object)backendService, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.BACKEND_SERVICE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.backendService = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter backendService must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.BACKEND_SERVICE_PATTERN.matcher(string2).matches(), (Object)"Parameter backendService must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getBackendService() {
                return this.backendService;
            }

            public Patch setBackendService(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.BACKEND_SERVICE_PATTERN.matcher(string).matches(), (Object)"Parameter backendService must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.backendService = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<BackendServiceList> {
            private static final String REST_PATH = "{project}/global/backendServices";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, BackendServiceList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/backendServices";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, BackendService backendService) {
                super(Compute.this, "POST", REST_PATH, (Object)backendService, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetHealth
        extends ComputeRequest<BackendServiceGroupHealth> {
            private static final String REST_PATH = "{project}/global/backendServices/{backendService}/getHealth";
            private final Pattern PROJECT_PATTERN;
            private final Pattern BACKEND_SERVICE_PATTERN;
            @Key
            private String project;
            @Key
            private String backendService;

            protected GetHealth(String string, String string2, ResourceGroupReference resourceGroupReference) {
                super(Compute.this, "POST", REST_PATH, (Object)resourceGroupReference, BackendServiceGroupHealth.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.BACKEND_SERVICE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.backendService = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter backendService must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.BACKEND_SERVICE_PATTERN.matcher(string2).matches(), (Object)"Parameter backendService must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public GetHealth setAlt(String string) {
                return (GetHealth)super.setAlt(string);
            }

            public GetHealth setFields(String string) {
                return (GetHealth)super.setFields(string);
            }

            public GetHealth setKey(String string) {
                return (GetHealth)super.setKey(string);
            }

            public GetHealth setOauthToken(String string) {
                return (GetHealth)super.setOauthToken(string);
            }

            public GetHealth setPrettyPrint(Boolean bl) {
                return (GetHealth)super.setPrettyPrint(bl);
            }

            public GetHealth setQuotaUser(String string) {
                return (GetHealth)super.setQuotaUser(string);
            }

            public GetHealth setUserIp(String string) {
                return (GetHealth)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public GetHealth setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getBackendService() {
                return this.backendService;
            }

            public GetHealth setBackendService(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.BACKEND_SERVICE_PATTERN.matcher(string).matches(), (Object)"Parameter backendService must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.backendService = string;
                return this;
            }

            @Override
            public GetHealth set(String string, Object object) {
                return (GetHealth)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<BackendService> {
            private static final String REST_PATH = "{project}/global/backendServices/{backendService}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern BACKEND_SERVICE_PATTERN;
            @Key
            private String project;
            @Key
            private String backendService;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, BackendService.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.BACKEND_SERVICE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.backendService = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter backendService must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.BACKEND_SERVICE_PATTERN.matcher(string2).matches(), (Object)"Parameter backendService must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getBackendService() {
                return this.backendService;
            }

            public Get setBackendService(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.BACKEND_SERVICE_PATTERN.matcher(string).matches(), (Object)"Parameter backendService must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.backendService = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/backendServices/{backendService}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern BACKEND_SERVICE_PATTERN;
            @Key
            private String project;
            @Key
            private String backendService;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.BACKEND_SERVICE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.backendService = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter backendService must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.BACKEND_SERVICE_PATTERN.matcher(string2).matches(), (Object)"Parameter backendService must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getBackendService() {
                return this.backendService;
            }

            public Delete setBackendService(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.BACKEND_SERVICE_PATTERN.matcher(string).matches(), (Object)"Parameter backendService must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.backendService = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Autoscalers {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, Autoscaler autoscaler) throws IOException {
            Insert insert = new Insert(string, string2, autoscaler);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, String string3, Autoscaler autoscaler) throws IOException {
            Patch patch = new Patch(string, string2, string3, autoscaler);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, Autoscaler autoscaler) throws IOException {
            Update update = new Update(string, string2, autoscaler);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/autoscalers";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern AUTOSCALER_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String autoscaler;

            protected Update(String string, String string2, Autoscaler autoscaler) {
                super(Compute.this, "PUT", REST_PATH, (Object)autoscaler, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.AUTOSCALER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Update setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getAutoscaler() {
                return this.autoscaler;
            }

            public Update setAutoscaler(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.AUTOSCALER_PATTERN.matcher(string).matches(), (Object)"Parameter autoscaler must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.autoscaler = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/autoscalers";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern AUTOSCALER_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String autoscaler;

            protected Patch(String string, String string2, String string3, Autoscaler autoscaler) {
                super(Compute.this, "PATCH", REST_PATH, (Object)autoscaler, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.AUTOSCALER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.autoscaler = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter autoscaler must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.AUTOSCALER_PATTERN.matcher(string3).matches(), (Object)"Parameter autoscaler must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Patch setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getAutoscaler() {
                return this.autoscaler;
            }

            public Patch setAutoscaler(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.AUTOSCALER_PATTERN.matcher(string).matches(), (Object)"Parameter autoscaler must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.autoscaler = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<AutoscalerList> {
            private static final String REST_PATH = "{project}/zones/{zone}/autoscalers";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, AutoscalerList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/autoscalers";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;

            protected Insert(String string, String string2, Autoscaler autoscaler) {
                super(Compute.this, "POST", REST_PATH, (Object)autoscaler, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Insert setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Autoscaler> {
            private static final String REST_PATH = "{project}/zones/{zone}/autoscalers/{autoscaler}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern AUTOSCALER_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String autoscaler;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, Autoscaler.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.AUTOSCALER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.autoscaler = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter autoscaler must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.AUTOSCALER_PATTERN.matcher(string3).matches(), (Object)"Parameter autoscaler must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getAutoscaler() {
                return this.autoscaler;
            }

            public Get setAutoscaler(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.AUTOSCALER_PATTERN.matcher(string).matches(), (Object)"Parameter autoscaler must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.autoscaler = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/autoscalers/{autoscaler}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern AUTOSCALER_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String autoscaler;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.AUTOSCALER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.autoscaler = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter autoscaler must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.AUTOSCALER_PATTERN.matcher(string3).matches(), (Object)"Parameter autoscaler must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Delete setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getAutoscaler() {
                return this.autoscaler;
            }

            public Delete setAutoscaler(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.AUTOSCALER_PATTERN.matcher(string).matches(), (Object)"Parameter autoscaler must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.autoscaler = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<AutoscalerAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/autoscalers";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, AutoscalerAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class Addresses {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, Address address) throws IOException {
            Insert insert = new Insert(string, string2, address);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<AddressList> {
            private static final String REST_PATH = "{project}/regions/{region}/addresses";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, AddressList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/addresses";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;

            protected Insert(String string, String string2, Address address) {
                super(Compute.this, "POST", REST_PATH, (Object)address, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Insert setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Address> {
            private static final String REST_PATH = "{project}/regions/{region}/addresses/{address}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern ADDRESS_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String address;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, Address.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.ADDRESS_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.address = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter address must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ADDRESS_PATTERN.matcher(string3).matches(), (Object)"Parameter address must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getAddress() {
                return this.address;
            }

            public Get setAddress(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ADDRESS_PATTERN.matcher(string).matches(), (Object)"Parameter address must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.address = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/addresses/{address}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern ADDRESS_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String address;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.ADDRESS_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.address = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter address must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ADDRESS_PATTERN.matcher(string3).matches(), (Object)"Parameter address must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getAddress() {
                return this.address;
            }

            public Delete setAddress(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ADDRESS_PATTERN.matcher(string).matches(), (Object)"Parameter address must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.address = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<AddressAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/addresses";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, AddressAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {