/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-03 at 22:45:34 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for RouterBgp.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RouterBgp extends com.google.api.client.json.GenericJson {

  /**
   * Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN, either 16-bit or
   * 32-bit. The value will be fixed for this router resource. All VPN tunnels that link to this
   * router will have the same local ASN.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long asn;

  /**
   * Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN, either 16-bit or
   * 32-bit. The value will be fixed for this router resource. All VPN tunnels that link to this
   * router will have the same local ASN.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAsn() {
    return asn;
  }

  /**
   * Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN, either 16-bit or
   * 32-bit. The value will be fixed for this router resource. All VPN tunnels that link to this
   * router will have the same local ASN.
   * @param asn asn or {@code null} for none
   */
  public RouterBgp setAsn(java.lang.Long asn) {
    this.asn = asn;
    return this;
  }

  @Override
  public RouterBgp set(String fieldName, Object value) {
    return (RouterBgp) super.set(fieldName, value);
  }

  @Override
  public RouterBgp clone() {
    return (RouterBgp) super.clone();
  }

}
