/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-09-08 at 05:10:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a customer-supplied encryption key
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CustomerEncryptionKey extends com.google.api.client.json.GenericJson {

  /**
   * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either
   * encrypt or decrypt this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rawKey;

  /**
   * [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key
   * that protects this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sha256;

  /**
   * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either
   * encrypt or decrypt this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getRawKey() {
    return rawKey;
  }

  /**
   * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either
   * encrypt or decrypt this resource.
   * @param rawKey rawKey or {@code null} for none
   */
  public CustomerEncryptionKey setRawKey(java.lang.String rawKey) {
    this.rawKey = rawKey;
    return this;
  }

  /**
   * [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key
   * that protects this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSha256() {
    return sha256;
  }

  /**
   * [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key
   * that protects this resource.
   * @param sha256 sha256 or {@code null} for none
   */
  public CustomerEncryptionKey setSha256(java.lang.String sha256) {
    this.sha256 = sha256;
    return this;
  }

  @Override
  public CustomerEncryptionKey set(String fieldName, Object value) {
    return (CustomerEncryptionKey) super.set(fieldName, value);
  }

  @Override
  public CustomerEncryptionKey clone() {
    return (CustomerEncryptionKey) super.clone();
  }

}
