/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-02-14 18:40:25 UTC)
 * on 2014-03-12 at 06:55:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * An access configuration attached to an instance's network interface.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccessConfig extends com.google.api.client.json.GenericJson {

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of this access configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * An external IP address associated with this instance. Specify an unused static IP address
   * available to the project. If not specified, the external IP will be drawn from a shared
   * ephemeral pool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String natIP;

  /**
   * Type of configuration. Must be set to "ONE_TO_ONE_NAT". This configures port-for-port NAT to
   * the internet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Type of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * @param kind kind or {@code null} for none
   */
  public AccessConfig setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of this access configuration.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this access configuration.
   * @param name name or {@code null} for none
   */
  public AccessConfig setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * An external IP address associated with this instance. Specify an unused static IP address
   * available to the project. If not specified, the external IP will be drawn from a shared
   * ephemeral pool.
   * @return value or {@code null} for none
   */
  public java.lang.String getNatIP() {
    return natIP;
  }

  /**
   * An external IP address associated with this instance. Specify an unused static IP address
   * available to the project. If not specified, the external IP will be drawn from a shared
   * ephemeral pool.
   * @param natIP natIP or {@code null} for none
   */
  public AccessConfig setNatIP(java.lang.String natIP) {
    this.natIP = natIP;
    return this;
  }

  /**
   * Type of configuration. Must be set to "ONE_TO_ONE_NAT". This configures port-for-port NAT to
   * the internet.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of configuration. Must be set to "ONE_TO_ONE_NAT". This configures port-for-port NAT to
   * the internet.
   * @param type type or {@code null} for none
   */
  public AccessConfig setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public AccessConfig set(String fieldName, Object value) {
    return (AccessConfig) super.set(fieldName, value);
  }

  @Override
  public AccessConfig clone() {
    return (AccessConfig) super.clone();
  }

}
