/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2017-02-09 at 23:57:58 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroup.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroup extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The creation timestamp for this instance group in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] The fingerprint of the named ports. The system uses this fingerprint to detect
   * conflicts when multiple users change the named ports concurrently.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * [Output Only] A unique identifier for this instance group, generated by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] The resource type, which is always compute#instanceGroup for instance groups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The name of the instance group. The name must be 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Assigns a name to a port number. For example: {name: "http", port: 80}
   *
   * This allows the system to reference ports by the assigned name instead of a port number. Named
   * ports can also contain multiple ports. For example: [{name: "http", port: 80},{name: "http",
   * port: 8080}]
   *
   * Named ports apply to all instances in this instance group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NamedPort> namedPorts;

  /**
   * The URL of the network to which all instances in the instance group belong.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * The URL of the region where the instance group is located (for regional resources).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * [Output Only] The URL for this instance group. The server generates this URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] The total number of instances in the instance group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer size;

  /**
   * The URL of the subnetwork to which all instances in the instance group belong.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subnetwork;

  /**
   * [Output Only] The URL of the zone where the instance group is located (for zonal resources).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * [Output Only] The creation timestamp for this instance group in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] The creation timestamp for this instance group in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public InstanceGroup setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public InstanceGroup setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] The fingerprint of the named ports. The system uses this fingerprint to detect
   * conflicts when multiple users change the named ports concurrently.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * [Output Only] The fingerprint of the named ports. The system uses this fingerprint to detect
   * conflicts when multiple users change the named ports concurrently.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * [Output Only] The fingerprint of the named ports. The system uses this fingerprint to detect
   * conflicts when multiple users change the named ports concurrently.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public InstanceGroup setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * [Output Only] The fingerprint of the named ports. The system uses this fingerprint to detect
   * conflicts when multiple users change the named ports concurrently.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public InstanceGroup encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * [Output Only] A unique identifier for this instance group, generated by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] A unique identifier for this instance group, generated by the server.
   * @param id id or {@code null} for none
   */
  public InstanceGroup setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceGroup for instance groups.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceGroup for instance groups.
   * @param kind kind or {@code null} for none
   */
  public InstanceGroup setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The name of the instance group. The name must be 1-63 characters long, and comply with RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the instance group. The name must be 1-63 characters long, and comply with RFC1035.
   * @param name name or {@code null} for none
   */
  public InstanceGroup setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Assigns a name to a port number. For example: {name: "http", port: 80}
   *
   * This allows the system to reference ports by the assigned name instead of a port number. Named
   * ports can also contain multiple ports. For example: [{name: "http", port: 80},{name: "http",
   * port: 8080}]
   *
   * Named ports apply to all instances in this instance group.
   * @return value or {@code null} for none
   */
  public java.util.List<NamedPort> getNamedPorts() {
    return namedPorts;
  }

  /**
   * Assigns a name to a port number. For example: {name: "http", port: 80}
   *
   * This allows the system to reference ports by the assigned name instead of a port number. Named
   * ports can also contain multiple ports. For example: [{name: "http", port: 80},{name: "http",
   * port: 8080}]
   *
   * Named ports apply to all instances in this instance group.
   * @param namedPorts namedPorts or {@code null} for none
   */
  public InstanceGroup setNamedPorts(java.util.List<NamedPort> namedPorts) {
    this.namedPorts = namedPorts;
    return this;
  }

  /**
   * The URL of the network to which all instances in the instance group belong.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * The URL of the network to which all instances in the instance group belong.
   * @param network network or {@code null} for none
   */
  public InstanceGroup setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  /**
   * The URL of the region where the instance group is located (for regional resources).
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * The URL of the region where the instance group is located (for regional resources).
   * @param region region or {@code null} for none
   */
  public InstanceGroup setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * [Output Only] The URL for this instance group. The server generates this URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] The URL for this instance group. The server generates this URL.
   * @param selfLink selfLink or {@code null} for none
   */
  public InstanceGroup setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output Only] The total number of instances in the instance group.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSize() {
    return size;
  }

  /**
   * [Output Only] The total number of instances in the instance group.
   * @param size size or {@code null} for none
   */
  public InstanceGroup setSize(java.lang.Integer size) {
    this.size = size;
    return this;
  }

  /**
   * The URL of the subnetwork to which all instances in the instance group belong.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubnetwork() {
    return subnetwork;
  }

  /**
   * The URL of the subnetwork to which all instances in the instance group belong.
   * @param subnetwork subnetwork or {@code null} for none
   */
  public InstanceGroup setSubnetwork(java.lang.String subnetwork) {
    this.subnetwork = subnetwork;
    return this;
  }

  /**
   * [Output Only] The URL of the zone where the instance group is located (for zonal resources).
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * [Output Only] The URL of the zone where the instance group is located (for zonal resources).
   * @param zone zone or {@code null} for none
   */
  public InstanceGroup setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public InstanceGroup set(String fieldName, Object value) {
    return (InstanceGroup) super.set(fieldName, value);
  }

  @Override
  public InstanceGroup clone() {
    return (InstanceGroup) super.clone();
  }

}
