/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-07-24 at 21:07:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Service resource (a.k.a service project) ID.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class XpnResourceId extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the service resource. In the case of projects, this field matches the project ID
   * (e.g., my-project), not the project number (e.g., 12345678).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The type of the service resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The ID of the service resource. In the case of projects, this field matches the project ID
   * (e.g., my-project), not the project number (e.g., 12345678).
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the service resource. In the case of projects, this field matches the project ID
   * (e.g., my-project), not the project number (e.g., 12345678).
   * @param id id or {@code null} for none
   */
  public XpnResourceId setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The type of the service resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the service resource.
   * @param type type or {@code null} for none
   */
  public XpnResourceId setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public XpnResourceId set(String fieldName, Object value) {
    return (XpnResourceId) super.set(fieldName, value);
  }

  @Override
  public XpnResourceId clone() {
    return (XpnResourceId) super.clone();
  }

}
