/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-08-07 at 18:18:23 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Custom utilization metric policy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AutoscalingPolicyCustomMetricUtilization extends com.google.api.client.json.GenericJson {

  /**
   * The identifier (type) of the Stackdriver Monitoring metric. The metric cannot have negative
   * values and should be a utilization metric, which means that the number of virtual machines
   * handling requests should increase or decrease proportionally to the metric.
   *
   * The metric must have a value type of INT64 or DOUBLE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metric;

  /**
   * The target value of the metric that autoscaler should maintain. This must be a positive value.
   *
   * For example, a good metric to use as a utilization_target is
   * compute.googleapis.com/instance/network/received_bytes_count. The autoscaler will work to keep
   * this value constant for each of the instances.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double utilizationTarget;

  /**
   * Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either
   * GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE. If not specified, the default is GAUGE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String utilizationTargetType;

  /**
   * The identifier (type) of the Stackdriver Monitoring metric. The metric cannot have negative
   * values and should be a utilization metric, which means that the number of virtual machines
   * handling requests should increase or decrease proportionally to the metric.
   *
   * The metric must have a value type of INT64 or DOUBLE.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetric() {
    return metric;
  }

  /**
   * The identifier (type) of the Stackdriver Monitoring metric. The metric cannot have negative
   * values and should be a utilization metric, which means that the number of virtual machines
   * handling requests should increase or decrease proportionally to the metric.
   *
   * The metric must have a value type of INT64 or DOUBLE.
   * @param metric metric or {@code null} for none
   */
  public AutoscalingPolicyCustomMetricUtilization setMetric(java.lang.String metric) {
    this.metric = metric;
    return this;
  }

  /**
   * The target value of the metric that autoscaler should maintain. This must be a positive value.
   *
   * For example, a good metric to use as a utilization_target is
   * compute.googleapis.com/instance/network/received_bytes_count. The autoscaler will work to keep
   * this value constant for each of the instances.
   * @return value or {@code null} for none
   */
  public java.lang.Double getUtilizationTarget() {
    return utilizationTarget;
  }

  /**
   * The target value of the metric that autoscaler should maintain. This must be a positive value.
   *
   * For example, a good metric to use as a utilization_target is
   * compute.googleapis.com/instance/network/received_bytes_count. The autoscaler will work to keep
   * this value constant for each of the instances.
   * @param utilizationTarget utilizationTarget or {@code null} for none
   */
  public AutoscalingPolicyCustomMetricUtilization setUtilizationTarget(java.lang.Double utilizationTarget) {
    this.utilizationTarget = utilizationTarget;
    return this;
  }

  /**
   * Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either
   * GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE. If not specified, the default is GAUGE.
   * @return value or {@code null} for none
   */
  public java.lang.String getUtilizationTargetType() {
    return utilizationTargetType;
  }

  /**
   * Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either
   * GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE. If not specified, the default is GAUGE.
   * @param utilizationTargetType utilizationTargetType or {@code null} for none
   */
  public AutoscalingPolicyCustomMetricUtilization setUtilizationTargetType(java.lang.String utilizationTargetType) {
    this.utilizationTargetType = utilizationTargetType;
    return this;
  }

  @Override
  public AutoscalingPolicyCustomMetricUtilization set(String fieldName, Object value) {
    return (AutoscalingPolicyCustomMetricUtilization) super.set(fieldName, value);
  }

  @Override
  public AutoscalingPolicyCustomMetricUtilization clone() {
    return (AutoscalingPolicyCustomMetricUtilization) super.clone();
  }

}
