/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-09-27 at 00:35:17 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Contains a list of managed instance groups.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RegionInstanceGroupManagerList extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Unique identifier for the resource; defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * A list of InstanceGroupManager resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InstanceGroupManager> items;

  static {
    // hack to force ProGuard to consider InstanceGroupManager used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(InstanceGroupManager.class);
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of
   * managed instance groups that exist in th regional scope.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] This token allows you to get the next page of results for list requests. If the
   * number of results is larger than maxResults, use the nextPageToken as a value for the query
   * parameter pageToken in the next list request. Subsequent list requests will have their own
   * nextPageToken to continue paging through the results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * [Output Only] Server-defined URL for this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] Unique identifier for the resource; defined by the server.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * [Output Only] Unique identifier for the resource; defined by the server.
   * @param id id or {@code null} for none
   */
  public RegionInstanceGroupManagerList setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * A list of InstanceGroupManager resources.
   * @return value or {@code null} for none
   */
  public java.util.List<InstanceGroupManager> getItems() {
    return items;
  }

  /**
   * A list of InstanceGroupManager resources.
   * @param items items or {@code null} for none
   */
  public RegionInstanceGroupManagerList setItems(java.util.List<InstanceGroupManager> items) {
    this.items = items;
    return this;
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of
   * managed instance groups that exist in th regional scope.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of
   * managed instance groups that exist in th regional scope.
   * @param kind kind or {@code null} for none
   */
  public RegionInstanceGroupManagerList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] This token allows you to get the next page of results for list requests. If the
   * number of results is larger than maxResults, use the nextPageToken as a value for the query
   * parameter pageToken in the next list request. Subsequent list requests will have their own
   * nextPageToken to continue paging through the results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * [Output Only] This token allows you to get the next page of results for list requests. If the
   * number of results is larger than maxResults, use the nextPageToken as a value for the query
   * parameter pageToken in the next list request. Subsequent list requests will have their own
   * nextPageToken to continue paging through the results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public RegionInstanceGroupManagerList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for this resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public RegionInstanceGroupManagerList setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public RegionInstanceGroupManagerList set(String fieldName, Object value) {
    return (RegionInstanceGroupManagerList) super.set(fieldName, value);
  }

  @Override
  public RegionInstanceGroupManagerList clone() {
    return (RegionInstanceGroupManagerList) super.clone();
  }

}
