/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-03-07 at 12:49:20 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Configuration parameters of autoscaling based on load balancing.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AutoscalingPolicyLoadBalancingUtilization extends com.google.api.client.json.GenericJson {

  /**
   * Fraction of backend capacity utilization (set in HTTP(s) load balancing configuration) that
   * autoscaler should maintain. Must be a positive float value. If not defined, the default is 0.8.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double utilizationTarget;

  /**
   * Fraction of backend capacity utilization (set in HTTP(s) load balancing configuration) that
   * autoscaler should maintain. Must be a positive float value. If not defined, the default is 0.8.
   * @return value or {@code null} for none
   */
  public java.lang.Double getUtilizationTarget() {
    return utilizationTarget;
  }

  /**
   * Fraction of backend capacity utilization (set in HTTP(s) load balancing configuration) that
   * autoscaler should maintain. Must be a positive float value. If not defined, the default is 0.8.
   * @param utilizationTarget utilizationTarget or {@code null} for none
   */
  public AutoscalingPolicyLoadBalancingUtilization setUtilizationTarget(java.lang.Double utilizationTarget) {
    this.utilizationTarget = utilizationTarget;
    return this;
  }

  @Override
  public AutoscalingPolicyLoadBalancingUtilization set(String fieldName, Object value) {
    return (AutoscalingPolicyLoadBalancingUtilization) super.set(fieldName, value);
  }

  @Override
  public AutoscalingPolicyLoadBalancingUtilization clone() {
    return (AutoscalingPolicyLoadBalancingUtilization) super.clone();
  }

}
