/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-03-07 at 14:24:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a reference to a resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Reference extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Type of the resource. Always compute#reference for references.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A description of the reference type with no implied semantics. Possible values include: -
   * MEMBER_OF
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String referenceType;

  /**
   * URL of the resource which refers to the target.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String referrer;

  /**
   * URL of the resource to which this reference points.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String target;

  /**
   * [Output Only] Type of the resource. Always compute#reference for references.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#reference for references.
   * @param kind kind or {@code null} for none
   */
  public Reference setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A description of the reference type with no implied semantics. Possible values include: -
   * MEMBER_OF
   * @return value or {@code null} for none
   */
  public java.lang.String getReferenceType() {
    return referenceType;
  }

  /**
   * A description of the reference type with no implied semantics. Possible values include: -
   * MEMBER_OF
   * @param referenceType referenceType or {@code null} for none
   */
  public Reference setReferenceType(java.lang.String referenceType) {
    this.referenceType = referenceType;
    return this;
  }

  /**
   * URL of the resource which refers to the target.
   * @return value or {@code null} for none
   */
  public java.lang.String getReferrer() {
    return referrer;
  }

  /**
   * URL of the resource which refers to the target.
   * @param referrer referrer or {@code null} for none
   */
  public Reference setReferrer(java.lang.String referrer) {
    this.referrer = referrer;
    return this;
  }

  /**
   * URL of the resource to which this reference points.
   * @return value or {@code null} for none
   */
  public java.lang.String getTarget() {
    return target;
  }

  /**
   * URL of the resource to which this reference points.
   * @param target target or {@code null} for none
   */
  public Reference setTarget(java.lang.String target) {
    this.target = target;
    return this;
  }

  @Override
  public Reference set(String fieldName, Object value) {
    return (Reference) super.set(fieldName, value);
  }

  @Override
  public Reference clone() {
    return (Reference) super.clone();
  }

}
