/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-04-05 at 17:45:49 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for SSLHealthCheck.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SSLHealthCheck extends com.google.api.client.json.GenericJson {

  /**
   * The TCP port number for the health check request. The default value is 443. Valid values are 1
   * through 65535.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer port;

  /**
   * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined,
   * port takes precedence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String portName;

  /**
   * Specifies the type of proxy header to append before sending data to the backend, either NONE or
   * PROXY_V1. The default is NONE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String proxyHeader;

  /**
   * The application data to send once the SSL connection has been established (default value is
   * empty). If both request and response are empty, the connection establishment alone will
   * indicate health. The request data can only be ASCII.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String request;

  /**
   * The bytes to match against the beginning of the response data. If left empty (the default
   * value), any response will indicate health. The response data can only be ASCII.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String response;

  /**
   * The TCP port number for the health check request. The default value is 443. Valid values are 1
   * through 65535.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPort() {
    return port;
  }

  /**
   * The TCP port number for the health check request. The default value is 443. Valid values are 1
   * through 65535.
   * @param port port or {@code null} for none
   */
  public SSLHealthCheck setPort(java.lang.Integer port) {
    this.port = port;
    return this;
  }

  /**
   * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined,
   * port takes precedence.
   * @return value or {@code null} for none
   */
  public java.lang.String getPortName() {
    return portName;
  }

  /**
   * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined,
   * port takes precedence.
   * @param portName portName or {@code null} for none
   */
  public SSLHealthCheck setPortName(java.lang.String portName) {
    this.portName = portName;
    return this;
  }

  /**
   * Specifies the type of proxy header to append before sending data to the backend, either NONE or
   * PROXY_V1. The default is NONE.
   * @return value or {@code null} for none
   */
  public java.lang.String getProxyHeader() {
    return proxyHeader;
  }

  /**
   * Specifies the type of proxy header to append before sending data to the backend, either NONE or
   * PROXY_V1. The default is NONE.
   * @param proxyHeader proxyHeader or {@code null} for none
   */
  public SSLHealthCheck setProxyHeader(java.lang.String proxyHeader) {
    this.proxyHeader = proxyHeader;
    return this;
  }

  /**
   * The application data to send once the SSL connection has been established (default value is
   * empty). If both request and response are empty, the connection establishment alone will
   * indicate health. The request data can only be ASCII.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequest() {
    return request;
  }

  /**
   * The application data to send once the SSL connection has been established (default value is
   * empty). If both request and response are empty, the connection establishment alone will
   * indicate health. The request data can only be ASCII.
   * @param request request or {@code null} for none
   */
  public SSLHealthCheck setRequest(java.lang.String request) {
    this.request = request;
    return this;
  }

  /**
   * The bytes to match against the beginning of the response data. If left empty (the default
   * value), any response will indicate health. The response data can only be ASCII.
   * @return value or {@code null} for none
   */
  public java.lang.String getResponse() {
    return response;
  }

  /**
   * The bytes to match against the beginning of the response data. If left empty (the default
   * value), any response will indicate health. The response data can only be ASCII.
   * @param response response or {@code null} for none
   */
  public SSLHealthCheck setResponse(java.lang.String response) {
    this.response = response;
    return this;
  }

  @Override
  public SSLHealthCheck set(String fieldName, Object value) {
    return (SSLHealthCheck) super.set(fieldName, value);
  }

  @Override
  public SSLHealthCheck clone() {
    return (SSLHealthCheck) super.clone();
  }

}
