/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-04-14 at 03:36:54 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A license resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class License extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean chargesUseFee;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of resource. Always compute#license for licenses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] The unique code used to attach this license to images, snapshots, and disks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger licenseCode;

  /**
   * [Output Only] Name of the resource. The name is 1-63 characters long and complies with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LicenseResourceRequirements resourceRequirements;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * If false, licenses will not be copied from the source resource when creating an image from a
   * disk, disk from snapshot, or snapshot from disk.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean transferable;

  /**
   * [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getChargesUseFee() {
    return chargesUseFee;
  }

  /**
   * [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
   * @param chargesUseFee chargesUseFee or {@code null} for none
   */
  public License setChargesUseFee(java.lang.Boolean chargesUseFee) {
    this.chargesUseFee = chargesUseFee;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public License setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @param description description or {@code null} for none
   */
  public License setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public License setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of resource. Always compute#license for licenses.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of resource. Always compute#license for licenses.
   * @param kind kind or {@code null} for none
   */
  public License setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] The unique code used to attach this license to images, snapshots, and disks.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getLicenseCode() {
    return licenseCode;
  }

  /**
   * [Output Only] The unique code used to attach this license to images, snapshots, and disks.
   * @param licenseCode licenseCode or {@code null} for none
   */
  public License setLicenseCode(java.math.BigInteger licenseCode) {
    this.licenseCode = licenseCode;
    return this;
  }

  /**
   * [Output Only] Name of the resource. The name is 1-63 characters long and complies with RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * [Output Only] Name of the resource. The name is 1-63 characters long and complies with RFC1035.
   * @param name name or {@code null} for none
   */
  public License setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public LicenseResourceRequirements getResourceRequirements() {
    return resourceRequirements;
  }

  /**
   * @param resourceRequirements resourceRequirements or {@code null} for none
   */
  public License setResourceRequirements(LicenseResourceRequirements resourceRequirements) {
    this.resourceRequirements = resourceRequirements;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public License setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * If false, licenses will not be copied from the source resource when creating an image from a
   * disk, disk from snapshot, or snapshot from disk.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getTransferable() {
    return transferable;
  }

  /**
   * If false, licenses will not be copied from the source resource when creating an image from a
   * disk, disk from snapshot, or snapshot from disk.
   * @param transferable transferable or {@code null} for none
   */
  public License setTransferable(java.lang.Boolean transferable) {
    this.transferable = transferable;
    return this;
  }

  @Override
  public License set(String fieldName, Object value) {
    return (License) super.set(fieldName, value);
  }

  @Override
  public License clone() {
    return (License) super.clone();
  }

}
