/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-04-06 17:52:19 UTC)
 * on 2018-04-21 at 06:10:33 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Describes a single physical circuit between the Customer and Google. CircuitInfo objects are
 * created by Google, so all fields are output only. Next id: 4
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectCircuitInfo extends com.google.api.client.json.GenericJson {

  /**
   * Customer-side demarc ID for this circuit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customerDemarcId;

  /**
   * Google-assigned unique ID for this circuit. Assigned at circuit turn-up.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String googleCircuitId;

  /**
   * Google-side demarc ID for this circuit. Assigned at circuit turn-up and provided by Google to
   * the customer in the LOA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String googleDemarcId;

  /**
   * Customer-side demarc ID for this circuit.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomerDemarcId() {
    return customerDemarcId;
  }

  /**
   * Customer-side demarc ID for this circuit.
   * @param customerDemarcId customerDemarcId or {@code null} for none
   */
  public InterconnectCircuitInfo setCustomerDemarcId(java.lang.String customerDemarcId) {
    this.customerDemarcId = customerDemarcId;
    return this;
  }

  /**
   * Google-assigned unique ID for this circuit. Assigned at circuit turn-up.
   * @return value or {@code null} for none
   */
  public java.lang.String getGoogleCircuitId() {
    return googleCircuitId;
  }

  /**
   * Google-assigned unique ID for this circuit. Assigned at circuit turn-up.
   * @param googleCircuitId googleCircuitId or {@code null} for none
   */
  public InterconnectCircuitInfo setGoogleCircuitId(java.lang.String googleCircuitId) {
    this.googleCircuitId = googleCircuitId;
    return this;
  }

  /**
   * Google-side demarc ID for this circuit. Assigned at circuit turn-up and provided by Google to
   * the customer in the LOA.
   * @return value or {@code null} for none
   */
  public java.lang.String getGoogleDemarcId() {
    return googleDemarcId;
  }

  /**
   * Google-side demarc ID for this circuit. Assigned at circuit turn-up and provided by Google to
   * the customer in the LOA.
   * @param googleDemarcId googleDemarcId or {@code null} for none
   */
  public InterconnectCircuitInfo setGoogleDemarcId(java.lang.String googleDemarcId) {
    this.googleDemarcId = googleDemarcId;
    return this;
  }

  @Override
  public InterconnectCircuitInfo set(String fieldName, Object value) {
    return (InterconnectCircuitInfo) super.set(fieldName, value);
  }

  @Override
  public InterconnectCircuitInfo clone() {
    return (InterconnectCircuitInfo) super.clone();
  }

}
