/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-06-30 at 18:27:59 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute;

/**
 * Service definition for Compute (v1).
 *
 * <p>
 * Creates and runs virtual machines on Google Cloud Platform.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/compute/docs/reference/latest/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link ComputeRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Compute extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.22.0 of the Compute Engine API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "compute/v1/projects/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Compute(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Compute(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the AcceleratorTypes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.AcceleratorTypes.List request = compute.acceleratorTypes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public AcceleratorTypes acceleratorTypes() {
    return new AcceleratorTypes();
  }

  /**
   * The "acceleratorTypes" collection of methods.
   */
  public class AcceleratorTypes {

    /**
     * Retrieves an aggregated list of accelerator types.
     *
     * Create a request for the method "acceleratorTypes.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.AcceleratorTypeAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/acceleratorTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of accelerator types.
       *
       * Create a request for the method "acceleratorTypes.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AcceleratorTypeAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public AggregatedList setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified accelerator type.
     *
     * Create a request for the method "acceleratorTypes.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param acceleratorType Name of the accelerator type to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String acceleratorType) throws java.io.IOException {
      Get result = new Get(project, zone, acceleratorType);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.AcceleratorType> {

      private static final String REST_PATH = "{project}/zones/{zone}/acceleratorTypes/{acceleratorType}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern ACCELERATOR_TYPE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified accelerator type.
       *
       * Create a request for the method "acceleratorTypes.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param acceleratorType Name of the accelerator type to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String acceleratorType) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AcceleratorType.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.acceleratorType = com.google.api.client.util.Preconditions.checkNotNull(acceleratorType, "Required parameter acceleratorType must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ACCELERATOR_TYPE_PATTERN.matcher(acceleratorType).matches(),
              "Parameter acceleratorType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the accelerator type to return. */
      @com.google.api.client.util.Key
      private java.lang.String acceleratorType;

      /** Name of the accelerator type to return.
       */
      public java.lang.String getAcceleratorType() {
        return acceleratorType;
      }

      /** Name of the accelerator type to return. */
      public Get setAcceleratorType(java.lang.String acceleratorType) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ACCELERATOR_TYPE_PATTERN.matcher(acceleratorType).matches(),
              "Parameter acceleratorType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.acceleratorType = acceleratorType;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of accelerator types available to the specified project.
     *
     * Create a request for the method "acceleratorTypes.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.AcceleratorTypeList> {

      private static final String REST_PATH = "{project}/zones/{zone}/acceleratorTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of accelerator types available to the specified project.
       *
       * Create a request for the method "acceleratorTypes.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AcceleratorTypeList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Addresses collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Addresses.List request = compute.addresses().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Addresses addresses() {
    return new Addresses();
  }

  /**
   * The "addresses" collection of methods.
   */
  public class Addresses {

    /**
     * Retrieves an aggregated list of addresses.
     *
     * Create a request for the method "addresses.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.AddressAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of addresses.
       *
       * Create a request for the method "addresses.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AddressAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public AggregatedList setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified address resource.
     *
     * Create a request for the method "addresses.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region for this request.
     * @param address Name of the address resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String region, java.lang.String address) throws java.io.IOException {
      Delete result = new Delete(project, region, address);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified address resource.
       *
       * Create a request for the method "addresses.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region for this request.
       * @param address Name of the address resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String region, java.lang.String address) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = com.google.api.client.util.Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region for this request. */
      public Delete setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the address resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String address;

      /** Name of the address resource to delete.
       */
      public java.lang.String getAddress() {
        return address;
      }

      /** Name of the address resource to delete. */
      public Delete setAddress(java.lang.String address) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = address;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified address resource.
     *
     * Create a request for the method "addresses.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region for this request.
     * @param address Name of the address resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region, java.lang.String address) throws java.io.IOException {
      Get result = new Get(project, region, address);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Address> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified address resource.
       *
       * Create a request for the method "addresses.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region for this request.
       * @param address Name of the address resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region, java.lang.String address) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Address.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = com.google.api.client.util.Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region for this request. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the address resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String address;

      /** Name of the address resource to return.
       */
      public java.lang.String getAddress() {
        return address;
      }

      /** Name of the address resource to return. */
      public Get setAddress(java.lang.String address) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = address;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an address resource in the specified project using the data included in the request.
     *
     * Create a request for the method "addresses.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region for this request.
     * @param content the {@link com.google.api.services.compute.model.Address}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.Address content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates an address resource in the specified project using the data included in the request.
       *
       * Create a request for the method "addresses.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region for this request.
       * @param content the {@link com.google.api.services.compute.model.Address}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.Address content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region for this request. */
      public Insert setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of addresses contained within the specified region.
     *
     * Create a request for the method "addresses.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.AddressList> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of addresses contained within the specified region.
       *
       * Create a request for the method "addresses.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AddressList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region for this request. */
      public List setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Autoscalers collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Autoscalers.List request = compute.autoscalers().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Autoscalers autoscalers() {
    return new Autoscalers();
  }

  /**
   * The "autoscalers" collection of methods.
   */
  public class Autoscalers {

    /**
     * Retrieves an aggregated list of autoscalers.
     *
     * Create a request for the method "autoscalers.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.AutoscalerAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/autoscalers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of autoscalers.
       *
       * Create a request for the method "autoscalers.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AutoscalerAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public AggregatedList setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified autoscaler.
     *
     * Create a request for the method "autoscalers.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @param autoscaler Name of the autoscaler to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String autoscaler) throws java.io.IOException {
      Delete result = new Delete(project, zone, autoscaler);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/autoscalers/{autoscaler}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern AUTOSCALER_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified autoscaler.
       *
       * Create a request for the method "autoscalers.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @param autoscaler Name of the autoscaler to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String autoscaler) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoscaler = com.google.api.client.util.Preconditions.checkNotNull(autoscaler, "Required parameter autoscaler must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public Delete setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the autoscaler to delete. */
      @com.google.api.client.util.Key
      private java.lang.String autoscaler;

      /** Name of the autoscaler to delete.
       */
      public java.lang.String getAutoscaler() {
        return autoscaler;
      }

      /** Name of the autoscaler to delete. */
      public Delete setAutoscaler(java.lang.String autoscaler) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoscaler = autoscaler;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified autoscaler resource. Gets a list of available autoscalers by making a
     * list() request.
     *
     * Create a request for the method "autoscalers.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @param autoscaler Name of the autoscaler to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String autoscaler) throws java.io.IOException {
      Get result = new Get(project, zone, autoscaler);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Autoscaler> {

      private static final String REST_PATH = "{project}/zones/{zone}/autoscalers/{autoscaler}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern AUTOSCALER_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified autoscaler resource. Gets a list of available autoscalers by making a
       * list() request.
       *
       * Create a request for the method "autoscalers.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @param autoscaler Name of the autoscaler to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String autoscaler) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Autoscaler.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoscaler = com.google.api.client.util.Preconditions.checkNotNull(autoscaler, "Required parameter autoscaler must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the autoscaler to return. */
      @com.google.api.client.util.Key
      private java.lang.String autoscaler;

      /** Name of the autoscaler to return.
       */
      public java.lang.String getAutoscaler() {
        return autoscaler;
      }

      /** Name of the autoscaler to return. */
      public Get setAutoscaler(java.lang.String autoscaler) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoscaler = autoscaler;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an autoscaler in the specified project using the data included in the request.
     *
     * Create a request for the method "autoscalers.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @param content the {@link com.google.api.services.compute.model.Autoscaler}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Autoscaler content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/autoscalers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates an autoscaler in the specified project using the data included in the request.
       *
       * Create a request for the method "autoscalers.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @param content the {@link com.google.api.services.compute.model.Autoscaler}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Autoscaler content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public Insert setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of autoscalers contained within the specified zone.
     *
     * Create a request for the method "autoscalers.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.AutoscalerList> {

      private static final String REST_PATH = "{project}/zones/{zone}/autoscalers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of autoscalers contained within the specified zone.
       *
       * Create a request for the method "autoscalers.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AutoscalerList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an autoscaler in the specified project using the data included in the request. This
     * method supports PATCH semantics and uses the JSON merge patch format and processing rules.
     *
     * Create a request for the method "autoscalers.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @param content the {@link com.google.api.services.compute.model.Autoscaler}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Autoscaler content) throws java.io.IOException {
      Patch result = new Patch(project, zone, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/autoscalers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern AUTOSCALER_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates an autoscaler in the specified project using the data included in the request. This
       * method supports PATCH semantics and uses the JSON merge patch format and processing rules.
       *
       * Create a request for the method "autoscalers.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @param content the {@link com.google.api.services.compute.model.Autoscaler}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Autoscaler content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public Patch setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the autoscaler to patch. */
      @com.google.api.client.util.Key
      private java.lang.String autoscaler;

      /** Name of the autoscaler to patch.
       */
      public java.lang.String getAutoscaler() {
        return autoscaler;
      }

      /** Name of the autoscaler to patch. */
      public Patch setAutoscaler(java.lang.String autoscaler) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoscaler = autoscaler;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Patch setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates an autoscaler in the specified project using the data included in the request.
     *
     * Create a request for the method "autoscalers.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @param content the {@link com.google.api.services.compute.model.Autoscaler}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Autoscaler content) throws java.io.IOException {
      Update result = new Update(project, zone, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/autoscalers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern AUTOSCALER_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates an autoscaler in the specified project using the data included in the request.
       *
       * Create a request for the method "autoscalers.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @param content the {@link com.google.api.services.compute.model.Autoscaler}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Autoscaler content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public Update setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the autoscaler to update. */
      @com.google.api.client.util.Key
      private java.lang.String autoscaler;

      /** Name of the autoscaler to update.
       */
      public java.lang.String getAutoscaler() {
        return autoscaler;
      }

      /** Name of the autoscaler to update. */
      public Update setAutoscaler(java.lang.String autoscaler) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoscaler = autoscaler;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Update setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the BackendBuckets collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.BackendBuckets.List request = compute.backendBuckets().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public BackendBuckets backendBuckets() {
    return new BackendBuckets();
  }

  /**
   * The "backendBuckets" collection of methods.
   */
  public class BackendBuckets {

    /**
     * Adds the given Signed URL Key to the backend bucket.
     *
     * Create a request for the method "backendBuckets.addSignedUrlKey".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AddSignedUrlKey#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendBucket Name of the BackendBucket resource to which the Signed URL Key should be added. The name should
     *        conform to RFC1035.
     * @param content the {@link com.google.api.services.compute.model.SignedUrlKey}
     * @return the request
     */
    public AddSignedUrlKey addSignedUrlKey(java.lang.String project, java.lang.String backendBucket, com.google.api.services.compute.model.SignedUrlKey content) throws java.io.IOException {
      AddSignedUrlKey result = new AddSignedUrlKey(project, backendBucket, content);
      initialize(result);
      return result;
    }

    public class AddSignedUrlKey extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendBuckets/{backendBucket}/addSignedUrlKey";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Adds the given Signed URL Key to the backend bucket.
       *
       * Create a request for the method "backendBuckets.addSignedUrlKey".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddSignedUrlKey#execute()} method to invoke the remote operation.
       * <p> {@link AddSignedUrlKey#initialize(com.google.api.client.googleapis.services.AbstractGoogleC
       * lientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendBucket Name of the BackendBucket resource to which the Signed URL Key should be added. The name should
     *        conform to RFC1035.
       * @param content the {@link com.google.api.services.compute.model.SignedUrlKey}
       * @since 1.13
       */
      protected AddSignedUrlKey(java.lang.String project, java.lang.String backendBucket, com.google.api.services.compute.model.SignedUrlKey content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendBucket = com.google.api.client.util.Preconditions.checkNotNull(backendBucket, "Required parameter backendBucket must be specified.");
      }

      @Override
      public AddSignedUrlKey setAlt(java.lang.String alt) {
        return (AddSignedUrlKey) super.setAlt(alt);
      }

      @Override
      public AddSignedUrlKey setFields(java.lang.String fields) {
        return (AddSignedUrlKey) super.setFields(fields);
      }

      @Override
      public AddSignedUrlKey setKey(java.lang.String key) {
        return (AddSignedUrlKey) super.setKey(key);
      }

      @Override
      public AddSignedUrlKey setOauthToken(java.lang.String oauthToken) {
        return (AddSignedUrlKey) super.setOauthToken(oauthToken);
      }

      @Override
      public AddSignedUrlKey setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AddSignedUrlKey) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddSignedUrlKey setQuotaUser(java.lang.String quotaUser) {
        return (AddSignedUrlKey) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddSignedUrlKey setUserIp(java.lang.String userIp) {
        return (AddSignedUrlKey) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AddSignedUrlKey setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Name of the BackendBucket resource to which the Signed URL Key should be added. The name
       * should conform to RFC1035.
       */
      @com.google.api.client.util.Key
      private java.lang.String backendBucket;

      /** Name of the BackendBucket resource to which the Signed URL Key should be added. The name should
     conform to RFC1035.
       */
      public java.lang.String getBackendBucket() {
        return backendBucket;
      }

      /**
       * Name of the BackendBucket resource to which the Signed URL Key should be added. The name
       * should conform to RFC1035.
       */
      public AddSignedUrlKey setBackendBucket(java.lang.String backendBucket) {
        this.backendBucket = backendBucket;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public AddSignedUrlKey setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public AddSignedUrlKey set(String parameterName, Object value) {
        return (AddSignedUrlKey) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified BackendBucket resource.
     *
     * Create a request for the method "backendBuckets.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendBucket Name of the BackendBucket resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String backendBucket) throws java.io.IOException {
      Delete result = new Delete(project, backendBucket);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendBuckets/{backendBucket}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_BUCKET_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified BackendBucket resource.
       *
       * Create a request for the method "backendBuckets.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendBucket Name of the BackendBucket resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String backendBucket) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendBucket = com.google.api.client.util.Preconditions.checkNotNull(backendBucket, "Required parameter backendBucket must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_BUCKET_PATTERN.matcher(backendBucket).matches(),
              "Parameter backendBucket must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendBucket resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String backendBucket;

      /** Name of the BackendBucket resource to delete.
       */
      public java.lang.String getBackendBucket() {
        return backendBucket;
      }

      /** Name of the BackendBucket resource to delete. */
      public Delete setBackendBucket(java.lang.String backendBucket) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_BUCKET_PATTERN.matcher(backendBucket).matches(),
              "Parameter backendBucket must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendBucket = backendBucket;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the given Signed URL Key from the backend bucket.
     *
     * Create a request for the method "backendBuckets.deleteSignedUrlKey".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link DeleteSignedUrlKey#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendBucket Name of the BackendBucket resource to which the Signed URL Key should be added. The name should
     *        conform to RFC1035.
     * @param keyName The name of the Signed URL Key to delete.
     * @return the request
     */
    public DeleteSignedUrlKey deleteSignedUrlKey(java.lang.String project, java.lang.String backendBucket, java.lang.String keyName) throws java.io.IOException {
      DeleteSignedUrlKey result = new DeleteSignedUrlKey(project, backendBucket, keyName);
      initialize(result);
      return result;
    }

    public class DeleteSignedUrlKey extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendBuckets/{backendBucket}/deleteSignedUrlKey";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Deletes the given Signed URL Key from the backend bucket.
       *
       * Create a request for the method "backendBuckets.deleteSignedUrlKey".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link DeleteSignedUrlKey#execute()} method to invoke the remote
       * operation. <p> {@link DeleteSignedUrlKey#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendBucket Name of the BackendBucket resource to which the Signed URL Key should be added. The name should
     *        conform to RFC1035.
       * @param keyName The name of the Signed URL Key to delete.
       * @since 1.13
       */
      protected DeleteSignedUrlKey(java.lang.String project, java.lang.String backendBucket, java.lang.String keyName) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendBucket = com.google.api.client.util.Preconditions.checkNotNull(backendBucket, "Required parameter backendBucket must be specified.");
        this.keyName = com.google.api.client.util.Preconditions.checkNotNull(keyName, "Required parameter keyName must be specified.");
      }

      @Override
      public DeleteSignedUrlKey setAlt(java.lang.String alt) {
        return (DeleteSignedUrlKey) super.setAlt(alt);
      }

      @Override
      public DeleteSignedUrlKey setFields(java.lang.String fields) {
        return (DeleteSignedUrlKey) super.setFields(fields);
      }

      @Override
      public DeleteSignedUrlKey setKey(java.lang.String key) {
        return (DeleteSignedUrlKey) super.setKey(key);
      }

      @Override
      public DeleteSignedUrlKey setOauthToken(java.lang.String oauthToken) {
        return (DeleteSignedUrlKey) super.setOauthToken(oauthToken);
      }

      @Override
      public DeleteSignedUrlKey setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DeleteSignedUrlKey) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DeleteSignedUrlKey setQuotaUser(java.lang.String quotaUser) {
        return (DeleteSignedUrlKey) super.setQuotaUser(quotaUser);
      }

      @Override
      public DeleteSignedUrlKey setUserIp(java.lang.String userIp) {
        return (DeleteSignedUrlKey) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public DeleteSignedUrlKey setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Name of the BackendBucket resource to which the Signed URL Key should be added. The name
       * should conform to RFC1035.
       */
      @com.google.api.client.util.Key
      private java.lang.String backendBucket;

      /** Name of the BackendBucket resource to which the Signed URL Key should be added. The name should
     conform to RFC1035.
       */
      public java.lang.String getBackendBucket() {
        return backendBucket;
      }

      /**
       * Name of the BackendBucket resource to which the Signed URL Key should be added. The name
       * should conform to RFC1035.
       */
      public DeleteSignedUrlKey setBackendBucket(java.lang.String backendBucket) {
        this.backendBucket = backendBucket;
        return this;
      }

      /** The name of the Signed URL Key to delete. */
      @com.google.api.client.util.Key
      private java.lang.String keyName;

      /** The name of the Signed URL Key to delete.
       */
      public java.lang.String getKeyName() {
        return keyName;
      }

      /** The name of the Signed URL Key to delete. */
      public DeleteSignedUrlKey setKeyName(java.lang.String keyName) {
        this.keyName = keyName;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public DeleteSignedUrlKey setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public DeleteSignedUrlKey set(String parameterName, Object value) {
        return (DeleteSignedUrlKey) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified BackendBucket resource. Gets a list of available backend buckets by making
     * a list() request.
     *
     * Create a request for the method "backendBuckets.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendBucket Name of the BackendBucket resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String backendBucket) throws java.io.IOException {
      Get result = new Get(project, backendBucket);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.BackendBucket> {

      private static final String REST_PATH = "{project}/global/backendBuckets/{backendBucket}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_BUCKET_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified BackendBucket resource. Gets a list of available backend buckets by
       * making a list() request.
       *
       * Create a request for the method "backendBuckets.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendBucket Name of the BackendBucket resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String backendBucket) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.BackendBucket.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendBucket = com.google.api.client.util.Preconditions.checkNotNull(backendBucket, "Required parameter backendBucket must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_BUCKET_PATTERN.matcher(backendBucket).matches(),
              "Parameter backendBucket must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendBucket resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String backendBucket;

      /** Name of the BackendBucket resource to return.
       */
      public java.lang.String getBackendBucket() {
        return backendBucket;
      }

      /** Name of the BackendBucket resource to return. */
      public Get setBackendBucket(java.lang.String backendBucket) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_BUCKET_PATTERN.matcher(backendBucket).matches(),
              "Parameter backendBucket must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendBucket = backendBucket;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a BackendBucket resource in the specified project using the data included in the request.
     *
     * Create a request for the method "backendBuckets.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.BackendBucket}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.BackendBucket content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendBuckets";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a BackendBucket resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "backendBuckets.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.BackendBucket}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.BackendBucket content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of BackendBucket resources available to the specified project.
     *
     * Create a request for the method "backendBuckets.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.BackendBucketList> {

      private static final String REST_PATH = "{project}/global/backendBuckets";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of BackendBucket resources available to the specified project.
       *
       * Create a request for the method "backendBuckets.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.BackendBucketList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified BackendBucket resource with the data included in the request. This method
     * supports PATCH semantics and uses the JSON merge patch format and processing rules.
     *
     * Create a request for the method "backendBuckets.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendBucket Name of the BackendBucket resource to patch.
     * @param content the {@link com.google.api.services.compute.model.BackendBucket}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String backendBucket, com.google.api.services.compute.model.BackendBucket content) throws java.io.IOException {
      Patch result = new Patch(project, backendBucket, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendBuckets/{backendBucket}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_BUCKET_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates the specified BackendBucket resource with the data included in the request. This method
       * supports PATCH semantics and uses the JSON merge patch format and processing rules.
       *
       * Create a request for the method "backendBuckets.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendBucket Name of the BackendBucket resource to patch.
       * @param content the {@link com.google.api.services.compute.model.BackendBucket}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String backendBucket, com.google.api.services.compute.model.BackendBucket content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendBucket = com.google.api.client.util.Preconditions.checkNotNull(backendBucket, "Required parameter backendBucket must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_BUCKET_PATTERN.matcher(backendBucket).matches(),
              "Parameter backendBucket must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendBucket resource to patch. */
      @com.google.api.client.util.Key
      private java.lang.String backendBucket;

      /** Name of the BackendBucket resource to patch.
       */
      public java.lang.String getBackendBucket() {
        return backendBucket;
      }

      /** Name of the BackendBucket resource to patch. */
      public Patch setBackendBucket(java.lang.String backendBucket) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_BUCKET_PATTERN.matcher(backendBucket).matches(),
              "Parameter backendBucket must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendBucket = backendBucket;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Patch setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified BackendBucket resource with the data included in the request.
     *
     * Create a request for the method "backendBuckets.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendBucket Name of the BackendBucket resource to update.
     * @param content the {@link com.google.api.services.compute.model.BackendBucket}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String backendBucket, com.google.api.services.compute.model.BackendBucket content) throws java.io.IOException {
      Update result = new Update(project, backendBucket, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendBuckets/{backendBucket}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_BUCKET_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates the specified BackendBucket resource with the data included in the request.
       *
       * Create a request for the method "backendBuckets.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendBucket Name of the BackendBucket resource to update.
       * @param content the {@link com.google.api.services.compute.model.BackendBucket}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String backendBucket, com.google.api.services.compute.model.BackendBucket content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendBucket = com.google.api.client.util.Preconditions.checkNotNull(backendBucket, "Required parameter backendBucket must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_BUCKET_PATTERN.matcher(backendBucket).matches(),
              "Parameter backendBucket must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendBucket resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String backendBucket;

      /** Name of the BackendBucket resource to update.
       */
      public java.lang.String getBackendBucket() {
        return backendBucket;
      }

      /** Name of the BackendBucket resource to update. */
      public Update setBackendBucket(java.lang.String backendBucket) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_BUCKET_PATTERN.matcher(backendBucket).matches(),
              "Parameter backendBucket must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendBucket = backendBucket;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Update setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the BackendServices collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.BackendServices.List request = compute.backendServices().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public BackendServices backendServices() {
    return new BackendServices();
  }

  /**
   * The "backendServices" collection of methods.
   */
  public class BackendServices {

    /**
     * Adds the given Signed URL Key to the specified backend service.
     *
     * Create a request for the method "backendServices.addSignedUrlKey".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AddSignedUrlKey#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to which the Signed URL Key should be added. The name should
     *        conform to RFC1035.
     * @param content the {@link com.google.api.services.compute.model.SignedUrlKey}
     * @return the request
     */
    public AddSignedUrlKey addSignedUrlKey(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.SignedUrlKey content) throws java.io.IOException {
      AddSignedUrlKey result = new AddSignedUrlKey(project, backendService, content);
      initialize(result);
      return result;
    }

    public class AddSignedUrlKey extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}/addSignedUrlKey";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Adds the given Signed URL Key to the specified backend service.
       *
       * Create a request for the method "backendServices.addSignedUrlKey".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddSignedUrlKey#execute()} method to invoke the remote operation.
       * <p> {@link AddSignedUrlKey#initialize(com.google.api.client.googleapis.services.AbstractGoogleC
       * lientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to which the Signed URL Key should be added. The name should
     *        conform to RFC1035.
       * @param content the {@link com.google.api.services.compute.model.SignedUrlKey}
       * @since 1.13
       */
      protected AddSignedUrlKey(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.SignedUrlKey content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
      }

      @Override
      public AddSignedUrlKey setAlt(java.lang.String alt) {
        return (AddSignedUrlKey) super.setAlt(alt);
      }

      @Override
      public AddSignedUrlKey setFields(java.lang.String fields) {
        return (AddSignedUrlKey) super.setFields(fields);
      }

      @Override
      public AddSignedUrlKey setKey(java.lang.String key) {
        return (AddSignedUrlKey) super.setKey(key);
      }

      @Override
      public AddSignedUrlKey setOauthToken(java.lang.String oauthToken) {
        return (AddSignedUrlKey) super.setOauthToken(oauthToken);
      }

      @Override
      public AddSignedUrlKey setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AddSignedUrlKey) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddSignedUrlKey setQuotaUser(java.lang.String quotaUser) {
        return (AddSignedUrlKey) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddSignedUrlKey setUserIp(java.lang.String userIp) {
        return (AddSignedUrlKey) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AddSignedUrlKey setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Name of the BackendService resource to which the Signed URL Key should be added. The name
       * should conform to RFC1035.
       */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to which the Signed URL Key should be added. The name should
     conform to RFC1035.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /**
       * Name of the BackendService resource to which the Signed URL Key should be added. The name
       * should conform to RFC1035.
       */
      public AddSignedUrlKey setBackendService(java.lang.String backendService) {
        this.backendService = backendService;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public AddSignedUrlKey setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public AddSignedUrlKey set(String parameterName, Object value) {
        return (AddSignedUrlKey) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of all BackendService resources, regional and global, available to the
     * specified project.
     *
     * Create a request for the method "backendServices.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.BackendServiceAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/backendServices";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of all BackendService resources, regional and global, available to the
       * specified project.
       *
       * Create a request for the method "backendServices.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.BackendServiceAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public AggregatedList setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified BackendService resource.
     *
     * Create a request for the method "backendServices.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String backendService) throws java.io.IOException {
      Delete result = new Delete(project, backendService);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified BackendService resource.
       *
       * Create a request for the method "backendServices.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String backendService) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to delete.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to delete. */
      public Delete setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendService = backendService;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the given Signed URL Key from the specified backend service.
     *
     * Create a request for the method "backendServices.deleteSignedUrlKey".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link DeleteSignedUrlKey#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to which the Signed URL Key should be added. The name should
     *        conform to RFC1035.
     * @param keyName The name of the Signed URL Key to delete.
     * @return the request
     */
    public DeleteSignedUrlKey deleteSignedUrlKey(java.lang.String project, java.lang.String backendService, java.lang.String keyName) throws java.io.IOException {
      DeleteSignedUrlKey result = new DeleteSignedUrlKey(project, backendService, keyName);
      initialize(result);
      return result;
    }

    public class DeleteSignedUrlKey extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}/deleteSignedUrlKey";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Deletes the given Signed URL Key from the specified backend service.
       *
       * Create a request for the method "backendServices.deleteSignedUrlKey".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link DeleteSignedUrlKey#execute()} method to invoke the remote
       * operation. <p> {@link DeleteSignedUrlKey#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to which the Signed URL Key should be added. The name should
     *        conform to RFC1035.
       * @param keyName The name of the Signed URL Key to delete.
       * @since 1.13
       */
      protected DeleteSignedUrlKey(java.lang.String project, java.lang.String backendService, java.lang.String keyName) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        this.keyName = com.google.api.client.util.Preconditions.checkNotNull(keyName, "Required parameter keyName must be specified.");
      }

      @Override
      public DeleteSignedUrlKey setAlt(java.lang.String alt) {
        return (DeleteSignedUrlKey) super.setAlt(alt);
      }

      @Override
      public DeleteSignedUrlKey setFields(java.lang.String fields) {
        return (DeleteSignedUrlKey) super.setFields(fields);
      }

      @Override
      public DeleteSignedUrlKey setKey(java.lang.String key) {
        return (DeleteSignedUrlKey) super.setKey(key);
      }

      @Override
      public DeleteSignedUrlKey setOauthToken(java.lang.String oauthToken) {
        return (DeleteSignedUrlKey) super.setOauthToken(oauthToken);
      }

      @Override
      public DeleteSignedUrlKey setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DeleteSignedUrlKey) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DeleteSignedUrlKey setQuotaUser(java.lang.String quotaUser) {
        return (DeleteSignedUrlKey) super.setQuotaUser(quotaUser);
      }

      @Override
      public DeleteSignedUrlKey setUserIp(java.lang.String userIp) {
        return (DeleteSignedUrlKey) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public DeleteSignedUrlKey setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Name of the BackendService resource to which the Signed URL Key should be added. The name
       * should conform to RFC1035.
       */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to which the Signed URL Key should be added. The name should
     conform to RFC1035.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /**
       * Name of the BackendService resource to which the Signed URL Key should be added. The name
       * should conform to RFC1035.
       */
      public DeleteSignedUrlKey setBackendService(java.lang.String backendService) {
        this.backendService = backendService;
        return this;
      }

      /** The name of the Signed URL Key to delete. */
      @com.google.api.client.util.Key
      private java.lang.String keyName;

      /** The name of the Signed URL Key to delete.
       */
      public java.lang.String getKeyName() {
        return keyName;
      }

      /** The name of the Signed URL Key to delete. */
      public DeleteSignedUrlKey setKeyName(java.lang.String keyName) {
        this.keyName = keyName;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public DeleteSignedUrlKey setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public DeleteSignedUrlKey set(String parameterName, Object value) {
        return (DeleteSignedUrlKey) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified BackendService resource. Gets a list of available backend services by
     * making a list() request.
     *
     * Create a request for the method "backendServices.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String backendService) throws java.io.IOException {
      Get result = new Get(project, backendService);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.BackendService> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified BackendService resource. Gets a list of available backend services by
       * making a list() request.
       *
       * Create a request for the method "backendServices.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String backendService) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.BackendService.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to return.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to return. */
      public Get setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendService = backendService;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets the most recent health check results for this BackendService.
     *
     * Create a request for the method "backendServices.getHealth".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetHealth#execute()} method to invoke the remote operation.
     *
     * @param project
     * @param backendService Name of the BackendService resource to which the queried instance belongs.
     * @param content the {@link com.google.api.services.compute.model.ResourceGroupReference}
     * @return the request
     */
    public GetHealth getHealth(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.ResourceGroupReference content) throws java.io.IOException {
      GetHealth result = new GetHealth(project, backendService, content);
      initialize(result);
      return result;
    }

    public class GetHealth extends ComputeRequest<com.google.api.services.compute.model.BackendServiceGroupHealth> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}/getHealth";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Gets the most recent health check results for this BackendService.
       *
       * Create a request for the method "backendServices.getHealth".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetHealth#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetHealth#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project
       * @param backendService Name of the BackendService resource to which the queried instance belongs.
       * @param content the {@link com.google.api.services.compute.model.ResourceGroupReference}
       * @since 1.13
       */
      protected GetHealth(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.ResourceGroupReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.BackendServiceGroupHealth.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public GetHealth setAlt(java.lang.String alt) {
        return (GetHealth) super.setAlt(alt);
      }

      @Override
      public GetHealth setFields(java.lang.String fields) {
        return (GetHealth) super.setFields(fields);
      }

      @Override
      public GetHealth setKey(java.lang.String key) {
        return (GetHealth) super.setKey(key);
      }

      @Override
      public GetHealth setOauthToken(java.lang.String oauthToken) {
        return (GetHealth) super.setOauthToken(oauthToken);
      }

      @Override
      public GetHealth setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetHealth) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetHealth setQuotaUser(java.lang.String quotaUser) {
        return (GetHealth) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetHealth setUserIp(java.lang.String userIp) {
        return (GetHealth) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String project;

      /**

       */
      public java.lang.String getProject() {
        return project;
      }

      public GetHealth setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to which the queried instance belongs. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to which the queried instance belongs.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to which the queried instance belongs. */
      public GetHealth setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendService = backendService;
        return this;
      }

      @Override
      public GetHealth set(String parameterName, Object value) {
        return (GetHealth) super.set(parameterName, value);
      }
    }
    /**
     * Creates a BackendService resource in the specified project using the data included in the
     * request. There are several restrictions and guidelines to keep in mind when creating a backend
     * service. Read  Restrictions and Guidelines for more information.
     *
     * Create a request for the method "backendServices.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.BackendService}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.BackendService content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendServices";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a BackendService resource in the specified project using the data included in the
       * request. There are several restrictions and guidelines to keep in mind when creating a backend
       * service. Read  Restrictions and Guidelines for more information.
       *
       * Create a request for the method "backendServices.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.BackendService}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.BackendService content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of BackendService resources available to the specified project.
     *
     * Create a request for the method "backendServices.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.BackendServiceList> {

      private static final String REST_PATH = "{project}/global/backendServices";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of BackendService resources available to the specified project.
       *
       * Create a request for the method "backendServices.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.BackendServiceList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Patches the specified BackendService resource with the data included in the request. There are
     * several restrictions and guidelines to keep in mind when updating a backend service. Read
     * Restrictions and Guidelines for more information. This method supports PATCH semantics and uses
     * the JSON merge patch format and processing rules.
     *
     * Create a request for the method "backendServices.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to patch.
     * @param content the {@link com.google.api.services.compute.model.BackendService}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.BackendService content) throws java.io.IOException {
      Patch result = new Patch(project, backendService, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Patches the specified BackendService resource with the data included in the request. There are
       * several restrictions and guidelines to keep in mind when updating a backend service. Read
       * Restrictions and Guidelines for more information. This method supports PATCH semantics and uses
       * the JSON merge patch format and processing rules.
       *
       * Create a request for the method "backendServices.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to patch.
       * @param content the {@link com.google.api.services.compute.model.BackendService}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.BackendService content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to patch. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to patch.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to patch. */
      public Patch setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendService = backendService;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Patch setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified BackendService resource with the data included in the request. There are
     * several restrictions and guidelines to keep in mind when updating a backend service. Read
     * Restrictions and Guidelines for more information.
     *
     * Create a request for the method "backendServices.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to update.
     * @param content the {@link com.google.api.services.compute.model.BackendService}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.BackendService content) throws java.io.IOException {
      Update result = new Update(project, backendService, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates the specified BackendService resource with the data included in the request. There are
       * several restrictions and guidelines to keep in mind when updating a backend service. Read
       * Restrictions and Guidelines for more information.
       *
       * Create a request for the method "backendServices.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to update.
       * @param content the {@link com.google.api.services.compute.model.BackendService}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.BackendService content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to update.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to update. */
      public Update setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendService = backendService;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Update setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the DiskTypes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.DiskTypes.List request = compute.diskTypes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public DiskTypes diskTypes() {
    return new DiskTypes();
  }

  /**
   * The "diskTypes" collection of methods.
   */
  public class DiskTypes {

    /**
     * Retrieves an aggregated list of disk types.
     *
     * Create a request for the method "diskTypes.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.DiskTypeAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/diskTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of disk types.
       *
       * Create a request for the method "diskTypes.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskTypeAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public AggregatedList setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified disk type. Gets a list of available disk types by making a list() request.
     *
     * Create a request for the method "diskTypes.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param diskType Name of the disk type to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String diskType) throws java.io.IOException {
      Get result = new Get(project, zone, diskType);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.DiskType> {

      private static final String REST_PATH = "{project}/zones/{zone}/diskTypes/{diskType}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_TYPE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified disk type. Gets a list of available disk types by making a list()
       * request.
       *
       * Create a request for the method "diskTypes.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param diskType Name of the disk type to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String diskType) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskType.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.diskType = com.google.api.client.util.Preconditions.checkNotNull(diskType, "Required parameter diskType must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_TYPE_PATTERN.matcher(diskType).matches(),
              "Parameter diskType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the disk type to return. */
      @com.google.api.client.util.Key
      private java.lang.String diskType;

      /** Name of the disk type to return.
       */
      public java.lang.String getDiskType() {
        return diskType;
      }

      /** Name of the disk type to return. */
      public Get setDiskType(java.lang.String diskType) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_TYPE_PATTERN.matcher(diskType).matches(),
              "Parameter diskType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.diskType = diskType;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of disk types available to the specified project.
     *
     * Create a request for the method "diskTypes.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.DiskTypeList> {

      private static final String REST_PATH = "{project}/zones/{zone}/diskTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of disk types available to the specified project.
       *
       * Create a request for the method "diskTypes.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskTypeList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Disks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Disks.List request = compute.disks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Disks disks() {
    return new Disks();
  }

  /**
   * The "disks" collection of methods.
   */
  public class Disks {

    /**
     * Retrieves an aggregated list of persistent disks.
     *
     * Create a request for the method "disks.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.DiskAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of persistent disks.
       *
       * Create a request for the method "disks.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public AggregatedList setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Creates a snapshot of a specified persistent disk.
     *
     * Create a request for the method "disks.createSnapshot".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link CreateSnapshot#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk Name of the persistent disk to snapshot.
     * @param content the {@link com.google.api.services.compute.model.Snapshot}
     * @return the request
     */
    public CreateSnapshot createSnapshot(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.Snapshot content) throws java.io.IOException {
      CreateSnapshot result = new CreateSnapshot(project, zone, disk, content);
      initialize(result);
      return result;
    }

    public class CreateSnapshot extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}/createSnapshot";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a snapshot of a specified persistent disk.
       *
       * Create a request for the method "disks.createSnapshot".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link CreateSnapshot#execute()} method to invoke the remote operation.
       * <p> {@link CreateSnapshot#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk Name of the persistent disk to snapshot.
       * @param content the {@link com.google.api.services.compute.model.Snapshot}
       * @since 1.13
       */
      protected CreateSnapshot(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.Snapshot content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public CreateSnapshot setAlt(java.lang.String alt) {
        return (CreateSnapshot) super.setAlt(alt);
      }

      @Override
      public CreateSnapshot setFields(java.lang.String fields) {
        return (CreateSnapshot) super.setFields(fields);
      }

      @Override
      public CreateSnapshot setKey(java.lang.String key) {
        return (CreateSnapshot) super.setKey(key);
      }

      @Override
      public CreateSnapshot setOauthToken(java.lang.String oauthToken) {
        return (CreateSnapshot) super.setOauthToken(oauthToken);
      }

      @Override
      public CreateSnapshot setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (CreateSnapshot) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public CreateSnapshot setQuotaUser(java.lang.String quotaUser) {
        return (CreateSnapshot) super.setQuotaUser(quotaUser);
      }

      @Override
      public CreateSnapshot setUserIp(java.lang.String userIp) {
        return (CreateSnapshot) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public CreateSnapshot setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public CreateSnapshot setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk to snapshot. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** Name of the persistent disk to snapshot.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** Name of the persistent disk to snapshot. */
      public CreateSnapshot setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = disk;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean guestFlush;

      /**

       */
      public java.lang.Boolean getGuestFlush() {
        return guestFlush;
      }

      public CreateSnapshot setGuestFlush(java.lang.Boolean guestFlush) {
        this.guestFlush = guestFlush;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public CreateSnapshot setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public CreateSnapshot set(String parameterName, Object value) {
        return (CreateSnapshot) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified persistent disk. Deleting a disk removes its data permanently and is
     * irreversible. However, deleting a disk does not delete any snapshots previously made from the
     * disk. You must separately delete snapshots.
     *
     * Create a request for the method "disks.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk Name of the persistent disk to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String disk) throws java.io.IOException {
      Delete result = new Delete(project, zone, disk);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified persistent disk. Deleting a disk removes its data permanently and is
       * irreversible. However, deleting a disk does not delete any snapshots previously made from the
       * disk. You must separately delete snapshots.
       *
       * Create a request for the method "disks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk Name of the persistent disk to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String disk) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Delete setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk to delete. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** Name of the persistent disk to delete.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** Name of the persistent disk to delete. */
      public Delete setDisk(java.lang.String disk) {
        this.disk = disk;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns a specified persistent disk. Gets a list of available persistent disks by making a list()
     * request.
     *
     * Create a request for the method "disks.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk Name of the persistent disk to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String disk) throws java.io.IOException {
      Get result = new Get(project, zone, disk);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Disk> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns a specified persistent disk. Gets a list of available persistent disks by making a
       * list() request.
       *
       * Create a request for the method "disks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk Name of the persistent disk to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String disk) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Disk.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk to return. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** Name of the persistent disk to return.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** Name of the persistent disk to return. */
      public Get setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = disk;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a persistent disk in the specified project using the data in the request. You can create
     * a disk with a sourceImage, a sourceSnapshot, or create an empty 500 GB data disk by omitting all
     * properties. You can also create a disk that is larger than the default size by specifying the
     * sizeGb property.
     *
     * Create a request for the method "disks.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param content the {@link com.google.api.services.compute.model.Disk}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Disk content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a persistent disk in the specified project using the data in the request. You can
       * create a disk with a sourceImage, a sourceSnapshot, or create an empty 500 GB data disk by
       * omitting all properties. You can also create a disk that is larger than the default size by
       * specifying the sizeGb property.
       *
       * Create a request for the method "disks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param content the {@link com.google.api.services.compute.model.Disk}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Disk content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Insert setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      /** Optional. Source image to restore onto a disk. */
      @com.google.api.client.util.Key
      private java.lang.String sourceImage;

      /** Optional. Source image to restore onto a disk.
       */
      public java.lang.String getSourceImage() {
        return sourceImage;
      }

      /** Optional. Source image to restore onto a disk. */
      public Insert setSourceImage(java.lang.String sourceImage) {
        this.sourceImage = sourceImage;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of persistent disks contained within the specified zone.
     *
     * Create a request for the method "disks.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.DiskList> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of persistent disks contained within the specified zone.
       *
       * Create a request for the method "disks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Resizes the specified persistent disk. You can only increase the size of the disk.
     *
     * Create a request for the method "disks.resize".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Resize#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk The name of the persistent disk.
     * @param content the {@link com.google.api.services.compute.model.DisksResizeRequest}
     * @return the request
     */
    public Resize resize(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.DisksResizeRequest content) throws java.io.IOException {
      Resize result = new Resize(project, zone, disk, content);
      initialize(result);
      return result;
    }

    public class Resize extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}/resize";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Resizes the specified persistent disk. You can only increase the size of the disk.
       *
       * Create a request for the method "disks.resize".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Resize#execute()} method to invoke the remote operation. <p> {@link
       * Resize#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk The name of the persistent disk.
       * @param content the {@link com.google.api.services.compute.model.DisksResizeRequest}
       * @since 1.13
       */
      protected Resize(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.DisksResizeRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Resize setAlt(java.lang.String alt) {
        return (Resize) super.setAlt(alt);
      }

      @Override
      public Resize setFields(java.lang.String fields) {
        return (Resize) super.setFields(fields);
      }

      @Override
      public Resize setKey(java.lang.String key) {
        return (Resize) super.setKey(key);
      }

      @Override
      public Resize setOauthToken(java.lang.String oauthToken) {
        return (Resize) super.setOauthToken(oauthToken);
      }

      @Override
      public Resize setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Resize) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Resize setQuotaUser(java.lang.String quotaUser) {
        return (Resize) super.setQuotaUser(quotaUser);
      }

      @Override
      public Resize setUserIp(java.lang.String userIp) {
        return (Resize) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Resize setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Resize setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** The name of the persistent disk. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** The name of the persistent disk.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** The name of the persistent disk. */
      public Resize setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = disk;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Resize setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Resize set(String parameterName, Object value) {
        return (Resize) super.set(parameterName, value);
      }
    }
    /**
     * Sets the labels on a disk. To learn more about labels, read the Labeling Resources documentation.
     *
     * Create a request for the method "disks.setLabels".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetLabels#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param resource Name of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.ZoneSetLabelsRequest}
     * @return the request
     */
    public SetLabels setLabels(java.lang.String project, java.lang.String zone, java.lang.String resource, com.google.api.services.compute.model.ZoneSetLabelsRequest content) throws java.io.IOException {
      SetLabels result = new SetLabels(project, zone, resource, content);
      initialize(result);
      return result;
    }

    public class SetLabels extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{resource}/setLabels";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets the labels on a disk. To learn more about labels, read the Labeling Resources
       * documentation.
       *
       * Create a request for the method "disks.setLabels".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetLabels#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetLabels#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param resource Name of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.ZoneSetLabelsRequest}
       * @since 1.13
       */
      protected SetLabels(java.lang.String project, java.lang.String zone, java.lang.String resource, com.google.api.services.compute.model.ZoneSetLabelsRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetLabels setAlt(java.lang.String alt) {
        return (SetLabels) super.setAlt(alt);
      }

      @Override
      public SetLabels setFields(java.lang.String fields) {
        return (SetLabels) super.setFields(fields);
      }

      @Override
      public SetLabels setKey(java.lang.String key) {
        return (SetLabels) super.setKey(key);
      }

      @Override
      public SetLabels setOauthToken(java.lang.String oauthToken) {
        return (SetLabels) super.setOauthToken(oauthToken);
      }

      @Override
      public SetLabels setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetLabels) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetLabels setQuotaUser(java.lang.String quotaUser) {
        return (SetLabels) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetLabels setUserIp(java.lang.String userIp) {
        return (SetLabels) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetLabels setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public SetLabels setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name of the resource for this request. */
      public SetLabels setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.resource = resource;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public SetLabels setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public SetLabels set(String parameterName, Object value) {
        return (SetLabels) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Firewalls collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Firewalls.List request = compute.firewalls().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Firewalls firewalls() {
    return new Firewalls();
  }

  /**
   * The "firewalls" collection of methods.
   */
  public class Firewalls {

    /**
     * Deletes the specified firewall.
     *
     * Create a request for the method "firewalls.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param firewall Name of the firewall rule to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String firewall) throws java.io.IOException {
      Delete result = new Delete(project, firewall);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified firewall.
       *
       * Create a request for the method "firewalls.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param firewall Name of the firewall rule to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String firewall) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall rule to delete. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall rule to delete.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall rule to delete. */
      public Delete setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified firewall.
     *
     * Create a request for the method "firewalls.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param firewall Name of the firewall rule to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String firewall) throws java.io.IOException {
      Get result = new Get(project, firewall);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Firewall> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified firewall.
       *
       * Create a request for the method "firewalls.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param firewall Name of the firewall rule to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String firewall) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Firewall.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall rule to return. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall rule to return.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall rule to return. */
      public Get setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a firewall rule in the specified project using the data included in the request.
     *
     * Create a request for the method "firewalls.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a firewall rule in the specified project using the data included in the request.
       *
       * Create a request for the method "firewalls.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of firewall rules available to the specified project.
     *
     * Create a request for the method "firewalls.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.FirewallList> {

      private static final String REST_PATH = "{project}/global/firewalls";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of firewall rules available to the specified project.
       *
       * Create a request for the method "firewalls.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.FirewallList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified firewall rule with the data included in the request. This method supports
     * PATCH semantics and uses the JSON merge patch format and processing rules.
     *
     * Create a request for the method "firewalls.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param firewall Name of the firewall rule to patch.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Patch result = new Patch(project, firewall, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates the specified firewall rule with the data included in the request. This method supports
       * PATCH semantics and uses the JSON merge patch format and processing rules.
       *
       * Create a request for the method "firewalls.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param firewall Name of the firewall rule to patch.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall rule to patch. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall rule to patch.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall rule to patch. */
      public Patch setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Patch setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified firewall rule with the data included in the request. The PUT method can
     * only update the following fields of firewall rule: allowed, description, sourceRanges,
     * sourceTags, targetTags.
     *
     * Create a request for the method "firewalls.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param firewall Name of the firewall rule to update.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Update result = new Update(project, firewall, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates the specified firewall rule with the data included in the request. The PUT method can
       * only update the following fields of firewall rule: allowed, description, sourceRanges,
       * sourceTags, targetTags.
       *
       * Create a request for the method "firewalls.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param firewall Name of the firewall rule to update.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall rule to update. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall rule to update.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall rule to update. */
      public Update setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Update setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ForwardingRules collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.ForwardingRules.List request = compute.forwardingRules().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ForwardingRules forwardingRules() {
    return new ForwardingRules();
  }

  /**
   * The "forwardingRules" collection of methods.
   */
  public class ForwardingRules {

    /**
     * Retrieves an aggregated list of forwarding rules.
     *
     * Create a request for the method "forwardingRules.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.ForwardingRuleAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of forwarding rules.
       *
       * Create a request for the method "forwardingRules.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRuleAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public AggregatedList setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified ForwardingRule resource.
     *
     * Create a request for the method "forwardingRules.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) throws java.io.IOException {
      Delete result = new Delete(project, region, forwardingRule);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified ForwardingRule resource.
       *
       * Create a request for the method "forwardingRules.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Delete setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource to delete.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to delete. */
      public Delete setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified ForwardingRule resource.
     *
     * Create a request for the method "forwardingRules.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) throws java.io.IOException {
      Get result = new Get(project, region, forwardingRule);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.ForwardingRule> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified ForwardingRule resource.
       *
       * Create a request for the method "forwardingRules.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRule.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource to return.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to return. */
      public Get setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a ForwardingRule resource in the specified project and region using the data included in
     * the request.
     *
     * Create a request for the method "forwardingRules.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.ForwardingRule content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a ForwardingRule resource in the specified project and region using the data included
       * in the request.
       *
       * Create a request for the method "forwardingRules.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region scoping this request.
       * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.ForwardingRule content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Insert setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of ForwardingRule resources available to the specified project and region.
     *
     * Create a request for the method "forwardingRules.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ForwardingRuleList> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of ForwardingRule resources available to the specified project and region.
       *
       * Create a request for the method "forwardingRules.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRuleList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public List setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Changes target URL for forwarding rule. The new target should be of the same type as the old
     * target.
     *
     * Create a request for the method "forwardingRules.setTarget".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetTarget#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource in which target is to be set.
     * @param content the {@link com.google.api.services.compute.model.TargetReference}
     * @return the request
     */
    public SetTarget setTarget(java.lang.String project, java.lang.String region, java.lang.String forwardingRule, com.google.api.services.compute.model.TargetReference content) throws java.io.IOException {
      SetTarget result = new SetTarget(project, region, forwardingRule, content);
      initialize(result);
      return result;
    }

    public class SetTarget extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}/setTarget";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Changes target URL for forwarding rule. The new target should be of the same type as the old
       * target.
       *
       * Create a request for the method "forwardingRules.setTarget".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetTarget#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetTarget#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource in which target is to be set.
       * @param content the {@link com.google.api.services.compute.model.TargetReference}
       * @since 1.13
       */
      protected SetTarget(java.lang.String project, java.lang.String region, java.lang.String forwardingRule, com.google.api.services.compute.model.TargetReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetTarget setAlt(java.lang.String alt) {
        return (SetTarget) super.setAlt(alt);
      }

      @Override
      public SetTarget setFields(java.lang.String fields) {
        return (SetTarget) super.setFields(fields);
      }

      @Override
      public SetTarget setKey(java.lang.String key) {
        return (SetTarget) super.setKey(key);
      }

      @Override
      public SetTarget setOauthToken(java.lang.String oauthToken) {
        return (SetTarget) super.setOauthToken(oauthToken);
      }

      @Override
      public SetTarget setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetTarget) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetTarget setQuotaUser(java.lang.String quotaUser) {
        return (SetTarget) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetTarget setUserIp(java.lang.String userIp) {
        return (SetTarget) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetTarget setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public SetTarget setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource in which target is to be set. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource in which target is to be set.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource in which target is to be set. */
      public SetTarget setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public SetTarget setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public SetTarget set(String parameterName, Object value) {
        return (SetTarget) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the GlobalAddresses collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.GlobalAddresses.List request = compute.globalAddresses().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public GlobalAddresses globalAddresses() {
    return new GlobalAddresses();
  }

  /**
   * The "globalAddresses" collection of methods.
   */
  public class GlobalAddresses {

    /**
     * Deletes the specified address resource.
     *
     * Create a request for the method "globalAddresses.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param address Name of the address resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String address) throws java.io.IOException {
      Delete result = new Delete(project, address);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified address resource.
       *
       * Create a request for the method "globalAddresses.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param address Name of the address resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String address) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.address = com.google.api.client.util.Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the address resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String address;

      /** Name of the address resource to delete.
       */
      public java.lang.String getAddress() {
        return address;
      }

      /** Name of the address resource to delete. */
      public Delete setAddress(java.lang.String address) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = address;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified address resource. Gets a list of available addresses by making a list()
     * request.
     *
     * Create a request for the method "globalAddresses.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param address Name of the address resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String address) throws java.io.IOException {
      Get result = new Get(project, address);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Address> {

      private static final String REST_PATH = "{project}/global/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified address resource. Gets a list of available addresses by making a list()
       * request.
       *
       * Create a request for the method "globalAddresses.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param address Name of the address resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String address) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Address.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.address = com.google.api.client.util.Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the address resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String address;

      /** Name of the address resource to return.
       */
      public java.lang.String getAddress() {
        return address;
      }

      /** Name of the address resource to return. */
      public Get setAddress(java.lang.String address) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = address;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an address resource in the specified project using the data included in the request.
     *
     * Create a request for the method "globalAddresses.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.Address}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Address content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates an address resource in the specified project using the data included in the request.
       *
       * Create a request for the method "globalAddresses.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.Address}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Address content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of global addresses.
     *
     * Create a request for the method "globalAddresses.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.AddressList> {

      private static final String REST_PATH = "{project}/global/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves a list of global addresses.
       *
       * Create a request for the method "globalAddresses.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AddressList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the GlobalForwardingRules collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.GlobalForwardingRules.List request = compute.globalForwardingRules().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public GlobalForwardingRules globalForwardingRules() {
    return new GlobalForwardingRules();
  }

  /**
   * The "globalForwardingRules" collection of methods.
   */
  public class GlobalForwardingRules {

    /**
     * Deletes the specified GlobalForwardingRule resource.
     *
     * Create a request for the method "globalForwardingRules.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param forwardingRule Name of the ForwardingRule resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String forwardingRule) throws java.io.IOException {
      Delete result = new Delete(project, forwardingRule);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified GlobalForwardingRule resource.
       *
       * Create a request for the method "globalForwardingRules.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param forwardingRule Name of the ForwardingRule resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String forwardingRule) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the ForwardingRule resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource to delete.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to delete. */
      public Delete setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified GlobalForwardingRule resource. Gets a list of available forwarding rules by
     * making a list() request.
     *
     * Create a request for the method "globalForwardingRules.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param forwardingRule Name of the ForwardingRule resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String forwardingRule) throws java.io.IOException {
      Get result = new Get(project, forwardingRule);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.ForwardingRule> {

      private static final String REST_PATH = "{project}/global/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified GlobalForwardingRule resource. Gets a list of available forwarding rules
       * by making a list() request.
       *
       * Create a request for the method "globalForwardingRules.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param forwardingRule Name of the ForwardingRule resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String forwardingRule) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRule.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the ForwardingRule resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource to return.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to return. */
      public Get setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a GlobalForwardingRule resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "globalForwardingRules.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.ForwardingRule content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a GlobalForwardingRule resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "globalForwardingRules.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.ForwardingRule content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of GlobalForwardingRule resources available to the specified project.
     *
     * Create a request for the method "globalForwardingRules.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ForwardingRuleList> {

      private static final String REST_PATH = "{project}/global/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves a list of GlobalForwardingRule resources available to the specified project.
       *
       * Create a request for the method "globalForwardingRules.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRuleList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Changes target URL for the GlobalForwardingRule resource. The new target should be of the same
     * type as the old target.
     *
     * Create a request for the method "globalForwardingRules.setTarget".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetTarget#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param forwardingRule Name of the ForwardingRule resource in which target is to be set.
     * @param content the {@link com.google.api.services.compute.model.TargetReference}
     * @return the request
     */
    public SetTarget setTarget(java.lang.String project, java.lang.String forwardingRule, com.google.api.services.compute.model.TargetReference content) throws java.io.IOException {
      SetTarget result = new SetTarget(project, forwardingRule, content);
      initialize(result);
      return result;
    }

    public class SetTarget extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/forwardingRules/{forwardingRule}/setTarget";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Changes target URL for the GlobalForwardingRule resource. The new target should be of the same
       * type as the old target.
       *
       * Create a request for the method "globalForwardingRules.setTarget".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetTarget#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetTarget#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param forwardingRule Name of the ForwardingRule resource in which target is to be set.
       * @param content the {@link com.google.api.services.compute.model.TargetReference}
       * @since 1.13
       */
      protected SetTarget(java.lang.String project, java.lang.String forwardingRule, com.google.api.services.compute.model.TargetReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetTarget setAlt(java.lang.String alt) {
        return (SetTarget) super.setAlt(alt);
      }

      @Override
      public SetTarget setFields(java.lang.String fields) {
        return (SetTarget) super.setFields(fields);
      }

      @Override
      public SetTarget setKey(java.lang.String key) {
        return (SetTarget) super.setKey(key);
      }

      @Override
      public SetTarget setOauthToken(java.lang.String oauthToken) {
        return (SetTarget) super.setOauthToken(oauthToken);
      }

      @Override
      public SetTarget setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetTarget) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetTarget setQuotaUser(java.lang.String quotaUser) {
        return (SetTarget) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetTarget setUserIp(java.lang.String userIp) {
        return (SetTarget) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetTarget setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the ForwardingRule resource in which target is to be set. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource in which target is to be set.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource in which target is to be set. */
      public SetTarget setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public SetTarget setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public SetTarget set(String parameterName, Object value) {
        return (SetTarget) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the GlobalOperations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.GlobalOperations.List request = compute.globalOperations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public GlobalOperations globalOperations() {
    return new GlobalOperations();
  }

  /**
   * The "globalOperations" collection of methods.
   */
  public class GlobalOperations {

    /**
     * Retrieves an aggregated list of all operations.
     *
     * Create a request for the method "globalOperations.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.OperationAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/operations";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of all operations.
       *
       * Create a request for the method "globalOperations.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.OperationAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public AggregatedList setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified Operations resource.
     *
     * Create a request for the method "globalOperations.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param operation Name of the Operations resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String operation) throws java.io.IOException {
      Delete result = new Delete(project, operation);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<Void> {

      private static final String REST_PATH = "{project}/global/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified Operations resource.
       *
       * Create a request for the method "globalOperations.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param operation Name of the Operations resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String operation) {
        super(Compute.this, "DELETE", REST_PATH, null, Void.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the Operations resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Name of the Operations resource to delete.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Name of the Operations resource to delete. */
      public Delete setOperation(java.lang.String operation) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the specified Operations resource. Gets a list of operations by making a list()
     * request.
     *
     * Create a request for the method "globalOperations.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param operation Name of the Operations resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String operation) throws java.io.IOException {
      Get result = new Get(project, operation);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the specified Operations resource. Gets a list of operations by making a list()
       * request.
       *
       * Create a request for the method "globalOperations.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param operation Name of the Operations resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String operation) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the Operations resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Name of the Operations resource to return.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Name of the Operations resource to return. */
      public Get setOperation(java.lang.String operation) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of Operation resources contained within the specified project.
     *
     * Create a request for the method "globalOperations.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.OperationList> {

      private static final String REST_PATH = "{project}/global/operations";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves a list of Operation resources contained within the specified project.
       *
       * Create a request for the method "globalOperations.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.OperationList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the HealthChecks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.HealthChecks.List request = compute.healthChecks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public HealthChecks healthChecks() {
    return new HealthChecks();
  }

  /**
   * The "healthChecks" collection of methods.
   */
  public class HealthChecks {

    /**
     * Deletes the specified HealthCheck resource.
     *
     * Create a request for the method "healthChecks.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param healthCheck Name of the HealthCheck resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String healthCheck) throws java.io.IOException {
      Delete result = new Delete(project, healthCheck);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/healthChecks/{healthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified HealthCheck resource.
       *
       * Create a request for the method "healthChecks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param healthCheck Name of the HealthCheck resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String healthCheck) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.healthCheck = com.google.api.client.util.Preconditions.checkNotNull(healthCheck, "Required parameter healthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HEALTH_CHECK_PATTERN.matcher(healthCheck).matches(),
              "Parameter healthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HealthCheck resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String healthCheck;

      /** Name of the HealthCheck resource to delete.
       */
      public java.lang.String getHealthCheck() {
        return healthCheck;
      }

      /** Name of the HealthCheck resource to delete. */
      public Delete setHealthCheck(java.lang.String healthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HEALTH_CHECK_PATTERN.matcher(healthCheck).matches(),
              "Parameter healthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.healthCheck = healthCheck;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified HealthCheck resource. Gets a list of available health checks by making a
     * list() request.
     *
     * Create a request for the method "healthChecks.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param healthCheck Name of the HealthCheck resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String healthCheck) throws java.io.IOException {
      Get result = new Get(project, healthCheck);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.HealthCheck> {

      private static final String REST_PATH = "{project}/global/healthChecks/{healthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified HealthCheck resource. Gets a list of available health checks by making a
       * list() request.
       *
       * Create a request for the method "healthChecks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param healthCheck Name of the HealthCheck resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String healthCheck) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.HealthCheck.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.healthCheck = com.google.api.client.util.Preconditions.checkNotNull(healthCheck, "Required parameter healthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HEALTH_CHECK_PATTERN.matcher(healthCheck).matches(),
              "Parameter healthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HealthCheck resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String healthCheck;

      /** Name of the HealthCheck resource to return.
       */
      public java.lang.String getHealthCheck() {
        return healthCheck;
      }

      /** Name of the HealthCheck resource to return. */
      public Get setHealthCheck(java.lang.String healthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HEALTH_CHECK_PATTERN.matcher(healthCheck).matches(),
              "Parameter healthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.healthCheck = healthCheck;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a HealthCheck resource in the specified project using the data included in the request.
     *
     * Create a request for the method "healthChecks.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.HealthCheck}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.HealthCheck content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/healthChecks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a HealthCheck resource in the specified project using the data included in the request.
       *
       * Create a request for the method "healthChecks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.HealthCheck}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.HealthCheck content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of HealthCheck resources available to the specified project.
     *
     * Create a request for the method "healthChecks.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.HealthCheckList> {

      private static final String REST_PATH = "{project}/global/healthChecks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of HealthCheck resources available to the specified project.
       *
       * Create a request for the method "healthChecks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.HealthCheckList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a HealthCheck resource in the specified project using the data included in the request.
     * This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
     *
     * Create a request for the method "healthChecks.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param healthCheck Name of the HealthCheck resource to patch.
     * @param content the {@link com.google.api.services.compute.model.HealthCheck}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String healthCheck, com.google.api.services.compute.model.HealthCheck content) throws java.io.IOException {
      Patch result = new Patch(project, healthCheck, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/healthChecks/{healthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates a HealthCheck resource in the specified project using the data included in the request.
       * This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
       *
       * Create a request for the method "healthChecks.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param healthCheck Name of the HealthCheck resource to patch.
       * @param content the {@link com.google.api.services.compute.model.HealthCheck}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String healthCheck, com.google.api.services.compute.model.HealthCheck content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.healthCheck = com.google.api.client.util.Preconditions.checkNotNull(healthCheck, "Required parameter healthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HEALTH_CHECK_PATTERN.matcher(healthCheck).matches(),
              "Parameter healthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HealthCheck resource to patch. */
      @com.google.api.client.util.Key
      private java.lang.String healthCheck;

      /** Name of the HealthCheck resource to patch.
       */
      public java.lang.String getHealthCheck() {
        return healthCheck;
      }

      /** Name of the HealthCheck resource to patch. */
      public Patch setHealthCheck(java.lang.String healthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HEALTH_CHECK_PATTERN.matcher(healthCheck).matches(),
              "Parameter healthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.healthCheck = healthCheck;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Patch setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates a HealthCheck resource in the specified project using the data included in the request.
     *
     * Create a request for the method "healthChecks.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param healthCheck Name of the HealthCheck resource to update.
     * @param content the {@link com.google.api.services.compute.model.HealthCheck}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String healthCheck, com.google.api.services.compute.model.HealthCheck content) throws java.io.IOException {
      Update result = new Update(project, healthCheck, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/healthChecks/{healthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates a HealthCheck resource in the specified project using the data included in the request.
       *
       * Create a request for the method "healthChecks.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param healthCheck Name of the HealthCheck resource to update.
       * @param content the {@link com.google.api.services.compute.model.HealthCheck}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String healthCheck, com.google.api.services.compute.model.HealthCheck content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.healthCheck = com.google.api.client.util.Preconditions.checkNotNull(healthCheck, "Required parameter healthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HEALTH_CHECK_PATTERN.matcher(healthCheck).matches(),
              "Parameter healthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HealthCheck resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String healthCheck;

      /** Name of the HealthCheck resource to update.
       */
      public java.lang.String getHealthCheck() {
        return healthCheck;
      }

      /** Name of the HealthCheck resource to update. */
      public Update setHealthCheck(java.lang.String healthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HEALTH_CHECK_PATTERN.matcher(healthCheck).matches(),
              "Parameter healthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.healthCheck = healthCheck;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Update setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the HttpHealthChecks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.HttpHealthChecks.List request = compute.httpHealthChecks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public HttpHealthChecks httpHealthChecks() {
    return new HttpHealthChecks();
  }

  /**
   * The "httpHealthChecks" collection of methods.
   */
  public class HttpHealthChecks {

    /**
     * Deletes the specified HttpHealthCheck resource.
     *
     * Create a request for the method "httpHealthChecks.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String httpHealthCheck) throws java.io.IOException {
      Delete result = new Delete(project, httpHealthCheck);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTP_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified HttpHealthCheck resource.
       *
       * Create a request for the method "httpHealthChecks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String httpHealthCheck) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to delete.
       */
      public java.lang.String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to delete. */
      public Delete setHttpHealthCheck(java.lang.String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified HttpHealthCheck resource. Gets a list of available HTTP health checks by
     * making a list() request.
     *
     * Create a request for the method "httpHealthChecks.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String httpHealthCheck) throws java.io.IOException {
      Get result = new Get(project, httpHealthCheck);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.HttpHealthCheck> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTP_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified HttpHealthCheck resource. Gets a list of available HTTP health checks by
       * making a list() request.
       *
       * Create a request for the method "httpHealthChecks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String httpHealthCheck) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.HttpHealthCheck.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to return.
       */
      public java.lang.String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to return. */
      public Get setHttpHealthCheck(java.lang.String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a HttpHealthCheck resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "httpHealthChecks.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.HttpHealthCheck content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a HttpHealthCheck resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "httpHealthChecks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.HttpHealthCheck content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of HttpHealthCheck resources available to the specified project.
     *
     * Create a request for the method "httpHealthChecks.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.HttpHealthCheckList> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of HttpHealthCheck resources available to the specified project.
       *
       * Create a request for the method "httpHealthChecks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.HttpHealthCheckList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a HttpHealthCheck resource in the specified project using the data included in the
     * request. This method supports PATCH semantics and uses the JSON merge patch format and processing
     * rules.
     *
     * Create a request for the method "httpHealthChecks.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to patch.
     * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) throws java.io.IOException {
      Patch result = new Patch(project, httpHealthCheck, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTP_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates a HttpHealthCheck resource in the specified project using the data included in the
       * request. This method supports PATCH semantics and uses the JSON merge patch format and
       * processing rules.
       *
       * Create a request for the method "httpHealthChecks.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to patch.
       * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to patch. */
      @com.google.api.client.util.Key
      private java.lang.String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to patch.
       */
      public java.lang.String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to patch. */
      public Patch setHttpHealthCheck(java.lang.String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Patch setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates a HttpHealthCheck resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "httpHealthChecks.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
     * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) throws java.io.IOException {
      Update result = new Update(project, httpHealthCheck, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTP_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates a HttpHealthCheck resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "httpHealthChecks.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
       * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to update.
       */
      public java.lang.String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to update. */
      public Update setHttpHealthCheck(java.lang.String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Update setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the HttpsHealthChecks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.HttpsHealthChecks.List request = compute.httpsHealthChecks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public HttpsHealthChecks httpsHealthChecks() {
    return new HttpsHealthChecks();
  }

  /**
   * The "httpsHealthChecks" collection of methods.
   */
  public class HttpsHealthChecks {

    /**
     * Deletes the specified HttpsHealthCheck resource.
     *
     * Create a request for the method "httpsHealthChecks.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param httpsHealthCheck Name of the HttpsHealthCheck resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String httpsHealthCheck) throws java.io.IOException {
      Delete result = new Delete(project, httpsHealthCheck);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpsHealthChecks/{httpsHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTPS_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified HttpsHealthCheck resource.
       *
       * Create a request for the method "httpsHealthChecks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param httpsHealthCheck Name of the HttpsHealthCheck resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String httpsHealthCheck) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpsHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpsHealthCheck, "Required parameter httpsHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPS_HEALTH_CHECK_PATTERN.matcher(httpsHealthCheck).matches(),
              "Parameter httpsHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpsHealthCheck resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String httpsHealthCheck;

      /** Name of the HttpsHealthCheck resource to delete.
       */
      public java.lang.String getHttpsHealthCheck() {
        return httpsHealthCheck;
      }

      /** Name of the HttpsHealthCheck resource to delete. */
      public Delete setHttpsHealthCheck(java.lang.String httpsHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPS_HEALTH_CHECK_PATTERN.matcher(httpsHealthCheck).matches(),
              "Parameter httpsHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpsHealthCheck = httpsHealthCheck;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified HttpsHealthCheck resource. Gets a list of available HTTPS health checks by
     * making a list() request.
     *
     * Create a request for the method "httpsHealthChecks.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param httpsHealthCheck Name of the HttpsHealthCheck resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String httpsHealthCheck) throws java.io.IOException {
      Get result = new Get(project, httpsHealthCheck);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.HttpsHealthCheck> {

      private static final String REST_PATH = "{project}/global/httpsHealthChecks/{httpsHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTPS_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified HttpsHealthCheck resource. Gets a list of available HTTPS health checks
       * by making a list() request.
       *
       * Create a request for the method "httpsHealthChecks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param httpsHealthCheck Name of the HttpsHealthCheck resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String httpsHealthCheck) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.HttpsHealthCheck.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpsHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpsHealthCheck, "Required parameter httpsHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPS_HEALTH_CHECK_PATTERN.matcher(httpsHealthCheck).matches(),
              "Parameter httpsHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpsHealthCheck resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String httpsHealthCheck;

      /** Name of the HttpsHealthCheck resource to return.
       */
      public java.lang.String getHttpsHealthCheck() {
        return httpsHealthCheck;
      }

      /** Name of the HttpsHealthCheck resource to return. */
      public Get setHttpsHealthCheck(java.lang.String httpsHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPS_HEALTH_CHECK_PATTERN.matcher(httpsHealthCheck).matches(),
              "Parameter httpsHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpsHealthCheck = httpsHealthCheck;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a HttpsHealthCheck resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "httpsHealthChecks.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.HttpsHealthCheck}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.HttpsHealthCheck content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpsHealthChecks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a HttpsHealthCheck resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "httpsHealthChecks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.HttpsHealthCheck}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.HttpsHealthCheck content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of HttpsHealthCheck resources available to the specified project.
     *
     * Create a request for the method "httpsHealthChecks.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.HttpsHealthCheckList> {

      private static final String REST_PATH = "{project}/global/httpsHealthChecks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of HttpsHealthCheck resources available to the specified project.
       *
       * Create a request for the method "httpsHealthChecks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.HttpsHealthCheckList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a HttpsHealthCheck resource in the specified project using the data included in the
     * request. This method supports PATCH semantics and uses the JSON merge patch format and processing
     * rules.
     *
     * Create a request for the method "httpsHealthChecks.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param httpsHealthCheck Name of the HttpsHealthCheck resource to patch.
     * @param content the {@link com.google.api.services.compute.model.HttpsHealthCheck}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String httpsHealthCheck, com.google.api.services.compute.model.HttpsHealthCheck content) throws java.io.IOException {
      Patch result = new Patch(project, httpsHealthCheck, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpsHealthChecks/{httpsHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTPS_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates a HttpsHealthCheck resource in the specified project using the data included in the
       * request. This method supports PATCH semantics and uses the JSON merge patch format and
       * processing rules.
       *
       * Create a request for the method "httpsHealthChecks.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param httpsHealthCheck Name of the HttpsHealthCheck resource to patch.
       * @param content the {@link com.google.api.services.compute.model.HttpsHealthCheck}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String httpsHealthCheck, com.google.api.services.compute.model.HttpsHealthCheck content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpsHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpsHealthCheck, "Required parameter httpsHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPS_HEALTH_CHECK_PATTERN.matcher(httpsHealthCheck).matches(),
              "Parameter httpsHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpsHealthCheck resource to patch. */
      @com.google.api.client.util.Key
      private java.lang.String httpsHealthCheck;

      /** Name of the HttpsHealthCheck resource to patch.
       */
      public java.lang.String getHttpsHealthCheck() {
        return httpsHealthCheck;
      }

      /** Name of the HttpsHealthCheck resource to patch. */
      public Patch setHttpsHealthCheck(java.lang.String httpsHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPS_HEALTH_CHECK_PATTERN.matcher(httpsHealthCheck).matches(),
              "Parameter httpsHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpsHealthCheck = httpsHealthCheck;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Patch setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates a HttpsHealthCheck resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "httpsHealthChecks.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param httpsHealthCheck Name of the HttpsHealthCheck resource to update.
     * @param content the {@link com.google.api.services.compute.model.HttpsHealthCheck}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String httpsHealthCheck, com.google.api.services.compute.model.HttpsHealthCheck content) throws java.io.IOException {
      Update result = new Update(project, httpsHealthCheck, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpsHealthChecks/{httpsHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTPS_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates a HttpsHealthCheck resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "httpsHealthChecks.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param httpsHealthCheck Name of the HttpsHealthCheck resource to update.
       * @param content the {@link com.google.api.services.compute.model.HttpsHealthCheck}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String httpsHealthCheck, com.google.api.services.compute.model.HttpsHealthCheck content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpsHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpsHealthCheck, "Required parameter httpsHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPS_HEALTH_CHECK_PATTERN.matcher(httpsHealthCheck).matches(),
              "Parameter httpsHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpsHealthCheck resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String httpsHealthCheck;

      /** Name of the HttpsHealthCheck resource to update.
       */
      public java.lang.String getHttpsHealthCheck() {
        return httpsHealthCheck;
      }

      /** Name of the HttpsHealthCheck resource to update. */
      public Update setHttpsHealthCheck(java.lang.String httpsHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPS_HEALTH_CHECK_PATTERN.matcher(httpsHealthCheck).matches(),
              "Parameter httpsHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpsHealthCheck = httpsHealthCheck;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Update setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Images collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Images.List request = compute.images().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Images images() {
    return new Images();
  }

  /**
   * The "images" collection of methods.
   */
  public class Images {

    /**
     * Deletes the specified image.
     *
     * Create a request for the method "images.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param image Name of the image resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String image) throws java.io.IOException {
      Delete result = new Delete(project, image);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/images/{image}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern IMAGE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified image.
       *
       * Create a request for the method "images.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param image Name of the image resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String image) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.image = com.google.api.client.util.Preconditions.checkNotNull(image, "Required parameter image must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the image resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String image;

      /** Name of the image resource to delete.
       */
      public java.lang.String getImage() {
        return image;
      }

      /** Name of the image resource to delete. */
      public Delete setImage(java.lang.String image) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.image = image;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Sets the deprecation status of an image.
     *
     * If an empty request body is given, clears the deprecation status instead.
     *
     * Create a request for the method "images.deprecate".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Deprecate#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param image Image name.
     * @param content the {@link com.google.api.services.compute.model.DeprecationStatus}
     * @return the request
     */
    public Deprecate deprecate(java.lang.String project, java.lang.String image, com.google.api.services.compute.model.DeprecationStatus content) throws java.io.IOException {
      Deprecate result = new Deprecate(project, image, content);
      initialize(result);
      return result;
    }

    public class Deprecate extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/images/{image}/deprecate";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern IMAGE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets the deprecation status of an image.
       *
       * If an empty request body is given, clears the deprecation status instead.
       *
       * Create a request for the method "images.deprecate".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Deprecate#execute()} method to invoke the remote operation. <p>
       * {@link
       * Deprecate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param image Image name.
       * @param content the {@link com.google.api.services.compute.model.DeprecationStatus}
       * @since 1.13
       */
      protected Deprecate(java.lang.String project, java.lang.String image, com.google.api.services.compute.model.DeprecationStatus content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.image = com.google.api.client.util.Preconditions.checkNotNull(image, "Required parameter image must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Deprecate setAlt(java.lang.String alt) {
        return (Deprecate) super.setAlt(alt);
      }

      @Override
      public Deprecate setFields(java.lang.String fields) {
        return (Deprecate) super.setFields(fields);
      }

      @Override
      public Deprecate setKey(java.lang.String key) {
        return (Deprecate) super.setKey(key);
      }

      @Override
      public Deprecate setOauthToken(java.lang.String oauthToken) {
        return (Deprecate) super.setOauthToken(oauthToken);
      }

      @Override
      public Deprecate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Deprecate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Deprecate setQuotaUser(java.lang.String quotaUser) {
        return (Deprecate) super.setQuotaUser(quotaUser);
      }

      @Override
      public Deprecate setUserIp(java.lang.String userIp) {
        return (Deprecate) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Deprecate setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Image name. */
      @com.google.api.client.util.Key
      private java.lang.String image;

      /** Image name.
       */
      public java.lang.String getImage() {
        return image;
      }

      /** Image name. */
      public Deprecate setImage(java.lang.String image) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.image = image;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Deprecate setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Deprecate set(String parameterName, Object value) {
        return (Deprecate) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified image. Gets a list of available images by making a list() request.
     *
     * Create a request for the method "images.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param image Name of the image resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String image) throws java.io.IOException {
      Get result = new Get(project, image);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Image> {

      private static final String REST_PATH = "{project}/global/images/{image}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern IMAGE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified image. Gets a list of available images by making a list() request.
       *
       * Create a request for the method "images.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param image Name of the image resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String image) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Image.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.image = com.google.api.client.util.Preconditions.checkNotNull(image, "Required parameter image must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the image resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String image;

      /** Name of the image resource to return.
       */
      public java.lang.String getImage() {
        return image;
      }

      /** Name of the image resource to return. */
      public Get setImage(java.lang.String image) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.image = image;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Returns the latest image that is part of an image family and is not deprecated.
     *
     * Create a request for the method "images.getFromFamily".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetFromFamily#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param family Name of the image family to search for.
     * @return the request
     */
    public GetFromFamily getFromFamily(java.lang.String project, java.lang.String family) throws java.io.IOException {
      GetFromFamily result = new GetFromFamily(project, family);
      initialize(result);
      return result;
    }

    public class GetFromFamily extends ComputeRequest<com.google.api.services.compute.model.Image> {

      private static final String REST_PATH = "{project}/global/images/family/{family}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FAMILY_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the latest image that is part of an image family and is not deprecated.
       *
       * Create a request for the method "images.getFromFamily".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetFromFamily#execute()} method to invoke the remote operation. <p>
       * {@link GetFromFamily#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientR
       * equest)} must be called to initialize this instance immediately after invoking the constructor.
       * </p>
       *
       * @param project Project ID for this request.
       * @param family Name of the image family to search for.
       * @since 1.13
       */
      protected GetFromFamily(java.lang.String project, java.lang.String family) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Image.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.family = com.google.api.client.util.Preconditions.checkNotNull(family, "Required parameter family must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FAMILY_PATTERN.matcher(family).matches(),
              "Parameter family must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetFromFamily setAlt(java.lang.String alt) {
        return (GetFromFamily) super.setAlt(alt);
      }

      @Override
      public GetFromFamily setFields(java.lang.String fields) {
        return (GetFromFamily) super.setFields(fields);
      }

      @Override
      public GetFromFamily setKey(java.lang.String key) {
        return (GetFromFamily) super.setKey(key);
      }

      @Override
      public GetFromFamily setOauthToken(java.lang.String oauthToken) {
        return (GetFromFamily) super.setOauthToken(oauthToken);
      }

      @Override
      public GetFromFamily setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetFromFamily) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetFromFamily setQuotaUser(java.lang.String quotaUser) {
        return (GetFromFamily) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetFromFamily setUserIp(java.lang.String userIp) {
        return (GetFromFamily) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public GetFromFamily setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the image family to search for. */
      @com.google.api.client.util.Key
      private java.lang.String family;

      /** Name of the image family to search for.
       */
      public java.lang.String getFamily() {
        return family;
      }

      /** Name of the image family to search for. */
      public GetFromFamily setFamily(java.lang.String family) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FAMILY_PATTERN.matcher(family).matches(),
              "Parameter family must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.family = family;
        return this;
      }

      @Override
      public GetFromFamily set(String parameterName, Object value) {
        return (GetFromFamily) super.set(parameterName, value);
      }
    }
    /**
     * Creates an image in the specified project using the data included in the request.
     *
     * Create a request for the method "images.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.Image}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Image content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/images";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates an image in the specified project using the data included in the request.
       *
       * Create a request for the method "images.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.Image}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Image content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Force image creation if true. */
      @com.google.api.client.util.Key
      private java.lang.Boolean forceCreate;

      /** Force image creation if true.
       */
      public java.lang.Boolean getForceCreate() {
        return forceCreate;
      }

      /** Force image creation if true. */
      public Insert setForceCreate(java.lang.Boolean forceCreate) {
        this.forceCreate = forceCreate;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of custom images available to the specified project. Custom images are images
     * you create that belong to your project. This method does not get any images that belong to other
     * projects, including publicly-available images, like Debian 8. If you want to get a list of
     * publicly-available images, use this method to make a request to the respective image project,
     * such as debian-cloud or windows-cloud.
     *
     * Create a request for the method "images.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ImageList> {

      private static final String REST_PATH = "{project}/global/images";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of custom images available to the specified project. Custom images are
       * images you create that belong to your project. This method does not get any images that belong
       * to other projects, including publicly-available images, like Debian 8. If you want to get a
       * list of publicly-available images, use this method to make a request to the respective image
       * project, such as debian-cloud or windows-cloud.
       *
       * Create a request for the method "images.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ImageList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Sets the labels on an image. To learn more about labels, read the Labeling Resources
     * documentation.
     *
     * Create a request for the method "images.setLabels".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetLabels#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param resource Name of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.GlobalSetLabelsRequest}
     * @return the request
     */
    public SetLabels setLabels(java.lang.String project, java.lang.String resource, com.google.api.services.compute.model.GlobalSetLabelsRequest content) throws java.io.IOException {
      SetLabels result = new SetLabels(project, resource, content);
      initialize(result);
      return result;
    }

    public class SetLabels extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/images/{resource}/setLabels";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?");

      /**
       * Sets the labels on an image. To learn more about labels, read the Labeling Resources
       * documentation.
       *
       * Create a request for the method "images.setLabels".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetLabels#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetLabels#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param resource Name of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.GlobalSetLabelsRequest}
       * @since 1.13
       */
      protected SetLabels(java.lang.String project, java.lang.String resource, com.google.api.services.compute.model.GlobalSetLabelsRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetLabels setAlt(java.lang.String alt) {
        return (SetLabels) super.setAlt(alt);
      }

      @Override
      public SetLabels setFields(java.lang.String fields) {
        return (SetLabels) super.setFields(fields);
      }

      @Override
      public SetLabels setKey(java.lang.String key) {
        return (SetLabels) super.setKey(key);
      }

      @Override
      public SetLabels setOauthToken(java.lang.String oauthToken) {
        return (SetLabels) super.setOauthToken(oauthToken);
      }

      @Override
      public SetLabels setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetLabels) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetLabels setQuotaUser(java.lang.String quotaUser) {
        return (SetLabels) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetLabels setUserIp(java.lang.String userIp) {
        return (SetLabels) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetLabels setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name of the resource for this request. */
      public SetLabels setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public SetLabels set(String parameterName, Object value) {
        return (SetLabels) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the InstanceGroupManagers collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.InstanceGroupManagers.List request = compute.instanceGroupManagers().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public InstanceGroupManagers instanceGroupManagers() {
    return new InstanceGroupManagers();
  }

  /**
   * The "instanceGroupManagers" collection of methods.
   */
  public class InstanceGroupManagers {

    /**
     * Schedules a group action to remove the specified instances from the managed instance group.
     * Abandoning an instance does not delete the instance, but it does remove the instance from any
     * target pools that are applied by the managed instance group. This method reduces the targetSize
     * of the managed instance group by the number of instances that you abandon. This operation is
     * marked as DONE when the action is scheduled even if the instances have not yet been removed from
     * the group. You must separately verify the status of the abandoning action with the
     * listmanagedinstances method.
     *
     * If the group is part of a backend service that has enabled connection draining, it can take up to
     * 60 seconds after the connection draining duration has elapsed before the VM instance is removed
     * or deleted.
     *
     * You can specify a maximum of 1000 instances with this method per request.
     *
     * Create a request for the method "instanceGroupManagers.abandonInstances".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AbandonInstances#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @param instanceGroupManager The name of the managed instance group.
     * @param content the {@link com.google.api.services.compute.model.InstanceGroupManagersAbandonInstancesRequest}
     * @return the request
     */
    public AbandonInstances abandonInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, com.google.api.services.compute.model.InstanceGroupManagersAbandonInstancesRequest content) throws java.io.IOException {
      AbandonInstances result = new AbandonInstances(project, zone, instanceGroupManager, content);
      initialize(result);
      return result;
    }

    public class AbandonInstances extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/abandonInstances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Schedules a group action to remove the specified instances from the managed instance group.
       * Abandoning an instance does not delete the instance, but it does remove the instance from any
       * target pools that are applied by the managed instance group. This method reduces the targetSize
       * of the managed instance group by the number of instances that you abandon. This operation is
       * marked as DONE when the action is scheduled even if the instances have not yet been removed
       * from the group. You must separately verify the status of the abandoning action with the
       * listmanagedinstances method.
       *
       * If the group is part of a backend service that has enabled connection draining, it can take up
       * to 60 seconds after the connection draining duration has elapsed before the VM instance is
       * removed or deleted.
       *
       * You can specify a maximum of 1000 instances with this method per request.
       *
       * Create a request for the method "instanceGroupManagers.abandonInstances".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AbandonInstances#execute()} method to invoke the remote operation.
       * <p> {@link AbandonInstances#initialize(com.google.api.client.googleapis.services.AbstractGoogle
       * ClientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @param instanceGroupManager The name of the managed instance group.
       * @param content the {@link com.google.api.services.compute.model.InstanceGroupManagersAbandonInstancesRequest}
       * @since 1.13
       */
      protected AbandonInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, com.google.api.services.compute.model.InstanceGroupManagersAbandonInstancesRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroupManager = com.google.api.client.util.Preconditions.checkNotNull(instanceGroupManager, "Required parameter instanceGroupManager must be specified.");
      }

      @Override
      public AbandonInstances setAlt(java.lang.String alt) {
        return (AbandonInstances) super.setAlt(alt);
      }

      @Override
      public AbandonInstances setFields(java.lang.String fields) {
        return (AbandonInstances) super.setFields(fields);
      }

      @Override
      public AbandonInstances setKey(java.lang.String key) {
        return (AbandonInstances) super.setKey(key);
      }

      @Override
      public AbandonInstances setOauthToken(java.lang.String oauthToken) {
        return (AbandonInstances) super.setOauthToken(oauthToken);
      }

      @Override
      public AbandonInstances setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AbandonInstances) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AbandonInstances setQuotaUser(java.lang.String quotaUser) {
        return (AbandonInstances) super.setQuotaUser(quotaUser);
      }

      @Override
      public AbandonInstances setUserIp(java.lang.String userIp) {
        return (AbandonInstances) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AbandonInstances setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public AbandonInstances setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the managed instance group. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroupManager;

      /** The name of the managed instance group.
       */
      public java.lang.String getInstanceGroupManager() {
        return instanceGroupManager;
      }

      /** The name of the managed instance group. */
      public AbandonInstances setInstanceGroupManager(java.lang.String instanceGroupManager) {
        this.instanceGroupManager = instanceGroupManager;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public AbandonInstances setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public AbandonInstances set(String parameterName, Object value) {
        return (AbandonInstances) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of managed instance groups and groups them by zone.
     *
     * Create a request for the method "instanceGroupManagers.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.InstanceGroupManagerAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/instanceGroupManagers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of managed instance groups and groups them by zone.
       *
       * Create a request for the method "instanceGroupManagers.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceGroupManagerAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public AggregatedList setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified managed instance group and all of the instances in that group. Note that
     * the instance group must not belong to a backend service. Read  Deleting an instance group for
     * more information.
     *
     * Create a request for the method "instanceGroupManagers.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @param instanceGroupManager The name of the managed instance group to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager) throws java.io.IOException {
      Delete result = new Delete(project, zone, instanceGroupManager);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Deletes the specified managed instance group and all of the instances in that group. Note that
       * the instance group must not belong to a backend service. Read  Deleting an instance group for
       * more information.
       *
       * Create a request for the method "instanceGroupManagers.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @param instanceGroupManager The name of the managed instance group to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroupManager = com.google.api.client.util.Preconditions.checkNotNull(instanceGroupManager, "Required parameter instanceGroupManager must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public Delete setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the managed instance group to delete. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroupManager;

      /** The name of the managed instance group to delete.
       */
      public java.lang.String getInstanceGroupManager() {
        return instanceGroupManager;
      }

      /** The name of the managed instance group to delete. */
      public Delete setInstanceGroupManager(java.lang.String instanceGroupManager) {
        this.instanceGroupManager = instanceGroupManager;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Schedules a group action to delete the specified instances in the managed instance group. The
     * instances are also removed from any target pools of which they were a member. This method reduces
     * the targetSize of the managed instance group by the number of instances that you delete. This
     * operation is marked as DONE when the action is scheduled even if the instances are still being
     * deleted. You must separately verify the status of the deleting action with the
     * listmanagedinstances method.
     *
     * If the group is part of a backend service that has enabled connection draining, it can take up to
     * 60 seconds after the connection draining duration has elapsed before the VM instance is removed
     * or deleted.
     *
     * You can specify a maximum of 1000 instances with this method per request.
     *
     * Create a request for the method "instanceGroupManagers.deleteInstances".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link DeleteInstances#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @param instanceGroupManager The name of the managed instance group.
     * @param content the {@link com.google.api.services.compute.model.InstanceGroupManagersDeleteInstancesRequest}
     * @return the request
     */
    public DeleteInstances deleteInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, com.google.api.services.compute.model.InstanceGroupManagersDeleteInstancesRequest content) throws java.io.IOException {
      DeleteInstances result = new DeleteInstances(project, zone, instanceGroupManager, content);
      initialize(result);
      return result;
    }

    public class DeleteInstances extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/deleteInstances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Schedules a group action to delete the specified instances in the managed instance group. The
       * instances are also removed from any target pools of which they were a member. This method
       * reduces the targetSize of the managed instance group by the number of instances that you
       * delete. This operation is marked as DONE when the action is scheduled even if the instances are
       * still being deleted. You must separately verify the status of the deleting action with the
       * listmanagedinstances method.
       *
       * If the group is part of a backend service that has enabled connection draining, it can take up
       * to 60 seconds after the connection draining duration has elapsed before the VM instance is
       * removed or deleted.
       *
       * You can specify a maximum of 1000 instances with this method per request.
       *
       * Create a request for the method "instanceGroupManagers.deleteInstances".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link DeleteInstances#execute()} method to invoke the remote operation.
       * <p> {@link DeleteInstances#initialize(com.google.api.client.googleapis.services.AbstractGoogleC
       * lientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @param instanceGroupManager The name of the managed instance group.
       * @param content the {@link com.google.api.services.compute.model.InstanceGroupManagersDeleteInstancesRequest}
       * @since 1.13
       */
      protected DeleteInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, com.google.api.services.compute.model.InstanceGroupManagersDeleteInstancesRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroupManager = com.google.api.client.util.Preconditions.checkNotNull(instanceGroupManager, "Required parameter instanceGroupManager must be specified.");
      }

      @Override
      public DeleteInstances setAlt(java.lang.String alt) {
        return (DeleteInstances) super.setAlt(alt);
      }

      @Override
      public DeleteInstances setFields(java.lang.String fields) {
        return (DeleteInstances) super.setFields(fields);
      }

      @Override
      public DeleteInstances setKey(java.lang.String key) {
        return (DeleteInstances) super.setKey(key);
      }

      @Override
      public DeleteInstances setOauthToken(java.lang.String oauthToken) {
        return (DeleteInstances) super.setOauthToken(oauthToken);
      }

      @Override
      public DeleteInstances setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DeleteInstances) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DeleteInstances setQuotaUser(java.lang.String quotaUser) {
        return (DeleteInstances) super.setQuotaUser(quotaUser);
      }

      @Override
      public DeleteInstances setUserIp(java.lang.String userIp) {
        return (DeleteInstances) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public DeleteInstances setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public DeleteInstances setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the managed instance group. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroupManager;

      /** The name of the managed instance group.
       */
      public java.lang.String getInstanceGroupManager() {
        return instanceGroupManager;
      }

      /** The name of the managed instance group. */
      public DeleteInstances setInstanceGroupManager(java.lang.String instanceGroupManager) {
        this.instanceGroupManager = instanceGroupManager;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public DeleteInstances setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public DeleteInstances set(String parameterName, Object value) {
        return (DeleteInstances) super.set(parameterName, value);
      }
    }
    /**
     * Returns all of the details about the specified managed instance group. Gets a list of available
     * managed instance groups by making a list() request.
     *
     * Create a request for the method "instanceGroupManagers.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @param instanceGroupManager The name of the managed instance group.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager) throws java.io.IOException {
      Get result = new Get(project, zone, instanceGroupManager);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.InstanceGroupManager> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Returns all of the details about the specified managed instance group. Gets a list of available
       * managed instance groups by making a list() request.
       *
       * Create a request for the method "instanceGroupManagers.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @param instanceGroupManager The name of the managed instance group.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceGroupManager.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroupManager = com.google.api.client.util.Preconditions.checkNotNull(instanceGroupManager, "Required parameter instanceGroupManager must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public Get setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the managed instance group. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroupManager;

      /** The name of the managed instance group.
       */
      public java.lang.String getInstanceGroupManager() {
        return instanceGroupManager;
      }

      /** The name of the managed instance group. */
      public Get setInstanceGroupManager(java.lang.String instanceGroupManager) {
        this.instanceGroupManager = instanceGroupManager;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a managed instance group using the information that you specify in the request. After the
     * group is created, it schedules an action to create instances in the group using the specified
     * instance template. This operation is marked as DONE when the group is created even if the
     * instances in the group have not yet been created. You must separately verify the status of the
     * individual instances with the listmanagedinstances method.
     *
     * A managed instance group can have up to 1000 VM instances per group. Please contact Cloud Support
     * if you need an increase in this limit.
     *
     * Create a request for the method "instanceGroupManagers.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where you want to create the managed instance group.
     * @param content the {@link com.google.api.services.compute.model.InstanceGroupManager}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.InstanceGroupManager content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a managed instance group using the information that you specify in the request. After
       * the group is created, it schedules an action to create instances in the group using the
       * specified instance template. This operation is marked as DONE when the group is created even if
       * the instances in the group have not yet been created. You must separately verify the status of
       * the individual instances with the listmanagedinstances method.
       *
       * A managed instance group can have up to 1000 VM instances per group. Please contact Cloud
       * Support if you need an increase in this limit.
       *
       * Create a request for the method "instanceGroupManagers.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where you want to create the managed instance group.
       * @param content the {@link com.google.api.services.compute.model.InstanceGroupManager}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.InstanceGroupManager content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where you want to create the managed instance group. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where you want to create the managed instance group.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where you want to create the managed instance group. */
      public Insert setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of managed instance groups that are contained within the specified project and
     * zone.
     *
     * Create a request for the method "instanceGroupManagers.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.InstanceGroupManagerList> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves a list of managed instance groups that are contained within the specified project and
       * zone.
       *
       * Create a request for the method "instanceGroupManagers.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceGroupManagerList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public List setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, a comparison operator, and the value that you want to use for filtering. The value must
     be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.

     For example, if you are filtering Compute Engine instances, you can exclude instances named
     example-instance by specifying name != example-instance.

     You can also filter nested fields. For example, you could specify scheduling.automaticRestart =
     false to include instances only if they are not scheduled for automatic restarts. You can use
     filtering on nested fields to filter based on resource labels.

     To filter on multiple expressions, provide each separate expression within parentheses. For
     example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default, each
     expression is an AND expression. However, you can include AND and OR expressions explicitly. For
     example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
     (scheduling.automaticRestart = true).
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, a comparison operator, and the value that you want to use for
       * filtering. The value must be a string, a number, or a boolean. The comparison operator must
       * be either =, !=, >, or <.
       *
       * For example, if you are filtering Compute Engine instances, you can exclude instances named
       * example-instance by specifying name != example-instance.
       *
       * You can also filter nested fields. For example, you could specify
       * scheduling.automaticRestart = false to include instances only if they are not scheduled for
       * automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels.
       *
       * To filter on multiple expressions, provide each separate expression within parentheses. For
       * example, (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake"). By default,
       * each expression is an AND expression. However, you can include AND and OR expressions
       * explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
       * Broadwell") AND (scheduling.automaticRestart = true).
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than maxResults, Compute Engine returns a nextPageToken that can be used to get the next
     page of results in subsequent list requests. Acceptable values are 0 to 500, inclusive. (Default:
     500) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than maxResults, Compute Engine returns a nextPageToken that can be used
       * to get the next page of results in subsequent list requests. Acceptable values are 0 to
       * 500, inclusive. (Default: 500)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name.

     You can also sort results in descending order based on the creation timestamp using
     orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field in
     reverse chronological order (newest result first). Use this to sort resources like operations so
     that the newest operation is returned first.

     Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name.
       *
       * You can also sort results in descending order based on the creation timestamp using
       * orderBy="creationTimestamp desc". This sorts results based on the creationTimestamp field
       * in reverse chronological order (newest result first). Use this to sort resources like
       * operations so that the newest operation is returned first.
       *
       * Currently, only sorting by name or creationTimestamp desc is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set pageToken to the nextPageToken returned by a previous
       * list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Lists all of the instances in the managed instance group. Each instance in the list has a
     * currentAction, which indicates the action that the managed instance group is performing on the
     * instance. For example, if the group is still creating an instance, the currentAction is CREATING.
     * If a previous action failed, the list displays the errors for that failed action.
     *
     * Create a request for the method "instanceGroupManagers.listManagedInstances".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link ListManagedInstances#execute()} method to invoke the remote
     * operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @param instanceGroupManager The name of the managed instance group.
     * @return the request
     */
    public ListManagedInstances listManagedInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager) throws java.io.IOException {
      ListManagedInstances result = new ListManagedInstances(project, zone, instanceGroupManager);
      initialize(result);
      return result;
    }

    public class ListManagedInstances extends ComputeRequest<com.google.api.services.compute.model.InstanceGroupManagersListManagedInstancesResponse> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/listManagedInstances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Lists all of the instances in the managed instance group. Each instance in the list has a
       * currentAction, which indicates the action that the managed instance group is performing on the
       * instance. For example, if the group is still creating an instance, the currentAction is
       * CREATING. If a previous action failed, the list displays the errors for that failed action.
       *
       * Create a request for the method "instanceGroupManagers.listManagedInstances".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link ListManagedInstances#execute()} method to invoke the remote
       * operation. <p> {@link ListManagedInstances#initialize(com.google.api.client.googleapis.services
       * .AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @param instanceGroupManager The name of the managed instance group.
       * @since 1.13
       */
      protected ListManagedInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.InstanceGroupManagersListManagedInstancesResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroupManager = com.google.api.client.util.Preconditions.checkNotNull(instanceGroupManager, "Required parameter instanceGroupManager must be specified.");
      }

      @Override
      public ListManagedInstances setAlt(java.lang.String alt) {
        return (ListManagedInstances) super.setAlt(alt);
      }

      @Override
      public ListManagedInstances setFields(java.lang.String fields) {
        return (ListManagedInstances) super.setFields(fields);
      }

      @Override
      public ListManagedInstances setKey(java.lang.String key) {
        return (ListManagedInstances) super.setKey(key);
      }

      @Override
      public ListManagedInstances setOauthToken(java.lang.String oauthToken) {
        return (ListManagedInstances) super.setOauthToken(oauthToken);
      }

      @Override
      public ListManagedInstances setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ListManagedInstances) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ListManagedInstances setQuotaUser(java.lang.String quotaUser) {
        return (ListManagedInstances) super.setQuotaUser(quotaUser);
      }

      @Override
      public ListManagedInstances setUserIp(java.lang.String userIp) {
        return (ListManagedInstances) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public ListManagedInstances setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public ListManagedInstances setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the managed instance group. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroupManager;

      /** The name of the managed instance group.
       */
      public java.lang.String getInstanceGroupManager() {
        return instanceGroupManager;
      }

      /** The name of the managed instance group. */
      public ListManagedInstances setInstanceGroupManager(java.lang.String instanceGroupManager) {
        this.instanceGroupManager = instanceGroupManager;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String filter;

      /**

       */
      public java.lang.String getFilter() {
        return filter;
      }

      public ListManagedInstances setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /**
     [ default: 500] minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      public ListManagedInstances setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @com.google.api.client.util.Key("order_by")
      private java.lang.String orderBy;

      /**

       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      public ListManagedInstances setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /**

       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      public ListManagedInstances setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public ListManagedInstances set(String parameterName, Object value) {
        return (ListManagedInstances) super.set(parameterName, value);
      }
    }
    /**
     * Schedules a group action to recreate the specified instances in the managed instance group. The
     * instances are deleted and recreated using the current instance template for the managed instance
     * group. This operation is marked as DONE when the action is scheduled even if the instances have
     * not yet been recreated. You must separately verify the status of the recreating action with the
     * listmanagedinstances method.
     *
     * If the group is part of a backend service that has enabled connection draining, it can take up to
     * 60 seconds after the connection draining duration has elapsed before the VM instance is removed
     * or deleted.
     *
     * You can specify a maximum of 1000 instances with this method per request.
     *
     * Create a request for the method "instanceGroupManagers.recreateInstances".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link RecreateInstances#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @param instanceGroupManager The name of the managed instance group.
     * @param content the {@link com.google.api.services.compute.model.InstanceGroupManagersRecreateInstancesRequest}
     * @return the request
     */
    public RecreateInstances recreateInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, com.google.api.services.compute.model.InstanceGroupManagersRecreateInstancesRequest content) throws java.io.IOException {
      RecreateInstances result = new RecreateInstances(project, zone, instanceGroupManager, content);
      initialize(result);
      return result;
    }

    public class RecreateInstances extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/recreateInstances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Schedules a group action to recreate the specified instances in the managed instance group. The
       * instances are deleted and recreated using the current instance template for the managed
       * instance group. This operation is marked as DONE when the action is scheduled even if the
       * instances have not yet been recreated. You must separately verify the status of the recreating
       * action with the listmanagedinstances method.
       *
       * If the group is part of a backend service that has enabled connection draining, it can take up
       * to 60 seconds after the connection draining duration has elapsed before the VM instance is
       * removed or deleted.
       *
       * You can specify a maximum of 1000 instances with this method per request.
       *
       * Create a request for the method "instanceGroupManagers.recreateInstances".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link RecreateInstances#execute()} method to invoke the remote operation.
       * <p> {@link RecreateInstances#initialize(com.google.api.client.googleapis.services.AbstractGoogl
       * eClientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @param instanceGroupManager The name of the managed instance group.
       * @param content the {@link com.google.api.services.compute.model.InstanceGroupManagersRecreateInstancesRequest}
       * @since 1.13
       */
      protected RecreateInstances(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, com.google.api.services.compute.model.InstanceGroupManagersRecreateInstancesRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroupManager = com.google.api.client.util.Preconditions.checkNotNull(instanceGroupManager, "Required parameter instanceGroupManager must be specified.");
      }

      @Override
      public RecreateInstances setAlt(java.lang.String alt) {
        return (RecreateInstances) super.setAlt(alt);
      }

      @Override
      public RecreateInstances setFields(java.lang.String fields) {
        return (RecreateInstances) super.setFields(fields);
      }

      @Override
      public RecreateInstances setKey(java.lang.String key) {
        return (RecreateInstances) super.setKey(key);
      }

      @Override
      public RecreateInstances setOauthToken(java.lang.String oauthToken) {
        return (RecreateInstances) super.setOauthToken(oauthToken);
      }

      @Override
      public RecreateInstances setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RecreateInstances) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RecreateInstances setQuotaUser(java.lang.String quotaUser) {
        return (RecreateInstances) super.setQuotaUser(quotaUser);
      }

      @Override
      public RecreateInstances setUserIp(java.lang.String userIp) {
        return (RecreateInstances) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public RecreateInstances setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone where the managed instance group is located. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone where the managed instance group is located.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone where the managed instance group is located. */
      public RecreateInstances setZone(java.lang.String zone) {
        this.zone = zone;
        return this;
      }

      /** The name of the managed instance group. */
      @com.google.api.client.util.Key
      private java.lang.String instanceGroupManager;

      /** The name of the managed instance group.
       */
      public java.lang.String getInstanceGroupManager() {
        return instanceGroupManager;
      }

      /** The name of the managed instance group. */
      public RecreateInstances setInstanceGroupManager(java.lang.String instanceGroupManager) {
        this.instanceGroupManager = instanceGroupManager;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed.

     For example, consider a situation where you make an initial request and the request times out. If
     you make the request again with the same request ID, the server can check if original operation
     with the same request ID was received, and if so, will ignore the second request. This prevents
     clients from accidentally creating duplicate commitments.

     The request ID must be a valid UUID with the exception that zero UUID is not supported
     (00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed.
       *
       * For example, consider a situation where you make an initial request and the request times
       * out. If you make the request again with the same request ID, the server can check if
       * original operation with the same request ID was received, and if so, will ignore the second
       * request. This prevents clients from accidentally creating duplicate commitments.
       *
       * The request ID must be a valid UUID with the exception that zero UUID is not supported
       * (00000000-0000-0000-0000-000000000000).
       */
      public RecreateInstances setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public RecreateInstances set(String parameterName, Object value) {
        return (RecreateInstances) super.set(parameterName, value);
      }
    }
    /**
     * Resizes the managed instance group. If you increase the size, the group creates new instances
     * using the current instance template. If you decrease the size, the group deletes instances. The
     * resize operation is marked DONE when the resize actions are scheduled even if the group has not
     * yet added or deleted any instances. You must separately verify the status of the creating or
     * deleting actions with the listmanagedinstances method.
     *
     * If the group is part of a backend service that has enabled connection draining, it can take up to
     * 60 seconds after the connection draining duration has elapsed before the VM instance is removed
     * or deleted.
     *
     * Create a request for the method "instanceGroupManagers.resize".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Resize#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone where the managed instance group is located.
     * @param instanceGroupManager The name of the managed instance group.
     * @param size The number of running instances that the managed instance group should maintain at any given time.
     *        The group automatically adds or removes instances to maintain the number of instances
     *        specified by this parameter.
     * @return the request
     */
    public Resize resize(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, java.lang.Integer size) throws java.io.IOException {
      Resize result = new Resize(project, zone, instanceGroupManager, size);
      initialize(result);
      return result;
    }

    public class Resize extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resize";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Resizes the managed instance group. If you increase the size, the group creates new instances
       * using the current instance template. If you decrease the size, the group deletes instances. The
       * resize operation is marked DONE when the resize actions are scheduled even if the group has not
       * yet added or deleted any instances. You must separately verify the status of the creating or
       * deleting actions with the listmanagedinstances method.
       *
       * If the group is part of a backend service that has enabled connection draining, it can take up
       * to 60 seconds after the connection draining duration has elapsed before the VM instance is
       * removed or deleted.
       *
       * Create a request for the method "instanceGroupManagers.resize".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Resize#execute()} method to invoke the remote operation. <p> {@link
       * Resize#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone where the managed instance group is located.
       * @param instanceGroupManager The name of the managed instance group.
       * @param size The number of running instances that the managed instance group should maintain at any given time.
     *        The group automatically adds or removes instances to maintain the number of instances
     *        specified by this parameter.
       * @since 1.13
       */
      protected Resize(java.lang.String project, java.lang.String zone, java.lang.String instanceGroupManager, java.lang.Integer size) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        this.instanceGroupManager = com.google.api.client.util.Preconditions.checkNotNull(instanceGroupManager, "Required parameter instanceGroupManager must be specified.");
        this.size = com.google.api.client.util.Preconditions.checkNotNull(size, "Required param