/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-04-15 19:10:39 UTC)
 * on 2014-05-20 at 18:41:38 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Initialization parameters for the new disk (Mutually exclusive with 'source', can currently only
 * be specified on the boot disk).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AttachedDiskInitializeParams extends com.google.api.client.json.GenericJson {

  /**
   * Name of the disk (when not provided defaults to the name of the instance).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String diskName;

  /**
   * Size of the disk in base-2 GB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long diskSizeGb;

  /**
   * The source image used to create this disk.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceImage;

  /**
   * Name of the disk (when not provided defaults to the name of the instance).
   * @return value or {@code null} for none
   */
  public java.lang.String getDiskName() {
    return diskName;
  }

  /**
   * Name of the disk (when not provided defaults to the name of the instance).
   * @param diskName diskName or {@code null} for none
   */
  public AttachedDiskInitializeParams setDiskName(java.lang.String diskName) {
    this.diskName = diskName;
    return this;
  }

  /**
   * Size of the disk in base-2 GB.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDiskSizeGb() {
    return diskSizeGb;
  }

  /**
   * Size of the disk in base-2 GB.
   * @param diskSizeGb diskSizeGb or {@code null} for none
   */
  public AttachedDiskInitializeParams setDiskSizeGb(java.lang.Long diskSizeGb) {
    this.diskSizeGb = diskSizeGb;
    return this;
  }

  /**
   * The source image used to create this disk.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceImage() {
    return sourceImage;
  }

  /**
   * The source image used to create this disk.
   * @param sourceImage sourceImage or {@code null} for none
   */
  public AttachedDiskInitializeParams setSourceImage(java.lang.String sourceImage) {
    this.sourceImage = sourceImage;
    return this;
  }

  @Override
  public AttachedDiskInitializeParams set(String fieldName, Object value) {
    return (AttachedDiskInitializeParams) super.set(fieldName, value);
  }

  @Override
  public AttachedDiskInitializeParams clone() {
    return (AttachedDiskInitializeParams) super.clone();
  }

}
