/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-07-07 at 11:26:43 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The named port. For example: .
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NamedPort extends com.google.api.client.json.GenericJson {

  /**
   * The name for this named port. The name must be 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The port number, which can be a value between 1 and 65535.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer port;

  /**
   * The name for this named port. The name must be 1-63 characters long, and comply with RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name for this named port. The name must be 1-63 characters long, and comply with RFC1035.
   * @param name name or {@code null} for none
   */
  public NamedPort setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The port number, which can be a value between 1 and 65535.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPort() {
    return port;
  }

  /**
   * The port number, which can be a value between 1 and 65535.
   * @param port port or {@code null} for none
   */
  public NamedPort setPort(java.lang.Integer port) {
    this.port = port;
    return this;
  }

  @Override
  public NamedPort set(String fieldName, Object value) {
    return (NamedPort) super.set(fieldName, value);
  }

  @Override
  public NamedPort clone() {
    return (NamedPort) super.clone();
  }

}
