/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.compute;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.compute.ComputeRequest;
import com.google.api.services.compute.ComputeRequestInitializer;
import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.Address;
import com.google.api.services.compute.model.AddressAggregatedList;
import com.google.api.services.compute.model.AddressList;
import com.google.api.services.compute.model.AttachedDisk;
import com.google.api.services.compute.model.DeprecationStatus;
import com.google.api.services.compute.model.Disk;
import com.google.api.services.compute.model.DiskAggregatedList;
import com.google.api.services.compute.model.DiskList;
import com.google.api.services.compute.model.DiskType;
import com.google.api.services.compute.model.DiskTypeAggregatedList;
import com.google.api.services.compute.model.DiskTypeList;
import com.google.api.services.compute.model.Firewall;
import com.google.api.services.compute.model.FirewallList;
import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.ForwardingRuleAggregatedList;
import com.google.api.services.compute.model.ForwardingRuleList;
import com.google.api.services.compute.model.HttpHealthCheck;
import com.google.api.services.compute.model.HttpHealthCheckList;
import com.google.api.services.compute.model.Image;
import com.google.api.services.compute.model.ImageList;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceAggregatedList;
import com.google.api.services.compute.model.InstanceList;
import com.google.api.services.compute.model.InstanceReference;
import com.google.api.services.compute.model.MachineType;
import com.google.api.services.compute.model.MachineTypeAggregatedList;
import com.google.api.services.compute.model.MachineTypeList;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.Network;
import com.google.api.services.compute.model.NetworkList;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.OperationAggregatedList;
import com.google.api.services.compute.model.OperationList;
import com.google.api.services.compute.model.Project;
import com.google.api.services.compute.model.Region;
import com.google.api.services.compute.model.RegionList;
import com.google.api.services.compute.model.Route;
import com.google.api.services.compute.model.RouteList;
import com.google.api.services.compute.model.Scheduling;
import com.google.api.services.compute.model.SerialPortOutput;
import com.google.api.services.compute.model.Snapshot;
import com.google.api.services.compute.model.SnapshotList;
import com.google.api.services.compute.model.Tags;
import com.google.api.services.compute.model.TargetInstance;
import com.google.api.services.compute.model.TargetInstanceAggregatedList;
import com.google.api.services.compute.model.TargetInstanceList;
import com.google.api.services.compute.model.TargetPool;
import com.google.api.services.compute.model.TargetPoolAggregatedList;
import com.google.api.services.compute.model.TargetPoolInstanceHealth;
import com.google.api.services.compute.model.TargetPoolList;
import com.google.api.services.compute.model.TargetPoolsAddHealthCheckRequest;
import com.google.api.services.compute.model.TargetPoolsAddInstanceRequest;
import com.google.api.services.compute.model.TargetPoolsRemoveHealthCheckRequest;
import com.google.api.services.compute.model.TargetPoolsRemoveInstanceRequest;
import com.google.api.services.compute.model.TargetReference;
import com.google.api.services.compute.model.Zone;
import com.google.api.services.compute.model.ZoneList;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compute
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "compute/v1/projects/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/compute/v1/projects/";

    public Compute(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Compute(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Addresses addresses() {
        return new Addresses();
    }

    public DiskTypes diskTypes() {
        return new DiskTypes();
    }

    public Disks disks() {
        return new Disks();
    }

    public Firewalls firewalls() {
        return new Firewalls();
    }

    public ForwardingRules forwardingRules() {
        return new ForwardingRules();
    }

    public GlobalOperations globalOperations() {
        return new GlobalOperations();
    }

    public HttpHealthChecks httpHealthChecks() {
        return new HttpHealthChecks();
    }

    public Images images() {
        return new Images();
    }

    public Instances instances() {
        return new Instances();
    }

    public MachineTypes machineTypes() {
        return new MachineTypes();
    }

    public Networks networks() {
        return new Networks();
    }

    public Projects projects() {
        return new Projects();
    }

    public RegionOperations regionOperations() {
        return new RegionOperations();
    }

    public Regions regions() {
        return new Regions();
    }

    public Routes routes() {
        return new Routes();
    }

    public Snapshots snapshots() {
        return new Snapshots();
    }

    public TargetInstances targetInstances() {
        return new TargetInstances();
    }

    public TargetPools targetPools() {
        return new TargetPools();
    }

    public ZoneOperations zoneOperations() {
        return new ZoneOperations();
    }

    public Zones zones() {
        return new Zones();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.15.0-rc of the Compute Engine API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Compute.DEFAULT_ROOT_URL, Compute.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Compute build() {
            return new Compute(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setComputeRequestInitializer(ComputeRequestInitializer computeRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)computeRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Zones {
        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<ZoneList> {
            private static final String REST_PATH = "{project}/zones";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, ZoneList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Zone> {
            private static final String REST_PATH = "{project}/zones/{zone}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Zone.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class ZoneOperations {
        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<OperationList> {
            private static final String REST_PATH = "{project}/zones/{zone}/operations";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, OperationList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String operation;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string3).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Get setOperation(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Void> {
            private static final String REST_PATH = "{project}/zones/{zone}/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String operation;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string3).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Delete setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Delete setOperation(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class TargetPools {
        public AddHealthCheck addHealthCheck(String string, String string2, String string3, TargetPoolsAddHealthCheckRequest targetPoolsAddHealthCheckRequest) throws IOException {
            AddHealthCheck addHealthCheck = new AddHealthCheck(string, string2, string3, targetPoolsAddHealthCheckRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)addHealthCheck);
            return addHealthCheck;
        }

        public AddInstance addInstance(String string, String string2, String string3, TargetPoolsAddInstanceRequest targetPoolsAddInstanceRequest) throws IOException {
            AddInstance addInstance = new AddInstance(string, string2, string3, targetPoolsAddInstanceRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)addInstance);
            return addInstance;
        }

        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetHealth getHealth(String string, String string2, String string3, InstanceReference instanceReference) throws IOException {
            GetHealth getHealth = new GetHealth(string, string2, string3, instanceReference);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)getHealth);
            return getHealth;
        }

        public Insert insert(String string, String string2, TargetPool targetPool) throws IOException {
            Insert insert = new Insert(string, string2, targetPool);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public RemoveHealthCheck removeHealthCheck(String string, String string2, String string3, TargetPoolsRemoveHealthCheckRequest targetPoolsRemoveHealthCheckRequest) throws IOException {
            RemoveHealthCheck removeHealthCheck = new RemoveHealthCheck(string, string2, string3, targetPoolsRemoveHealthCheckRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)removeHealthCheck);
            return removeHealthCheck;
        }

        public RemoveInstance removeInstance(String string, String string2, String string3, TargetPoolsRemoveInstanceRequest targetPoolsRemoveInstanceRequest) throws IOException {
            RemoveInstance removeInstance = new RemoveInstance(string, string2, string3, targetPoolsRemoveInstanceRequest);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)removeInstance);
            return removeInstance;
        }

        public SetBackup setBackup(String string, String string2, String string3, TargetReference targetReference) throws IOException {
            SetBackup setBackup = new SetBackup(string, string2, string3, targetReference);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setBackup);
            return setBackup;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetBackup
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/setBackup";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGETPOOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;
            @Key
            private Float failoverRatio;

            protected SetBackup(String string, String string2, String string3, TargetReference targetReference) {
                super(Compute.this, "POST", REST_PATH, (Object)targetReference, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGETPOOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETPOOL_PATTERN.matcher(string3).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public SetBackup setAlt(String string) {
                return (SetBackup)super.setAlt(string);
            }

            public SetBackup setFields(String string) {
                return (SetBackup)super.setFields(string);
            }

            public SetBackup setKey(String string) {
                return (SetBackup)super.setKey(string);
            }

            public SetBackup setOauthToken(String string) {
                return (SetBackup)super.setOauthToken(string);
            }

            public SetBackup setPrettyPrint(Boolean bl) {
                return (SetBackup)super.setPrettyPrint(bl);
            }

            public SetBackup setQuotaUser(String string) {
                return (SetBackup)super.setQuotaUser(string);
            }

            public SetBackup setUserIp(String string) {
                return (SetBackup)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetBackup setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public SetBackup setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public SetBackup setTargetPool(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETPOOL_PATTERN.matcher(string).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = string;
                return this;
            }

            public Float getFailoverRatio() {
                return this.failoverRatio;
            }

            public SetBackup setFailoverRatio(Float f) {
                this.failoverRatio = f;
                return this;
            }

            @Override
            public SetBackup set(String string, Object object) {
                return (SetBackup)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class RemoveInstance
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/removeInstance";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGETPOOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;

            protected RemoveInstance(String string, String string2, String string3, TargetPoolsRemoveInstanceRequest targetPoolsRemoveInstanceRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)targetPoolsRemoveInstanceRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGETPOOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETPOOL_PATTERN.matcher(string3).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public RemoveInstance setAlt(String string) {
                return (RemoveInstance)super.setAlt(string);
            }

            public RemoveInstance setFields(String string) {
                return (RemoveInstance)super.setFields(string);
            }

            public RemoveInstance setKey(String string) {
                return (RemoveInstance)super.setKey(string);
            }

            public RemoveInstance setOauthToken(String string) {
                return (RemoveInstance)super.setOauthToken(string);
            }

            public RemoveInstance setPrettyPrint(Boolean bl) {
                return (RemoveInstance)super.setPrettyPrint(bl);
            }

            public RemoveInstance setQuotaUser(String string) {
                return (RemoveInstance)super.setQuotaUser(string);
            }

            public RemoveInstance setUserIp(String string) {
                return (RemoveInstance)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public RemoveInstance setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public RemoveInstance setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public RemoveInstance setTargetPool(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETPOOL_PATTERN.matcher(string).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = string;
                return this;
            }

            @Override
            public RemoveInstance set(String string, Object object) {
                return (RemoveInstance)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class RemoveHealthCheck
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/removeHealthCheck";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGETPOOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;

            protected RemoveHealthCheck(String string, String string2, String string3, TargetPoolsRemoveHealthCheckRequest targetPoolsRemoveHealthCheckRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)targetPoolsRemoveHealthCheckRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGETPOOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETPOOL_PATTERN.matcher(string3).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public RemoveHealthCheck setAlt(String string) {
                return (RemoveHealthCheck)super.setAlt(string);
            }

            public RemoveHealthCheck setFields(String string) {
                return (RemoveHealthCheck)super.setFields(string);
            }

            public RemoveHealthCheck setKey(String string) {
                return (RemoveHealthCheck)super.setKey(string);
            }

            public RemoveHealthCheck setOauthToken(String string) {
                return (RemoveHealthCheck)super.setOauthToken(string);
            }

            public RemoveHealthCheck setPrettyPrint(Boolean bl) {
                return (RemoveHealthCheck)super.setPrettyPrint(bl);
            }

            public RemoveHealthCheck setQuotaUser(String string) {
                return (RemoveHealthCheck)super.setQuotaUser(string);
            }

            public RemoveHealthCheck setUserIp(String string) {
                return (RemoveHealthCheck)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public RemoveHealthCheck setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public RemoveHealthCheck setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public RemoveHealthCheck setTargetPool(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETPOOL_PATTERN.matcher(string).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = string;
                return this;
            }

            @Override
            public RemoveHealthCheck set(String string, Object object) {
                return (RemoveHealthCheck)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<TargetPoolList> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, TargetPoolList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;

            protected Insert(String string, String string2, TargetPool targetPool) {
                super(Compute.this, "POST", REST_PATH, (Object)targetPool, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Insert setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetHealth
        extends ComputeRequest<TargetPoolInstanceHealth> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/getHealth";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGETPOOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;

            protected GetHealth(String string, String string2, String string3, InstanceReference instanceReference) {
                super(Compute.this, "POST", REST_PATH, (Object)instanceReference, TargetPoolInstanceHealth.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGETPOOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETPOOL_PATTERN.matcher(string3).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public GetHealth setAlt(String string) {
                return (GetHealth)super.setAlt(string);
            }

            public GetHealth setFields(String string) {
                return (GetHealth)super.setFields(string);
            }

            public GetHealth setKey(String string) {
                return (GetHealth)super.setKey(string);
            }

            public GetHealth setOauthToken(String string) {
                return (GetHealth)super.setOauthToken(string);
            }

            public GetHealth setPrettyPrint(Boolean bl) {
                return (GetHealth)super.setPrettyPrint(bl);
            }

            public GetHealth setQuotaUser(String string) {
                return (GetHealth)super.setQuotaUser(string);
            }

            public GetHealth setUserIp(String string) {
                return (GetHealth)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public GetHealth setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public GetHealth setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public GetHealth setTargetPool(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETPOOL_PATTERN.matcher(string).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = string;
                return this;
            }

            @Override
            public GetHealth set(String string, Object object) {
                return (GetHealth)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<TargetPool> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGETPOOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, TargetPool.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGETPOOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETPOOL_PATTERN.matcher(string3).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public Get setTargetPool(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETPOOL_PATTERN.matcher(string).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGETPOOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGETPOOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETPOOL_PATTERN.matcher(string3).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public Delete setTargetPool(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETPOOL_PATTERN.matcher(string).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<TargetPoolAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/targetPools";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, TargetPoolAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AddInstance
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/addInstance";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGETPOOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;

            protected AddInstance(String string, String string2, String string3, TargetPoolsAddInstanceRequest targetPoolsAddInstanceRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)targetPoolsAddInstanceRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGETPOOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETPOOL_PATTERN.matcher(string3).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public AddInstance setAlt(String string) {
                return (AddInstance)super.setAlt(string);
            }

            public AddInstance setFields(String string) {
                return (AddInstance)super.setFields(string);
            }

            public AddInstance setKey(String string) {
                return (AddInstance)super.setKey(string);
            }

            public AddInstance setOauthToken(String string) {
                return (AddInstance)super.setOauthToken(string);
            }

            public AddInstance setPrettyPrint(Boolean bl) {
                return (AddInstance)super.setPrettyPrint(bl);
            }

            public AddInstance setQuotaUser(String string) {
                return (AddInstance)super.setQuotaUser(string);
            }

            public AddInstance setUserIp(String string) {
                return (AddInstance)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AddInstance setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public AddInstance setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public AddInstance setTargetPool(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETPOOL_PATTERN.matcher(string).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = string;
                return this;
            }

            @Override
            public AddInstance set(String string, Object object) {
                return (AddInstance)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AddHealthCheck
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/addHealthCheck";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGETPOOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;

            protected AddHealthCheck(String string, String string2, String string3, TargetPoolsAddHealthCheckRequest targetPoolsAddHealthCheckRequest) {
                super(Compute.this, "POST", REST_PATH, (Object)targetPoolsAddHealthCheckRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGETPOOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETPOOL_PATTERN.matcher(string3).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public AddHealthCheck setAlt(String string) {
                return (AddHealthCheck)super.setAlt(string);
            }

            public AddHealthCheck setFields(String string) {
                return (AddHealthCheck)super.setFields(string);
            }

            public AddHealthCheck setKey(String string) {
                return (AddHealthCheck)super.setKey(string);
            }

            public AddHealthCheck setOauthToken(String string) {
                return (AddHealthCheck)super.setOauthToken(string);
            }

            public AddHealthCheck setPrettyPrint(Boolean bl) {
                return (AddHealthCheck)super.setPrettyPrint(bl);
            }

            public AddHealthCheck setQuotaUser(String string) {
                return (AddHealthCheck)super.setQuotaUser(string);
            }

            public AddHealthCheck setUserIp(String string) {
                return (AddHealthCheck)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AddHealthCheck setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public AddHealthCheck setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public AddHealthCheck setTargetPool(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETPOOL_PATTERN.matcher(string).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = string;
                return this;
            }

            @Override
            public AddHealthCheck set(String string, Object object) {
                return (AddHealthCheck)super.set(string, object);
            }
        }
    }

    public class TargetInstances {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, TargetInstance targetInstance) throws IOException {
            Insert insert = new Insert(string, string2, targetInstance);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<TargetInstanceList> {
            private static final String REST_PATH = "{project}/zones/{zone}/targetInstances";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, TargetInstanceList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/targetInstances";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;

            protected Insert(String string, String string2, TargetInstance targetInstance) {
                super(Compute.this, "POST", REST_PATH, (Object)targetInstance, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Insert setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<TargetInstance> {
            private static final String REST_PATH = "{project}/zones/{zone}/targetInstances/{targetInstance}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern TARGETINSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String targetInstance;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, TargetInstance.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGETINSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetInstance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetInstance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETINSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter targetInstance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getTargetInstance() {
                return this.targetInstance;
            }

            public Get setTargetInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETINSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter targetInstance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetInstance = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/targetInstances/{targetInstance}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern TARGETINSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String targetInstance;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGETINSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetInstance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter targetInstance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETINSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter targetInstance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Delete setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getTargetInstance() {
                return this.targetInstance;
            }

            public Delete setTargetInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGETINSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter targetInstance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetInstance = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<TargetInstanceAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/targetInstances";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, TargetInstanceAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class Snapshots {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<SnapshotList> {
            private static final String REST_PATH = "{project}/global/snapshots";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, SnapshotList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Snapshot> {
            private static final String REST_PATH = "{project}/global/snapshots/{snapshot}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SNAPSHOT_PATTERN;
            @Key
            private String project;
            @Key
            private String snapshot;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Snapshot.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SNAPSHOT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.snapshot = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter snapshot must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(string2).matches(), (Object)"Parameter snapshot must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getSnapshot() {
                return this.snapshot;
            }

            public Get setSnapshot(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(string).matches(), (Object)"Parameter snapshot must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.snapshot = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/snapshots/{snapshot}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SNAPSHOT_PATTERN;
            @Key
            private String project;
            @Key
            private String snapshot;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SNAPSHOT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.snapshot = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter snapshot must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(string2).matches(), (Object)"Parameter snapshot must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getSnapshot() {
                return this.snapshot;
            }

            public Delete setSnapshot(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(string).matches(), (Object)"Parameter snapshot must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.snapshot = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Routes {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Route route) throws IOException {
            Insert insert = new Insert(string, route);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<RouteList> {
            private static final String REST_PATH = "{project}/global/routes";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, RouteList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/routes";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, Route route) {
                super(Compute.this, "POST", REST_PATH, (Object)route, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Route> {
            private static final String REST_PATH = "{project}/global/routes/{route}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ROUTE_PATTERN;
            @Key
            private String project;
            @Key
            private String route;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Route.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ROUTE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.route = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter route must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTE_PATTERN.matcher(string2).matches(), (Object)"Parameter route must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRoute() {
                return this.route;
            }

            public Get setRoute(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTE_PATTERN.matcher(string).matches(), (Object)"Parameter route must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.route = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/routes/{route}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ROUTE_PATTERN;
            @Key
            private String project;
            @Key
            private String route;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ROUTE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.route = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter route must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTE_PATTERN.matcher(string2).matches(), (Object)"Parameter route must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRoute() {
                return this.route;
            }

            public Delete setRoute(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTE_PATTERN.matcher(string).matches(), (Object)"Parameter route must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.route = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Regions {
        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<RegionList> {
            private static final String REST_PATH = "{project}/regions";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, RegionList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Region> {
            private static final String REST_PATH = "{project}/regions/{region}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Region.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class RegionOperations {
        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<OperationList> {
            private static final String REST_PATH = "{project}/regions/{region}/operations";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, OperationList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String operation;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string3).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Get setOperation(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Void> {
            private static final String REST_PATH = "{project}/regions/{region}/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String operation;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string3).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Delete setOperation(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Projects {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public SetCommonInstanceMetadata setCommonInstanceMetadata(String string, Metadata metadata) throws IOException {
            SetCommonInstanceMetadata setCommonInstanceMetadata = new SetCommonInstanceMetadata(string, metadata);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setCommonInstanceMetadata);
            return setCommonInstanceMetadata;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetCommonInstanceMetadata
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/setCommonInstanceMetadata";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected SetCommonInstanceMetadata(String string, Metadata metadata) {
                super(Compute.this, "POST", REST_PATH, (Object)metadata, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public SetCommonInstanceMetadata setAlt(String string) {
                return (SetCommonInstanceMetadata)super.setAlt(string);
            }

            public SetCommonInstanceMetadata setFields(String string) {
                return (SetCommonInstanceMetadata)super.setFields(string);
            }

            public SetCommonInstanceMetadata setKey(String string) {
                return (SetCommonInstanceMetadata)super.setKey(string);
            }

            public SetCommonInstanceMetadata setOauthToken(String string) {
                return (SetCommonInstanceMetadata)super.setOauthToken(string);
            }

            public SetCommonInstanceMetadata setPrettyPrint(Boolean bl) {
                return (SetCommonInstanceMetadata)super.setPrettyPrint(bl);
            }

            public SetCommonInstanceMetadata setQuotaUser(String string) {
                return (SetCommonInstanceMetadata)super.setQuotaUser(string);
            }

            public SetCommonInstanceMetadata setUserIp(String string) {
                return (SetCommonInstanceMetadata)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetCommonInstanceMetadata setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public SetCommonInstanceMetadata set(String string, Object object) {
                return (SetCommonInstanceMetadata)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Project> {
            private static final String REST_PATH = "{project}";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Get(String string) {
                super(Compute.this, "GET", REST_PATH, null, Project.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Networks {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Network network) throws IOException {
            Insert insert = new Insert(string, network);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<NetworkList> {
            private static final String REST_PATH = "{project}/global/networks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, NetworkList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/networks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, Network network) {
                super(Compute.this, "POST", REST_PATH, (Object)network, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Network> {
            private static final String REST_PATH = "{project}/global/networks/{network}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern NETWORK_PATTERN;
            @Key
            private String project;
            @Key
            private String network;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Network.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.NETWORK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.network = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter network must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NETWORK_PATTERN.matcher(string2).matches(), (Object)"Parameter network must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getNetwork() {
                return this.network;
            }

            public Get setNetwork(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NETWORK_PATTERN.matcher(string).matches(), (Object)"Parameter network must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.network = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/networks/{network}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern NETWORK_PATTERN;
            @Key
            private String project;
            @Key
            private String network;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.NETWORK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.network = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter network must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NETWORK_PATTERN.matcher(string2).matches(), (Object)"Parameter network must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getNetwork() {
                return this.network;
            }

            public Delete setNetwork(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NETWORK_PATTERN.matcher(string).matches(), (Object)"Parameter network must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.network = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class MachineTypes {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<MachineTypeList> {
            private static final String REST_PATH = "{project}/zones/{zone}/machineTypes";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, MachineTypeList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<MachineType> {
            private static final String REST_PATH = "{project}/zones/{zone}/machineTypes/{machineType}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern MACHINETYPE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String machineType;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, MachineType.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.MACHINETYPE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.machineType = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter machineType must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MACHINETYPE_PATTERN.matcher(string3).matches(), (Object)"Parameter machineType must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getMachineType() {
                return this.machineType;
            }

            public Get setMachineType(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MACHINETYPE_PATTERN.matcher(string).matches(), (Object)"Parameter machineType must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.machineType = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<MachineTypeAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/machineTypes";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, MachineTypeAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class Instances {
        public AddAccessConfig addAccessConfig(String string, String string2, String string3, String string4, AccessConfig accessConfig) throws IOException {
            AddAccessConfig addAccessConfig = new AddAccessConfig(string, string2, string3, string4, accessConfig);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)addAccessConfig);
            return addAccessConfig;
        }

        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public AttachDisk attachDisk(String string, String string2, String string3, AttachedDisk attachedDisk) throws IOException {
            AttachDisk attachDisk = new AttachDisk(string, string2, string3, attachedDisk);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)attachDisk);
            return attachDisk;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public DeleteAccessConfig deleteAccessConfig(String string, String string2, String string3, String string4, String string5) throws IOException {
            DeleteAccessConfig deleteAccessConfig = new DeleteAccessConfig(string, string2, string3, string4, string5);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)deleteAccessConfig);
            return deleteAccessConfig;
        }

        public DetachDisk detachDisk(String string, String string2, String string3, String string4) throws IOException {
            DetachDisk detachDisk = new DetachDisk(string, string2, string3, string4);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)detachDisk);
            return detachDisk;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetSerialPortOutput getSerialPortOutput(String string, String string2, String string3) throws IOException {
            GetSerialPortOutput getSerialPortOutput = new GetSerialPortOutput(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)getSerialPortOutput);
            return getSerialPortOutput;
        }

        public Insert insert(String string, String string2, Instance instance) throws IOException {
            Insert insert = new Insert(string, string2, instance);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Reset reset(String string, String string2, String string3) throws IOException {
            Reset reset = new Reset(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)reset);
            return reset;
        }

        public SetDiskAutoDelete setDiskAutoDelete(String string, String string2, String string3, Boolean bl, String string4) throws IOException {
            SetDiskAutoDelete setDiskAutoDelete = new SetDiskAutoDelete(string, string2, string3, bl, string4);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setDiskAutoDelete);
            return setDiskAutoDelete;
        }

        public SetMetadata setMetadata(String string, String string2, String string3, Metadata metadata) throws IOException {
            SetMetadata setMetadata = new SetMetadata(string, string2, string3, metadata);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setMetadata);
            return setMetadata;
        }

        public SetScheduling setScheduling(String string, String string2, String string3, Scheduling scheduling) throws IOException {
            SetScheduling setScheduling = new SetScheduling(string, string2, string3, scheduling);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setScheduling);
            return setScheduling;
        }

        public SetTags setTags(String string, String string2, String string3, Tags tags) throws IOException {
            SetTags setTags = new SetTags(string, string2, string3, tags);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setTags);
            return setTags;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetTags
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setTags";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected SetTags(String string, String string2, String string3, Tags tags) {
                super(Compute.this, "POST", REST_PATH, (Object)tags, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public SetTags setAlt(String string) {
                return (SetTags)super.setAlt(string);
            }

            public SetTags setFields(String string) {
                return (SetTags)super.setFields(string);
            }

            public SetTags setKey(String string) {
                return (SetTags)super.setKey(string);
            }

            public SetTags setOauthToken(String string) {
                return (SetTags)super.setOauthToken(string);
            }

            public SetTags setPrettyPrint(Boolean bl) {
                return (SetTags)super.setPrettyPrint(bl);
            }

            public SetTags setQuotaUser(String string) {
                return (SetTags)super.setQuotaUser(string);
            }

            public SetTags setUserIp(String string) {
                return (SetTags)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetTags setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public SetTags setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public SetTags setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public SetTags set(String string, Object object) {
                return (SetTags)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetScheduling
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setScheduling";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected SetScheduling(String string, String string2, String string3, Scheduling scheduling) {
                super(Compute.this, "POST", REST_PATH, (Object)scheduling, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public SetScheduling setAlt(String string) {
                return (SetScheduling)super.setAlt(string);
            }

            public SetScheduling setFields(String string) {
                return (SetScheduling)super.setFields(string);
            }

            public SetScheduling setKey(String string) {
                return (SetScheduling)super.setKey(string);
            }

            public SetScheduling setOauthToken(String string) {
                return (SetScheduling)super.setOauthToken(string);
            }

            public SetScheduling setPrettyPrint(Boolean bl) {
                return (SetScheduling)super.setPrettyPrint(bl);
            }

            public SetScheduling setQuotaUser(String string) {
                return (SetScheduling)super.setQuotaUser(string);
            }

            public SetScheduling setUserIp(String string) {
                return (SetScheduling)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetScheduling setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public SetScheduling setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public SetScheduling setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public SetScheduling set(String string, Object object) {
                return (SetScheduling)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetMetadata
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setMetadata";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected SetMetadata(String string, String string2, String string3, Metadata metadata) {
                super(Compute.this, "POST", REST_PATH, (Object)metadata, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public SetMetadata setAlt(String string) {
                return (SetMetadata)super.setAlt(string);
            }

            public SetMetadata setFields(String string) {
                return (SetMetadata)super.setFields(string);
            }

            public SetMetadata setKey(String string) {
                return (SetMetadata)super.setKey(string);
            }

            public SetMetadata setOauthToken(String string) {
                return (SetMetadata)super.setOauthToken(string);
            }

            public SetMetadata setPrettyPrint(Boolean bl) {
                return (SetMetadata)super.setPrettyPrint(bl);
            }

            public SetMetadata setQuotaUser(String string) {
                return (SetMetadata)super.setQuotaUser(string);
            }

            public SetMetadata setUserIp(String string) {
                return (SetMetadata)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetMetadata setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public SetMetadata setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public SetMetadata setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public SetMetadata set(String string, Object object) {
                return (SetMetadata)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetDiskAutoDelete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setDiskAutoDelete";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            private final Pattern DEVICENAME_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;
            @Key
            private Boolean autoDelete;
            @Key
            private String deviceName;

            protected SetDiskAutoDelete(String string, String string2, String string3, Boolean bl, String string4) {
                super(Compute.this, "POST", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.DEVICENAME_PATTERN = Pattern.compile("\\w[\\w.-]{0,254}");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.autoDelete = (Boolean)Preconditions.checkNotNull((Object)bl, (Object)"Required parameter autoDelete must be specified.");
                this.deviceName = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter deviceName must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEVICENAME_PATTERN.matcher(string4).matches(), (Object)"Parameter deviceName must conform to the pattern \\w[\\w.-]{0,254}");
                }
            }

            public SetDiskAutoDelete setAlt(String string) {
                return (SetDiskAutoDelete)super.setAlt(string);
            }

            public SetDiskAutoDelete setFields(String string) {
                return (SetDiskAutoDelete)super.setFields(string);
            }

            public SetDiskAutoDelete setKey(String string) {
                return (SetDiskAutoDelete)super.setKey(string);
            }

            public SetDiskAutoDelete setOauthToken(String string) {
                return (SetDiskAutoDelete)super.setOauthToken(string);
            }

            public SetDiskAutoDelete setPrettyPrint(Boolean bl) {
                return (SetDiskAutoDelete)super.setPrettyPrint(bl);
            }

            public SetDiskAutoDelete setQuotaUser(String string) {
                return (SetDiskAutoDelete)super.setQuotaUser(string);
            }

            public SetDiskAutoDelete setUserIp(String string) {
                return (SetDiskAutoDelete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetDiskAutoDelete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public SetDiskAutoDelete setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public SetDiskAutoDelete setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            public Boolean getAutoDelete() {
                return this.autoDelete;
            }

            public SetDiskAutoDelete setAutoDelete(Boolean bl) {
                this.autoDelete = bl;
                return this;
            }

            public String getDeviceName() {
                return this.deviceName;
            }

            public SetDiskAutoDelete setDeviceName(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEVICENAME_PATTERN.matcher(string).matches(), (Object)"Parameter deviceName must conform to the pattern \\w[\\w.-]{0,254}");
                }
                this.deviceName = string;
                return this;
            }

            @Override
            public SetDiskAutoDelete set(String string, Object object) {
                return (SetDiskAutoDelete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Reset
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/reset";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected Reset(String string, String string2, String string3) {
                super(Compute.this, "POST", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Reset setAlt(String string) {
                return (Reset)super.setAlt(string);
            }

            public Reset setFields(String string) {
                return (Reset)super.setFields(string);
            }

            public Reset setKey(String string) {
                return (Reset)super.setKey(string);
            }

            public Reset setOauthToken(String string) {
                return (Reset)super.setOauthToken(string);
            }

            public Reset setPrettyPrint(Boolean bl) {
                return (Reset)super.setPrettyPrint(bl);
            }

            public Reset setQuotaUser(String string) {
                return (Reset)super.setQuotaUser(string);
            }

            public Reset setUserIp(String string) {
                return (Reset)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Reset setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Reset setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Reset setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public Reset set(String string, Object object) {
                return (Reset)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<InstanceList> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, InstanceList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;

            protected Insert(String string, String string2, Instance instance) {
                super(Compute.this, "POST", REST_PATH, (Object)instance, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Insert setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetSerialPortOutput
        extends ComputeRequest<SerialPortOutput> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/serialPort";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected GetSerialPortOutput(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, SerialPortOutput.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetSerialPortOutput setAlt(String string) {
                return (GetSerialPortOutput)super.setAlt(string);
            }

            public GetSerialPortOutput setFields(String string) {
                return (GetSerialPortOutput)super.setFields(string);
            }

            public GetSerialPortOutput setKey(String string) {
                return (GetSerialPortOutput)super.setKey(string);
            }

            public GetSerialPortOutput setOauthToken(String string) {
                return (GetSerialPortOutput)super.setOauthToken(string);
            }

            public GetSerialPortOutput setPrettyPrint(Boolean bl) {
                return (GetSerialPortOutput)super.setPrettyPrint(bl);
            }

            public GetSerialPortOutput setQuotaUser(String string) {
                return (GetSerialPortOutput)super.setQuotaUser(string);
            }

            public GetSerialPortOutput setUserIp(String string) {
                return (GetSerialPortOutput)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public GetSerialPortOutput setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public GetSerialPortOutput setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public GetSerialPortOutput setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public GetSerialPortOutput set(String string, Object object) {
                return (GetSerialPortOutput)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Instance> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, Instance.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Get setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class DetachDisk
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/detachDisk";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            private final Pattern DEVICENAME_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;
            @Key
            private String deviceName;

            protected DetachDisk(String string, String string2, String string3, String string4) {
                super(Compute.this, "POST", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.DEVICENAME_PATTERN = Pattern.compile("\\w[\\w.-]{0,254}");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deviceName = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter deviceName must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEVICENAME_PATTERN.matcher(string4).matches(), (Object)"Parameter deviceName must conform to the pattern \\w[\\w.-]{0,254}");
                }
            }

            public DetachDisk setAlt(String string) {
                return (DetachDisk)super.setAlt(string);
            }

            public DetachDisk setFields(String string) {
                return (DetachDisk)super.setFields(string);
            }

            public DetachDisk setKey(String string) {
                return (DetachDisk)super.setKey(string);
            }

            public DetachDisk setOauthToken(String string) {
                return (DetachDisk)super.setOauthToken(string);
            }

            public DetachDisk setPrettyPrint(Boolean bl) {
                return (DetachDisk)super.setPrettyPrint(bl);
            }

            public DetachDisk setQuotaUser(String string) {
                return (DetachDisk)super.setQuotaUser(string);
            }

            public DetachDisk setUserIp(String string) {
                return (DetachDisk)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public DetachDisk setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public DetachDisk setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public DetachDisk setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            public String getDeviceName() {
                return this.deviceName;
            }

            public DetachDisk setDeviceName(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEVICENAME_PATTERN.matcher(string).matches(), (Object)"Parameter deviceName must conform to the pattern \\w[\\w.-]{0,254}");
                }
                this.deviceName = string;
                return this;
            }

            @Override
            public DetachDisk set(String string, Object object) {
                return (DetachDisk)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class DeleteAccessConfig
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/deleteAccessConfig";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;
            @Key
            private String accessConfig;
            @Key
            private String networkInterface;

            protected DeleteAccessConfig(String string, String string2, String string3, String string4, String string5) {
                super(Compute.this, "POST", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.accessConfig = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter accessConfig must be specified.");
                this.networkInterface = (String)Preconditions.checkNotNull((Object)string5, (Object)"Required parameter networkInterface must be specified.");
            }

            public DeleteAccessConfig setAlt(String string) {
                return (DeleteAccessConfig)super.setAlt(string);
            }

            public DeleteAccessConfig setFields(String string) {
                return (DeleteAccessConfig)super.setFields(string);
            }

            public DeleteAccessConfig setKey(String string) {
                return (DeleteAccessConfig)super.setKey(string);
            }

            public DeleteAccessConfig setOauthToken(String string) {
                return (DeleteAccessConfig)super.setOauthToken(string);
            }

            public DeleteAccessConfig setPrettyPrint(Boolean bl) {
                return (DeleteAccessConfig)super.setPrettyPrint(bl);
            }

            public DeleteAccessConfig setQuotaUser(String string) {
                return (DeleteAccessConfig)super.setQuotaUser(string);
            }

            public DeleteAccessConfig setUserIp(String string) {
                return (DeleteAccessConfig)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public DeleteAccessConfig setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public DeleteAccessConfig setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public DeleteAccessConfig setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            public String getAccessConfig() {
                return this.accessConfig;
            }

            public DeleteAccessConfig setAccessConfig(String string) {
                this.accessConfig = string;
                return this;
            }

            public String getNetworkInterface() {
                return this.networkInterface;
            }

            public DeleteAccessConfig setNetworkInterface(String string) {
                this.networkInterface = string;
                return this;
            }

            @Override
            public DeleteAccessConfig set(String string, Object object) {
                return (DeleteAccessConfig)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Delete setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Delete setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AttachDisk
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/attachDisk";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;

            protected AttachDisk(String string, String string2, String string3, AttachedDisk attachedDisk) {
                super(Compute.this, "POST", REST_PATH, (Object)attachedDisk, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public AttachDisk setAlt(String string) {
                return (AttachDisk)super.setAlt(string);
            }

            public AttachDisk setFields(String string) {
                return (AttachDisk)super.setFields(string);
            }

            public AttachDisk setKey(String string) {
                return (AttachDisk)super.setKey(string);
            }

            public AttachDisk setOauthToken(String string) {
                return (AttachDisk)super.setOauthToken(string);
            }

            public AttachDisk setPrettyPrint(Boolean bl) {
                return (AttachDisk)super.setPrettyPrint(bl);
            }

            public AttachDisk setQuotaUser(String string) {
                return (AttachDisk)super.setQuotaUser(string);
            }

            public AttachDisk setUserIp(String string) {
                return (AttachDisk)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AttachDisk setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public AttachDisk setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public AttachDisk setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public AttachDisk set(String string, Object object) {
                return (AttachDisk)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<InstanceAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/instances";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, InstanceAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AddAccessConfig
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/addAccessConfig";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String instance;
            @Key
            private String networkInterface;

            protected AddAccessConfig(String string, String string2, String string3, String string4, AccessConfig accessConfig) {
                super(Compute.this, "POST", REST_PATH, (Object)accessConfig, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string3).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.networkInterface = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter networkInterface must be specified.");
            }

            public AddAccessConfig setAlt(String string) {
                return (AddAccessConfig)super.setAlt(string);
            }

            public AddAccessConfig setFields(String string) {
                return (AddAccessConfig)super.setFields(string);
            }

            public AddAccessConfig setKey(String string) {
                return (AddAccessConfig)super.setKey(string);
            }

            public AddAccessConfig setOauthToken(String string) {
                return (AddAccessConfig)super.setOauthToken(string);
            }

            public AddAccessConfig setPrettyPrint(Boolean bl) {
                return (AddAccessConfig)super.setPrettyPrint(bl);
            }

            public AddAccessConfig setQuotaUser(String string) {
                return (AddAccessConfig)super.setQuotaUser(string);
            }

            public AddAccessConfig setUserIp(String string) {
                return (AddAccessConfig)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AddAccessConfig setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public AddAccessConfig setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public AddAccessConfig setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            public String getNetworkInterface() {
                return this.networkInterface;
            }

            public AddAccessConfig setNetworkInterface(String string) {
                this.networkInterface = string;
                return this;
            }

            @Override
            public AddAccessConfig set(String string, Object object) {
                return (AddAccessConfig)super.set(string, object);
            }
        }
    }

    public class Images {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Deprecate deprecate(String string, String string2, DeprecationStatus deprecationStatus) throws IOException {
            Deprecate deprecate = new Deprecate(string, string2, deprecationStatus);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)deprecate);
            return deprecate;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Image image) throws IOException {
            Insert insert = new Insert(string, image);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<ImageList> {
            private static final String REST_PATH = "{project}/global/images";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, ImageList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/images";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, Image image) {
                super(Compute.this, "POST", REST_PATH, (Object)image, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Image> {
            private static final String REST_PATH = "{project}/global/images/{image}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern IMAGE_PATTERN;
            @Key
            private String project;
            @Key
            private String image;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Image.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.IMAGE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.image = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter image must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IMAGE_PATTERN.matcher(string2).matches(), (Object)"Parameter image must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getImage() {
                return this.image;
            }

            public Get setImage(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IMAGE_PATTERN.matcher(string).matches(), (Object)"Parameter image must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.image = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Deprecate
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/images/{image}/deprecate";
            private final Pattern PROJECT_PATTERN;
            private final Pattern IMAGE_PATTERN;
            @Key
            private String project;
            @Key
            private String image;

            protected Deprecate(String string, String string2, DeprecationStatus deprecationStatus) {
                super(Compute.this, "POST", REST_PATH, (Object)deprecationStatus, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.IMAGE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.image = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter image must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IMAGE_PATTERN.matcher(string2).matches(), (Object)"Parameter image must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Deprecate setAlt(String string) {
                return (Deprecate)super.setAlt(string);
            }

            public Deprecate setFields(String string) {
                return (Deprecate)super.setFields(string);
            }

            public Deprecate setKey(String string) {
                return (Deprecate)super.setKey(string);
            }

            public Deprecate setOauthToken(String string) {
                return (Deprecate)super.setOauthToken(string);
            }

            public Deprecate setPrettyPrint(Boolean bl) {
                return (Deprecate)super.setPrettyPrint(bl);
            }

            public Deprecate setQuotaUser(String string) {
                return (Deprecate)super.setQuotaUser(string);
            }

            public Deprecate setUserIp(String string) {
                return (Deprecate)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Deprecate setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getImage() {
                return this.image;
            }

            public Deprecate setImage(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IMAGE_PATTERN.matcher(string).matches(), (Object)"Parameter image must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.image = string;
                return this;
            }

            @Override
            public Deprecate set(String string, Object object) {
                return (Deprecate)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/images/{image}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern IMAGE_PATTERN;
            @Key
            private String project;
            @Key
            private String image;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.IMAGE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.image = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter image must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IMAGE_PATTERN.matcher(string2).matches(), (Object)"Parameter image must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getImage() {
                return this.image;
            }

            public Delete setImage(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IMAGE_PATTERN.matcher(string).matches(), (Object)"Parameter image must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.image = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class HttpHealthChecks {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, HttpHealthCheck httpHealthCheck) throws IOException {
            Insert insert = new Insert(string, httpHealthCheck);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, HttpHealthCheck httpHealthCheck) throws IOException {
            Patch patch = new Patch(string, string2, httpHealthCheck);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, HttpHealthCheck httpHealthCheck) throws IOException {
            Update update = new Update(string, string2, httpHealthCheck);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern HTTPHEALTHCHECK_PATTERN;
            @Key
            private String project;
            @Key
            private String httpHealthCheck;

            protected Update(String string, String string2, HttpHealthCheck httpHealthCheck) {
                super(Compute.this, "PUT", REST_PATH, (Object)httpHealthCheck, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.HTTPHEALTHCHECK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.httpHealthCheck = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter httpHealthCheck must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTPHEALTHCHECK_PATTERN.matcher(string2).matches(), (Object)"Parameter httpHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getHttpHealthCheck() {
                return this.httpHealthCheck;
            }

            public Update setHttpHealthCheck(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTPHEALTHCHECK_PATTERN.matcher(string).matches(), (Object)"Parameter httpHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.httpHealthCheck = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern HTTPHEALTHCHECK_PATTERN;
            @Key
            private String project;
            @Key
            private String httpHealthCheck;

            protected Patch(String string, String string2, HttpHealthCheck httpHealthCheck) {
                super(Compute.this, "PATCH", REST_PATH, (Object)httpHealthCheck, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.HTTPHEALTHCHECK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.httpHealthCheck = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter httpHealthCheck must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTPHEALTHCHECK_PATTERN.matcher(string2).matches(), (Object)"Parameter httpHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getHttpHealthCheck() {
                return this.httpHealthCheck;
            }

            public Patch setHttpHealthCheck(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTPHEALTHCHECK_PATTERN.matcher(string).matches(), (Object)"Parameter httpHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.httpHealthCheck = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<HttpHealthCheckList> {
            private static final String REST_PATH = "{project}/global/httpHealthChecks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, HttpHealthCheckList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/httpHealthChecks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, HttpHealthCheck httpHealthCheck) {
                super(Compute.this, "POST", REST_PATH, (Object)httpHealthCheck, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<HttpHealthCheck> {
            private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern HTTPHEALTHCHECK_PATTERN;
            @Key
            private String project;
            @Key
            private String httpHealthCheck;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, HttpHealthCheck.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.HTTPHEALTHCHECK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.httpHealthCheck = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter httpHealthCheck must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTPHEALTHCHECK_PATTERN.matcher(string2).matches(), (Object)"Parameter httpHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getHttpHealthCheck() {
                return this.httpHealthCheck;
            }

            public Get setHttpHealthCheck(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTPHEALTHCHECK_PATTERN.matcher(string).matches(), (Object)"Parameter httpHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.httpHealthCheck = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern HTTPHEALTHCHECK_PATTERN;
            @Key
            private String project;
            @Key
            private String httpHealthCheck;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.HTTPHEALTHCHECK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.httpHealthCheck = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter httpHealthCheck must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTPHEALTHCHECK_PATTERN.matcher(string2).matches(), (Object)"Parameter httpHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getHttpHealthCheck() {
                return this.httpHealthCheck;
            }

            public Delete setHttpHealthCheck(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.HTTPHEALTHCHECK_PATTERN.matcher(string).matches(), (Object)"Parameter httpHealthCheck must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.httpHealthCheck = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class GlobalOperations {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<OperationList> {
            private static final String REST_PATH = "{project}/global/operations";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, OperationList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String operation;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string2).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Get setOperation(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Void> {
            private static final String REST_PATH = "{project}/global/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String operation;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string2).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Delete setOperation(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<OperationAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/operations";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, OperationAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class ForwardingRules {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, ForwardingRule forwardingRule) throws IOException {
            Insert insert = new Insert(string, string2, forwardingRule);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public SetTarget setTarget(String string, String string2, String string3, TargetReference targetReference) throws IOException {
            SetTarget setTarget = new SetTarget(string, string2, string3, targetReference);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setTarget);
            return setTarget;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetTarget
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}/setTarget";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern FORWARDINGRULE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String forwardingRule;

            protected SetTarget(String string, String string2, String string3, TargetReference targetReference) {
                super(Compute.this, "POST", REST_PATH, (Object)targetReference, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.FORWARDINGRULE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.forwardingRule = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter forwardingRule must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDINGRULE_PATTERN.matcher(string3).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public SetTarget setAlt(String string) {
                return (SetTarget)super.setAlt(string);
            }

            public SetTarget setFields(String string) {
                return (SetTarget)super.setFields(string);
            }

            public SetTarget setKey(String string) {
                return (SetTarget)super.setKey(string);
            }

            public SetTarget setOauthToken(String string) {
                return (SetTarget)super.setOauthToken(string);
            }

            public SetTarget setPrettyPrint(Boolean bl) {
                return (SetTarget)super.setPrettyPrint(bl);
            }

            public SetTarget setQuotaUser(String string) {
                return (SetTarget)super.setQuotaUser(string);
            }

            public SetTarget setUserIp(String string) {
                return (SetTarget)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetTarget setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public SetTarget setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getForwardingRule() {
                return this.forwardingRule;
            }

            public SetTarget setForwardingRule(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDINGRULE_PATTERN.matcher(string).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.forwardingRule = string;
                return this;
            }

            @Override
            public SetTarget set(String string, Object object) {
                return (SetTarget)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<ForwardingRuleList> {
            private static final String REST_PATH = "{project}/regions/{region}/forwardingRules";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, ForwardingRuleList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/forwardingRules";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;

            protected Insert(String string, String string2, ForwardingRule forwardingRule) {
                super(Compute.this, "POST", REST_PATH, (Object)forwardingRule, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Insert setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<ForwardingRule> {
            private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern FORWARDINGRULE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String forwardingRule;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, ForwardingRule.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.FORWARDINGRULE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.forwardingRule = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter forwardingRule must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDINGRULE_PATTERN.matcher(string3).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getForwardingRule() {
                return this.forwardingRule;
            }

            public Get setForwardingRule(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDINGRULE_PATTERN.matcher(string).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.forwardingRule = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern FORWARDINGRULE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String forwardingRule;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.FORWARDINGRULE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.forwardingRule = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter forwardingRule must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDINGRULE_PATTERN.matcher(string3).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getForwardingRule() {
                return this.forwardingRule;
            }

            public Delete setForwardingRule(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FORWARDINGRULE_PATTERN.matcher(string).matches(), (Object)"Parameter forwardingRule must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.forwardingRule = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<ForwardingRuleAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/forwardingRules";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, ForwardingRuleAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class Firewalls {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Firewall firewall) throws IOException {
            Insert insert = new Insert(string, firewall);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, Firewall firewall) throws IOException {
            Patch patch = new Patch(string, string2, firewall);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, Firewall firewall) throws IOException {
            Update update = new Update(string, string2, firewall);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/firewalls/{firewall}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern FIREWALL_PATTERN;
            @Key
            private String project;
            @Key
            private String firewall;

            protected Update(String string, String string2, Firewall firewall) {
                super(Compute.this, "PUT", REST_PATH, (Object)firewall, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.FIREWALL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.firewall = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter firewall must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string2).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFirewall() {
                return this.firewall;
            }

            public Update setFirewall(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.firewall = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/firewalls/{firewall}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern FIREWALL_PATTERN;
            @Key
            private String project;
            @Key
            private String firewall;

            protected Patch(String string, String string2, Firewall firewall) {
                super(Compute.this, "PATCH", REST_PATH, (Object)firewall, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.FIREWALL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.firewall = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter firewall must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string2).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFirewall() {
                return this.firewall;
            }

            public Patch setFirewall(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.firewall = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<FirewallList> {
            private static final String REST_PATH = "{project}/global/firewalls";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, FirewallList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/firewalls";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, Firewall firewall) {
                super(Compute.this, "POST", REST_PATH, (Object)firewall, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Firewall> {
            private static final String REST_PATH = "{project}/global/firewalls/{firewall}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern FIREWALL_PATTERN;
            @Key
            private String project;
            @Key
            private String firewall;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Firewall.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.FIREWALL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.firewall = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter firewall must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string2).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFirewall() {
                return this.firewall;
            }

            public Get setFirewall(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.firewall = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/global/firewalls/{firewall}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern FIREWALL_PATTERN;
            @Key
            private String project;
            @Key
            private String firewall;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.FIREWALL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.firewall = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter firewall must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string2).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFirewall() {
                return this.firewall;
            }

            public Delete setFirewall(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.firewall = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Disks {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public CreateSnapshot createSnapshot(String string, String string2, String string3, Snapshot snapshot) throws IOException {
            CreateSnapshot createSnapshot = new CreateSnapshot(string, string2, string3, snapshot);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)createSnapshot);
            return createSnapshot;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, Disk disk) throws IOException {
            Insert insert = new Insert(string, string2, disk);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<DiskList> {
            private static final String REST_PATH = "{project}/zones/{zone}/disks";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, DiskList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/disks";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String sourceImage;

            protected Insert(String string, String string2, Disk disk) {
                super(Compute.this, "POST", REST_PATH, (Object)disk, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Insert setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getSourceImage() {
                return this.sourceImage;
            }

            public Insert setSourceImage(String string) {
                this.sourceImage = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Disk> {
            private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern DISK_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String disk;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, Disk.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.DISK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.disk = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter disk must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string3).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getDisk() {
                return this.disk;
            }

            public Get setDisk(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.disk = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern DISK_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String disk;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.DISK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.disk = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter disk must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string3).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Delete setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getDisk() {
                return this.disk;
            }

            public Delete setDisk(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.disk = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class CreateSnapshot
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}/createSnapshot";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern DISK_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String disk;

            protected CreateSnapshot(String string, String string2, String string3, Snapshot snapshot) {
                super(Compute.this, "POST", REST_PATH, (Object)snapshot, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.DISK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.disk = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter disk must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string3).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public CreateSnapshot setAlt(String string) {
                return (CreateSnapshot)super.setAlt(string);
            }

            public CreateSnapshot setFields(String string) {
                return (CreateSnapshot)super.setFields(string);
            }

            public CreateSnapshot setKey(String string) {
                return (CreateSnapshot)super.setKey(string);
            }

            public CreateSnapshot setOauthToken(String string) {
                return (CreateSnapshot)super.setOauthToken(string);
            }

            public CreateSnapshot setPrettyPrint(Boolean bl) {
                return (CreateSnapshot)super.setPrettyPrint(bl);
            }

            public CreateSnapshot setQuotaUser(String string) {
                return (CreateSnapshot)super.setQuotaUser(string);
            }

            public CreateSnapshot setUserIp(String string) {
                return (CreateSnapshot)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public CreateSnapshot setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public CreateSnapshot setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getDisk() {
                return this.disk;
            }

            public CreateSnapshot setDisk(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.disk = string;
                return this;
            }

            @Override
            public CreateSnapshot set(String string, Object object) {
                return (CreateSnapshot)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<DiskAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/disks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, DiskAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class DiskTypes {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<DiskTypeList> {
            private static final String REST_PATH = "{project}/zones/{zone}/diskTypes";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, DiskTypeList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<DiskType> {
            private static final String REST_PATH = "{project}/zones/{zone}/diskTypes/{diskType}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern DISKTYPE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String diskType;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, DiskType.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.DISKTYPE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.diskType = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter diskType must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISKTYPE_PATTERN.matcher(string3).matches(), (Object)"Parameter diskType must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            public String getDiskType() {
                return this.diskType;
            }

            public Get setDiskType(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISKTYPE_PATTERN.matcher(string).matches(), (Object)"Parameter diskType must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.diskType = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<DiskTypeAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/diskTypes";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, DiskTypeAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }

    public class Addresses {
        public AggregatedList aggregatedList(String string) throws IOException {
            AggregatedList aggregatedList = new AggregatedList(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)aggregatedList);
            return aggregatedList;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, Address address) throws IOException {
            Insert insert = new Insert(string, string2, address);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<AddressList> {
            private static final String REST_PATH = "{project}/regions/{region}/addresses";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, AddressList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/addresses";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;

            protected Insert(String string, String string2, Address address) {
                super(Compute.this, "POST", REST_PATH, (Object)address, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Insert setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Address> {
            private static final String REST_PATH = "{project}/regions/{region}/addresses/{address}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern ADDRESS_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String address;

            protected Get(String string, String string2, String string3) {
                super(Compute.this, "GET", REST_PATH, null, Address.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.ADDRESS_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.address = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter address must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ADDRESS_PATTERN.matcher(string3).matches(), (Object)"Parameter address must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getAddress() {
                return this.address;
            }

            public Get setAddress(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ADDRESS_PATTERN.matcher(string).matches(), (Object)"Parameter address must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.address = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/regions/{region}/addresses/{address}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern ADDRESS_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String address;

            protected Delete(String string, String string2, String string3) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.ADDRESS_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string2).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.address = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter address must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ADDRESS_PATTERN.matcher(string3).matches(), (Object)"Parameter address must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(string).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = string;
                return this;
            }

            public String getAddress() {
                return this.address;
            }

            public Delete setAddress(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ADDRESS_PATTERN.matcher(string).matches(), (Object)"Parameter address must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.address = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AggregatedList
        extends ComputeRequest<AddressAggregatedList> {
            private static final String REST_PATH = "{project}/aggregated/addresses";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected AggregatedList(String string) {
                super(Compute.this, "GET", REST_PATH, null, AddressAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList setAlt(String string) {
                return (AggregatedList)super.setAlt(string);
            }

            public AggregatedList setFields(String string) {
                return (AggregatedList)super.setFields(string);
            }

            public AggregatedList setKey(String string) {
                return (AggregatedList)super.setKey(string);
            }

            public AggregatedList setOauthToken(String string) {
                return (AggregatedList)super.setOauthToken(string);
            }

            public AggregatedList setPrettyPrint(Boolean bl) {
                return (AggregatedList)super.setPrettyPrint(bl);
            }

            public AggregatedList setQuotaUser(String string) {
                return (AggregatedList)super.setQuotaUser(string);
            }

            public AggregatedList setUserIp(String string) {
                return (AggregatedList)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public AggregatedList set(String string, Object object) {
                return (AggregatedList)super.set(string, object);
            }
        }
    }
}

