/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for HttpRouteAction.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HttpRouteAction extends com.google.api.client.json.GenericJson {

  /**
   * The specification for allowing client side cross-origin requests. Please see W3C Recommendation
   * for Cross Origin Resource Sharing
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CorsPolicy corsPolicy;

  /**
   * The specification for fault injection introduced into traffic to test the resiliency of clients
   * to backend service failure. As part of fault injection, when clients send requests to a backend
   * service, delays can be introduced by Loadbalancer on a percentage of requests before sending
   * those request to the backend service. Similarly requests from clients can be aborted by the
   * Loadbalancer for a percentage of requests. timeout and retry_policy will be ignored by clients
   * that are configured with a fault_injection_policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HttpFaultInjection faultInjectionPolicy;

  /**
   * Specifies the policy on how requests intended for the route's backends are shadowed to a
   * separate mirrored backend service. Loadbalancer does not wait for responses from the shadow
   * service. Prior to sending traffic to the shadow service, the host / authority header is
   * suffixed with -shadow.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RequestMirrorPolicy requestMirrorPolicy;

  /**
   * Specifies the retry policy associated with this route.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HttpRetryPolicy retryPolicy;

  /**
   * Specifies the timeout for the selected route. Timeout is computed from the time the request has
   * been fully processed (i.e. end-of-stream) up until the response has been completely processed.
   * Timeout includes all retries. If not specified, will use the largest timeout among all backend
   * services associated with the route.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Duration timeout;

  /**
   * The spec to modify the URL of the request, prior to forwarding the request to the matched
   * service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UrlRewrite urlRewrite;

  /**
   * A list of weighted backend services to send traffic to when a route match occurs. The weights
   * determine the fraction of traffic that flows to their corresponding backend service. If all
   * traffic needs to go to a single backend service, there must be one  weightedBackendService with
   * weight set to a non 0 number. Once a backendService is identified and before forwarding the
   * request to the backend service, advanced routing actions like Url rewrites and header
   * transformations are applied depending on additional settings specified in this HttpRouteAction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<WeightedBackendService> weightedBackendServices;

  /**
   * The specification for allowing client side cross-origin requests. Please see W3C Recommendation
   * for Cross Origin Resource Sharing
   * @return value or {@code null} for none
   */
  public CorsPolicy getCorsPolicy() {
    return corsPolicy;
  }

  /**
   * The specification for allowing client side cross-origin requests. Please see W3C Recommendation
   * for Cross Origin Resource Sharing
   * @param corsPolicy corsPolicy or {@code null} for none
   */
  public HttpRouteAction setCorsPolicy(CorsPolicy corsPolicy) {
    this.corsPolicy = corsPolicy;
    return this;
  }

  /**
   * The specification for fault injection introduced into traffic to test the resiliency of clients
   * to backend service failure. As part of fault injection, when clients send requests to a backend
   * service, delays can be introduced by Loadbalancer on a percentage of requests before sending
   * those request to the backend service. Similarly requests from clients can be aborted by the
   * Loadbalancer for a percentage of requests. timeout and retry_policy will be ignored by clients
   * that are configured with a fault_injection_policy.
   * @return value or {@code null} for none
   */
  public HttpFaultInjection getFaultInjectionPolicy() {
    return faultInjectionPolicy;
  }

  /**
   * The specification for fault injection introduced into traffic to test the resiliency of clients
   * to backend service failure. As part of fault injection, when clients send requests to a backend
   * service, delays can be introduced by Loadbalancer on a percentage of requests before sending
   * those request to the backend service. Similarly requests from clients can be aborted by the
   * Loadbalancer for a percentage of requests. timeout and retry_policy will be ignored by clients
   * that are configured with a fault_injection_policy.
   * @param faultInjectionPolicy faultInjectionPolicy or {@code null} for none
   */
  public HttpRouteAction setFaultInjectionPolicy(HttpFaultInjection faultInjectionPolicy) {
    this.faultInjectionPolicy = faultInjectionPolicy;
    return this;
  }

  /**
   * Specifies the policy on how requests intended for the route's backends are shadowed to a
   * separate mirrored backend service. Loadbalancer does not wait for responses from the shadow
   * service. Prior to sending traffic to the shadow service, the host / authority header is
   * suffixed with -shadow.
   * @return value or {@code null} for none
   */
  public RequestMirrorPolicy getRequestMirrorPolicy() {
    return requestMirrorPolicy;
  }

  /**
   * Specifies the policy on how requests intended for the route's backends are shadowed to a
   * separate mirrored backend service. Loadbalancer does not wait for responses from the shadow
   * service. Prior to sending traffic to the shadow service, the host / authority header is
   * suffixed with -shadow.
   * @param requestMirrorPolicy requestMirrorPolicy or {@code null} for none
   */
  public HttpRouteAction setRequestMirrorPolicy(RequestMirrorPolicy requestMirrorPolicy) {
    this.requestMirrorPolicy = requestMirrorPolicy;
    return this;
  }

  /**
   * Specifies the retry policy associated with this route.
   * @return value or {@code null} for none
   */
  public HttpRetryPolicy getRetryPolicy() {
    return retryPolicy;
  }

  /**
   * Specifies the retry policy associated with this route.
   * @param retryPolicy retryPolicy or {@code null} for none
   */
  public HttpRouteAction setRetryPolicy(HttpRetryPolicy retryPolicy) {
    this.retryPolicy = retryPolicy;
    return this;
  }

  /**
   * Specifies the timeout for the selected route. Timeout is computed from the time the request has
   * been fully processed (i.e. end-of-stream) up until the response has been completely processed.
   * Timeout includes all retries. If not specified, will use the largest timeout among all backend
   * services associated with the route.
   * @return value or {@code null} for none
   */
  public Duration getTimeout() {
    return timeout;
  }

  /**
   * Specifies the timeout for the selected route. Timeout is computed from the time the request has
   * been fully processed (i.e. end-of-stream) up until the response has been completely processed.
   * Timeout includes all retries. If not specified, will use the largest timeout among all backend
   * services associated with the route.
   * @param timeout timeout or {@code null} for none
   */
  public HttpRouteAction setTimeout(Duration timeout) {
    this.timeout = timeout;
    return this;
  }

  /**
   * The spec to modify the URL of the request, prior to forwarding the request to the matched
   * service.
   * @return value or {@code null} for none
   */
  public UrlRewrite getUrlRewrite() {
    return urlRewrite;
  }

  /**
   * The spec to modify the URL of the request, prior to forwarding the request to the matched
   * service.
   * @param urlRewrite urlRewrite or {@code null} for none
   */
  public HttpRouteAction setUrlRewrite(UrlRewrite urlRewrite) {
    this.urlRewrite = urlRewrite;
    return this;
  }

  /**
   * A list of weighted backend services to send traffic to when a route match occurs. The weights
   * determine the fraction of traffic that flows to their corresponding backend service. If all
   * traffic needs to go to a single backend service, there must be one  weightedBackendService with
   * weight set to a non 0 number. Once a backendService is identified and before forwarding the
   * request to the backend service, advanced routing actions like Url rewrites and header
   * transformations are applied depending on additional settings specified in this HttpRouteAction.
   * @return value or {@code null} for none
   */
  public java.util.List<WeightedBackendService> getWeightedBackendServices() {
    return weightedBackendServices;
  }

  /**
   * A list of weighted backend services to send traffic to when a route match occurs. The weights
   * determine the fraction of traffic that flows to their corresponding backend service. If all
   * traffic needs to go to a single backend service, there must be one  weightedBackendService with
   * weight set to a non 0 number. Once a backendService is identified and before forwarding the
   * request to the backend service, advanced routing actions like Url rewrites and header
   * transformations are applied depending on additional settings specified in this HttpRouteAction.
   * @param weightedBackendServices weightedBackendServices or {@code null} for none
   */
  public HttpRouteAction setWeightedBackendServices(java.util.List<WeightedBackendService> weightedBackendServices) {
    this.weightedBackendServices = weightedBackendServices;
    return this;
  }

  @Override
  public HttpRouteAction set(String fieldName, Object value) {
    return (HttpRouteAction) super.set(fieldName, value);
  }

  @Override
  public HttpRouteAction clone() {
    return (HttpRouteAction) super.clone();
  }

}
