/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Opaque filter criteria used by loadbalancers to restrict routing configuration to a limited set
 * of loadbalancing proxies. Proxies and sidecars involved in loadbalancing would typically present
 * metadata to the loadbalancers which need to match criteria specified here. If a match takes
 * place, the relevant configuration is made available to those proxies. For each metadataFilter in
 * this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must
 * match the corresponding label provided in the metadata. If its filterMatchCriteria is set to
 * MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the
 * metadata. An example for using metadataFilters would be: if loadbalancing involves  Envoys, they
 * will only receive routing configuration when values in metadataFilters match values supplied in
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MetadataFilter extends com.google.api.client.json.GenericJson {

  /**
   * The list of label value pairs that must match labels in the provided metadata based on
   * filterMatchCriteria This list must not be empty and can have at the most 64 entries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MetadataFilterLabelMatch> filterLabels;

  /**
   * Specifies how individual filterLabel matches within the list of filterLabels contribute towards
   * the overall metadataFilter match. Supported values are:   - MATCH_ANY: At least one of the
   * filterLabels must have a matching label in the provided metadata.  - MATCH_ALL: All
   * filterLabels must have matching labels in the provided metadata.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String filterMatchCriteria;

  /**
   * The list of label value pairs that must match labels in the provided metadata based on
   * filterMatchCriteria This list must not be empty and can have at the most 64 entries.
   * @return value or {@code null} for none
   */
  public java.util.List<MetadataFilterLabelMatch> getFilterLabels() {
    return filterLabels;
  }

  /**
   * The list of label value pairs that must match labels in the provided metadata based on
   * filterMatchCriteria This list must not be empty and can have at the most 64 entries.
   * @param filterLabels filterLabels or {@code null} for none
   */
  public MetadataFilter setFilterLabels(java.util.List<MetadataFilterLabelMatch> filterLabels) {
    this.filterLabels = filterLabels;
    return this;
  }

  /**
   * Specifies how individual filterLabel matches within the list of filterLabels contribute towards
   * the overall metadataFilter match. Supported values are:   - MATCH_ANY: At least one of the
   * filterLabels must have a matching label in the provided metadata.  - MATCH_ALL: All
   * filterLabels must have matching labels in the provided metadata.
   * @return value or {@code null} for none
   */
  public java.lang.String getFilterMatchCriteria() {
    return filterMatchCriteria;
  }

  /**
   * Specifies how individual filterLabel matches within the list of filterLabels contribute towards
   * the overall metadataFilter match. Supported values are:   - MATCH_ANY: At least one of the
   * filterLabels must have a matching label in the provided metadata.  - MATCH_ALL: All
   * filterLabels must have matching labels in the provided metadata.
   * @param filterMatchCriteria filterMatchCriteria or {@code null} for none
   */
  public MetadataFilter setFilterMatchCriteria(java.lang.String filterMatchCriteria) {
    this.filterMatchCriteria = filterMatchCriteria;
    return this;
  }

  @Override
  public MetadataFilter set(String fieldName, Object value) {
    return (MetadataFilter) super.set(fieldName, value);
  }

  @Override
  public MetadataFilter clone() {
    return (MetadataFilter) super.clone();
  }

}
