/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for NodeGroupAutoscalingPolicy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NodeGroupAutoscalingPolicy extends com.google.api.client.json.GenericJson {

  /**
   * The maximum number of nodes that the group should have.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxNodes;

  /**
   * The minimum number of nodes that the group should have.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minNodes;

  /**
   * The autoscaling mode. Set to one of: ON, OFF, or ONLY_SCALE_OUT. For more information, see
   * Autoscaler modes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mode;

  /**
   * The maximum number of nodes that the group should have.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxNodes() {
    return maxNodes;
  }

  /**
   * The maximum number of nodes that the group should have.
   * @param maxNodes maxNodes or {@code null} for none
   */
  public NodeGroupAutoscalingPolicy setMaxNodes(java.lang.Integer maxNodes) {
    this.maxNodes = maxNodes;
    return this;
  }

  /**
   * The minimum number of nodes that the group should have.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinNodes() {
    return minNodes;
  }

  /**
   * The minimum number of nodes that the group should have.
   * @param minNodes minNodes or {@code null} for none
   */
  public NodeGroupAutoscalingPolicy setMinNodes(java.lang.Integer minNodes) {
    this.minNodes = minNodes;
    return this;
  }

  /**
   * The autoscaling mode. Set to one of: ON, OFF, or ONLY_SCALE_OUT. For more information, see
   * Autoscaler modes.
   * @return value or {@code null} for none
   */
  public java.lang.String getMode() {
    return mode;
  }

  /**
   * The autoscaling mode. Set to one of: ON, OFF, or ONLY_SCALE_OUT. For more information, see
   * Autoscaler modes.
   * @param mode mode or {@code null} for none
   */
  public NodeGroupAutoscalingPolicy setMode(java.lang.String mode) {
    this.mode = mode;
    return this;
  }

  @Override
  public NodeGroupAutoscalingPolicy set(String fieldName, Object value) {
    return (NodeGroupAutoscalingPolicy) super.set(fieldName, value);
  }

  @Override
  public NodeGroupAutoscalingPolicy clone() {
    return (NodeGroupAutoscalingPolicy) super.clone();
  }

}
