/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A matcher for the path portion of the URL. The BackendService from the longest-matched rule will
 * serve the URL. If no rule was matched, the default service will be used.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PathMatcher extends com.google.api.client.json.GenericJson {

  /**
   * defaultRouteAction takes effect when none of the  pathRules or routeRules match. The load
   * balancer performs advanced routing actions like URL rewrites, header transformations, etc.
   * prior to forwarding the request to the selected backend. If defaultRouteAction specifies any
   * weightedBackendServices, defaultService must not be set. Conversely if defaultService is set,
   * defaultRouteAction cannot contain any  weightedBackendServices. Only one of defaultRouteAction
   * or defaultUrlRedirect must be set. UrlMaps for external HTTP(S) load balancers support only the
   * urlRewrite action within a pathMatcher's defaultRouteAction.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HttpRouteAction defaultRouteAction;

  /**
   * The full or partial URL to the BackendService resource. This will be used if none of the
   * pathRules or routeRules defined by this PathMatcher are matched. For example, the following are
   * all valid URLs to a BackendService resource: -
   * https://www.googleapis.com/compute/v1/projects/project/global/backendServices/backendService  -
   * compute/v1/projects/project/global/backendServices/backendService  -
   * global/backendServices/backendService  If defaultRouteAction is additionally specified,
   * advanced routing actions like URL Rewrites, etc. take effect prior to sending the request to
   * the backend. However, if defaultService is specified, defaultRouteAction cannot contain any
   * weightedBackendServices. Conversely, if defaultRouteAction specifies any
   * weightedBackendServices, defaultService must not be specified. Only one of defaultService,
   * defaultUrlRedirect  or defaultRouteAction.weightedBackendService must be set. Authorization
   * requires one or more of the following Google IAM permissions on the specified resource
   * default_service:   - compute.backendBuckets.use  - compute.backendServices.use
   *
   * pathMatchers[].defaultService is the only option available when the URL map is bound to target
   * gRPC proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultService;

  /**
   * When none of the specified pathRules or routeRules match, the request is redirected to a URL
   * specified by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
   * defaultRouteAction must not be set.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HttpRedirectAction defaultUrlRedirect;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Specifies changes to request and response headers that need to take effect for the selected
   * backendService. HeaderAction specified here are applied after the matching HttpRouteRule
   * HeaderAction and before the HeaderAction in the UrlMap  Note that headerAction is not supported
   * for Loadbalancers that have their loadBalancingScheme set to EXTERNAL.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HttpHeaderAction headerAction;

  /**
   * The name to which this PathMatcher is referred by the HostRule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The list of path rules. Use this list instead of routeRules when routing based on simple path
   * matching is all that's required. The order by which path rules are specified does not matter.
   * Matches are always done on the longest-path-first basis. For example: a pathRule with a path
   * /a/b/c will match before /a/b irrespective of the order in which those paths appear in this
   * list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PathRule> pathRules;

  /**
   * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching
   * and routing actions are desired. routeRules are evaluated in order of priority, from the lowest
   * to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<HttpRouteRule> routeRules;

  static {
    // hack to force ProGuard to consider HttpRouteRule used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(HttpRouteRule.class);
  }

  /**
   * defaultRouteAction takes effect when none of the  pathRules or routeRules match. The load
   * balancer performs advanced routing actions like URL rewrites, header transformations, etc.
   * prior to forwarding the request to the selected backend. If defaultRouteAction specifies any
   * weightedBackendServices, defaultService must not be set. Conversely if defaultService is set,
   * defaultRouteAction cannot contain any  weightedBackendServices. Only one of defaultRouteAction
   * or defaultUrlRedirect must be set. UrlMaps for external HTTP(S) load balancers support only the
   * urlRewrite action within a pathMatcher's defaultRouteAction.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public HttpRouteAction getDefaultRouteAction() {
    return defaultRouteAction;
  }

  /**
   * defaultRouteAction takes effect when none of the  pathRules or routeRules match. The load
   * balancer performs advanced routing actions like URL rewrites, header transformations, etc.
   * prior to forwarding the request to the selected backend. If defaultRouteAction specifies any
   * weightedBackendServices, defaultService must not be set. Conversely if defaultService is set,
   * defaultRouteAction cannot contain any  weightedBackendServices. Only one of defaultRouteAction
   * or defaultUrlRedirect must be set. UrlMaps for external HTTP(S) load balancers support only the
   * urlRewrite action within a pathMatcher's defaultRouteAction.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @param defaultRouteAction defaultRouteAction or {@code null} for none
   */
  public PathMatcher setDefaultRouteAction(HttpRouteAction defaultRouteAction) {
    this.defaultRouteAction = defaultRouteAction;
    return this;
  }

  /**
   * The full or partial URL to the BackendService resource. This will be used if none of the
   * pathRules or routeRules defined by this PathMatcher are matched. For example, the following are
   * all valid URLs to a BackendService resource: -
   * https://www.googleapis.com/compute/v1/projects/project/global/backendServices/backendService  -
   * compute/v1/projects/project/global/backendServices/backendService  -
   * global/backendServices/backendService  If defaultRouteAction is additionally specified,
   * advanced routing actions like URL Rewrites, etc. take effect prior to sending the request to
   * the backend. However, if defaultService is specified, defaultRouteAction cannot contain any
   * weightedBackendServices. Conversely, if defaultRouteAction specifies any
   * weightedBackendServices, defaultService must not be specified. Only one of defaultService,
   * defaultUrlRedirect  or defaultRouteAction.weightedBackendService must be set. Authorization
   * requires one or more of the following Google IAM permissions on the specified resource
   * default_service:   - compute.backendBuckets.use  - compute.backendServices.use
   *
   * pathMatchers[].defaultService is the only option available when the URL map is bound to target
   * gRPC proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultService() {
    return defaultService;
  }

  /**
   * The full or partial URL to the BackendService resource. This will be used if none of the
   * pathRules or routeRules defined by this PathMatcher are matched. For example, the following are
   * all valid URLs to a BackendService resource: -
   * https://www.googleapis.com/compute/v1/projects/project/global/backendServices/backendService  -
   * compute/v1/projects/project/global/backendServices/backendService  -
   * global/backendServices/backendService  If defaultRouteAction is additionally specified,
   * advanced routing actions like URL Rewrites, etc. take effect prior to sending the request to
   * the backend. However, if defaultService is specified, defaultRouteAction cannot contain any
   * weightedBackendServices. Conversely, if defaultRouteAction specifies any
   * weightedBackendServices, defaultService must not be specified. Only one of defaultService,
   * defaultUrlRedirect  or defaultRouteAction.weightedBackendService must be set. Authorization
   * requires one or more of the following Google IAM permissions on the specified resource
   * default_service:   - compute.backendBuckets.use  - compute.backendServices.use
   *
   * pathMatchers[].defaultService is the only option available when the URL map is bound to target
   * gRPC proxy that has validateForProxyless field set to true.
   * @param defaultService defaultService or {@code null} for none
   */
  public PathMatcher setDefaultService(java.lang.String defaultService) {
    this.defaultService = defaultService;
    return this;
  }

  /**
   * When none of the specified pathRules or routeRules match, the request is redirected to a URL
   * specified by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
   * defaultRouteAction must not be set.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy.
   * @return value or {@code null} for none
   */
  public HttpRedirectAction getDefaultUrlRedirect() {
    return defaultUrlRedirect;
  }

  /**
   * When none of the specified pathRules or routeRules match, the request is redirected to a URL
   * specified by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
   * defaultRouteAction must not be set.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy.
   * @param defaultUrlRedirect defaultUrlRedirect or {@code null} for none
   */
  public PathMatcher setDefaultUrlRedirect(HttpRedirectAction defaultUrlRedirect) {
    this.defaultUrlRedirect = defaultUrlRedirect;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public PathMatcher setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Specifies changes to request and response headers that need to take effect for the selected
   * backendService. HeaderAction specified here are applied after the matching HttpRouteRule
   * HeaderAction and before the HeaderAction in the UrlMap  Note that headerAction is not supported
   * for Loadbalancers that have their loadBalancingScheme set to EXTERNAL.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public HttpHeaderAction getHeaderAction() {
    return headerAction;
  }

  /**
   * Specifies changes to request and response headers that need to take effect for the selected
   * backendService. HeaderAction specified here are applied after the matching HttpRouteRule
   * HeaderAction and before the HeaderAction in the UrlMap  Note that headerAction is not supported
   * for Loadbalancers that have their loadBalancingScheme set to EXTERNAL.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @param headerAction headerAction or {@code null} for none
   */
  public PathMatcher setHeaderAction(HttpHeaderAction headerAction) {
    this.headerAction = headerAction;
    return this;
  }

  /**
   * The name to which this PathMatcher is referred by the HostRule.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name to which this PathMatcher is referred by the HostRule.
   * @param name name or {@code null} for none
   */
  public PathMatcher setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The list of path rules. Use this list instead of routeRules when routing based on simple path
   * matching is all that's required. The order by which path rules are specified does not matter.
   * Matches are always done on the longest-path-first basis. For example: a pathRule with a path
   * /a/b/c will match before /a/b irrespective of the order in which those paths appear in this
   * list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public java.util.List<PathRule> getPathRules() {
    return pathRules;
  }

  /**
   * The list of path rules. Use this list instead of routeRules when routing based on simple path
   * matching is all that's required. The order by which path rules are specified does not matter.
   * Matches are always done on the longest-path-first basis. For example: a pathRule with a path
   * /a/b/c will match before /a/b irrespective of the order in which those paths appear in this
   * list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @param pathRules pathRules or {@code null} for none
   */
  public PathMatcher setPathRules(java.util.List<PathRule> pathRules) {
    this.pathRules = pathRules;
    return this;
  }

  /**
   * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching
   * and routing actions are desired. routeRules are evaluated in order of priority, from the lowest
   * to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public java.util.List<HttpRouteRule> getRouteRules() {
    return routeRules;
  }

  /**
   * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching
   * and routing actions are desired. routeRules are evaluated in order of priority, from the lowest
   * to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @param routeRules routeRules or {@code null} for none
   */
  public PathMatcher setRouteRules(java.util.List<HttpRouteRule> routeRules) {
    this.routeRules = routeRules;
    return this;
  }

  @Override
  public PathMatcher set(String fieldName, Object value) {
    return (PathMatcher) super.set(fieldName, value);
  }

  @Override
  public PathMatcher clone() {
    return (PathMatcher) super.clone();
  }

}
