/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Specified snapshot properties for scheduled snapshots created by this policy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourcePolicySnapshotSchedulePolicySnapshotProperties extends com.google.api.client.json.GenericJson {

  /**
   * Indication to perform a 'guest aware' snapshot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean guestFlush;

  /**
   * Labels to apply to scheduled snapshots. These can be later modified by the setLabels method.
   * Label values may be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> storageLocations;

  /**
   * Indication to perform a 'guest aware' snapshot.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getGuestFlush() {
    return guestFlush;
  }

  /**
   * Indication to perform a 'guest aware' snapshot.
   * @param guestFlush guestFlush or {@code null} for none
   */
  public ResourcePolicySnapshotSchedulePolicySnapshotProperties setGuestFlush(java.lang.Boolean guestFlush) {
    this.guestFlush = guestFlush;
    return this;
  }

  /**
   * Labels to apply to scheduled snapshots. These can be later modified by the setLabels method.
   * Label values may be empty.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * Labels to apply to scheduled snapshots. These can be later modified by the setLabels method.
   * Label values may be empty.
   * @param labels labels or {@code null} for none
   */
  public ResourcePolicySnapshotSchedulePolicySnapshotProperties setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getStorageLocations() {
    return storageLocations;
  }

  /**
   * Cloud Storage bucket storage location of the auto snapshot (regional or multi-regional).
   * @param storageLocations storageLocations or {@code null} for none
   */
  public ResourcePolicySnapshotSchedulePolicySnapshotProperties setStorageLocations(java.util.List<java.lang.String> storageLocations) {
    this.storageLocations = storageLocations;
    return this;
  }

  @Override
  public ResourcePolicySnapshotSchedulePolicySnapshotProperties set(String fieldName, Object value) {
    return (ResourcePolicySnapshotSchedulePolicySnapshotProperties) super.set(fieldName, value);
  }

  @Override
  public ResourcePolicySnapshotSchedulePolicySnapshotProperties clone() {
    return (ResourcePolicySnapshotSchedulePolicySnapshotProperties) super.clone();
  }

}
