/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for TestFailure.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TestFailure extends com.google.api.client.json.GenericJson {

  /**
   * BackendService or BackendBucket returned by load balancer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String actualService;

  /**
   * Expected BackendService or BackendBucket resource the given URL should be mapped to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String expectedService;

  /**
   * Host portion of the URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String host;

  /**
   * Path portion including query parameters in the URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String path;

  /**
   * BackendService or BackendBucket returned by load balancer.
   * @return value or {@code null} for none
   */
  public java.lang.String getActualService() {
    return actualService;
  }

  /**
   * BackendService or BackendBucket returned by load balancer.
   * @param actualService actualService or {@code null} for none
   */
  public TestFailure setActualService(java.lang.String actualService) {
    this.actualService = actualService;
    return this;
  }

  /**
   * Expected BackendService or BackendBucket resource the given URL should be mapped to.
   * @return value or {@code null} for none
   */
  public java.lang.String getExpectedService() {
    return expectedService;
  }

  /**
   * Expected BackendService or BackendBucket resource the given URL should be mapped to.
   * @param expectedService expectedService or {@code null} for none
   */
  public TestFailure setExpectedService(java.lang.String expectedService) {
    this.expectedService = expectedService;
    return this;
  }

  /**
   * Host portion of the URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getHost() {
    return host;
  }

  /**
   * Host portion of the URL.
   * @param host host or {@code null} for none
   */
  public TestFailure setHost(java.lang.String host) {
    this.host = host;
    return this;
  }

  /**
   * Path portion including query parameters in the URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getPath() {
    return path;
  }

  /**
   * Path portion including query parameters in the URL.
   * @param path path or {@code null} for none
   */
  public TestFailure setPath(java.lang.String path) {
    this.path = path;
    return this;
  }

  @Override
  public TestFailure set(String fieldName, Object value) {
    return (TestFailure) super.set(fieldName, value);
  }

  @Override
  public TestFailure clone() {
    return (TestFailure) super.clone();
  }

}
