/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a Backend Service resource.
 *
 * A backend service defines how Google Cloud load balancers distribute traffic. The backend service
 * configuration contains a set of values, such as the protocol used to connect to backends, various
 * distribution and session settings, health checks, and timeouts. These settings provide fine-
 * grained control over how your load balancer behaves. Most of the settings have default values
 * that allow for easy configuration if you need to get started quickly.
 *
 * Backend services in Google Compute Engine can be either regionally or globally scoped.
 *
 * * [Global](/compute/docs/reference/rest/{$api_version}/backendServices) *
 * [Regional](/compute/docs/reference/rest/{$api_version}/regionBackendServices)
 *
 * For more information, see Backend Services.
 *
 * (== resource_for {$api_version}.backendService ==)
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendService extends com.google.api.client.json.GenericJson {

  /**
   * Lifetime of cookies in seconds. Only applicable if the loadBalancingScheme is EXTERNAL,
   * INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, the protocol is HTTP or HTTPS, and the
   * sessionAffinity is GENERATED_COOKIE, or HTTP_COOKIE.
   *
   * If set to 0, the cookie is non-persistent and lasts only until the end of the browser session
   * (or equivalent). The maximum allowed value is one day (86,400).
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer affinityCookieTtlSec;

  /**
   * The list of backends that serve this BackendService.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Backend> backends;

  static {
    // hack to force ProGuard to consider Backend used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Backend.class);
  }

  /**
   * Cloud CDN configuration for this BackendService. Not available for Internal TCP/UDP Load
   * Balancing and Network Load Balancing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BackendServiceCdnPolicy cdnPolicy;

  /**
   * Settings controlling the volume of connections to a backend service. If not set, this feature
   * is considered disabled.
   *
   * This field is applicable to either:   - A regional backend service with the service_protocol
   * set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.  - A global
   * backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CircuitBreakers circuitBreakers;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConnectionDraining connectionDraining;

  /**
   * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP
   * headers, cookies or other properties. This load balancing policy is applicable only for HTTP
   * connections. The affinity to a particular destination host will be lost when one or more hosts
   * are added/removed from the destination service. This field specifies parameters that control
   * consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or
   * RING_HASH.
   *
   * This field is applicable to either:   - A regional backend service with the service_protocol
   * set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.  - A global
   * backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConsistentHashLoadBalancerSettings consistentHash;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * Headers that the HTTP/S load balancer should add to proxied requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> customRequestHeaders;

  /**
   * Headers that the HTTP/S load balancer should add to proxied responses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> customResponseHeaders;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * If true, enables Cloud CDN for the backend service. Only applicable if the loadBalancingScheme
   * is EXTERNAL and the protocol is HTTP or HTTPS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableCDN;

  /**
   * Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing.
   * Requires at least one backend instance group to be defined as a backup (failover) backend.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BackendServiceFailoverPolicy failoverPolicy;

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-
   * date fingerprint must be provided in order to update the BackendService, otherwise the request
   * will fail with error 412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a BackendService.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy)
   * resource for health checking this backend service. Not all backend services support legacy
   * health checks. See  Load balancer guide. Currently, at most one health check can be specified
   * for each backend service. Backend services with instance group or zonal NEG backends must have
   * a health check. Backend services with internet or serverless NEG backends must not have a
   * health check.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> healthChecks;

  /**
   * The configurations for Identity-Aware Proxy on this resource. Not available for Internal
   * TCP/UDP Load Balancing and Network Load Balancing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BackendServiceIAP iap;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of resource. Always compute#backendService for backend services.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Specifies the load balancer type. Choose EXTERNAL for external HTTP(S), SSL Proxy, TCP Proxy
   * and Network Load Balancing. Choose  INTERNAL for Internal TCP/UDP Load Balancing. Choose
   * INTERNAL_MANAGED for Internal HTTP(S) Load Balancing.  INTERNAL_SELF_MANAGED for Traffic
   * Director. A backend service created for one type of load balancer cannot be used with another.
   * For more information, refer to Choosing a load balancer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String loadBalancingScheme;

  /**
   * The load balancing algorithm used within the scope of the locality. The possible values are: -
   * ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin
   * order. This is the default.  - LEAST_REQUEST: An O(1) algorithm which selects two random
   * healthy hosts and picks the host which has fewer active requests.  - RING_HASH: The ring/modulo
   * hash load balancer implements consistent hashing to backends. The algorithm has the property
   * that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.  -
   * RANDOM: The load balancer selects a random healthy host.  - ORIGINAL_DESTINATION: Backend host
   * is selected based on the client connection metadata, i.e., connections are opened to the same
   * address as the destination address of the incoming connection before the connection was
   * redirected to the load balancer.  - MAGLEV: used as a drop in replacement for the ring hash
   * load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and
   * host selection times. For more information about Maglev, see
   * https://ai.google/research/pubs/pub44824
   *
   * This field is applicable to either:   - A regional backend service with the service_protocol
   * set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.  - A global
   * backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   *
   * If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session
   * affinity settings will not take effect.
   *
   * Only the default ROUND_ROBIN policy is supported when the backend service is referenced by a
   * URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String localityLbPolicy;

  /**
   * This field denotes the logging options for the load balancer traffic served by this backend
   * service. If logging is enabled, logs will be exported to Stackdriver.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BackendServiceLogConfig logConfig;

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The URL of the network to which this backend service belongs. This field can only be specified
   * when the load balancing scheme is set to INTERNAL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * Settings controlling the eviction of unhealthy hosts from the load balancing pool for the
   * backend service. If not set, this feature is considered disabled.
   *
   * This field is applicable to either:   - A regional backend service with the service_protocol
   * set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.  - A global
   * backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OutlierDetection outlierDetection;

  /**
   * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is
   * 80.
   *
   * This cannot be used if the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer port;

  /**
   * A named port on a backend instance group representing the port for communication to the backend
   * VMs in that group. Required when the loadBalancingScheme is EXTERNAL (except Network Load
   * Balancing), INTERNAL_MANAGED, or  INTERNAL_SELF_MANAGED and the backends are instance groups.
   * The named port must be defined on each backend instance group. This parameter has no meaning if
   * the backends are NEGs.
   *
   * Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you
   * omit port_name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String portName;

  /**
   * The protocol this BackendService uses to communicate with backends.
   *
   * Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load
   * balancer or Traffic Director configuration. Refer to the documentation for the load balancer or
   * for Traffic Director for more information.
   *
   * Must be set to GRPC when the backend service is referenced by a URL map that is bound to target
   * gRPC proxy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String protocol;

  /**
   * [Output Only] URL of the region where the regional backend service resides. This field is not
   * applicable to global backend services. You must specify this field as part of the HTTP request
   * URL. It is not settable as a field in the request body.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * [Output Only] The resource URL for the security policy associated with this backend service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String securityPolicy;

  /**
   * This field specifies the security policy that applies to this backend service. This field is
   * applicable to either: - A regional backend service with the service_protocol set to HTTP,
   * HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.  - A global backend service
   * with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SecuritySettings securitySettings;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Type of session affinity to use. The default is NONE.
   *
   * When the loadBalancingScheme is EXTERNAL: * For Network Load Balancing, the possible values are
   * NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO. * For all other load balancers that
   * use loadBalancingScheme=EXTERNAL, the possible values are NONE, CLIENT_IP, or GENERATED_COOKIE.
   * * You can use GENERATED_COOKIE if the protocol is HTTP, HTTP2, or HTTPS.
   *
   * When the loadBalancingScheme is INTERNAL, possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO,
   * or CLIENT_IP_PORT_PROTO.
   *
   * When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, possible values are
   * NONE, CLIENT_IP, GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sessionAffinity;

  /**
   * The backend service timeout has a different meaning depending on the type of load balancer. For
   * more information see,  Backend service settings The default is 30 seconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer timeoutSec;

  /**
   * Lifetime of cookies in seconds. Only applicable if the loadBalancingScheme is EXTERNAL,
   * INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, the protocol is HTTP or HTTPS, and the
   * sessionAffinity is GENERATED_COOKIE, or HTTP_COOKIE.
   *
   * If set to 0, the cookie is non-persistent and lasts only until the end of the browser session
   * (or equivalent). The maximum allowed value is one day (86,400).
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAffinityCookieTtlSec() {
    return affinityCookieTtlSec;
  }

  /**
   * Lifetime of cookies in seconds. Only applicable if the loadBalancingScheme is EXTERNAL,
   * INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, the protocol is HTTP or HTTPS, and the
   * sessionAffinity is GENERATED_COOKIE, or HTTP_COOKIE.
   *
   * If set to 0, the cookie is non-persistent and lasts only until the end of the browser session
   * (or equivalent). The maximum allowed value is one day (86,400).
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @param affinityCookieTtlSec affinityCookieTtlSec or {@code null} for none
   */
  public BackendService setAffinityCookieTtlSec(java.lang.Integer affinityCookieTtlSec) {
    this.affinityCookieTtlSec = affinityCookieTtlSec;
    return this;
  }

  /**
   * The list of backends that serve this BackendService.
   * @return value or {@code null} for none
   */
  public java.util.List<Backend> getBackends() {
    return backends;
  }

  /**
   * The list of backends that serve this BackendService.
   * @param backends backends or {@code null} for none
   */
  public BackendService setBackends(java.util.List<Backend> backends) {
    this.backends = backends;
    return this;
  }

  /**
   * Cloud CDN configuration for this BackendService. Not available for Internal TCP/UDP Load
   * Balancing and Network Load Balancing.
   * @return value or {@code null} for none
   */
  public BackendServiceCdnPolicy getCdnPolicy() {
    return cdnPolicy;
  }

  /**
   * Cloud CDN configuration for this BackendService. Not available for Internal TCP/UDP Load
   * Balancing and Network Load Balancing.
   * @param cdnPolicy cdnPolicy or {@code null} for none
   */
  public BackendService setCdnPolicy(BackendServiceCdnPolicy cdnPolicy) {
    this.cdnPolicy = cdnPolicy;
    return this;
  }

  /**
   * Settings controlling the volume of connections to a backend service. If not set, this feature
   * is considered disabled.
   *
   * This field is applicable to either:   - A regional backend service with the service_protocol
   * set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.  - A global
   * backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public CircuitBreakers getCircuitBreakers() {
    return circuitBreakers;
  }

  /**
   * Settings controlling the volume of connections to a backend service. If not set, this feature
   * is considered disabled.
   *
   * This field is applicable to either:   - A regional backend service with the service_protocol
   * set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.  - A global
   * backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @param circuitBreakers circuitBreakers or {@code null} for none
   */
  public BackendService setCircuitBreakers(CircuitBreakers circuitBreakers) {
    this.circuitBreakers = circuitBreakers;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public ConnectionDraining getConnectionDraining() {
    return connectionDraining;
  }

  /**
   * @param connectionDraining connectionDraining or {@code null} for none
   */
  public BackendService setConnectionDraining(ConnectionDraining connectionDraining) {
    this.connectionDraining = connectionDraining;
    return this;
  }

  /**
   * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP
   * headers, cookies or other properties. This load balancing policy is applicable only for HTTP
   * connections. The affinity to a particular destination host will be lost when one or more hosts
   * are added/removed from the destination service. This field specifies parameters that control
   * consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or
   * RING_HASH.
   *
   * This field is applicable to either:   - A regional backend service with the service_protocol
   * set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.  - A global
   * backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public ConsistentHashLoadBalancerSettings getConsistentHash() {
    return consistentHash;
  }

  /**
   * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP
   * headers, cookies or other properties. This load balancing policy is applicable only for HTTP
   * connections. The affinity to a particular destination host will be lost when one or more hosts
   * are added/removed from the destination service. This field specifies parameters that control
   * consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or
   * RING_HASH.
   *
   * This field is applicable to either:   - A regional backend service with the service_protocol
   * set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.  - A global
   * backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @param consistentHash consistentHash or {@code null} for none
   */
  public BackendService setConsistentHash(ConsistentHashLoadBalancerSettings consistentHash) {
    this.consistentHash = consistentHash;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public BackendService setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * Headers that the HTTP/S load balancer should add to proxied requests.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getCustomRequestHeaders() {
    return customRequestHeaders;
  }

  /**
   * Headers that the HTTP/S load balancer should add to proxied requests.
   * @param customRequestHeaders customRequestHeaders or {@code null} for none
   */
  public BackendService setCustomRequestHeaders(java.util.List<java.lang.String> customRequestHeaders) {
    this.customRequestHeaders = customRequestHeaders;
    return this;
  }

  /**
   * Headers that the HTTP/S load balancer should add to proxied responses.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getCustomResponseHeaders() {
    return customResponseHeaders;
  }

  /**
   * Headers that the HTTP/S load balancer should add to proxied responses.
   * @param customResponseHeaders customResponseHeaders or {@code null} for none
   */
  public BackendService setCustomResponseHeaders(java.util.List<java.lang.String> customResponseHeaders) {
    this.customResponseHeaders = customResponseHeaders;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public BackendService setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * If true, enables Cloud CDN for the backend service. Only applicable if the loadBalancingScheme
   * is EXTERNAL and the protocol is HTTP or HTTPS.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableCDN() {
    return enableCDN;
  }

  /**
   * If true, enables Cloud CDN for the backend service. Only applicable if the loadBalancingScheme
   * is EXTERNAL and the protocol is HTTP or HTTPS.
   * @param enableCDN enableCDN or {@code null} for none
   */
  public BackendService setEnableCDN(java.lang.Boolean enableCDN) {
    this.enableCDN = enableCDN;
    return this;
  }

  /**
   * Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing.
   * Requires at least one backend instance group to be defined as a backup (failover) backend.
   * @return value or {@code null} for none
   */
  public BackendServiceFailoverPolicy getFailoverPolicy() {
    return failoverPolicy;
  }

  /**
   * Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing.
   * Requires at least one backend instance group to be defined as a backup (failover) backend.
   * @param failoverPolicy failoverPolicy or {@code null} for none
   */
  public BackendService setFailoverPolicy(BackendServiceFailoverPolicy failoverPolicy) {
    this.failoverPolicy = failoverPolicy;
    return this;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-
   * date fingerprint must be provided in order to update the BackendService, otherwise the request
   * will fail with error 412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a BackendService.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-
   * date fingerprint must be provided in order to update the BackendService, otherwise the request
   * will fail with error 412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a BackendService.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-
   * date fingerprint must be provided in order to update the BackendService, otherwise the request
   * will fail with error 412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a BackendService.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public BackendService setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-
   * date fingerprint must be provided in order to update the BackendService, otherwise the request
   * will fail with error 412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a BackendService.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public BackendService encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy)
   * resource for health checking this backend service. Not all backend services support legacy
   * health checks. See  Load balancer guide. Currently, at most one health check can be specified
   * for each backend service. Backend services with instance group or zonal NEG backends must have
   * a health check. Backend services with internet or serverless NEG backends must not have a
   * health check.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getHealthChecks() {
    return healthChecks;
  }

  /**
   * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy)
   * resource for health checking this backend service. Not all backend services support legacy
   * health checks. See  Load balancer guide. Currently, at most one health check can be specified
   * for each backend service. Backend services with instance group or zonal NEG backends must have
   * a health check. Backend services with internet or serverless NEG backends must not have a
   * health check.
   * @param healthChecks healthChecks or {@code null} for none
   */
  public BackendService setHealthChecks(java.util.List<java.lang.String> healthChecks) {
    this.healthChecks = healthChecks;
    return this;
  }

  /**
   * The configurations for Identity-Aware Proxy on this resource. Not available for Internal
   * TCP/UDP Load Balancing and Network Load Balancing.
   * @return value or {@code null} for none
   */
  public BackendServiceIAP getIap() {
    return iap;
  }

  /**
   * The configurations for Identity-Aware Proxy on this resource. Not available for Internal
   * TCP/UDP Load Balancing and Network Load Balancing.
   * @param iap iap or {@code null} for none
   */
  public BackendService setIap(BackendServiceIAP iap) {
    this.iap = iap;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public BackendService setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of resource. Always compute#backendService for backend services.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of resource. Always compute#backendService for backend services.
   * @param kind kind or {@code null} for none
   */
  public BackendService setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Specifies the load balancer type. Choose EXTERNAL for external HTTP(S), SSL Proxy, TCP Proxy
   * and Network Load Balancing. Choose  INTERNAL for Internal TCP/UDP Load Balancing. Choose
   * INTERNAL_MANAGED for Internal HTTP(S) Load Balancing.  INTERNAL_SELF_MANAGED for Traffic
   * Director. A backend service created for one type of load balancer cannot be used with another.
   * For more information, refer to Choosing a load balancer.
   * @return value or {@code null} for none
   */
  public java.lang.String getLoadBalancingScheme() {
    return loadBalancingScheme;
  }

  /**
   * Specifies the load balancer type. Choose EXTERNAL for external HTTP(S), SSL Proxy, TCP Proxy
   * and Network Load Balancing. Choose  INTERNAL for Internal TCP/UDP Load Balancing. Choose
   * INTERNAL_MANAGED for Internal HTTP(S) Load Balancing.  INTERNAL_SELF_MANAGED for Traffic
   * Director. A backend service created for one type of load balancer cannot be used with another.
   * For more information, refer to Choosing a load balancer.
   * @param loadBalancingScheme loadBalancingScheme or {@code null} for none
   */
  public BackendService setLoadBalancingScheme(java.lang.String loadBalancingScheme) {
    this.loadBalancingScheme = loadBalancingScheme;
    return this;
  }

  /**
   * The load balancing algorithm used within the scope of the locality. The possible values are: -
   * ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin
   * order. This is the default.  - LEAST_REQUEST: An O(1) algorithm which selects two random
   * healthy hosts and picks the host which has fewer active requests.  - RING_HASH: The ring/modulo
   * hash load balancer implements consistent hashing to backends. The algorithm has the property
   * that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.  -
   * RANDOM: The load balancer selects a random healthy host.  - ORIGINAL_DESTINATION: Backend host
   * is selected based on the client connection metadata, i.e., connections are opened to the same
   * address as the destination address of the incoming connection before the connection was
   * redirected to the load balancer.  - MAGLEV: used as a drop in replacement for the ring hash
   * load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and
   * host selection times. For more information about Maglev, see
   * https://ai.google/research/pubs/pub44824
   *
   * This field is applicable to either:   - A regional backend service with the service_protocol
   * set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.  - A global
   * backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   *
   * If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session
   * affinity settings will not take effect.
   *
   * Only the default ROUND_ROBIN policy is supported when the backend service is referenced by a
   * URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocalityLbPolicy() {
    return localityLbPolicy;
  }

  /**
   * The load balancing algorithm used within the scope of the locality. The possible values are: -
   * ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin
   * order. This is the default.  - LEAST_REQUEST: An O(1) algorithm which selects two random
   * healthy hosts and picks the host which has fewer active requests.  - RING_HASH: The ring/modulo
   * hash load balancer implements consistent hashing to backends. The algorithm has the property
   * that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.  -
   * RANDOM: The load balancer selects a random healthy host.  - ORIGINAL_DESTINATION: Backend host
   * is selected based on the client connection metadata, i.e., connections are opened to the same
   * address as the destination address of the incoming connection before the connection was
   * redirected to the load balancer.  - MAGLEV: used as a drop in replacement for the ring hash
   * load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and
   * host selection times. For more information about Maglev, see
   * https://ai.google/research/pubs/pub44824
   *
   * This field is applicable to either:   - A regional backend service with the service_protocol
   * set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.  - A global
   * backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   *
   * If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session
   * affinity settings will not take effect.
   *
   * Only the default ROUND_ROBIN policy is supported when the backend service is referenced by a
   * URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * @param localityLbPolicy localityLbPolicy or {@code null} for none
   */
  public BackendService setLocalityLbPolicy(java.lang.String localityLbPolicy) {
    this.localityLbPolicy = localityLbPolicy;
    return this;
  }

  /**
   * This field denotes the logging options for the load balancer traffic served by this backend
   * service. If logging is enabled, logs will be exported to Stackdriver.
   * @return value or {@code null} for none
   */
  public BackendServiceLogConfig getLogConfig() {
    return logConfig;
  }

  /**
   * This field denotes the logging options for the load balancer traffic served by this backend
   * service. If logging is enabled, logs will be exported to Stackdriver.
   * @param logConfig logConfig or {@code null} for none
   */
  public BackendService setLogConfig(BackendServiceLogConfig logConfig) {
    this.logConfig = logConfig;
    return this;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public BackendService setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The URL of the network to which this backend service belongs. This field can only be specified
   * when the load balancing scheme is set to INTERNAL.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * The URL of the network to which this backend service belongs. This field can only be specified
   * when the load balancing scheme is set to INTERNAL.
   * @param network network or {@code null} for none
   */
  public BackendService setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  /**
   * Settings controlling the eviction of unhealthy hosts from the load balancing pool for the
   * backend service. If not set, this feature is considered disabled.
   *
   * This field is applicable to either:   - A regional backend service with the service_protocol
   * set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.  - A global
   * backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public OutlierDetection getOutlierDetection() {
    return outlierDetection;
  }

  /**
   * Settings controlling the eviction of unhealthy hosts from the load balancing pool for the
   * backend service. If not set, this feature is considered disabled.
   *
   * This field is applicable to either:   - A regional backend service with the service_protocol
   * set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.  - A global
   * backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @param outlierDetection outlierDetection or {@code null} for none
   */
  public BackendService setOutlierDetection(OutlierDetection outlierDetection) {
    this.outlierDetection = outlierDetection;
    return this;
  }

  /**
   * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is
   * 80.
   *
   * This cannot be used if the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPort() {
    return port;
  }

  /**
   * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is
   * 80.
   *
   * This cannot be used if the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
   * @param port port or {@code null} for none
   */
  public BackendService setPort(java.lang.Integer port) {
    this.port = port;
    return this;
  }

  /**
   * A named port on a backend instance group representing the port for communication to the backend
   * VMs in that group. Required when the loadBalancingScheme is EXTERNAL (except Network Load
   * Balancing), INTERNAL_MANAGED, or  INTERNAL_SELF_MANAGED and the backends are instance groups.
   * The named port must be defined on each backend instance group. This parameter has no meaning if
   * the backends are NEGs.
   *
   * Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you
   * omit port_name.
   * @return value or {@code null} for none
   */
  public java.lang.String getPortName() {
    return portName;
  }

  /**
   * A named port on a backend instance group representing the port for communication to the backend
   * VMs in that group. Required when the loadBalancingScheme is EXTERNAL (except Network Load
   * Balancing), INTERNAL_MANAGED, or  INTERNAL_SELF_MANAGED and the backends are instance groups.
   * The named port must be defined on each backend instance group. This parameter has no meaning if
   * the backends are NEGs.
   *
   * Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you
   * omit port_name.
   * @param portName portName or {@code null} for none
   */
  public BackendService setPortName(java.lang.String portName) {
    this.portName = portName;
    return this;
  }

  /**
   * The protocol this BackendService uses to communicate with backends.
   *
   * Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load
   * balancer or Traffic Director configuration. Refer to the documentation for the load balancer or
   * for Traffic Director for more information.
   *
   * Must be set to GRPC when the backend service is referenced by a URL map that is bound to target
   * gRPC proxy.
   * @return value or {@code null} for none
   */
  public java.lang.String getProtocol() {
    return protocol;
  }

  /**
   * The protocol this BackendService uses to communicate with backends.
   *
   * Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load
   * balancer or Traffic Director configuration. Refer to the documentation for the load balancer or
   * for Traffic Director for more information.
   *
   * Must be set to GRPC when the backend service is referenced by a URL map that is bound to target
   * gRPC proxy.
   * @param protocol protocol or {@code null} for none
   */
  public BackendService setProtocol(java.lang.String protocol) {
    this.protocol = protocol;
    return this;
  }

  /**
   * [Output Only] URL of the region where the regional backend service resides. This field is not
   * applicable to global backend services. You must specify this field as part of the HTTP request
   * URL. It is not settable as a field in the request body.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * [Output Only] URL of the region where the regional backend service resides. This field is not
   * applicable to global backend services. You must specify this field as part of the HTTP request
   * URL. It is not settable as a field in the request body.
   * @param region region or {@code null} for none
   */
  public BackendService setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * [Output Only] The resource URL for the security policy associated with this backend service.
   * @return value or {@code null} for none
   */
  public java.lang.String getSecurityPolicy() {
    return securityPolicy;
  }

  /**
   * [Output Only] The resource URL for the security policy associated with this backend service.
   * @param securityPolicy securityPolicy or {@code null} for none
   */
  public BackendService setSecurityPolicy(java.lang.String securityPolicy) {
    this.securityPolicy = securityPolicy;
    return this;
  }

  /**
   * This field specifies the security policy that applies to this backend service. This field is
   * applicable to either: - A regional backend service with the service_protocol set to HTTP,
   * HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.  - A global backend service
   * with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   * @return value or {@code null} for none
   */
  public SecuritySettings getSecuritySettings() {
    return securitySettings;
  }

  /**
   * This field specifies the security policy that applies to this backend service. This field is
   * applicable to either: - A regional backend service with the service_protocol set to HTTP,
   * HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.  - A global backend service
   * with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   * @param securitySettings securitySettings or {@code null} for none
   */
  public BackendService setSecuritySettings(SecuritySettings securitySettings) {
    this.securitySettings = securitySettings;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public BackendService setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Type of session affinity to use. The default is NONE.
   *
   * When the loadBalancingScheme is EXTERNAL: * For Network Load Balancing, the possible values are
   * NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO. * For all other load balancers that
   * use loadBalancingScheme=EXTERNAL, the possible values are NONE, CLIENT_IP, or GENERATED_COOKIE.
   * * You can use GENERATED_COOKIE if the protocol is HTTP, HTTP2, or HTTPS.
   *
   * When the loadBalancingScheme is INTERNAL, possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO,
   * or CLIENT_IP_PORT_PROTO.
   *
   * When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, possible values are
   * NONE, CLIENT_IP, GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public java.lang.String getSessionAffinity() {
    return sessionAffinity;
  }

  /**
   * Type of session affinity to use. The default is NONE.
   *
   * When the loadBalancingScheme is EXTERNAL: * For Network Load Balancing, the possible values are
   * NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO. * For all other load balancers that
   * use loadBalancingScheme=EXTERNAL, the possible values are NONE, CLIENT_IP, or GENERATED_COOKIE.
   * * You can use GENERATED_COOKIE if the protocol is HTTP, HTTP2, or HTTPS.
   *
   * When the loadBalancingScheme is INTERNAL, possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO,
   * or CLIENT_IP_PORT_PROTO.
   *
   * When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, possible values are
   * NONE, CLIENT_IP, GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.
   *
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @param sessionAffinity sessionAffinity or {@code null} for none
   */
  public BackendService setSessionAffinity(java.lang.String sessionAffinity) {
    this.sessionAffinity = sessionAffinity;
    return this;
  }

  /**
   * The backend service timeout has a different meaning depending on the type of load balancer. For
   * more information see,  Backend service settings The default is 30 seconds.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTimeoutSec() {
    return timeoutSec;
  }

  /**
   * The backend service timeout has a different meaning depending on the type of load balancer. For
   * more information see,  Backend service settings The default is 30 seconds.
   * @param timeoutSec timeoutSec or {@code null} for none
   */
  public BackendService setTimeoutSec(java.lang.Integer timeoutSec) {
    this.timeoutSec = timeoutSec;
    return this;
  }

  @Override
  public BackendService set(String fieldName, Object value) {
    return (BackendService) super.set(fieldName, value);
  }

  @Override
  public BackendService clone() {
    return (BackendService) super.clone();
  }

}
