/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a Packet Mirroring resource.
 *
 * Packet Mirroring clones the traffic of specified instances in your Virtual Private Cloud (VPC)
 * network and forwards it to a collector destination, such as an instance group of an internal
 * TCP/UDP load balancer, for analysis or examination. For more information about setting up Packet
 * Mirroring, see Using Packet Mirroring. (== resource_for {$api_version}.packetMirrorings ==)
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PacketMirroring extends com.google.api.client.json.GenericJson {

  /**
   * The Forwarding Rule resource of type loadBalancingScheme=INTERNAL that will be used as
   * collector for mirrored traffic. The specified forwarding rule must have isMirroringCollector
   * set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PacketMirroringForwardingRuleInfo collectorIlb;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Indicates whether or not this packet mirroring takes effect. If set to FALSE, this packet
   * mirroring policy will not be enforced on the network.
   *
   * The default is TRUE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String enable;

  /**
   * Filter for mirrored traffic. If unspecified, all traffic is mirrored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PacketMirroringFilter filter;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of the resource. Always compute#packetMirroring for packet mirrorings.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * PacketMirroring mirroredResourceInfos. MirroredResourceInfo specifies a set of mirrored VM
   * instances, subnetworks and/or tags for which traffic from/to all VM instances will be mirrored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PacketMirroringMirroredResourceInfo mirroredResources;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Specifies the mirrored VPC network. Only packets in this network will be mirrored. All mirrored
   * VMs should have a NIC in the given network. All mirrored subnetworks should belong to the given
   * network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PacketMirroringNetworkInfo network;

  /**
   * The priority of applying this configuration. Priority is used to break ties in cases where
   * there is more than one matching rule. In the case of two rules that apply for a given Instance,
   * the one with the lowest-numbered priority value wins.
   *
   * Default value is 1000. Valid range is 0 through 65535.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long priority;

  /**
   * [Output Only] URI of the region where the packetMirroring resides.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The Forwarding Rule resource of type loadBalancingScheme=INTERNAL that will be used as
   * collector for mirrored traffic. The specified forwarding rule must have isMirroringCollector
   * set to true.
   * @return value or {@code null} for none
   */
  public PacketMirroringForwardingRuleInfo getCollectorIlb() {
    return collectorIlb;
  }

  /**
   * The Forwarding Rule resource of type loadBalancingScheme=INTERNAL that will be used as
   * collector for mirrored traffic. The specified forwarding rule must have isMirroringCollector
   * set to true.
   * @param collectorIlb collectorIlb or {@code null} for none
   */
  public PacketMirroring setCollectorIlb(PacketMirroringForwardingRuleInfo collectorIlb) {
    this.collectorIlb = collectorIlb;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public PacketMirroring setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public PacketMirroring setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Indicates whether or not this packet mirroring takes effect. If set to FALSE, this packet
   * mirroring policy will not be enforced on the network.
   *
   * The default is TRUE.
   * @return value or {@code null} for none
   */
  public java.lang.String getEnable() {
    return enable;
  }

  /**
   * Indicates whether or not this packet mirroring takes effect. If set to FALSE, this packet
   * mirroring policy will not be enforced on the network.
   *
   * The default is TRUE.
   * @param enable enable or {@code null} for none
   */
  public PacketMirroring setEnable(java.lang.String enable) {
    this.enable = enable;
    return this;
  }

  /**
   * Filter for mirrored traffic. If unspecified, all traffic is mirrored.
   * @return value or {@code null} for none
   */
  public PacketMirroringFilter getFilter() {
    return filter;
  }

  /**
   * Filter for mirrored traffic. If unspecified, all traffic is mirrored.
   * @param filter filter or {@code null} for none
   */
  public PacketMirroring setFilter(PacketMirroringFilter filter) {
    this.filter = filter;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public PacketMirroring setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#packetMirroring for packet mirrorings.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#packetMirroring for packet mirrorings.
   * @param kind kind or {@code null} for none
   */
  public PacketMirroring setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * PacketMirroring mirroredResourceInfos. MirroredResourceInfo specifies a set of mirrored VM
   * instances, subnetworks and/or tags for which traffic from/to all VM instances will be mirrored.
   * @return value or {@code null} for none
   */
  public PacketMirroringMirroredResourceInfo getMirroredResources() {
    return mirroredResources;
  }

  /**
   * PacketMirroring mirroredResourceInfos. MirroredResourceInfo specifies a set of mirrored VM
   * instances, subnetworks and/or tags for which traffic from/to all VM instances will be mirrored.
   * @param mirroredResources mirroredResources or {@code null} for none
   */
  public PacketMirroring setMirroredResources(PacketMirroringMirroredResourceInfo mirroredResources) {
    this.mirroredResources = mirroredResources;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public PacketMirroring setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Specifies the mirrored VPC network. Only packets in this network will be mirrored. All mirrored
   * VMs should have a NIC in the given network. All mirrored subnetworks should belong to the given
   * network.
   * @return value or {@code null} for none
   */
  public PacketMirroringNetworkInfo getNetwork() {
    return network;
  }

  /**
   * Specifies the mirrored VPC network. Only packets in this network will be mirrored. All mirrored
   * VMs should have a NIC in the given network. All mirrored subnetworks should belong to the given
   * network.
   * @param network network or {@code null} for none
   */
  public PacketMirroring setNetwork(PacketMirroringNetworkInfo network) {
    this.network = network;
    return this;
  }

  /**
   * The priority of applying this configuration. Priority is used to break ties in cases where
   * there is more than one matching rule. In the case of two rules that apply for a given Instance,
   * the one with the lowest-numbered priority value wins.
   *
   * Default value is 1000. Valid range is 0 through 65535.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPriority() {
    return priority;
  }

  /**
   * The priority of applying this configuration. Priority is used to break ties in cases where
   * there is more than one matching rule. In the case of two rules that apply for a given Instance,
   * the one with the lowest-numbered priority value wins.
   *
   * Default value is 1000. Valid range is 0 through 65535.
   * @param priority priority or {@code null} for none
   */
  public PacketMirroring setPriority(java.lang.Long priority) {
    this.priority = priority;
    return this;
  }

  /**
   * [Output Only] URI of the region where the packetMirroring resides.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * [Output Only] URI of the region where the packetMirroring resides.
   * @param region region or {@code null} for none
   */
  public PacketMirroring setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public PacketMirroring setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public PacketMirroring set(String fieldName, Object value) {
    return (PacketMirroring) super.set(fieldName, value);
  }

  @Override
  public PacketMirroring clone() {
    return (PacketMirroring) super.clone();
  }

}
