/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Settings controlling the volume of requests, connections and retries to this backend service.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CircuitBreakers extends com.google.api.client.json.GenericJson {

  /**
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxConnections;

  /**
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxPendingRequests;

  /**
   * The maximum number of parallel requests that allowed to the backend service. If not specified,
   * there is no limit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxRequests;

  /**
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxRequestsPerConnection;

  /**
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxRetries;

  /**
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxConnections() {
    return maxConnections;
  }

  /**
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @param maxConnections maxConnections or {@code null} for none
   */
  public CircuitBreakers setMaxConnections(java.lang.Integer maxConnections) {
    this.maxConnections = maxConnections;
    return this;
  }

  /**
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxPendingRequests() {
    return maxPendingRequests;
  }

  /**
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @param maxPendingRequests maxPendingRequests or {@code null} for none
   */
  public CircuitBreakers setMaxPendingRequests(java.lang.Integer maxPendingRequests) {
    this.maxPendingRequests = maxPendingRequests;
    return this;
  }

  /**
   * The maximum number of parallel requests that allowed to the backend service. If not specified,
   * there is no limit.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxRequests() {
    return maxRequests;
  }

  /**
   * The maximum number of parallel requests that allowed to the backend service. If not specified,
   * there is no limit.
   * @param maxRequests maxRequests or {@code null} for none
   */
  public CircuitBreakers setMaxRequests(java.lang.Integer maxRequests) {
    this.maxRequests = maxRequests;
    return this;
  }

  /**
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxRequestsPerConnection() {
    return maxRequestsPerConnection;
  }

  /**
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @param maxRequestsPerConnection maxRequestsPerConnection or {@code null} for none
   */
  public CircuitBreakers setMaxRequestsPerConnection(java.lang.Integer maxRequestsPerConnection) {
    this.maxRequestsPerConnection = maxRequestsPerConnection;
    return this;
  }

  /**
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxRetries() {
    return maxRetries;
  }

  /**
   * Not supported when the backend service is referenced by a URL map that is bound to target gRPC
   * proxy that has validateForProxyless field set to true.
   * @param maxRetries maxRetries or {@code null} for none
   */
  public CircuitBreakers setMaxRetries(java.lang.Integer maxRetries) {
    this.maxRetries = maxRetries;
    return this;
  }

  @Override
  public CircuitBreakers set(String fieldName, Object value) {
    return (CircuitBreakers) super.set(fieldName, value);
  }

  @Override
  public CircuitBreakers clone() {
    return (CircuitBreakers) super.clone();
  }

}
