/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a Firewall Policy resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FirewallPolicy extends com.google.api.client.json.GenericJson {

  /**
   * A list of associations that belong to this firewall policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FirewallPolicyAssociation> associations;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Deprecated, please use short name instead. User-provided name of the Organization firewall
   * policy. The name should be unique in the organization in which the firewall policy is created.
   * This name must be set on creation and cannot be changed. The name must be 1-63 characters long,
   * and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the
   * regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a
   * lowercase letter, and all following characters must be a dash, lowercase letter, or digit,
   * except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's
   * contents and used for optimistic locking. The fingerprint is initially generated by Compute
   * Engine and changes after every request to modify or update metadata. You must always provide an
   * up-to-date fingerprint hash in order to update or change metadata, otherwise the request will
   * fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the
   * firewall policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output only] Type of the resource. Always compute#firewallPolicyfor firewall policies
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] Name of the resource. It is a numeric ID allocated by GCP which uniquely
   * identifies the Firewall Policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] The parent of the firewall policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parent;

  /**
   * [Output Only] Total count of all firewall policy rule tuples. A firewall policy can not exceed
   * a set number of tuples.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer ruleTupleCount;

  /**
   * A list of rules that belong to this policy. There must always be a default rule (rule with
   * priority 2147483647 and match "*"). If no rules are provided when creating a firewall policy, a
   * default rule with action "allow" will be added.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FirewallPolicyRule> rules;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLinkWithId;

  /**
   * User-provided name of the Organization firewall plicy. The name should be unique in the
   * organization in which the firewall policy is created. This name must be set on creation and
   * cannot be changed. The name must be 1-63 characters long, and comply with RFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular expression
   * `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and
   * all following characters must be a dash, lowercase letter, or digit, except the last character,
   * which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shortName;

  /**
   * A list of associations that belong to this firewall policy.
   * @return value or {@code null} for none
   */
  public java.util.List<FirewallPolicyAssociation> getAssociations() {
    return associations;
  }

  /**
   * A list of associations that belong to this firewall policy.
   * @param associations associations or {@code null} for none
   */
  public FirewallPolicy setAssociations(java.util.List<FirewallPolicyAssociation> associations) {
    this.associations = associations;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public FirewallPolicy setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public FirewallPolicy setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Deprecated, please use short name instead. User-provided name of the Organization firewall
   * policy. The name should be unique in the organization in which the firewall policy is created.
   * This name must be set on creation and cannot be changed. The name must be 1-63 characters long,
   * and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the
   * regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a
   * lowercase letter, and all following characters must be a dash, lowercase letter, or digit,
   * except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Deprecated, please use short name instead. User-provided name of the Organization firewall
   * policy. The name should be unique in the organization in which the firewall policy is created.
   * This name must be set on creation and cannot be changed. The name must be 1-63 characters long,
   * and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the
   * regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a
   * lowercase letter, and all following characters must be a dash, lowercase letter, or digit,
   * except the last character, which cannot be a dash.
   * @param displayName displayName or {@code null} for none
   */
  public FirewallPolicy setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's
   * contents and used for optimistic locking. The fingerprint is initially generated by Compute
   * Engine and changes after every request to modify or update metadata. You must always provide an
   * up-to-date fingerprint hash in order to update or change metadata, otherwise the request will
   * fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the
   * firewall policy.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's
   * contents and used for optimistic locking. The fingerprint is initially generated by Compute
   * Engine and changes after every request to modify or update metadata. You must always provide an
   * up-to-date fingerprint hash in order to update or change metadata, otherwise the request will
   * fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the
   * firewall policy.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's
   * contents and used for optimistic locking. The fingerprint is initially generated by Compute
   * Engine and changes after every request to modify or update metadata. You must always provide an
   * up-to-date fingerprint hash in order to update or change metadata, otherwise the request will
   * fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the
   * firewall policy.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public FirewallPolicy setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * Specifies a fingerprint for this resource, which is essentially a hash of the metadata's
   * contents and used for optimistic locking. The fingerprint is initially generated by Compute
   * Engine and changes after every request to modify or update metadata. You must always provide an
   * up-to-date fingerprint hash in order to update or change metadata, otherwise the request will
   * fail with error 412 conditionNotMet. To see the latest fingerprint, make get() request to the
   * firewall policy.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public FirewallPolicy encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public FirewallPolicy setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output only] Type of the resource. Always compute#firewallPolicyfor firewall policies
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output only] Type of the resource. Always compute#firewallPolicyfor firewall policies
   * @param kind kind or {@code null} for none
   */
  public FirewallPolicy setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] Name of the resource. It is a numeric ID allocated by GCP which uniquely
   * identifies the Firewall Policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * [Output Only] Name of the resource. It is a numeric ID allocated by GCP which uniquely
   * identifies the Firewall Policy.
   * @param name name or {@code null} for none
   */
  public FirewallPolicy setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] The parent of the firewall policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getParent() {
    return parent;
  }

  /**
   * [Output Only] The parent of the firewall policy.
   * @param parent parent or {@code null} for none
   */
  public FirewallPolicy setParent(java.lang.String parent) {
    this.parent = parent;
    return this;
  }

  /**
   * [Output Only] Total count of all firewall policy rule tuples. A firewall policy can not exceed
   * a set number of tuples.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRuleTupleCount() {
    return ruleTupleCount;
  }

  /**
   * [Output Only] Total count of all firewall policy rule tuples. A firewall policy can not exceed
   * a set number of tuples.
   * @param ruleTupleCount ruleTupleCount or {@code null} for none
   */
  public FirewallPolicy setRuleTupleCount(java.lang.Integer ruleTupleCount) {
    this.ruleTupleCount = ruleTupleCount;
    return this;
  }

  /**
   * A list of rules that belong to this policy. There must always be a default rule (rule with
   * priority 2147483647 and match "*"). If no rules are provided when creating a firewall policy, a
   * default rule with action "allow" will be added.
   * @return value or {@code null} for none
   */
  public java.util.List<FirewallPolicyRule> getRules() {
    return rules;
  }

  /**
   * A list of rules that belong to this policy. There must always be a default rule (rule with
   * priority 2147483647 and match "*"). If no rules are provided when creating a firewall policy, a
   * default rule with action "allow" will be added.
   * @param rules rules or {@code null} for none
   */
  public FirewallPolicy setRules(java.util.List<FirewallPolicyRule> rules) {
    this.rules = rules;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public FirewallPolicy setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLinkWithId() {
    return selfLinkWithId;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @param selfLinkWithId selfLinkWithId or {@code null} for none
   */
  public FirewallPolicy setSelfLinkWithId(java.lang.String selfLinkWithId) {
    this.selfLinkWithId = selfLinkWithId;
    return this;
  }

  /**
   * User-provided name of the Organization firewall plicy. The name should be unique in the
   * organization in which the firewall policy is created. This name must be set on creation and
   * cannot be changed. The name must be 1-63 characters long, and comply with RFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular expression
   * `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and
   * all following characters must be a dash, lowercase letter, or digit, except the last character,
   * which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getShortName() {
    return shortName;
  }

  /**
   * User-provided name of the Organization firewall plicy. The name should be unique in the
   * organization in which the firewall policy is created. This name must be set on creation and
   * cannot be changed. The name must be 1-63 characters long, and comply with RFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular expression
   * `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and
   * all following characters must be a dash, lowercase letter, or digit, except the last character,
   * which cannot be a dash.
   * @param shortName shortName or {@code null} for none
   */
  public FirewallPolicy setShortName(java.lang.String shortName) {
    this.shortName = shortName;
    return this;
  }

  @Override
  public FirewallPolicy set(String fieldName, Object value) {
    return (FirewallPolicy) super.set(fieldName, value);
  }

  @Override
  public FirewallPolicy clone() {
    return (FirewallPolicy) super.clone();
  }

}
