/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * DEPRECATED: Please use compute#savedDisk instead. An instance-attached disk resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SavedAttachedDisk extends com.google.api.client.json.GenericJson {

  /**
   * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the
   * disk is detached from the instance).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoDelete;

  /**
   * Indicates that this is a boot disk. The virtual machine will use the first partition of the
   * disk for its root filesystem.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean boot;

  /**
   * Specifies the name of the disk attached to the source instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deviceName;

  /**
   * The encryption key for the disk.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CustomerEncryptionKey diskEncryptionKey;

  /**
   * The size of the disk in base-2 GB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long diskSizeGb;

  /**
   * [Output Only] URL of the disk type resource. For example: projects/project
   * /zones/zone/diskTypes/pd-standard or pd-ssd
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String diskType;

  /**
   * A list of features to enable on the guest operating system. Applicable only for bootable
   * images. Read Enabling guest operating system features to see a list of available options.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GuestOsFeature> guestOsFeatures;

  static {
    // hack to force ProGuard to consider GuestOsFeature used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GuestOsFeature.class);
  }

  /**
   * Specifies zero-based index of the disk that is attached to the source instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer index;

  /**
   * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("interface")
  private java.lang.String interface__;

  /**
   * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] Any valid publicly visible licenses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> licenses;

  /**
   * The mode in which this disk is attached to the source instance, either READ_WRITE or READ_ONLY.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mode;

  /**
   * Specifies a URL of the disk attached to the source instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String source;

  /**
   * [Output Only] A size of the storage used by the disk's snapshot by this machine image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long storageBytes;

  /**
   * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as
   * a result of shared storage reallocation. This status can either be UPDATING, meaning the size
   * of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-
   * date.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String storageBytesStatus;

  /**
   * Specifies the type of the attached disk, either SCRATCH or PERSISTENT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the
   * disk is detached from the instance).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoDelete() {
    return autoDelete;
  }

  /**
   * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the
   * disk is detached from the instance).
   * @param autoDelete autoDelete or {@code null} for none
   */
  public SavedAttachedDisk setAutoDelete(java.lang.Boolean autoDelete) {
    this.autoDelete = autoDelete;
    return this;
  }

  /**
   * Indicates that this is a boot disk. The virtual machine will use the first partition of the
   * disk for its root filesystem.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getBoot() {
    return boot;
  }

  /**
   * Indicates that this is a boot disk. The virtual machine will use the first partition of the
   * disk for its root filesystem.
   * @param boot boot or {@code null} for none
   */
  public SavedAttachedDisk setBoot(java.lang.Boolean boot) {
    this.boot = boot;
    return this;
  }

  /**
   * Specifies the name of the disk attached to the source instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeviceName() {
    return deviceName;
  }

  /**
   * Specifies the name of the disk attached to the source instance.
   * @param deviceName deviceName or {@code null} for none
   */
  public SavedAttachedDisk setDeviceName(java.lang.String deviceName) {
    this.deviceName = deviceName;
    return this;
  }

  /**
   * The encryption key for the disk.
   * @return value or {@code null} for none
   */
  public CustomerEncryptionKey getDiskEncryptionKey() {
    return diskEncryptionKey;
  }

  /**
   * The encryption key for the disk.
   * @param diskEncryptionKey diskEncryptionKey or {@code null} for none
   */
  public SavedAttachedDisk setDiskEncryptionKey(CustomerEncryptionKey diskEncryptionKey) {
    this.diskEncryptionKey = diskEncryptionKey;
    return this;
  }

  /**
   * The size of the disk in base-2 GB.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDiskSizeGb() {
    return diskSizeGb;
  }

  /**
   * The size of the disk in base-2 GB.
   * @param diskSizeGb diskSizeGb or {@code null} for none
   */
  public SavedAttachedDisk setDiskSizeGb(java.lang.Long diskSizeGb) {
    this.diskSizeGb = diskSizeGb;
    return this;
  }

  /**
   * [Output Only] URL of the disk type resource. For example: projects/project
   * /zones/zone/diskTypes/pd-standard or pd-ssd
   * @return value or {@code null} for none
   */
  public java.lang.String getDiskType() {
    return diskType;
  }

  /**
   * [Output Only] URL of the disk type resource. For example: projects/project
   * /zones/zone/diskTypes/pd-standard or pd-ssd
   * @param diskType diskType or {@code null} for none
   */
  public SavedAttachedDisk setDiskType(java.lang.String diskType) {
    this.diskType = diskType;
    return this;
  }

  /**
   * A list of features to enable on the guest operating system. Applicable only for bootable
   * images. Read Enabling guest operating system features to see a list of available options.
   * @return value or {@code null} for none
   */
  public java.util.List<GuestOsFeature> getGuestOsFeatures() {
    return guestOsFeatures;
  }

  /**
   * A list of features to enable on the guest operating system. Applicable only for bootable
   * images. Read Enabling guest operating system features to see a list of available options.
   * @param guestOsFeatures guestOsFeatures or {@code null} for none
   */
  public SavedAttachedDisk setGuestOsFeatures(java.util.List<GuestOsFeature> guestOsFeatures) {
    this.guestOsFeatures = guestOsFeatures;
    return this;
  }

  /**
   * Specifies zero-based index of the disk that is attached to the source instance.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getIndex() {
    return index;
  }

  /**
   * Specifies zero-based index of the disk that is attached to the source instance.
   * @param index index or {@code null} for none
   */
  public SavedAttachedDisk setIndex(java.lang.Integer index) {
    this.index = index;
    return this;
  }

  /**
   * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME.
   * @return value or {@code null} for none
   */
  public java.lang.String getInterface() {
    return interface__;
  }

  /**
   * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME.
   * @param interface__ interface__ or {@code null} for none
   */
  public SavedAttachedDisk setInterface(java.lang.String interface__) {
    this.interface__ = interface__;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
   * @param kind kind or {@code null} for none
   */
  public SavedAttachedDisk setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] Any valid publicly visible licenses.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLicenses() {
    return licenses;
  }

  /**
   * [Output Only] Any valid publicly visible licenses.
   * @param licenses licenses or {@code null} for none
   */
  public SavedAttachedDisk setLicenses(java.util.List<java.lang.String> licenses) {
    this.licenses = licenses;
    return this;
  }

  /**
   * The mode in which this disk is attached to the source instance, either READ_WRITE or READ_ONLY.
   * @return value or {@code null} for none
   */
  public java.lang.String getMode() {
    return mode;
  }

  /**
   * The mode in which this disk is attached to the source instance, either READ_WRITE or READ_ONLY.
   * @param mode mode or {@code null} for none
   */
  public SavedAttachedDisk setMode(java.lang.String mode) {
    this.mode = mode;
    return this;
  }

  /**
   * Specifies a URL of the disk attached to the source instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getSource() {
    return source;
  }

  /**
   * Specifies a URL of the disk attached to the source instance.
   * @param source source or {@code null} for none
   */
  public SavedAttachedDisk setSource(java.lang.String source) {
    this.source = source;
    return this;
  }

  /**
   * [Output Only] A size of the storage used by the disk's snapshot by this machine image.
   * @return value or {@code null} for none
   */
  public java.lang.Long getStorageBytes() {
    return storageBytes;
  }

  /**
   * [Output Only] A size of the storage used by the disk's snapshot by this machine image.
   * @param storageBytes storageBytes or {@code null} for none
   */
  public SavedAttachedDisk setStorageBytes(java.lang.Long storageBytes) {
    this.storageBytes = storageBytes;
    return this;
  }

  /**
   * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as
   * a result of shared storage reallocation. This status can either be UPDATING, meaning the size
   * of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-
   * date.
   * @return value or {@code null} for none
   */
  public java.lang.String getStorageBytesStatus() {
    return storageBytesStatus;
  }

  /**
   * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as
   * a result of shared storage reallocation. This status can either be UPDATING, meaning the size
   * of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-
   * date.
   * @param storageBytesStatus storageBytesStatus or {@code null} for none
   */
  public SavedAttachedDisk setStorageBytesStatus(java.lang.String storageBytesStatus) {
    this.storageBytesStatus = storageBytesStatus;
    return this;
  }

  /**
   * Specifies the type of the attached disk, either SCRATCH or PERSISTENT.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Specifies the type of the attached disk, either SCRATCH or PERSISTENT.
   * @param type type or {@code null} for none
   */
  public SavedAttachedDisk setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public SavedAttachedDisk set(String fieldName, Object value) {
    return (SavedAttachedDisk) super.set(fieldName, value);
  }

  @Override
  public SavedAttachedDisk clone() {
    return (SavedAttachedDisk) super.clone();
  }

}
