/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The authentication and authorization settings for a BackendService.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SecuritySettings extends com.google.api.client.json.GenericJson {

  /**
   * Optional. A URL referring to a networksecurity.ClientTlsPolicy resource that describes how
   * clients should authenticate with this service's backends. clientTlsPolicy only applies to a
   * global BackendService with the loadBalancingScheme set to INTERNAL_SELF_MANAGED. If left blank,
   * communications are not encrypted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clientTlsPolicy;

  /**
   * Optional. A list of Subject Alternative Names (SANs) that the client verifies during a mutual
   * TLS handshake with an server/endpoint for this BackendService. When the server presents its
   * X.509 certificate to the client, the client inspects the certificate's subjectAltName field. If
   * the field contains one of the specified values, the communication continues. Otherwise, it
   * fails. This additional check enables the client to verify that the server is authorized to run
   * the requested service. Note that the contents of the server certificate's subjectAltName field
   * are configured by the Public Key Infrastructure which provisions server identities. Only
   * applies to a global BackendService with loadBalancingScheme set to INTERNAL_SELF_MANAGED. Only
   * applies when BackendService has an attached clientTlsPolicy with clientCertificate (mTLS mode).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> subjectAltNames;

  /**
   * Optional. A URL referring to a networksecurity.ClientTlsPolicy resource that describes how
   * clients should authenticate with this service's backends. clientTlsPolicy only applies to a
   * global BackendService with the loadBalancingScheme set to INTERNAL_SELF_MANAGED. If left blank,
   * communications are not encrypted.
   * @return value or {@code null} for none
   */
  public java.lang.String getClientTlsPolicy() {
    return clientTlsPolicy;
  }

  /**
   * Optional. A URL referring to a networksecurity.ClientTlsPolicy resource that describes how
   * clients should authenticate with this service's backends. clientTlsPolicy only applies to a
   * global BackendService with the loadBalancingScheme set to INTERNAL_SELF_MANAGED. If left blank,
   * communications are not encrypted.
   * @param clientTlsPolicy clientTlsPolicy or {@code null} for none
   */
  public SecuritySettings setClientTlsPolicy(java.lang.String clientTlsPolicy) {
    this.clientTlsPolicy = clientTlsPolicy;
    return this;
  }

  /**
   * Optional. A list of Subject Alternative Names (SANs) that the client verifies during a mutual
   * TLS handshake with an server/endpoint for this BackendService. When the server presents its
   * X.509 certificate to the client, the client inspects the certificate's subjectAltName field. If
   * the field contains one of the specified values, the communication continues. Otherwise, it
   * fails. This additional check enables the client to verify that the server is authorized to run
   * the requested service. Note that the contents of the server certificate's subjectAltName field
   * are configured by the Public Key Infrastructure which provisions server identities. Only
   * applies to a global BackendService with loadBalancingScheme set to INTERNAL_SELF_MANAGED. Only
   * applies when BackendService has an attached clientTlsPolicy with clientCertificate (mTLS mode).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSubjectAltNames() {
    return subjectAltNames;
  }

  /**
   * Optional. A list of Subject Alternative Names (SANs) that the client verifies during a mutual
   * TLS handshake with an server/endpoint for this BackendService. When the server presents its
   * X.509 certificate to the client, the client inspects the certificate's subjectAltName field. If
   * the field contains one of the specified values, the communication continues. Otherwise, it
   * fails. This additional check enables the client to verify that the server is authorized to run
   * the requested service. Note that the contents of the server certificate's subjectAltName field
   * are configured by the Public Key Infrastructure which provisions server identities. Only
   * applies to a global BackendService with loadBalancingScheme set to INTERNAL_SELF_MANAGED. Only
   * applies when BackendService has an attached clientTlsPolicy with clientCertificate (mTLS mode).
   * @param subjectAltNames subjectAltNames or {@code null} for none
   */
  public SecuritySettings setSubjectAltNames(java.util.List<java.lang.String> subjectAltNames) {
    this.subjectAltNames = subjectAltNames;
    return this;
  }

  @Override
  public SecuritySettings set(String fieldName, Object value) {
    return (SecuritySettings) super.set(fieldName, value);
  }

  @Override
  public SecuritySettings clone() {
    return (SecuritySettings) super.clone();
  }

}
