/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Configuration information for enabling Media Access Control security (MACsec) on this Cloud
 * Interconnect connection between Google and your on-premises router.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectMacsec extends com.google.api.client.json.GenericJson {

  /**
   * If set to true, the Interconnect connection is configured with a should-secure MACsec security
   * policy, that allows the Google router to fallback to cleartext traffic if the MKA session
   * cannot be established. By default, the Interconnect connection is configured with a must-secure
   * security policy that drops all traffic if the MKA session cannot be established with your
   * router.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean failOpen;

  /**
   * Required. A keychain placeholder describing a set of named key objects along with their start
   * times. A MACsec CKN/CAK is generated for each key in the key chain. Google router automatically
   * picks the key with the most recent startTime when establishing or re-establishing a MACsec
   * secure link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InterconnectMacsecPreSharedKey> preSharedKeys;

  /**
   * If set to true, the Interconnect connection is configured with a should-secure MACsec security
   * policy, that allows the Google router to fallback to cleartext traffic if the MKA session
   * cannot be established. By default, the Interconnect connection is configured with a must-secure
   * security policy that drops all traffic if the MKA session cannot be established with your
   * router.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFailOpen() {
    return failOpen;
  }

  /**
   * If set to true, the Interconnect connection is configured with a should-secure MACsec security
   * policy, that allows the Google router to fallback to cleartext traffic if the MKA session
   * cannot be established. By default, the Interconnect connection is configured with a must-secure
   * security policy that drops all traffic if the MKA session cannot be established with your
   * router.
   * @param failOpen failOpen or {@code null} for none
   */
  public InterconnectMacsec setFailOpen(java.lang.Boolean failOpen) {
    this.failOpen = failOpen;
    return this;
  }

  /**
   * Required. A keychain placeholder describing a set of named key objects along with their start
   * times. A MACsec CKN/CAK is generated for each key in the key chain. Google router automatically
   * picks the key with the most recent startTime when establishing or re-establishing a MACsec
   * secure link.
   * @return value or {@code null} for none
   */
  public java.util.List<InterconnectMacsecPreSharedKey> getPreSharedKeys() {
    return preSharedKeys;
  }

  /**
   * Required. A keychain placeholder describing a set of named key objects along with their start
   * times. A MACsec CKN/CAK is generated for each key in the key chain. Google router automatically
   * picks the key with the most recent startTime when establishing or re-establishing a MACsec
   * secure link.
   * @param preSharedKeys preSharedKeys or {@code null} for none
   */
  public InterconnectMacsec setPreSharedKeys(java.util.List<InterconnectMacsecPreSharedKey> preSharedKeys) {
    this.preSharedKeys = preSharedKeys;
    return this;
  }

  @Override
  public InterconnectMacsec set(String fieldName, Object value) {
    return (InterconnectMacsec) super.set(fieldName, value);
  }

  @Override
  public InterconnectMacsec clone() {
    return (InterconnectMacsec) super.clone();
  }

}
