/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for SecurityPolicyRulePreconfiguredWafConfigExclusion.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SecurityPolicyRulePreconfiguredWafConfigExclusion extends com.google.api.client.json.GenericJson {

  /**
   * A list of request cookie names whose value will be excluded from inspection during
   * preconfigured WAF evaluation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams> requestCookiesToExclude;

  /**
   * A list of request header names whose value will be excluded from inspection during
   * preconfigured WAF evaluation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams> requestHeadersToExclude;

  /**
   * A list of request query parameter names whose value will be excluded from inspection during
   * preconfigured WAF evaluation. Note that the parameter can be in the query string or in the POST
   * body.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams> requestQueryParamsToExclude;

  /**
   * A list of request URIs from the request line to be excluded from inspection during
   * preconfigured WAF evaluation. When specifying this field, the query or fragment part should be
   * excluded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams> requestUrisToExclude;

  /**
   * A list of target rule IDs under the WAF rule set to apply the preconfigured WAF exclusion. If
   * omitted, it refers to all the rule IDs under the WAF rule set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> targetRuleIds;

  /**
   * Target WAF rule set to apply the preconfigured WAF exclusion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetRuleSet;

  /**
   * A list of request cookie names whose value will be excluded from inspection during
   * preconfigured WAF evaluation.
   * @return value or {@code null} for none
   */
  public java.util.List<SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams> getRequestCookiesToExclude() {
    return requestCookiesToExclude;
  }

  /**
   * A list of request cookie names whose value will be excluded from inspection during
   * preconfigured WAF evaluation.
   * @param requestCookiesToExclude requestCookiesToExclude or {@code null} for none
   */
  public SecurityPolicyRulePreconfiguredWafConfigExclusion setRequestCookiesToExclude(java.util.List<SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams> requestCookiesToExclude) {
    this.requestCookiesToExclude = requestCookiesToExclude;
    return this;
  }

  /**
   * A list of request header names whose value will be excluded from inspection during
   * preconfigured WAF evaluation.
   * @return value or {@code null} for none
   */
  public java.util.List<SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams> getRequestHeadersToExclude() {
    return requestHeadersToExclude;
  }

  /**
   * A list of request header names whose value will be excluded from inspection during
   * preconfigured WAF evaluation.
   * @param requestHeadersToExclude requestHeadersToExclude or {@code null} for none
   */
  public SecurityPolicyRulePreconfiguredWafConfigExclusion setRequestHeadersToExclude(java.util.List<SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams> requestHeadersToExclude) {
    this.requestHeadersToExclude = requestHeadersToExclude;
    return this;
  }

  /**
   * A list of request query parameter names whose value will be excluded from inspection during
   * preconfigured WAF evaluation. Note that the parameter can be in the query string or in the POST
   * body.
   * @return value or {@code null} for none
   */
  public java.util.List<SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams> getRequestQueryParamsToExclude() {
    return requestQueryParamsToExclude;
  }

  /**
   * A list of request query parameter names whose value will be excluded from inspection during
   * preconfigured WAF evaluation. Note that the parameter can be in the query string or in the POST
   * body.
   * @param requestQueryParamsToExclude requestQueryParamsToExclude or {@code null} for none
   */
  public SecurityPolicyRulePreconfiguredWafConfigExclusion setRequestQueryParamsToExclude(java.util.List<SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams> requestQueryParamsToExclude) {
    this.requestQueryParamsToExclude = requestQueryParamsToExclude;
    return this;
  }

  /**
   * A list of request URIs from the request line to be excluded from inspection during
   * preconfigured WAF evaluation. When specifying this field, the query or fragment part should be
   * excluded.
   * @return value or {@code null} for none
   */
  public java.util.List<SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams> getRequestUrisToExclude() {
    return requestUrisToExclude;
  }

  /**
   * A list of request URIs from the request line to be excluded from inspection during
   * preconfigured WAF evaluation. When specifying this field, the query or fragment part should be
   * excluded.
   * @param requestUrisToExclude requestUrisToExclude or {@code null} for none
   */
  public SecurityPolicyRulePreconfiguredWafConfigExclusion setRequestUrisToExclude(java.util.List<SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams> requestUrisToExclude) {
    this.requestUrisToExclude = requestUrisToExclude;
    return this;
  }

  /**
   * A list of target rule IDs under the WAF rule set to apply the preconfigured WAF exclusion. If
   * omitted, it refers to all the rule IDs under the WAF rule set.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTargetRuleIds() {
    return targetRuleIds;
  }

  /**
   * A list of target rule IDs under the WAF rule set to apply the preconfigured WAF exclusion. If
   * omitted, it refers to all the rule IDs under the WAF rule set.
   * @param targetRuleIds targetRuleIds or {@code null} for none
   */
  public SecurityPolicyRulePreconfiguredWafConfigExclusion setTargetRuleIds(java.util.List<java.lang.String> targetRuleIds) {
    this.targetRuleIds = targetRuleIds;
    return this;
  }

  /**
   * Target WAF rule set to apply the preconfigured WAF exclusion.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetRuleSet() {
    return targetRuleSet;
  }

  /**
   * Target WAF rule set to apply the preconfigured WAF exclusion.
   * @param targetRuleSet targetRuleSet or {@code null} for none
   */
  public SecurityPolicyRulePreconfiguredWafConfigExclusion setTargetRuleSet(java.lang.String targetRuleSet) {
    this.targetRuleSet = targetRuleSet;
    return this;
  }

  @Override
  public SecurityPolicyRulePreconfiguredWafConfigExclusion set(String fieldName, Object value) {
    return (SecurityPolicyRulePreconfiguredWafConfigExclusion) super.set(fieldName, value);
  }

  @Override
  public SecurityPolicyRulePreconfiguredWafConfigExclusion clone() {
    return (SecurityPolicyRulePreconfiguredWafConfigExclusion) super.clone();
  }

}
