/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for StoragePoolType.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StoragePoolType extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * [Output Only] The deprecation status associated with this storage pool type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeprecationStatus deprecated;

  /**
   * [Output Only] An optional description of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of the resource. Always compute#storagePoolType for storage pool types.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] Maximum storage pool size in GB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxPoolProvisionedCapacityGb;

  /**
   * [Output Only] Maximum provisioned IOPS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxPoolProvisionedIops;

  /**
   * [Output Only] Maximum provisioned throughput.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxPoolProvisionedThroughput;

  /**
   * [Output Only] Minimum storage pool size in GB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long minPoolProvisionedCapacityGb;

  /**
   * [Output Only] Minimum provisioned IOPS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long minPoolProvisionedIops;

  /**
   * [Output Only] Minimum provisioned throughput.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long minPoolProvisionedThroughput;

  /**
   * [Deprecated] This field is deprecated. Use minPoolProvisionedCapacityGb instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long minSizeGb;

  /**
   * [Output Only] Name of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLinkWithId;

  /**
   * [Output Only] The list of disk types supported in this storage pool type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> supportedDiskTypes;

  /**
   * [Output Only] URL of the zone where the storage pool type resides. You must specify this field
   * as part of the HTTP request URL. It is not settable as a field in the request body.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public StoragePoolType setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * [Output Only] The deprecation status associated with this storage pool type.
   * @return value or {@code null} for none
   */
  public DeprecationStatus getDeprecated() {
    return deprecated;
  }

  /**
   * [Output Only] The deprecation status associated with this storage pool type.
   * @param deprecated deprecated or {@code null} for none
   */
  public StoragePoolType setDeprecated(DeprecationStatus deprecated) {
    this.deprecated = deprecated;
    return this;
  }

  /**
   * [Output Only] An optional description of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * [Output Only] An optional description of this resource.
   * @param description description or {@code null} for none
   */
  public StoragePoolType setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public StoragePoolType setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#storagePoolType for storage pool types.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#storagePoolType for storage pool types.
   * @param kind kind or {@code null} for none
   */
  public StoragePoolType setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] Maximum storage pool size in GB.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxPoolProvisionedCapacityGb() {
    return maxPoolProvisionedCapacityGb;
  }

  /**
   * [Output Only] Maximum storage pool size in GB.
   * @param maxPoolProvisionedCapacityGb maxPoolProvisionedCapacityGb or {@code null} for none
   */
  public StoragePoolType setMaxPoolProvisionedCapacityGb(java.lang.Long maxPoolProvisionedCapacityGb) {
    this.maxPoolProvisionedCapacityGb = maxPoolProvisionedCapacityGb;
    return this;
  }

  /**
   * [Output Only] Maximum provisioned IOPS.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxPoolProvisionedIops() {
    return maxPoolProvisionedIops;
  }

  /**
   * [Output Only] Maximum provisioned IOPS.
   * @param maxPoolProvisionedIops maxPoolProvisionedIops or {@code null} for none
   */
  public StoragePoolType setMaxPoolProvisionedIops(java.lang.Long maxPoolProvisionedIops) {
    this.maxPoolProvisionedIops = maxPoolProvisionedIops;
    return this;
  }

  /**
   * [Output Only] Maximum provisioned throughput.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxPoolProvisionedThroughput() {
    return maxPoolProvisionedThroughput;
  }

  /**
   * [Output Only] Maximum provisioned throughput.
   * @param maxPoolProvisionedThroughput maxPoolProvisionedThroughput or {@code null} for none
   */
  public StoragePoolType setMaxPoolProvisionedThroughput(java.lang.Long maxPoolProvisionedThroughput) {
    this.maxPoolProvisionedThroughput = maxPoolProvisionedThroughput;
    return this;
  }

  /**
   * [Output Only] Minimum storage pool size in GB.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMinPoolProvisionedCapacityGb() {
    return minPoolProvisionedCapacityGb;
  }

  /**
   * [Output Only] Minimum storage pool size in GB.
   * @param minPoolProvisionedCapacityGb minPoolProvisionedCapacityGb or {@code null} for none
   */
  public StoragePoolType setMinPoolProvisionedCapacityGb(java.lang.Long minPoolProvisionedCapacityGb) {
    this.minPoolProvisionedCapacityGb = minPoolProvisionedCapacityGb;
    return this;
  }

  /**
   * [Output Only] Minimum provisioned IOPS.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMinPoolProvisionedIops() {
    return minPoolProvisionedIops;
  }

  /**
   * [Output Only] Minimum provisioned IOPS.
   * @param minPoolProvisionedIops minPoolProvisionedIops or {@code null} for none
   */
  public StoragePoolType setMinPoolProvisionedIops(java.lang.Long minPoolProvisionedIops) {
    this.minPoolProvisionedIops = minPoolProvisionedIops;
    return this;
  }

  /**
   * [Output Only] Minimum provisioned throughput.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMinPoolProvisionedThroughput() {
    return minPoolProvisionedThroughput;
  }

  /**
   * [Output Only] Minimum provisioned throughput.
   * @param minPoolProvisionedThroughput minPoolProvisionedThroughput or {@code null} for none
   */
  public StoragePoolType setMinPoolProvisionedThroughput(java.lang.Long minPoolProvisionedThroughput) {
    this.minPoolProvisionedThroughput = minPoolProvisionedThroughput;
    return this;
  }

  /**
   * [Deprecated] This field is deprecated. Use minPoolProvisionedCapacityGb instead.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMinSizeGb() {
    return minSizeGb;
  }

  /**
   * [Deprecated] This field is deprecated. Use minPoolProvisionedCapacityGb instead.
   * @param minSizeGb minSizeGb or {@code null} for none
   */
  public StoragePoolType setMinSizeGb(java.lang.Long minSizeGb) {
    this.minSizeGb = minSizeGb;
    return this;
  }

  /**
   * [Output Only] Name of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * [Output Only] Name of the resource.
   * @param name name or {@code null} for none
   */
  public StoragePoolType setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public StoragePoolType setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLinkWithId() {
    return selfLinkWithId;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @param selfLinkWithId selfLinkWithId or {@code null} for none
   */
  public StoragePoolType setSelfLinkWithId(java.lang.String selfLinkWithId) {
    this.selfLinkWithId = selfLinkWithId;
    return this;
  }

  /**
   * [Output Only] The list of disk types supported in this storage pool type.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSupportedDiskTypes() {
    return supportedDiskTypes;
  }

  /**
   * [Output Only] The list of disk types supported in this storage pool type.
   * @param supportedDiskTypes supportedDiskTypes or {@code null} for none
   */
  public StoragePoolType setSupportedDiskTypes(java.util.List<java.lang.String> supportedDiskTypes) {
    this.supportedDiskTypes = supportedDiskTypes;
    return this;
  }

  /**
   * [Output Only] URL of the zone where the storage pool type resides. You must specify this field
   * as part of the HTTP request URL. It is not settable as a field in the request body.
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * [Output Only] URL of the zone where the storage pool type resides. You must specify this field
   * as part of the HTTP request URL. It is not settable as a field in the request body.
   * @param zone zone or {@code null} for none
   */
  public StoragePoolType setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public StoragePoolType set(String fieldName, Object value) {
    return (StoragePoolType) super.set(fieldName, value);
  }

  @Override
  public StoragePoolType clone() {
    return (StoragePoolType) super.clone();
  }

}
