/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for HTTP2HealthCheck.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HTTP2HealthCheck extends com.google.api.client.json.GenericJson {

  /**
   * The value of the host header in the HTTP/2 health check request. If left empty (default value),
   * the host header is set to the destination IP address to which health check packets are sent.
   * The destination IP address depends on the type of load balancer. For details, see:
   * https://cloud.google.com/load-balancing/docs/health-check-concepts#hc-packet-dest
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String host;

  /**
   * The TCP port number to which the health check prober sends packets. The default value is 443.
   * Valid values are 1 through 65535.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer port;

  /**
   * Not supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String portName;

  /**
   * Specifies how a port is selected for health checking. Can be one of the following values:
   * USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check.
   * Supported by backend services for passthrough load balancers and backend services for proxy
   * load balancers. Not supported by target pools. The health check supports all backends supported
   * by the backend service provided the backend can be health checked. For example, GCE_VM_IP
   * network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends.
   * USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the
   * health check port by referring to the backend service. Only supported by backend services for
   * proxy load balancers. Not supported by target pools. Not supported by backend services for
   * passthrough load balancers. Supports all backends that can be health checked; for example,
   * GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network
   * endpoint group backends, the health check uses the port number specified for each endpoint in
   * the network endpoint group. For instance group backends, the health check uses the port number
   * determined by looking up the backend service's named port in the instance group's list of named
   * ports.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String portSpecification;

  /**
   * Specifies the type of proxy header to append before sending data to the backend, either NONE or
   * PROXY_V1. The default is NONE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String proxyHeader;

  /**
   * The request path of the HTTP/2 health check request. The default value is /.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestPath;

  /**
   * Creates a content-based HTTP/2 health check. In addition to the required HTTP 200 (OK) status
   * code, you can configure the health check to pass only when the backend sends this specific
   * ASCII response string within the first 1024 bytes of the HTTP response body. For details, see:
   * https://cloud.google.com/load-balancing/docs/health-check-concepts#criteria-protocol-http
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String response;

  /**
   * The value of the host header in the HTTP/2 health check request. If left empty (default value),
   * the host header is set to the destination IP address to which health check packets are sent.
   * The destination IP address depends on the type of load balancer. For details, see:
   * https://cloud.google.com/load-balancing/docs/health-check-concepts#hc-packet-dest
   * @return value or {@code null} for none
   */
  public java.lang.String getHost() {
    return host;
  }

  /**
   * The value of the host header in the HTTP/2 health check request. If left empty (default value),
   * the host header is set to the destination IP address to which health check packets are sent.
   * The destination IP address depends on the type of load balancer. For details, see:
   * https://cloud.google.com/load-balancing/docs/health-check-concepts#hc-packet-dest
   * @param host host or {@code null} for none
   */
  public HTTP2HealthCheck setHost(java.lang.String host) {
    this.host = host;
    return this;
  }

  /**
   * The TCP port number to which the health check prober sends packets. The default value is 443.
   * Valid values are 1 through 65535.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPort() {
    return port;
  }

  /**
   * The TCP port number to which the health check prober sends packets. The default value is 443.
   * Valid values are 1 through 65535.
   * @param port port or {@code null} for none
   */
  public HTTP2HealthCheck setPort(java.lang.Integer port) {
    this.port = port;
    return this;
  }

  /**
   * Not supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getPortName() {
    return portName;
  }

  /**
   * Not supported.
   * @param portName portName or {@code null} for none
   */
  public HTTP2HealthCheck setPortName(java.lang.String portName) {
    this.portName = portName;
    return this;
  }

  /**
   * Specifies how a port is selected for health checking. Can be one of the following values:
   * USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check.
   * Supported by backend services for passthrough load balancers and backend services for proxy
   * load balancers. Not supported by target pools. The health check supports all backends supported
   * by the backend service provided the backend can be health checked. For example, GCE_VM_IP
   * network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends.
   * USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the
   * health check port by referring to the backend service. Only supported by backend services for
   * proxy load balancers. Not supported by target pools. Not supported by backend services for
   * passthrough load balancers. Supports all backends that can be health checked; for example,
   * GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network
   * endpoint group backends, the health check uses the port number specified for each endpoint in
   * the network endpoint group. For instance group backends, the health check uses the port number
   * determined by looking up the backend service's named port in the instance group's list of named
   * ports.
   * @return value or {@code null} for none
   */
  public java.lang.String getPortSpecification() {
    return portSpecification;
  }

  /**
   * Specifies how a port is selected for health checking. Can be one of the following values:
   * USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check.
   * Supported by backend services for passthrough load balancers and backend services for proxy
   * load balancers. Not supported by target pools. The health check supports all backends supported
   * by the backend service provided the backend can be health checked. For example, GCE_VM_IP
   * network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends.
   * USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the
   * health check port by referring to the backend service. Only supported by backend services for
   * proxy load balancers. Not supported by target pools. Not supported by backend services for
   * passthrough load balancers. Supports all backends that can be health checked; for example,
   * GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network
   * endpoint group backends, the health check uses the port number specified for each endpoint in
   * the network endpoint group. For instance group backends, the health check uses the port number
   * determined by looking up the backend service's named port in the instance group's list of named
   * ports.
   * @param portSpecification portSpecification or {@code null} for none
   */
  public HTTP2HealthCheck setPortSpecification(java.lang.String portSpecification) {
    this.portSpecification = portSpecification;
    return this;
  }

  /**
   * Specifies the type of proxy header to append before sending data to the backend, either NONE or
   * PROXY_V1. The default is NONE.
   * @return value or {@code null} for none
   */
  public java.lang.String getProxyHeader() {
    return proxyHeader;
  }

  /**
   * Specifies the type of proxy header to append before sending data to the backend, either NONE or
   * PROXY_V1. The default is NONE.
   * @param proxyHeader proxyHeader or {@code null} for none
   */
  public HTTP2HealthCheck setProxyHeader(java.lang.String proxyHeader) {
    this.proxyHeader = proxyHeader;
    return this;
  }

  /**
   * The request path of the HTTP/2 health check request. The default value is /.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestPath() {
    return requestPath;
  }

  /**
   * The request path of the HTTP/2 health check request. The default value is /.
   * @param requestPath requestPath or {@code null} for none
   */
  public HTTP2HealthCheck setRequestPath(java.lang.String requestPath) {
    this.requestPath = requestPath;
    return this;
  }

  /**
   * Creates a content-based HTTP/2 health check. In addition to the required HTTP 200 (OK) status
   * code, you can configure the health check to pass only when the backend sends this specific
   * ASCII response string within the first 1024 bytes of the HTTP response body. For details, see:
   * https://cloud.google.com/load-balancing/docs/health-check-concepts#criteria-protocol-http
   * @return value or {@code null} for none
   */
  public java.lang.String getResponse() {
    return response;
  }

  /**
   * Creates a content-based HTTP/2 health check. In addition to the required HTTP 200 (OK) status
   * code, you can configure the health check to pass only when the backend sends this specific
   * ASCII response string within the first 1024 bytes of the HTTP response body. For details, see:
   * https://cloud.google.com/load-balancing/docs/health-check-concepts#criteria-protocol-http
   * @param response response or {@code null} for none
   */
  public HTTP2HealthCheck setResponse(java.lang.String response) {
    this.response = response;
    return this;
  }

  @Override
  public HTTP2HealthCheck set(String fieldName, Object value) {
    return (HTTP2HealthCheck) super.set(fieldName, value);
  }

  @Override
  public HTTP2HealthCheck clone() {
    return (HTTP2HealthCheck) super.clone();
  }

}
