/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Per-instance properties to be set on individual instances. To be extended in the future.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BulkInsertInstanceResourcePerInstanceProperties extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the hostname of the instance. More details in:
   * https://cloud.google.com/compute/docs/instances/custom-hostname-vm#naming_convention
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hostname;

  /**
   * This field is only temporary. It will be removed. Do not use it.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Specifies the hostname of the instance. More details in:
   * https://cloud.google.com/compute/docs/instances/custom-hostname-vm#naming_convention
   * @return value or {@code null} for none
   */
  public java.lang.String getHostname() {
    return hostname;
  }

  /**
   * Specifies the hostname of the instance. More details in:
   * https://cloud.google.com/compute/docs/instances/custom-hostname-vm#naming_convention
   * @param hostname hostname or {@code null} for none
   */
  public BulkInsertInstanceResourcePerInstanceProperties setHostname(java.lang.String hostname) {
    this.hostname = hostname;
    return this;
  }

  /**
   * This field is only temporary. It will be removed. Do not use it.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * This field is only temporary. It will be removed. Do not use it.
   * @param name name or {@code null} for none
   */
  public BulkInsertInstanceResourcePerInstanceProperties setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public BulkInsertInstanceResourcePerInstanceProperties set(String fieldName, Object value) {
    return (BulkInsertInstanceResourcePerInstanceProperties) super.set(fieldName, value);
  }

  @Override
  public BulkInsertInstanceResourcePerInstanceProperties clone() {
    return (BulkInsertInstanceResourcePerInstanceProperties) super.clone();
  }

}
