/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * [Output Only] A connection connected to this service attachment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ServiceAttachmentConnectedEndpoint extends com.google.api.client.json.GenericJson {

  /**
   * The url of the consumer network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String consumerNetwork;

  /**
   * The url of a connected endpoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String endpoint;

  /**
   * The PSC connection id of the connected endpoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger pscConnectionId;

  /**
   * The status of a connected endpoint to this service attachment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * The url of the consumer network.
   * @return value or {@code null} for none
   */
  public java.lang.String getConsumerNetwork() {
    return consumerNetwork;
  }

  /**
   * The url of the consumer network.
   * @param consumerNetwork consumerNetwork or {@code null} for none
   */
  public ServiceAttachmentConnectedEndpoint setConsumerNetwork(java.lang.String consumerNetwork) {
    this.consumerNetwork = consumerNetwork;
    return this;
  }

  /**
   * The url of a connected endpoint.
   * @return value or {@code null} for none
   */
  public java.lang.String getEndpoint() {
    return endpoint;
  }

  /**
   * The url of a connected endpoint.
   * @param endpoint endpoint or {@code null} for none
   */
  public ServiceAttachmentConnectedEndpoint setEndpoint(java.lang.String endpoint) {
    this.endpoint = endpoint;
    return this;
  }

  /**
   * The PSC connection id of the connected endpoint.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getPscConnectionId() {
    return pscConnectionId;
  }

  /**
   * The PSC connection id of the connected endpoint.
   * @param pscConnectionId pscConnectionId or {@code null} for none
   */
  public ServiceAttachmentConnectedEndpoint setPscConnectionId(java.math.BigInteger pscConnectionId) {
    this.pscConnectionId = pscConnectionId;
    return this;
  }

  /**
   * The status of a connected endpoint to this service attachment.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The status of a connected endpoint to this service attachment.
   * @param status status or {@code null} for none
   */
  public ServiceAttachmentConnectedEndpoint setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public ServiceAttachmentConnectedEndpoint set(String fieldName, Object value) {
    return (ServiceAttachmentConnectedEndpoint) super.set(fieldName, value);
  }

  @Override
  public ServiceAttachmentConnectedEndpoint clone() {
    return (ServiceAttachmentConnectedEndpoint) super.clone();
  }

}
