/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Commitment for a particular license resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LicenseResourceCommitment extends com.google.api.client.json.GenericJson {

  /**
   * The number of licenses purchased.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long amount;

  /**
   * Specifies the core range of the instance for which this license applies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String coresPerLicense;

  /**
   * Any applicable license URI.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String license;

  /**
   * The number of licenses purchased.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAmount() {
    return amount;
  }

  /**
   * The number of licenses purchased.
   * @param amount amount or {@code null} for none
   */
  public LicenseResourceCommitment setAmount(java.lang.Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Specifies the core range of the instance for which this license applies.
   * @return value or {@code null} for none
   */
  public java.lang.String getCoresPerLicense() {
    return coresPerLicense;
  }

  /**
   * Specifies the core range of the instance for which this license applies.
   * @param coresPerLicense coresPerLicense or {@code null} for none
   */
  public LicenseResourceCommitment setCoresPerLicense(java.lang.String coresPerLicense) {
    this.coresPerLicense = coresPerLicense;
    return this;
  }

  /**
   * Any applicable license URI.
   * @return value or {@code null} for none
   */
  public java.lang.String getLicense() {
    return license;
  }

  /**
   * Any applicable license URI.
   * @param license license or {@code null} for none
   */
  public LicenseResourceCommitment setLicense(java.lang.String license) {
    this.license = license;
    return this;
  }

  @Override
  public LicenseResourceCommitment set(String fieldName, Object value) {
    return (LicenseResourceCommitment) super.set(fieldName, value);
  }

  @Override
  public LicenseResourceCommitment clone() {
    return (LicenseResourceCommitment) super.clone();
  }

}
