/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A VPN gateway interface.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VpnGatewayVpnGatewayInterface extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Numeric identifier for this VPN interface associated with the VPN gateway.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long id;

  /**
   * URL of the VLAN attachment (interconnectAttachment) resource for this VPN gateway interface.
   * When the value of this field is present, the VPN gateway is used for HA VPN over Cloud
   * Interconnect; all egress or ingress traffic for this VPN gateway interface goes through the
   * specified VLAN attachment resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String interconnectAttachment;

  /**
   * [Output Only] IP address for this VPN interface associated with the VPN gateway. The IP address
   * could be either a regional external IP address or a regional internal IP address. The two IP
   * addresses for a VPN gateway must be all regional external or regional internal IP addresses.
   * There cannot be a mix of regional external IP addresses and regional internal IP addresses. For
   * HA VPN over Cloud Interconnect, the IP addresses for both interfaces could either be regional
   * internal IP addresses or regional external IP addresses. For regular (non HA VPN over Cloud
   * Interconnect) HA VPN tunnels, the IP address must be a regional external IP address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipAddress;

  /**
   * [Output Only] IPv6 address for this VPN interface associated with the VPN gateway. The IPv6
   * address must be a regional external IPv6 address. The format is RFC 5952 format (e.g.
   * 2001:db8::2d9:51:0:0).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipv6Address;

  /**
   * [Output Only] Numeric identifier for this VPN interface associated with the VPN gateway.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * [Output Only] Numeric identifier for this VPN interface associated with the VPN gateway.
   * @param id id or {@code null} for none
   */
  public VpnGatewayVpnGatewayInterface setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * URL of the VLAN attachment (interconnectAttachment) resource for this VPN gateway interface.
   * When the value of this field is present, the VPN gateway is used for HA VPN over Cloud
   * Interconnect; all egress or ingress traffic for this VPN gateway interface goes through the
   * specified VLAN attachment resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getInterconnectAttachment() {
    return interconnectAttachment;
  }

  /**
   * URL of the VLAN attachment (interconnectAttachment) resource for this VPN gateway interface.
   * When the value of this field is present, the VPN gateway is used for HA VPN over Cloud
   * Interconnect; all egress or ingress traffic for this VPN gateway interface goes through the
   * specified VLAN attachment resource.
   * @param interconnectAttachment interconnectAttachment or {@code null} for none
   */
  public VpnGatewayVpnGatewayInterface setInterconnectAttachment(java.lang.String interconnectAttachment) {
    this.interconnectAttachment = interconnectAttachment;
    return this;
  }

  /**
   * [Output Only] IP address for this VPN interface associated with the VPN gateway. The IP address
   * could be either a regional external IP address or a regional internal IP address. The two IP
   * addresses for a VPN gateway must be all regional external or regional internal IP addresses.
   * There cannot be a mix of regional external IP addresses and regional internal IP addresses. For
   * HA VPN over Cloud Interconnect, the IP addresses for both interfaces could either be regional
   * internal IP addresses or regional external IP addresses. For regular (non HA VPN over Cloud
   * Interconnect) HA VPN tunnels, the IP address must be a regional external IP address.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpAddress() {
    return ipAddress;
  }

  /**
   * [Output Only] IP address for this VPN interface associated with the VPN gateway. The IP address
   * could be either a regional external IP address or a regional internal IP address. The two IP
   * addresses for a VPN gateway must be all regional external or regional internal IP addresses.
   * There cannot be a mix of regional external IP addresses and regional internal IP addresses. For
   * HA VPN over Cloud Interconnect, the IP addresses for both interfaces could either be regional
   * internal IP addresses or regional external IP addresses. For regular (non HA VPN over Cloud
   * Interconnect) HA VPN tunnels, the IP address must be a regional external IP address.
   * @param ipAddress ipAddress or {@code null} for none
   */
  public VpnGatewayVpnGatewayInterface setIpAddress(java.lang.String ipAddress) {
    this.ipAddress = ipAddress;
    return this;
  }

  /**
   * [Output Only] IPv6 address for this VPN interface associated with the VPN gateway. The IPv6
   * address must be a regional external IPv6 address. The format is RFC 5952 format (e.g.
   * 2001:db8::2d9:51:0:0).
   * @return value or {@code null} for none
   */
  public java.lang.String getIpv6Address() {
    return ipv6Address;
  }

  /**
   * [Output Only] IPv6 address for this VPN interface associated with the VPN gateway. The IPv6
   * address must be a regional external IPv6 address. The format is RFC 5952 format (e.g.
   * 2001:db8::2d9:51:0:0).
   * @param ipv6Address ipv6Address or {@code null} for none
   */
  public VpnGatewayVpnGatewayInterface setIpv6Address(java.lang.String ipv6Address) {
    this.ipv6Address = ipv6Address;
    return this;
  }

  @Override
  public VpnGatewayVpnGatewayInterface set(String fieldName, Object value) {
    return (VpnGatewayVpnGatewayInterface) super.set(fieldName, value);
  }

  @Override
  public VpnGatewayVpnGatewayInterface clone() {
    return (VpnGatewayVpnGatewayInterface) super.clone();
  }

}
